/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.pipeline.bit.available;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.pipeline.PipeBitInfoUtil;
import org.apache.ctakes.gui.pipeline.bit.info.PipeBitInfoComparator;
import org.apache.log4j.Logger;

public final class AvailablesListModel
extends AbstractListModel<PipeBitInfo> {
    private static final Logger LOGGER = Logger.getLogger((String)"AvailablesListModel");
    private final List<PipeBitInfo> _pipeBitInfos = new ArrayList<PipeBitInfo>();
    private final Map<PipeBitInfo, Class<?>> _pipeBitMap = new HashMap();

    public void setPipeBits(Collection<Class<?>> bits) {
        int oldSize = this._pipeBitInfos.size();
        if (oldSize > 0) {
            this._pipeBitInfos.clear();
            this._pipeBitMap.clear();
        }
        if (bits == null || bits.isEmpty()) {
            if (oldSize > 0) {
                this.fireIntervalRemoved(this, 0, oldSize - 1);
            }
            return;
        }
        for (Class<?> bit : bits) {
            PipeBitInfo info = PipeBitInfoUtil.getInfo(bit);
            this._pipeBitInfos.add(info);
            this._pipeBitMap.put(info, bit);
        }
        this._pipeBitInfos.sort(PipeBitInfoComparator.getInstance());
        this.fireContentsChanged(this, 0, this._pipeBitInfos.size());
    }

    public Class<?> getPipeBit(PipeBitInfo pipeBitInfo) {
        return this._pipeBitMap.get(pipeBitInfo);
    }

    @Override
    public int getSize() {
        return this._pipeBitInfos.size();
    }

    @Override
    public PipeBitInfo getElementAt(int index) {
        return this._pipeBitInfos.get(index);
    }
}

