/*
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations under
 * the License.
 *
 * The Original Code is ICEfaces 1.5 open source software code, released
 * November 5, 2006. The Initial Developer of the Original Code is ICEsoft
 * Technologies Canada, Corp. Portions created by ICEsoft are Copyright (C)
 * 2004-2011 ICEsoft Technologies Canada, Corp. All Rights Reserved.
 *
 * Contributor(s): _____________________.
 */

function formOf(element) {
    var parent = element.parentNode;
    while (parent) {
        if (parent.tagName && parent.tagName.toLowerCase() == 'form') return parent;
        parent = parent.parentNode;
    }

    throw 'Cannot find enclosing form.';
}

if (!window['ice']) {
    window.ice = {};
}
if (!window['ice']['component_util']) {
    window.ice.component_util = {};
}

ice.component_util.isEventSourceInputElement = function(event) {
    var elem = ice.component_util.eventTarget(event);
    var tag = elem.tagName.toLowerCase();
    if (tag == 'input' || tag == 'select' || tag == 'option' || tag == 'a' || tag == 'textarea') {
        return true;
    } else {
        return false;
    }
}

ice.component_util.eventTarget = function(event) {
       event = event || window.event;           
       return(event.target || event.srcElement);
}

ice.component_util.printArguments = function() {
    logger.info('-= Printing arguments =-');
    for(var i=0; i<arguments.length; i++) 
       logger.info(arguments[i]);
}

if (!window['ice']) {
    window.ice = {};
}
/*
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations under
 * the License.
 *
 * The Original Code is ICEfaces 1.5 open source software code, released
 * November 5, 2006. The Initial Developer of the Original Code is ICEsoft
 * Technologies Canada, Corp. Portions created by ICEsoft are Copyright (C)
 * 2004-2011 ICEsoft Technologies Canada, Corp. All Rights Reserved.
 *
 * Contributor(s): _____________________.
 */

String.prototype.trim = function () {
    return this.replace(/^\s*/, "").replace(/\s*$/, "");
};

ice.yui3 = {
    y : null,
    getY: function() {
        return ice.yui3.y;
    },
    modules: {},
    use :function(callback) {
        if (ice.yui3.y == null) {
			var Yui = ice.yui3.getNewInstance();
			Yui.use('loader', 'oop', 'event-custom', 'attribute', 'base',
                    'event', 'dom', 'node', 'event-delegate',
                    // load modules required by the animation library
                    'anim', 'plugin', 'pluginhost',
                    // Specified by animation-v2.js
                    //'json',
                    function(Y) {
                ice.yui3.y = Y;
                callback(ice.yui3.y);
            });
        } else {
            callback(ice.yui3.y);
        }
    },
    loadModule: function(module) {
        if (!this.modules[module])
            this.modules[module] = module;
    },
    getModules: function() {
        var modules = '';
        for (module in this.modules)
            modules += module + ',';
        return modules.substring(0, modules.length - 1);
    },
    //basePathPattern: /^.*\/+(.*)\/javax\.faces\.resource.*yui\/yui-min\.js(.*)\?ln=(.*)?$/,
	basePathPattern: /^(.*)javax\.faces\.resource([\/\=])yui\/yui-min\.js(.*)$/,
	basePathPatternPortlets: /^(.*)javax\.faces\.resource([\/\=])yui%2Fyui-min\.js(.*)$/,
	libraryPattern: /^(.*[\_\-\.\&\?])ln\=yui\/[0-9a-zA-Z_\.]+(.*)$/,
	libraryPatternPortlets: /^(.*[\_\-\.\&\?])ln\=yui%2F[0-9a-zA-Z_\.]+(.*)$/,
	getBasePath: function(pattern) {
		var nodes, i, src, match;
		nodes = document.getElementsByTagName('script') || [];
		for (i = 0; i < nodes.length; i++) {
			src = nodes[i].src;
			if (src) {
				match = src.match(pattern);
				if (match) {
					return match;
				}
			}
		}
		return null;
    },
	yui3Base: '',
	yui2in3Base: '',
	facesServletExtension: '',
    yui3TrailingPath: '',
    yui2in3TrailingPath: '',
	getNewInstance: function() { // Private, only for use()
		if (!(ice.yui3.yui3Base && ice.yui3.yui2in3Base)) {
			//alert('1' + match[1] + '\n' + '2' + match[2] + '\n' + '3' + match[3]);
			/*
			var basePath = match[1];
			if (basePath.indexOf(':') != -1) { // check if domain contains port number and extract base path
				basePath = basePath.substring(basePath.indexOf('/', basePath.indexOf(':')) + 1);
			}
			*/
			// determine the Faces Servlet extension (usually .jsf), also consider the case when the jsessionid is in the url
			/*
			var jsessionidIndex = match[2].indexOf(';jsessionid=');
			if (jsessionidIndex != -1) {
				ice.yui3.facesServletExtension = match[2].substring(0, jsessionidIndex);
			} else {
				ice.yui3.facesServletExtension = match[2]
			}
			ice.yui3.yui3Base = '/' + basePath + '/javax.faces.resource/' + match[3] + '/';
			ice.yui3.yui2in3Base = '/' + basePath + '/javax.faces.resource/' + 'yui/2in3/';
			*/
			var isPortlet = false;
			var whole = ice.yui3.getBasePath(ice.yui3.basePathPattern);
			if (!whole) {
				whole = ice.yui3.getBasePath(ice.yui3.basePathPatternPortlets);
				isPortlet = true;
			}
			var library;
			if (isPortlet) {
				library = whole[3].match(ice.yui3.libraryPatternPortlets);
			} else {
				library = whole[3].match(ice.yui3.libraryPattern);
			}
			ice.yui3.yui3Base = whole[1] + "javax.faces.resource" + whole[2];
			ice.yui3.yui2in3Base = whole[1] + "javax.faces.resource" + whole[2];
			ice.yui3.yui3TrailingPath = whole[3];
			ice.yui3.yui2in3TrailingPath = library[1] + "ln=yui/2in3" + library[2];
		}

        //filter:"raw"
		var Y = YUI({combine: false, base: ice.yui3.yui3Base,
			groups: {
				yui2: {
				    combine: false,
					base: ice.yui3.yui2in3Base,
					patterns:  {
						'yui2-': {
							configFn: function(me) {
								if (/-skin|reset|fonts|grids|base/.test(me.name)) {
									me.type = 'css';
									me.path = me.path.replace(/\.js/, '.css');
								}
							}
						}
					}
				}
			}
		});
		
		// create URLs with the Faces Servlet extension at the end (e.g. '.jsf')
		var oldUrlFn = Y.Loader.prototype._url;
		Y.Loader.prototype._url = function(path, name, base) {
			var trailingPath;
			if (name.indexOf('yui2-') == -1) {
				trailingPath = ice.yui3.yui3TrailingPath;
			} else {
				trailingPath = ice.yui3.yui2in3TrailingPath;
			}
			return oldUrlFn.call(this, path, name, base) + trailingPath;
		};		
		
		// make Y.one support ':'s in IDs
		var _one = Y.one;
		Y.one = function(id) { 
			if (Y.Lang.isString(id)) {
				id = id.replace(':', '\\:');
			}
			return _one(id);
		}
		
		return Y;
	}
};


var JSContext = function(clientId) {
    this.clientId = clientId
};
JSContext.list = {};
JSContext.prototype = {
    setComponent:function(component) {
        this.component = component;
    },

    getComponent:function() {
        return this.component;
    },

    setJSProps:function(props) {
        this.jsProps = props;
    },

    getJSProps:function() {
        return this.jsProps;
    },
    setJSFProps:function(props) {
        this.jsfProps = props;
    },

    getJSFProps:function() {
        return this.jsfProps;
    },

    isAttached:function() {
        return document.getElementById(this.clientId)['JSContext'];
    }
};

ice.component = {
    updateProperties:function(clientId, jsProps, jsfProps, events, lib) {
        ice.yui3.use(function() {
            ice.component.getInstance(clientId, function(yuiComp) {
                // TODO Why is yuiComp undefined
                if (!yuiComp) {
                    return;
                }
                for (prop in jsProps) {
                    var propValue = yuiComp.get(prop);
                    if (propValue != jsProps[prop]) {
                        yuiComp.set(prop, jsProps[prop]);
                    }
                }
            }, lib, jsProps, jsfProps);
        });

    },
    getInstance:function(clientId, callback, lib, jsProps, jsfProps) {
        var component = document.getElementById(clientId);
        //could be either new component, or part of the DOM diff
        var context = this.getJSContext(clientId);
        if (!context || (context && !context.isAttached())) {
            context = this.createContext(clientId);
            context.setJSProps(jsProps);
            context.setJSFProps(jsfProps);
            lib.initialize(clientId, jsProps, jsfProps, function(YUIJS) {
                context.setComponent(YUIJS);
                callback(context.getComponent());
            });
        } else {
            context = this.getJSContext(clientId);
            context.setJSProps(jsProps);
            context.setJSFProps(jsfProps);
            callback(context.getComponent());
        }
    },

    getJSContext: function(clientId) {
        var component = document.getElementById(clientId);
        if (component) {
            if (component['JSContext'])
                return component['JSContext'];
            else
                return JSContext[clientId];
        }
        return null;
    },

    createContext:function(clientId) {
        var component = document.getElementById(clientId);
        component['JSContext'] = new JSContext(clientId);
        JSContext[clientId] = component['JSContext'];
        return component['JSContext'];
    },

    clientState: {
        set: function(clientId, state) {
            this.getStateHolder()[clientId] = state;
        },

        get: function(clientId) {
            return this.getStateHolder()[clientId];
        },

        has: function(clientId) {
            return (this.getStateHolder()[clientId] != null);
        },

        getStateHolder: function () {
            if (!window.document['sparkle_clientState']) {
                window.document['sparkle_clientState'] = {};
            }
            return window.document['sparkle_clientState'];
        }
    }
};

for (props in ice.component) {
    ice.yui3[props] = ice.component[props];
}
 

/*
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations under
 * the License.
 *
 * The Original Code is ICEfaces 1.5 open source software code, released
 * November 5, 2006. The Initial Developer of the Original Code is ICEsoft
 * Technologies Canada, Corp. Portions created by ICEsoft are Copyright (C)
 * 2004-2011 ICEsoft Technologies Canada, Corp. All Rights Reserved.
 *
 * Contributor(s): _____________________.
 */

ice.util = {
	createHiddenField : function(parent, id) {
	   var inp = document.createElement("input"); 
	   inp.setAttribute('type', 'hidden');
	   inp.setAttribute('id', id);
	   inp.setAttribute('name', id);
	   parent.appendChild(inp);	   
	   return inp;
	},
	
	createElement:function(parent, name) {
		var element = document.createElement(name); 
		parent.appendChild(element);
		return element;
	},
	
	removeElement: function(element) {
		element.parentNode.removeChild(element);
	}
}

 
ice.animation = {
	events : ["transition", "click", "hover"],
	animations : ["fade", "highlight"],
	defaultAnimations:{},
	loadDefaultAnims: function(Y) {
	 
		Y.on("domready", function() {
			var element = ice.util.createElement(document.body, "div");
			element.setAttribute("id", "themeElement");
			element.setAttribute("class", "default_display_value");
			var node = Y.one("#themeElement");
			
			node.addClass("default_display_value"); 
			default_display_value = node.getStyle("display");
			if("none" != default_display_value) {
				//console.info("default_display_value must be set to none, to register theme based animations");
				return;
			}
			
			for (i=0; i< ice.animation.events.length; i++) {
				for (j=0; j< ice.animation.animations.length; j++) {
					var styleClass = 'default_' + ice.animation.events[i] + '_'+  ice.animation.animations[j];
					node.addClass(styleClass);
					var display = node.getStyle("display");
					if (display == "block") {
						ice.animation.defaultAnimations[ice.animation.events[i]] = ice.animation.animations[j];
						//console.info(ice.animation.animations[j] + " registered for "+ ice.animation.events[i]);
					}
					node.removeClass(styleClass);
				}
			}
			ice.util.removeElement(element);
		}, Y);
	},
	
	getAnimation: function (clientId, eventName) {
	    //var node = ice.yui3.y.one('#'+ clientId);
		var node = ice.yui3.y.one(document.getElementById(clientId));
 	   
        var animation = null;
	    if (node) {
			if (node["animation"]) {
				animation = node.animation.getAnimation(eventName);
			} else if (node._node.animation) {//backdoor for IE
				animation = node._node.animation.getAnimation("transition");
			} else {//none of the effect has been defined by the developer, return the theme default if any
			    if (ice.animation.defaultAnimations[eventName]) { 
					animation = ice.animation.register({name: ice.animation.defaultAnimations[eventName], event:eventName, node:'#'+ clientId});
				}
				 
			}
	    } 
		return animation;
	}
};


var anim;
ice.yui3.effects = {};
ice.yui3.use(function(Y) {
	//------ Escape client ID

	function AnimPlugin(config) { 
			AnimPlugin.superclass.constructor.apply(this, arguments);
			this.get("host")["animList"] = {}; 
		}
		AnimPlugin.NAME = 'AnimPlugin';
		AnimPlugin.NS = "animation";


		Y.extend(AnimPlugin, Y.Plugin.Base, {
			add: function(args, effect) { 
			   var event = args.event;
			   var animations = this.get("host")["animList"];
			   


				var index = -1;
				if (!animations[event]) {
					animations[event] = [];
					index = 0;
				} else { //more then one effects are define on same event chain them 
					index = [animations[event].length];
				}
				effect.index = index;
				effect.event = event;
				effect.list = animations[event];
				animations[event][index] = effect;	
				this.get("host")._node.animation = this;								
				return effect;
			},
		
			getAnimation: function(eventName) { 
			   for (a in this.get("host").animList) {
					if (a == eventName) {
						return this.get("host").animList[a][0]; 
					}
				}
				return null;
			}
		});	
	ice.animation.AnimPlugin = AnimPlugin;
	ice.animation.loadDefaultAnims(Y);
	
	var _one = Y.one;
	Y.one = function(id) { 
		if (Y.Lang.isString(id)) {
			id = id.replace(':', '\\:');
		}
		return _one(id);
	}

		
    function chain(ref) {
		this.anim = ref;
		this.anim.on("chainend", function() {
			this.serialize();
		});
	}
	
	
	chain.prototype.set = function(name, value) {
		for (i = this.anim.index; i < this.anim.list.length; i++) {
			this.anim.list[i].set(name, value);
		}
	}
	 
	chain.prototype.on = function(name, callback) {
		if (name == "end") {
			this.anim.on("chainend", callback);
		}
	}	 


		/*
			This method can be used as anim.run(). The difference is that anim.run() would run  
			animation on source anim only while anim.chain.run() would run animation on source and all of 
			the animations bounded to the same event type. 

			The chain is based on 0 based index. If a chain is being run from index 2 so only 
			animation on higher indexs will be a part of a chain
		
		*/
	 
	chain.prototype.run = function(toggleReverse) {
			starter = this.anim;
			var currentAnim = this.anim;
			if(!starter.chainRunEndInstallted) {
				starter.on("end", function() {
					starter.chainRunEndInstallted = true;
					var lastRunningAnim = currentAnim;
					
					if (!starter.toggleReverse) {
						if (!currentAnim){ 
						   currentAnim = starter.next();
						} else {
						   currentAnim = currentAnim.next();
						}
					} else {
					   currentAnim.set("reverse", !currentAnim.get("reverse"));
					   //chain should be reversed should get previous anim
					  // console.info('revering chain ');
					 //  console.info('revering chain current anim '+ currentAnim);
					   try {
							currentAnim = currentAnim.previous();
							if (currentAnim == starter) {
								//Anim can not go beyond the starting point
								throw ("finished");
							}
					   } catch (e){
							//console.info(e);
							//END point when toggleReverse
							return;
							
					   }
					   currentAnim.set("reverse", !currentAnim.get("reverse"));
					}
					
					
					
					if (!currentAnim) {
				
						if (toggleReverse) {
							starter.toggleReverse = true;
						} else {
						   //it means chain only have one 
						   starter.fire("chainend");
						   return;
						}
						currentAnim = lastRunningAnim;
						currentAnim.set("reverse", !currentAnim.get("reverse"));
						//END point of first run
						starter.fire("chainend");
						//console.info('Chain list ends...' + lastRunningAnim);
						
					} 
					
					if (currentAnim) {
						   //console.info( 'going to run '+ currentAnim.effectName);		
							endhandle = currentAnim.on("end", function() { 
								   endhandle.detach();
								   starter.fire("end");
							});				
							currentAnim.run();
						}
				
				
				
				
				
				});
			}
			
			//console.info( 'going to run '+ starter.effectName);	
			starter.run();
		}
	

	function AnimBase(params) { 

		this.params = params;
 
		AnimBase.superclass.constructor.apply(this, arguments); 
		if (!this.params['duration']) {
			this.set("duration", 0.5);
		} else {
			try {
		    //miliseconds to second
				this.set("duration", this.params['duration'] / 1000);
			} catch (e) {
				this.set("duration", 0.5);
			}
		}
	    if (params['easing']) {  
			//TODO check for valid names
			this.set("easing", Y.Easing[params['easing']]);
		}		

		this.cloneNode = Y.one(params.node).cloneNode(false);
		this.cloneNode.setStyle("display", "none");
		var ancestor= Y.one(this.params["node"]).ancestor();
		ancestor.insert(this.cloneNode); 					
		this.setInitialValues();
 		ancestor.removeChild(this.cloneNode); 	
		this.chain = new chain(this);
		this.toggleReverse = false;
		this.containerId = null;
		this.on("start", function() {
			this.fire("prerequisite");
		});
	}
	
	Y.extend(AnimBase, Y.Anim , {
		/*
			helper for chain execution
		*/
		next: function() {
			var index = parseInt(this.index);
		    //console.info(''+ index +  ' :  '+ this.list.length);
			if (index < this.list.length) {
				return this.list[++index];
			} else {
				alert("no more elements");
			}
		},
		
		/*
			helper for chain execution
		*/		
		previous: function() {
			if (this.index >0) {
				return this.list[this.index - 1];
			} else {
				throw ("no more elements");
			}
		},
		
		getContainerId: function() {
			return this.containerId;
		},
		
		/*
			Only required by those components which doesn't apply effect or root element instead a sub element. In that case
			setting containerId exclusivly helps anim.serialize() to identify source component's clientid.
			
		*/
		setContainerId: function(cid) {
			this.containerId = cid;
		},
		
		/* 
		   responsible to set style of anim node to a hidden field, that would be used by AnimationBehavior.decode()
		   format: effect_style[animation_parent_clientid]
		*/
		serialize: function() {
			var elementId;
			var element  = this.get('node')._node;
			if (this.getContainerId() != null) {
				elementId = this.getContainerId();
			} else {
				elementId = element.id;

			}   
			var _form = formOf(element);
	        var effectStyleElementId = 'effect_style'+ elementId;
					
			var sourceId = Y.Node.getDOMNode(this.get('node')).id;
			var effectStyleElement = document.getElementById(effectStyleElementId);			
			  if (!effectStyleElement) {
				effectStyleElement = ice.util.createHiddenField(_form, effectStyleElementId);
			  }
			  effectStyleElement.value = document.getElementById(sourceId).style.cssText ;			
		},
		
		setInitialValues: function() {
			//console.info('setInitialValues is not overriden by the '+ this.effectName);
		},

		setInitialValue: function (param, prop, initVal, validator) {
			if (!this.params[param]) {
					this.cloneNode.addClass(this.effectName + '_'+  param);
					var val = this.cloneNode.getStyle(prop);
					this.cloneNode.removeClass(this.effectName + '_'+  param);
					//console.info(this.effectName + '_'+  param + "  : "+ val);
					if (!val) {
						val = initVal;
					}
					//console.info('looking for validator ');
					if (validator) {
					   
						val = validator(val);
					}
					//console.info('setting color '+ val );
					var obj = {};
					obj[prop] = val;
					this.set(param, obj);
			}
		}
	});
	

	
	// create a Fade effect
	function Fade(params) {//console.info('Fade constructor ');
		//must be set before calling super class constructor
		this.effectName = "fade";
		Fade.superclass.constructor.apply(this, arguments);  
 		this.cycle = false;
		this.on("prerequisite", function() {
			if (this.get("reverse")) {
				this.get("node").setStyle("visibility", "visible");
				this.get("node").setStyle("opacity", "0");			
			}
		})
	}
	
	Y.extend(Fade, AnimBase , { 
		setInitialValues: function() {
			this.setInitialValue("to", "opacity", 0);
			this.setInitialValue("from", "opacity", 1);
		}	
	});
	
	
	// create a Highlight effect
	function Highlight(params) {//console.info('Highlight constructor ');
		this.effectName = "highlight";
		Highlight.superclass.constructor.apply(this, arguments);  
 		this.set("iterations", 1);
		this.cycle = false;
	}
	
	Y.extend(Highlight, AnimBase , { 
		setInitialValues: function() {
			
			this.setInitialValue("to", "backgroundColor", "red");

			var node = this.params["node"];
			this.setInitialValue("from", "backgroundColor", "yellow", function(val) {
			   //console.info('executring validator');
			   if (val.toLowerCase() == "transparent") {
				   val = "white"; //most common case
				   node = Y.one(node);
				   pnode = node.ancestor(function(ele) {  
					if(ele.getStyle("backgroundColor").toLowerCase() != "transparent") 
						return true;
					else
						return false;
				   }, true);
				   if(pnode) {
					  val = pnode.getStyle("backgroundColor");
				   }
			   }
			    
				return val;
			});
		}	
	});
	
	

	
	// create a Highlight effect
	function Anim(params) {//console.info('Highlight constructor ');
		this.effectName = "Anim";
		Anim.superclass.constructor.apply(this, arguments);  
	}
	
	Y.extend(Anim, AnimBase , { 
	
	});
	
	//------ Register Fade effect
	
	
	
	ice.yui3.effects["fade"] = Fade;
	ice.yui3.effects["highlight"] = Highlight;	
	ice.yui3.effects["anim"] = Anim;	
	
 	
});


ice.animation.register = function(args, callback) {
		   var effect  = null;
		   ice.yui3.use( function(Y) { 
		        //console.info("registering "+ args.name);
				effect = new ice.yui3.effects[args.name.toLowerCase()](args); 
				
	//---- Animation plugin
				// (this is done for portlets; for some reason ':'s aren't escaped at this point)
				var _node = document.getElementById(args.node.substring(1));

				//var node = Y.one(args.node);
				var node = Y.one(_node);
	
				if (!node["animation"]) { 
					node.plug(ice.animation.AnimPlugin);
				}

			    anim = node.animation.add(args, effect);
			 
		   }); 
		   return effect;

}
		
ice.animation.run = function(args) {
	new ice.yui3.effects[args.name.toLowerCase()](args).run();
}    

/*
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations under
 * the License.
 *
 * The Original Code is ICEfaces 1.5 open source software code, released
 * November 5, 2006. The Initial Developer of the Original Code is ICEsoft
 * Technologies Canada, Corp. Portions created by ICEsoft are Copyright (C)
 * 2004-2011 ICEsoft Technologies Canada, Corp. All Rights Reserved.
 *
 * Contributor(s): _____________________.
 */

ice.component.checkboxbutton = {
    initialize:function(clientId, jsProps, jsfProps, bindYUI) {
	 ice.yui3.use(function(Y){ 
     Y.use('yui2-button', function(Yui) {
	 Y.on('domready', function(){
		var YAHOO = Y.YUI2;
	
	  var Dom = YAHOO.util.Dom;
      var divNode = document.getElementById(clientId);

//      if (YAHOO.widget.Logger){
//	 	  YAHOO.widget.Logger.enableBrowserConsole();
//      }
       var spanId = clientId+"_span";
	   var button = new YAHOO.widget.Button(spanId, {type: jsProps.type, tabindex: null});

		var hiddenField = Dom.get(clientId+"_hidden");

		//use input hidden field instead to update value for server push
  		if(jsProps.checked) {
   			button.set('checked', hiddenField.value);
 		}
    
		var onCheckedChange = function (e) {
           var context = ice.component.getJSContext(clientId);
           var singleSubmit= context.getJSFProps().singleSubmit;
           var postParameters = context.getJSFProps().postParameters;
           var params = function(parameter) {
               if (postParameters != null) {
                   var argCount = postParameters.length / 2;
                   for (var idx =0; idx < argCount; idx ++ ) {
                       parameter( postParameters[idx*2], postParameters[(idx*2)+1] );
                   }
               }
           };
           YAHOO.log(" in onCheckedChange singleSubmit="+singleSubmit);
           if (singleSubmit)
                YAHOO.log("in onCheckedChange singleSubmit="+singleSubmit);
            else YAHOO.log("  onCheckedChange no jsfProps.singleSubmit"+singleSubmit);
		    buttonNode = document.getElementById(spanId);
	        divNode = document.getElementById(clientId);
			//get the current value of checked
 	        var submittedValue =  e.newValue;

            YAHOO.log("         e.newValue="+e.newValue+" old="+e.prevValue);

			hiddenField.value=submittedValue;

	        YAHOO.log(" hidden Field="+clientId+"_hidden"+" has value="+hiddenField.value);

	        if (singleSubmit) {
 	         	YAHOO.log("single submit goes to server");
 			    //e.target is null so have to set the target to the root of this button for submit
 	         	e.target = buttonNode;
                ice.se(e, divNode, params);
            } else {
             	YAHOO.log("single Submit is false doesn't go to server");
                //no submit!! already updated the hidden field
            }
		};

		button.on("checkedChange", onCheckedChange);

	    if (jsfProps.aria) {
	         //add roles and attributes to the YUI slider widget
	            buttonNode = document.getElementById(spanId);
	            buttonNode.firstChild.setAttribute("role", "button");
	            buttonNode.firstChild.setAttribute("aria-describedby",jsProps.label);
	            if (jsfProps.disabled){
	            	buttonNode.firstChild.setAttribute("aria-disabled", jsfProps.disabled);
	            }
	            //listen for keydown event, to provide short-cut key support.

	            button.on("keydown", function(event) {
	                //get the current value of the element and set the aria values
	            	//the space bar toggles the button
	                var isSpace = event.keyCode == 32;

	                if (isSpace) {
	                	// submit the thing
	                	YAHOO.log(" submit this thing for keycode="+event.keyCode);

	                	//update the root of this element to set the aria values
	        			buttonNode = document.getElementById(spanId);
	          			//get the current value of checked
	         	        var submittedValue =  event.newValue;
	         	        if (submittedValue){
	        	            buttonNode.firstChild.setAttribute("aria-checked",true);
	         	        }else {
	        	            buttonNode.firstChild.setAttribute("aria-checked",false);
	         	        }

	         	       //the space seems to fire the onClick event for both FF and Safari
	                }
	            }, divNode);
	    }
		bindYUI(button);
	 }); // *** end of ondomready
	 }); // *** end of Y.use
	 }); // *** end of ice.yui3.use
	},
	
   //delegate call to ice.yui.updateProperties(..)  with the reference of this lib
   updateProperties:function(clientId, jsProps, jsfProps, events) {        		
        //YAHOO.log("updateProperties...checking jsfProps.singleSubmit="+jsfProps.singleSubmit);

        var context = ice.component.getJSContext(clientId);
        if (context && context.isAttached()) {
            var prevJSFProps = context.getJSFProps();
            if (prevJSFProps.hashCode != jsfProps.hashCode) {
                context.getComponent().destroy();
                document.getElementById(clientId)['JSContext'] = null;
                JSContext[clientId] = null;
            }
        }
       ice.component.updateProperties(clientId, jsProps, jsfProps, events, this);
       //     var JSContext = ice.component.getJSContext(clientId);
       //     var singleSubmit = JSContext.getJSFProps().singleSubmit;

   },
 
   //delegate call to ice.yui.getInstance(..) with the reference of this lib 
   getInstance:function(clientId, callback) {
       ice.component.getInstance(clientId, callback, this);
   }


};
/*
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations under
 * the License.
 *
 * The Original Code is ICEfaces 1.5 open source software code, released
 * November 5, 2006. The Initial Developer of the Original Code is ICEsoft
 * Technologies Canada, Corp. Portions created by ICEsoft are Copyright (C)
 * 2004-2011 ICEsoft Technologies Canada, Corp. All Rights Reserved.
 *
 * Contributor(s): _____________________.
 */

//(function(){
/*
//YAHOO.namespace("icefaces.calendar");
var calendarns = this, i, ns;
//calendarns = (function(){return this;}).call();
//ns = "YAHOO.icefaces.calendar".split(".");
ns = "ice.component.calendar".split(".");
for (i = 0; i < ns.length; i++) {
    calendarns[ns[i]] = calendarns[ns[i]] || {};
    calendarns = calendarns[ns[i]];
}
*/
//var calendarns = ice.component.calendar; // namespace creation as in tabset.js
/*
YAHOO.util.Event.onDOMReady(function() {
    var calLogReader = new YAHOO.widget.LogReader(null, {newestOnTop:false});
    calLogReader.setTitle("Calendar Logger");
    calLogReader.hideSource("global");
    calLogReader.hideSource("LogReader");
});
var logger = new YAHOO.widget.LogWriter("Calendar 4");
*/
ice.component.calendar = { // public functions for calendar namespace
IceCalendar: function(container, config, params) { // ICE calendar constructor
    ice.component.calendar.IceCalendar.superclass.constructor.call(this, container, config);
    this.params = params;
},
isReady: false,
// thisYUI : YUI3 with calendar dependency modules aready loaded
setupLib: function(thisYUI) {
			var YAHOO = thisYUI.YUI2;
var YuiCalendar = YAHOO.widget.Calendar,
           lang = YAHOO.lang,
           JSON = lang.JSON,
            Dom = YAHOO.util.Dom,
          Event = YAHOO.util.Event;

var renderFooter = function(html) {
    html = ice.component.calendar.IceCalendar.superclass.renderFooter.call(this, html);
    var cfg = this.cfg;
    var hourField = cfg.getProperty("hourField");
    if (!hourField) return html;

    var selectedHour = parseInt(cfg.getProperty("selectedHour"), 10);
    var selectedMinute = parseInt(cfg.getProperty("selectedMinute"), 10);
    var amPmStr = cfg.getProperty("amPmStr");
    var amStr = cfg.getProperty("amStr");
    var pmStr = cfg.getProperty("pmStr");
    var renderAsPopup = cfg.getProperty("renderAsPopup");
    var selHrId = this.containerId + "_selHr";
    var selMinId = this.containerId + "_selMin";
    var selAmPmId = this.containerId + "_selAmPm";
    var disabled = this.params.disabled ? " disabled='disabled'" : "";
    var Event = YAHOO.util.Event;
    var Dom = YAHOO.util.Dom;
    var calendar = this;

    var doSelChange = function (evt, selId) {
        var selValue = Dom.get(selId).value;
        var result, cfg = this.cfg;
        if (selId == selHrId) {
            result = cfg.setProperty("selectedHour", selValue, true);
        } else if (selId == selMinId) {
            result = cfg.setProperty("selectedMinute", selValue, true);
        } else if (selId == selAmPmId) {
            result = cfg.setProperty("amPmStr", selValue, true);
        }
        ice.setFocus(selId);
        if (!renderAsPopup) {
            ice.component.calendar.timeSelectHandler(this, evt);
        }
    };
    var selAvailable = function (selId) {
        Event.addListener(selId, "change", doSelChange, selId, calendar);
    };

    var j = parseInt(hourField.charAt(hourField.length - 1), 10);
    var k = hourField.match(/^HOUR_OF_DAY[01]$/) ? j + 23 : j + 11;
    var i, temp;
    html[html.length] = "<tfoot><tr><td align='center' colspan='7'";
    if (this.params.disabled) {
        html[html.length] = " class='disabled'";
    }
    html[html.length] = ">";
    html[html.length] = "<select" + " id='" + selHrId + "' name='" + selHrId + "'" + disabled + ">";
    for (i = j; i <= k; i++) {
        temp = "<option value='" + i + "'";
        if (i == selectedHour) {
            temp += " selected='selected'";
        }
        temp += ">";
        html[html.length] = temp + (i < 10 ? 0 : "") + i + "</option>";
    }
    html[html.length] = "</select>";
    Event.onAvailable(selHrId, selAvailable, selHrId);
    html[html.length] = ": ";
    html[html.length] = "<select" + " id='" + selMinId + "' name='" + selMinId + "'" + disabled + ">";
    for (i = 0; i <= 59; i++) {
        temp = "<option value='" + i + "'";
        if (i == selectedMinute) {
            temp += " selected='selected'";
        }
        temp += ">";
        html[html.length] = temp + (i < 10 ? 0 : "") + i + "</option>";
    }
    html[html.length] = "</select>";
    Event.onAvailable(selMinId, selAvailable, selMinId);
    if (hourField.match(/^HOUR[01]$/)) {
        html[html.length] = "<select" + " id='" + selAmPmId + "' name='" + selAmPmId + "'" + disabled + ">";
        temp = "<option value='" + amStr + "'";
        if (amStr == amPmStr) {
            temp += " selected='selected'";
        }
        temp += ">";
        html[html.length] = temp + amStr + "</option>";
        temp = "<option value='" + pmStr + "'";
        if (pmStr == amPmStr) {
            temp += " selected='selected'";
        }
        temp += ">";
        html[html.length] = temp + pmStr + "</option>";
        html[html.length] = "</select>";
        Event.onAvailable(selAmPmId, selAvailable, selAmPmId);
    }
    html[html.length] = "</td></tr></tfoot>";
    return html;
};
var selectCell = function(cellIndex) {
    this.currentFocus = this.cells[cellIndex].id;
    ice.component.calendar.IceCalendar.superclass.selectCell.call(this, cellIndex);
};
var styleCellDefault = function(workingDate, cell) {
    if (this.params.disabled) {
        Dom.addClass(cell, "disabled");
    } else {
        Dom.addClass(cell, this.Style.CSS_CELL_SELECTABLE);
    }
};
var renderCellDefault = function(workingDate, cell) {
    if (this.params.disabled) {
        cell.innerHTML = workingDate.getDate();
    } else {
        cell.innerHTML = '<a href="#" class="' + this.Style.CSS_CELL_SELECTOR + '">' + this.buildDayLabel(workingDate) + "</a>";
    }
};
var getProperty = function(key) {
    if (key == "pageDate") {
        key = "pagedate";
    } else if (key == "selectedDate") {
        key = "selected";
    }
    var value = this.cfg.getProperty(key);
    if (key == "pagedate") {
        value = YAHOO.util.Date.format(value, {format:"%m/%Y"}, "en-US");
    } else if (key == "selected") {
        value = YAHOO.util.Date.format(new Date(value[0][0], value[0][1] - 1, value[0][2]), {format:"%x"}, "en-US");
    }
    return value;
};
var setProperty = function(key, value) {
    if (key == "pageDate") {
        key = "pagedate";
    } else if (key == "selectedDate") {
        key = "selected";
    }
    this.cfg.setProperty(key, value, false);
};
var overrides = {renderFooter:renderFooter, selectCell:selectCell, styleCellDefault:styleCellDefault,
                 renderCellDefault:renderCellDefault, get:getProperty, set:setProperty};
lang.extend(ice.component.calendar.IceCalendar, YuiCalendar, overrides);
},
getTime: function(calendar) {
    var hr = 0, min = 0;
    var cfg = calendar.cfg;
    var hourField = cfg.getProperty("hourField");
    if (hourField) {
        hr = parseInt(cfg.getProperty("selectedHour"), 10);
        min = parseInt(cfg.getProperty("selectedMinute"), 10);
        if (hourField == "HOUR_OF_DAY1" && hr == 24 || hourField == "HOUR1" && hr == 12) {
            hr = 0;
        }
        if (hourField.match(/^HOUR[01]$/) && cfg.getProperty("amPmStr") == cfg.getProperty("pmStr")) {
            hr += 12;
        }
    }
    return {hr:hr, min:min};
},
timeSelectHandler: function(calendar, evt) {
    var rootId = calendar.params.clientId, calValueEl = this[rootId].calValueEl;
    var date = calendar.getSelectedDates()[0];
    var time = this.getTime(calendar);
    var dateStr = date.getFullYear() + "-" + (date.getMonth() + 1) + "-" + date.getDate() + " " + time.hr + ":" + time.min;
    calValueEl.set("value", dateStr, true);
    if (calendar.params.singleSubmit) {
        ice.se(evt, rootId);
    }
},
configCal: function (calendar, params) {
    var cfg = calendar.cfg;
    cfg.addProperty("selectedHour", {value:params.selectedHour});
    cfg.addProperty("selectedMinute", {value:params.selectedMinute});
    cfg.addProperty("hourField", {value:params.hourField});
    cfg.addProperty("amPmStr", {value:params.amPmStr});
    cfg.addProperty("amStr", {value:params.amStr});
    cfg.addProperty("pmStr", {value:params.pmStr});
    cfg.addProperty("renderAsPopup", {value:params.renderAsPopup});
    cfg.setProperty("MONTHS_LONG", params.longMonths);
    cfg.setProperty("WEEKDAYS_SHORT", params.shortWeekdays);
    if (params.ariaEnabled) {
        calendar.renderEvent.subscribe(this.aria, null, calendar);
    }
    this[params.clientId].yuiComponent = calendar;
},
aria: function() {
	var thiz = this;
    // We're already within a context where our initialize() has setup YUI3/2
	var thisYUI = ice.yui3.getY();
	var YAHOO = thisYUI.YUI2;
    var Event = YAHOO.util.Event,
        Dom = YAHOO.util.Dom,
        KeyListener = YAHOO.util.KeyListener,
        Selector = YAHOO.util.Selector;
    var fnTrue = function() {
        return true;
    };
    Dom.setAttribute(thiz.id, "role", "grid");
    var tbody = Dom.getElementBy(fnTrue, "tbody", thiz.id);
    var weeks = Dom.getElementsBy(fnTrue, "tr", tbody);
    for (var i = 0; i < weeks.length; i++) {
        weeks[i].setAttribute("aria-label", "week " + (i + 1));
        //            Dom.setAttribute(weeks[i], "aria-label", "week " + (i + 1));
    }
/*
    var mthYr = Dom.getElementsByClassName("calnav", null, thiz.id)[0];
    mthYr.setAttribute("role", "heading");
    mthYr.setAttribute("aria-label", mthYr.text);
    mthYr.setAttribute("aria-live", "assertive");
    mthYr.setAttribute("aria-atomic", "true");
*/
    Dom.getElementsByClassName("calweekdaycell", null, thiz.id, function(el) {
        el.setAttribute("role", "columnheader");
    });
    Dom.getElementsByClassName("calcell", null, thiz.id, function(el) {
        el.setAttribute("role", "gridcell");
    });
    Dom.getElementsByClassName("selected", null, tbody, function(el) {
        el.setAttribute("aria-selected", "true");
    });
    var tabIndex = thiz.params.tabIndex;
    var selectedCell = Dom.getElementsByClassName(thiz.Style.CSS_CELL_SELECTED, "td", thiz.id)[0];
    Dom.batch(thiz.oDomContainer.getElementsByTagName("a"), function(el) {
        Dom.setAttribute(el, "tabindex", "-1");
    });
    if (selectedCell) {
        Dom.setAttribute(Dom.getFirstChild(selectedCell), "tabindex", tabIndex);
    } else {
        Dom.setAttribute(thiz.oDomContainer.getElementsByTagName("a")[0], "tabindex", tabIndex);
    }
    var keys = KeyListener.KEY;
    var kl1Handler = function(evType, fireArgs, subscribeObj) {
        var charCode = fireArgs[0], evt = fireArgs[1];
        var target = Event.getTarget(evt), newTarget;
        var i;
        switch (charCode) {
            case keys.SPACE:
                if (Selector.test(target, ".selectable .selector")) {
                    thiz.doSelectCell(evt, thiz);
                }
                break;
            case keys.LEFT:
                if (Dom.hasClass(target, thiz.Style.CSS_NAV_LEFT)) {
                    for (i = thiz.cells.length - 1; i >= 0; i--) {
                        if (Dom.hasClass(thiz.cells[i], thiz.Style.CSS_CELL_SELECTABLE)) {
                            newTarget = thiz.cells[i].getElementsByTagName("a")[0];
                            break;
                        }
                    }
                } else if (Dom.hasClass(target, thiz.Style.CSS_NAV)) {
                    newTarget = Dom.getElementsByClassName(thiz.Style.CSS_NAV_LEFT, "a", thiz.id)[0];
                } else if (Dom.hasClass(target, thiz.Style.CSS_NAV_RIGHT)) {
//                    newTarget = Dom.getElementsByClassName(thiz.Style.CSS_NAV, "a", thiz.id)[0];
                    newTarget = Dom.getElementsByClassName(thiz.Style.CSS_NAV_LEFT, "a", thiz.id)[0];
                } else if (Dom.hasClass(target, thiz.Style.CSS_CELL_SELECTOR)) {
                    i = thiz.getIndexFromId(target.parentNode.id) - 1;
                    if (i < 0) {
                        newTarget = Dom.getElementsByClassName(thiz.Style.CSS_NAV_RIGHT, "a", thiz.id)[0];
//                        thiz.doPreviousMonthNav(evt, thiz);
                    } else {
                        for (; i >= 0; i--) {
                            if (Dom.hasClass(thiz.cells[i], thiz.Style.CSS_CELL_SELECTABLE)) {
                                newTarget = thiz.cells[i].getElementsByTagName("a")[0];
                                break;
                            }
                            if (Dom.hasClass(thiz.cells[i], thiz.Style.CSS_CELL_OOM)) {
                                newTarget = Dom.getElementsByClassName(thiz.Style.CSS_NAV_RIGHT, "a", thiz.id)[0];
//                                thiz.doPreviousMonthNav(evt, thiz);
                                break;
                            }
                        }
                    }
                }
                break;
            case keys.RIGHT:
                if (Dom.hasClass(target, thiz.Style.CSS_NAV_LEFT)) {
//                    newTarget = Dom.getElementsByClassName(thiz.Style.CSS_NAV, "a", thiz.id)[0];
//                } else if (Dom.hasClass(target, thiz.Style.CSS_NAV)) {
                    newTarget = Dom.getElementsByClassName(thiz.Style.CSS_NAV_RIGHT, "a", thiz.id)[0];
                } else if (Dom.hasClass(target, thiz.Style.CSS_NAV_RIGHT)) {
                    for (i = 0; i < thiz.cells.length; i++) {
                        if (Dom.hasClass(thiz.cells[i], thiz.Style.CSS_CELL_SELECTABLE)) {
                            newTarget = thiz.cells[i].getElementsByTagName("a")[0];
                            break;
                        }
                    }
                } else if (Dom.hasClass(target, thiz.Style.CSS_CELL_SELECTOR)) {
                    i = thiz.getIndexFromId(target.parentNode.id) + 1;
                    if (i >= thiz.cells.length) {
                        newTarget = Dom.getElementsByClassName(thiz.Style.CSS_NAV_LEFT, "a", thiz.id)[0];
//                        thiz.doNextMonthNav(evt, thiz);
                    } else {
                        for (; i < thiz.cells.length; i++) {
                            if (Dom.hasClass(thiz.cells[i], thiz.Style.CSS_CELL_SELECTABLE)) {
                                newTarget = thiz.cells[i].getElementsByTagName("a")[0];
                                break;
                            }
                            if (Dom.hasClass(thiz.cells[i], thiz.Style.CSS_CELL_OOM)) {
                                newTarget = Dom.getElementsByClassName(thiz.Style.CSS_NAV_LEFT, "a", thiz.id)[0];
//                                thiz.doNextMonthNav(evt, thiz);
                                break;
                            }
                        }
                    }
                }
                break;
            case keys.UP:
                if (Dom.hasClass(target, thiz.Style.CSS_CELL_SELECTOR)) {
                    i = thiz.getIndexFromId(target.parentNode.id) - 7;
                    if (i < 0) {
//                        thiz.doPreviousMonthNav(evt, thiz);
                    } else {
                        for (; i >= 0; i -= 7) {
                            if (Dom.hasClass(thiz.cells[i], thiz.Style.CSS_CELL_SELECTABLE)) {
                                newTarget = thiz.cells[i].getElementsByTagName("a")[0];
                                break;
                            }
                            if (Dom.hasClass(thiz.cells[i], thiz.Style.CSS_CELL_OOM)) {
//                                thiz.doPreviousMonthNav(evt, thiz);
                                break;
                            }
                        }
                    }
                }
                break;
            case keys.DOWN:
                if (Dom.hasClass(target, thiz.Style.CSS_CELL_SELECTOR)) {
                    i = thiz.getIndexFromId(target.parentNode.id) + 7;
                    if (i >= thiz.cells.length) {
//                        thiz.doNextMonthNav(evt, thiz);
                    } else {
                        for (; i < thiz.cells.length; i += 7) {
                            if (Dom.hasClass(thiz.cells[i], thiz.Style.CSS_CELL_SELECTABLE)) {
                                newTarget = thiz.cells[i].getElementsByTagName("a")[0];
                                break;
                            }
                            if (Dom.hasClass(thiz.cells[i], thiz.Style.CSS_CELL_OOM)) {
//                                thiz.doNextMonthNav(evt, thiz);
                                break;
                            }
                        }
                    }
                }
                break;
            case keys.PAGE_UP:
                thiz.doPreviousMonthNav(evt, thiz);
                break;
            case keys.PAGE_DOWN:
                thiz.doNextMonthNav(evt, thiz);
                break;
            case keys.HOME:
                newTarget = Dom.getElementsByClassName(thiz.Style.CSS_CELL_SELECTOR, "a", thiz.id)[0];
                break;
            case keys.END:
                newTarget = Dom.getElementsByClassName(thiz.Style.CSS_CELL_SELECTOR, "a", thiz.id).pop();
                break;
        }
        if (newTarget) {
            Dom.setAttribute(target, "tabindex", "-1");
            Dom.setAttribute(newTarget, "tabindex", tabIndex);
            newTarget.focus();
        }
        Event.stopEvent(evt);
    };
    var kl1 = new KeyListener(thiz.oDomContainer,
    {keys:[keys.SPACE,keys.LEFT,keys.RIGHT,keys.UP,keys.DOWN,keys.HOME,keys.END]},
//    {keys:[keys.SPACE,keys.LEFT,keys.RIGHT,keys.UP,keys.DOWN,keys.PAGE_UP,keys.PAGE_DOWN,keys.HOME,keys.END]},
    {fn:kl1Handler, correctScope:thiz});
    kl1.enable();
},
initialize: function(clientId, jsProps, jsfProps, bindYUI) {
	var thiz = this;
	 ice.yui3.use(function(Y){ 
     Y.use('yui2-yahoo', 'yui2-yahoo-dom-event', 'yui2-dom', 'yui2-event',
           'yui2-element', 'yui2-json', 'yui2-container', 'yui2-selector',
           'yui2-datasource', 'yui2-calendar', 'yui2-button', function(thisYUI) {
	 Y.on('domready', function(){
			var YAHOO = thisYUI.YUI2;
	var lang = YAHOO.lang;
    thiz[clientId] = thiz[clientId] || {};
    var params = lang.merge({clientId:clientId}, jsProps, jsfProps);
//    console.log("params =", lang.dump(params));






	if (!ice.component.calendar.isReady) {
		ice.component.calendar.setupLib(thisYUI);
		ice.component.calendar.isReady = true;
	}

    var Element = YAHOO.util.Element,
        Event = YAHOO.util.Event,
        Dom = YAHOO.util.Dom,
        KeyListener = YAHOO.util.KeyListener;

    var rootId = params.clientId, rootEl = new Element(rootId); // server-side rendering root
    var calRootId = rootId + "_calRoot", calRootEl;             // client-side rendering root
    var calContainerId = rootId + "_cal", calContainerEl;       // calendar container
    var calRootHtmlEl = Dom.getLastChildBy(Dom.get(rootId), function(el){return el.id == calRootId;});
    if (calRootHtmlEl) {
        calRootHtmlEl.innerHTML = "";
        calRootEl = new Element(calRootHtmlEl);
    } else {
        calRootEl = new Element(document.createElement("div"), {id:calRootId, className:"ice-calcontainer"});
        calRootEl.appendTo(rootEl);
        var clearDiv = new Element(document.createElement("div"));
        Dom.setAttribute(clearDiv, "style", "clear: left;");
        clearDiv.appendTo(rootEl);
    }
    // hidden field to store date value string
    var calValueId = rootId + "_value";
    var calValueEl = new Element(document.createElement("input"), {type:"hidden", id:calValueId, name:calValueId, value:params.hiddenValue});
    calValueEl.appendTo(calRootEl);
    thiz[rootId].calValueEl = calValueEl;
    var calendar; // IceCalendar object
    if (!params.renderAsPopup) { // inline calendar
        calContainerEl = new Element(document.createElement("div"), {id:calContainerId});
        calContainerEl.appendTo(calRootEl);
        function inlineDateSelectHandler(type, args, calendar) {
//            console.log("calendar.currentFocus =", calendar.currentFocus);
            ice.setFocus(calendar.currentFocus);
            Dom.getFirstChild(calendar.currentFocus).focus();
            var time = ice.component.calendar.getTime(calendar);
            var dateStr = args[0][0][0] + "-" + args[0][0][1] + "-" + args[0][0][2] + " " + time.hr + ":" + time.min;
            calValueEl.set("value", dateStr, true);
            var context = ice.component.getJSContext(params.clientId);
            var sJSFProps = context.getJSFProps();
            if (sJSFProps.singleSubmit) {
                ice.se(null, rootId);
            }
        }
        calendar = new ice.component.calendar.IceCalendar(calContainerId, { // Art: non-structural change, 'calContainerEl' was before 'calContainerId'
            pagedate:params.pageDate,
            selected:params.selectedDate,
            hide_blank_weeks:true,
			iframe:false // Art: non-structural change, this option wasn't present
//            navigator:true
        }, params);
        thiz.configCal(calendar, params);
        calendar.selectEvent.subscribe(inlineDateSelectHandler, calendar, true);
        calendar.render();
        if (Dom.isAncestor(rootId, params.currentFocus)) {
            Dom.getFirstChild(params.currentFocus).focus();
        }
        if (params.tabIndex && !params.ariaEnabled) {
            calContainerEl.set("tabIndex", params.tabIndex, true);
        }
        return;
    }
    var inputId = rootId + "_input";
    var inputEl = new Element(document.createElement("input"), {type:"text", value:params.dateStr, className:"text-input", id:inputId, name:inputId});
    var toggleBtnEl = new Element(document.createElement("input"), {type:"button", className:"toggle-popup open-popup"});
    if (params.disabled) {
        inputEl.setAttributes({disabled:"disabled", "aria-disabled":true}, true);
        toggleBtnEl.setAttributes({disabled:"disabled", "aria-disabled":true}, true);
    }
    if (params.tabIndex) {
        inputEl.set("tabIndex", params.tabIndex, true);
        toggleBtnEl.set("tabIndex", params.tabIndex, true);
    }
    var inputChange = function(evt) {
        calValueEl.setAttributes({value:this.get("value")}, true);
        var context = ice.component.getJSContext(params.clientId);
        var sJSFProps = context.getJSFProps();
        if (sJSFProps.singleSubmit) {
            ice.se(evt, rootId);
        }
    };
    if (params.renderInputField) {
        inputEl.appendTo(calRootEl);
        inputEl.addListener("change", inputChange);
    }
    toggleBtnEl.appendTo(calRootEl);

    var cancelClick = function() {
        this.hide();
        toggleBtnEl.replaceClass("close-popup", "open-popup");
    };
    var okClick = function(evt, dialog) {
        this.hide();
        toggleBtnEl.replaceClass("close-popup", "open-popup");
        var context = ice.component.getJSContext(params.clientId);
        var calendar = context.getComponent();
        if (calendar.getSelectedDates().length <= 0) return;
        var date = calendar.getSelectedDates()[0];
        var time = ice.component.calendar.getTime(calendar);
        var dateStr = date.getFullYear() + "-" + (date.getMonth() + 1) + "-" + date.getDate() + " " + time.hr + ":" + time.min;
        calValueEl.setAttributes({value:dateStr}, true);
        var sJSFProps = context.getJSFProps();
        var submit = sJSFProps.singleSubmit ? ice.se : (sJSFProps.renderInputField ? ice.ser : null);
        if (submit) submit(evt, rootId);
    };
    var popupDateSelectHandler = function(type, args, calendar) {
        ice.setFocus(calendar.currentFocus);
        Dom.getFirstChild(calendar.currentFocus).focus();
    }
    var dialog = new YAHOO.widget.Dialog(rootId + "_dialog", {
        visible:false,
        context:[params.renderInputField ? inputEl : toggleBtnEl, "tl", "bl"],
        buttons:[{text:"OK", handler:okClick}, {text:"Cancel", isDefault:true, handler:cancelClick}],
        draggable:false,
        close:false,
        underlay:"none",
        constraintoviewport:true
    });
    dialog.setBody("<div id='" + calContainerId + "'/>");
    dialog.render(calRootEl);
    if (params.tabIndex && !params.ariaEnabled) {
        Dom.setAttribute(dialog.id, "tabindex", params.tabIndex);
    }

    calendar = new ice.component.calendar.IceCalendar(calContainerId, {
        pagedate:params.pageDate,
        selected:params.selectedDate,
        iframe:false,
        hide_blank_weeks:true
//        navigator:true
    }, params);
    thiz.configCal(calendar, params);
    calendar.selectEvent.subscribe(popupDateSelectHandler, calendar, true);
    calendar.render();

//   thiz = this;
   var toggleClick = null;
////	ice.yui3.use(function(Y) {

    var animation = ice.animation.getAnimation(params.clientId, "transition");

	if (animation) {
			animation.chain.set('node', '#'+ dialog.id+'_c');
			animation.chain.on('end', function() {
				if (animation.get('reverse')) {
					dialog.show();
					toggleBtnEl.replaceClass("open-popup", "close-popup");
				} else {
					dialog.hide();
					toggleBtnEl.replaceClass("close-popup", "open-popup");
				}
			});
	}
     toggleClick = function() {

	     thix = this;
        if (this.hasClass("open-popup")) {
				if (animation) {
					animation.chain.set('reverse', true);
					animation.chain.run();
				} else {
				dialog.show();
				this.replaceClass("open-popup", "close-popup");
			}
        } else {
			if (animation) {
				animation.chain.set('reverse', false);
				animation.chain.run();
			} else {
				dialog.hide();
				this.replaceClass("close-popup", "open-popup");
			}
        }
    };


////	});

    var inputEnter = function(evType, fireArgs, subscribeObj) {
//        console.log(this);
//        for (var i = 0; i < arguments.length; i++) {
//            console.log(arguments[i]);
//        }
        inputEl.removeListener("change", inputChange);
        calValueEl.setAttributes({value:this.value}, true);
/*
        ice.submit(fireArgs[1], this, function(p) {
            p(calValueEl.get("name"), calValueEl.get("value"));
        });
*/
        inputEl.addListener("blur", function() {
            this.addListener("change", inputChange);
        });
    };
    var inputKL = new KeyListener(inputEl.get("element"), {keys:KeyListener.KEY.ENTER},
                                  {fn:inputEnter, scope:inputEl.get("element"), correctScope:true});

    // We're already in an onload block
////    var domReady = function() {
        Event.addListener(document, "click", function(e) {
            var el = Event.getTarget(e);
            var dialogEl = dialog.element;
            var showBtn = toggleBtnEl.get("element");
            if (el != dialogEl && !Dom.isAncestor(dialogEl, el) && el != showBtn && !Dom.isAncestor(showBtn, el)) {
                dialog.hide();
                toggleBtnEl.replaceClass("close-popup", "open-popup");
            }
        });
        toggleBtnEl.addListener("click", toggleClick);
        inputKL.enable();
////    };

////    Event.onDOMReady(domReady);







	
	bindYUI(thiz[clientId].yuiComponent);
	});
    });
	});
},
updateProperties: function(clientId, jsProps, jsfProps, events) {
	var thiz = this;

    ice.yui3.use(function(Y){
    //Y.use('yui2-yahoo', function(Yui) {
    Y.use('yui2-yahoo', 'yui2-yahoo-dom-event', 'yui2-dom', 'yui2-event',
           'yui2-element', 'yui2-json', 'yui2-container', 'yui2-selector',
           'yui2-datasource', 'yui2-calendar', 'yui2-button', function(Yui) {
    Yui.on('domready', function(){

    var YAHOO = Yui.YUI2;
    var lang = YAHOO.lang;

    var context = ice.component.getJSContext(clientId);
    if (context && context.isAttached()) {
        var prevProps = lang.merge(context.getJSProps(), context.getJSFProps());
        var currProps = lang.merge(jsProps, jsfProps);
        for (var prop in currProps) {
            if (!lang.hasOwnProperty(currProps, prop)) continue;
            if (currProps[prop] == prevProps[prop]) continue;
            var component = context.getComponent();
            if (component) {
                component.destroy();
            }
            document.getElementById(clientId)['JSContext'] = null;
            JSContext[clientId] = null;
            break;
        }
    }
    ice.component.updateProperties(clientId, jsProps, jsfProps, events, ice.component.calendar);

	}, '#' + clientId);
	});
    });
},
getInstance: function(clientId, callback) {
    ice.component.getInstance(clientId, callback, this);
}
};
//lang.augmentObject(calendarns, ns, true);
//})();
/*
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations under
 * the License.
 *
 * The Original Code is ICEfaces 1.5 open source software code, released
 * November 5, 2006. The Initial Developer of the Original Code is ICEsoft
 * Technologies Canada, Corp. Portions created by ICEsoft are Copyright (C)
 * 2004-2011 ICEsoft Technologies Canada, Corp. All Rights Reserved.
 *
 * Contributor(s): _____________________.
 */

ice.component.linkButton = {

    initialize:function(clientId, jsProps, jsfProps, bindYUI) {
//	   if (YAHOO.widget.Logger){
//	 	  YAHOO.widget.Logger.enableBrowserConsole();
//       }

	 ice.yui3.use(function(Y){
     Y.use('yui2-button', function(Yui) {
	 Y.on('domready', function(){
		var YAHOO = Y.YUI2;

        var spanId = clientId + "_span";
	    var oLinkButton = new YAHOO.widget.Button(spanId,{ label: jsProps.label, tabindex: null }, {type: jsProps.type});

        root = document.getElementById(spanId);

		root.firstChild.setAttribute("role", "link");
	    root.firstChild.setAttribute("aria-labelledby",jsProps.label);
	    if (jsfProps.disabled){
	        root.firstChild.setAttribute("aria-disabled", jsfProps.disabled);
	    }
	    // If there's no action listener, this is standard anchor behaviour
	    // otherwise it's got an actionListener/action attribute. Described by offers further description
	    if (!jsfProps.doAction ) {
	       root.firstChild.setAttribute("aria-describedby", "Standard HTML anchor");
	    } else {
           root.firstChild.setAttribute("aria-describedby", "JSF action event source");
        } 

		bindYUI(oLinkButton);
	 }); // *** end of domready
	 }); // *** end of Y.use
	 }); // *** end of ice.yui3.use
	},
	
    //delegate call to ice.yui.updateProperties(..)  with the reference of this lib
    updateProperties:function(clientId, jsProps, jsfProps, events) {

        var context = ice.component.getJSContext(clientId);
        if (context && context.isAttached()) {
            var prevJSFProps = context.getJSFProps();
            if (prevJSFProps.hashCode != jsfProps.hashCode) {
                context.getComponent().destroy();
                document.getElementById(clientId)['JSContext'] = null;
                JSContext[clientId] = null;
            }
        }
        ice.component.updateProperties(clientId, jsProps, jsfProps, events, this);
    },
 
    //delegate call to ice.yui.getInstance(..) with the reference of this lib
    getInstance:function(clientId, callback) {
        ice.component.getInstance(clientId, callback, this);
    },

    // Click handler visible from Renderer code 
    clickHandler : function (e, clientId) {
        var JSContext = ice.component.getJSContext(clientId);
        var singleSubmit = JSContext.getJSFProps().singleSubmit;
        var doAction = JSContext.getJSFProps().doAction;
        //YAHOO.log("--> Button.doAction = " + doAction);

        var divRoot = document.getElementById(clientId);

        var postParameters = JSContext.getJSFProps().postParameters;
        var params = function(parameter) {
            if (postParameters != null) {
                var argCount = postParameters.length / 2;
                for (var idx =0; idx < argCount; idx ++ ) {
                    parameter( postParameters[idx*2], postParameters[(idx*2)+1] );
                }
            }
        };
        if (singleSubmit) {
            //YAHOO.log("Single Submit on element: " + divRoot);
            ice.se(e, divRoot, params );
        } else {
            //YAHOO.log("Full Submit on element: " + divRoot);
            ice.s(e, divRoot, params );
        }
        // If there are actionListeners, don't do default behaviour
        if (doAction) {
            return false;
        }
    },

    // keyDown handler visible from Renderer code
    keyDownHandler : function (e, clientId) {
        if (e.keyCode != 13) {
            return true;
        }
        var JSContext = ice.component.getJSContext(clientId);
        var singleSubmit = JSContext.getJSFProps().singleSubmit;
        var doAction = JSContext.getJSFProps().doAction;
        //YAHOO.log("--> Button.doAction = " + doAction);

        var divRoot = document.getElementById(clientId);

        var postParameters = JSContext.getJSFProps().postParameters;
        var params = function(parameter) {
            if (postParameters != null) {
                var argCount = postParameters.length / 2;
                for (var idx =0; idx < argCount; idx ++ ) {
                    parameter( postParameters[idx*2], postParameters[(idx*2)+1] );
                }
            }
        };
        if (singleSubmit) {
            //YAHOO.log("Single Submit on element: " + divRoot);
            ice.se(e, divRoot, params );
        } else {
            //YAHOO.log("Full Submit on element: " + divRoot);
            ice.s(e, divRoot, params );
        }
        // If there are actionListeners, don't do default behaviour
        if (doAction) {
            return false;
        }
    }
};
/*
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations under
 * the License.
 *
 * The Original Code is ICEfaces 1.5 open source software code, released
 * November 5, 2006. The Initial Developer of the Original Code is ICEsoft
 * Technologies Canada, Corp. Portions created by ICEsoft are Copyright (C)
 * 2004-2011 ICEsoft Technologies Canada, Corp. All Rights Reserved.
 *
 * Contributor(s): _____________________.
 */

ice.component.logger = {
    initialize:function(clientId, jsProps, jsfProps, bindYUI) {
	
        ice.yui3.use(function(Y){
        Y.use('yui2-logger', function(Yui) {
        Y.on('domready', function(){

        //setup Yahoo logger for either global/page or particular component
        var YAHOO = Yui.YUI2;
	    var calLogReader = new YAHOO.widget.LogReader(null, {newestOnTop:false});
	    calLogReader.setTitle("Yui Logger");
	    calLogReader.hideSource("global");
	    calLogReader.hideSource("LogReader");
        if (jsProps.debugElement){
            var logger = new YAHOO.widget.LogReader("jsfProps.debugElement");
        }
        else{
            var logger = new YAHOO.widget.LogWriter("Page Console");
        }
        YAHOO.widget.Logger.enableBrowserConsole();

//		logger.log("params id"+clientId);

		
//		if(jsProps.label) {
//			button.set('label', jsProps.label);
//		}
//
//		if(jsProps.type) {
//			button.set('button', jsProps.type);
//		} 
//		
//		bindYUI(button);
        });
	    });
        });
	},
	
   //delegate call to ice.yui.updateProperties(..)  with the reference of this lib
   updateProperties:function(clientId, jsProps, jsfProps, events) {
       ice.component.updateProperties(clientId, jsProps, jsfProps, events, this);
   },
 
   //delegate call to ice.yui.getInstance(..) with the reference of this lib 
   getInstance:function(clientId, callback) {
       ice.component.getInstance(clientId, callback, this);
   }
   
   
};
/*
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations under
 * the License.
 *
 * The Original Code is ICEfaces 1.5 open source software code, released
 * November 5, 2006. The Initial Developer of the Original Code is ICEsoft
 * Technologies Canada, Corp. Portions created by ICEsoft are Copyright (C)
 * 2004-2011 ICEsoft Technologies Canada, Corp. All Rights Reserved.
 *
 * Contributor(s): _____________________.
 */

ice.component.pushbutton = {
    initialize:function(clientId, jsProps, jsfProps, bindYUI) {
//      if (YAHOO.widget.Logger) {
//            YAHOO.widget.Logger.enableBrowserConsole();
//      }

	 ice.yui3.use(function(Y){ 
     Y.use('yui2-button', function(Yui) {
	 Y.on('domready', function(){
	    var YAHOO = Y.YUI2;
	 
        //want the span id
        var spanId = clientId + "_span";
        YAHOO.log("clientId=" + clientId + " spanId=" + spanId);
        //get the button html element
        var buttonNode = document.getElementById(spanId);

        var button = new YAHOO.widget.Button(spanId,
            {label: jsProps.label, tabindex: null,
            type: jsProps.type});


        if (jsProps.label) {
            button.set('label', jsProps.label);
        }

        if (jsProps.type) {
            button.set('button', jsProps.type);
        }
/*
        if (!jsProps.tabindex) {
            button.set('tabindex', jsProps.tabindex);
        }
*/

        if (jsfProps.disabled) {
            button.set("disabled", true);
        } else {
            button.set("disabled", false);
        }

        var params = function(parameter) {
            var context = ice.component.getJSContext(clientId);
            var sJSFProps = context.getJSFProps();
            var postParameters = sJSFProps.postParameters;
            if (postParameters != null) {
                 var argCount = postParameters.length / 2;
                 for (var idx =0; idx < argCount; idx ++ ) {
                     parameter( postParameters[idx*2], postParameters[(idx*2)+1] );
                 }
            }
        };


        var onClick = function (e) {
            YAHOO.log(" in onClick and e.target=" + e.target);
            YAHOO.log("  buttonRoot=" + buttonRoot + "  buttonNode=" + buttonNode);
            var divRoot = document.getElementById(clientId);
            //singleSubmit means button just submits itself and renders itself
            //single submit false means that it submits the form
            var context = ice.component.getJSContext(clientId);
            var singleSubmit = context.getJSFProps().singleSubmit;

            if (singleSubmit) {
                YAHOO.log(" single submit is true for clientId=" + spanId);
                ice.se(e, divRoot, params);
            } else {
                YAHOO.log("single Submit is false for clientId=" + spanId);
                ice.s(e, divRoot, params);
            }
        };

        buttonRoot = document.getElementById(spanId);
        if (jsfProps.aria) {
            //add roles and attributes to the YUI slider widget
            buttonRoot.firstChild.setAttribute("role", "button");
            if (jsfProps.ariaLabel) {
                buttonRoot.firstChild.setAttribute("aria-describedby", jsfProps.ariaLabel);
            } else {
                buttonRoot.firstChild.setAttribute("aria-describedby", "button description unavailable");
            }
            if (jsfProps.disabled) {
                buttonRoot.firstChild.setAttribute("aria-disabled", jsfProps.disabled);
            }
        }

        button.on("click", onClick);


        bindYUI(button);
	 }); // *** end of domready
	 }); // *** end of Y.use
	 }); // *** end of ice.yui3.use
    },
	
   //delegate call to ice.yui.updateProperties(..)  with the reference of this lib
   updateProperties:function(clientId, jsProps, jsfProps, events) {
       var context = ice.component.getJSContext(clientId);
       if (context && context.isAttached()) {
           var prevJSFProps = context.getJSFProps();
           if (prevJSFProps.hashCode != jsfProps.hashCode) {
               context.getComponent().destroy();
               document.getElementById(clientId)['JSContext'] = null;
               JSContext[clientId] = null;
           }
       }
	   ice.yui3.updateProperties(clientId, jsProps, jsfProps, events, this);
       //ice.component.updateProperties(clientId, jsProps, jsfProps, events, this);
   },
 
   //delegate call to ice.yui.getInstance(..) with the reference of this lib 
   getInstance:function(clientId, callback) {
       ice.component.getInstance(clientId, callback, this);
   }
   
   
};
/*
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations under
 * the License.
 *
 * The Original Code is ICEfaces 1.5 open source software code, released
 * November 5, 2006. The Initial Developer of the Original Code is ICEsoft
 * Technologies Canada, Corp. Portions created by ICEsoft are Copyright (C)
 * 2004-2011 ICEsoft Technologies Canada, Corp. All Rights Reserved.
 *
 * Contributor(s): _____________________.
 */

ice.component.slider = {
   initialize:function(clientId, yuiProps, jsfProps, bindYUI) {
        
        //get the slider html element
        var root = document.getElementById(clientId);
        
        //for short cut and to make it more like OOP
        //var super = ice.yui3;

        var hiddenFieldId = clientId+"_hidden";

        //set a callback to create slider component 
        ice.yui3.use(function(Y){
            Y.use('slider', function(Yui) {
        	    Y.on('domready', function(){
				    var hiddenField = document.getElementById(clientId+"_hidden");
				
					try {
			            var obj = new Y.Slider({
							//following two properties has to be set when initializing componnent
							axis: yuiProps.axis,
							thumbUrl: jsfProps.thumbUrl
							});
	 
						obj.updateLabels = function() {
							obj.updateMinLabel();
							obj.updateMaxLabel();
							obj.updateMidLabel();
						}	
						obj.updateMinLabel = function(min) {
							var nodes = obj.get('railRef').get('children');
				 			nodes.item(0).setContent("<div class='sldrLblMn'>"+ yuiProps.min + '</div>');
						}
						
						obj.updateMaxLabel = function(max) {
							var nodes = obj.get('railRef').get('children');
							nodes.item(1).setContent("<div class='sldrLblMx'>"+ yuiProps.max+ '</div>');
						}
						
						obj.updateMidLabel = function(mid) {
							if (!obj.get('midLblNode')) {
							    if (yuiProps.axis == 'y') {
									obj.get('railRef').append("<div class='sldrLblMid'></div>");	
									obj.set('midLblNode', obj.get('railRef').get('children').item(3));								
								} else {
									obj.get('railRef').append("<center><div class='sldrLblMid'></div></center>");	
									obj.set('midLblNode', obj.get('railRef').get('children').item(3).get('children').item(0));
								}
							}
							obj.get('midLblNode').setContent(parseInt(((yuiProps.max - yuiProps.min)/2)+yuiProps.min));
						}
						if (jsfProps.showLabels) {						
							obj.renderRail_ = obj.renderRail;
							obj.renderRail = function() {
								var railNode = obj.renderRail_();
			
							    if (!railNode.hasClass("sldrLbl")) {
									railNode.addClass("sldrLbl");
								}
							 						
	
								obj.set('railRef', railNode);
								return railNode;
							}
						}
						
						obj.render(root);
                        obj.set('disabled', yuiProps.disabled);
                        if (jsfProps.showLabels) {
							obj.updateLabels();
	                        obj.on('minChange', function(prop) {
								yuiProps.min = prop.newVal;
								obj.updateLabels();
							});
				            obj.on('maxChange', function(prop) {
								yuiProps.max = prop.newVal;
								obj.updateLabels();
							});						
                        }
				
					} catch(e){alert(e)}
						
					var invokeSubmit = function (event) {
						var context = ice.component.getJSContext(clientId);
						var sJSFProps = context.getJSFProps();
						if (sJSFProps.singleSubmit) {
							var sObj = context.getComponent();
							var postParameters = sJSFProps.postParameters;
							ice.se(event, root, function(param) {
								param(hiddenFieldId, sObj.get('value'));
								param('ice.focus', ice.focus);
								param('onevent', function(data) { 
									if (data.status == 'success') {
										if (ice.focus == clientId) {
											root.firstChild.focus();
										}
									}
								});
								if (postParameters != null) {
									var argCount = postParameters.length / 2;
									for (var idx =0; idx < argCount; idx ++ ) {
										param( postParameters[idx*2], postParameters[(idx*2)+1] );
									}
								}
							});
						}  						
					}
						
						obj.after("focus", function() {
							ice.focus = clientId;
						});
						
						obj.after("blur", function() {
							ice.focus = "";
						});
						
					    var eventName;
						obj.after("valueChange", function(event) {
                            var context = ice.component.getJSContext(clientId);
                            var vcObj = context.getComponent();
						    var sliderValue = vcObj.get('value');
		                    //if aria is enabled, then set aria property so screen reader can pick it
                            var vcJSFProps = context.getJSFProps();
                            if (vcJSFProps.aria) {
		                        // Because we're in a callback, to be safe we'll lookup
		                        //  the current root element again, instead of using
		                        //  the old root reference, which might be stale.
		                        document.getElementById(clientId).firstChild.setAttribute("aria-valuenow", sliderValue);
		                    }

		                    // Strategy is now to use hidden field rather than
		                    // request map value

                            var hiddenField = document.getElementById(hiddenFieldId);
		                    hiddenField.value=sliderValue;
                            var shouldSubmit = (eventName == 'railMouseDown');
                            eventName = "";
							if (shouldSubmit) {
								invokeSubmit(event);
							}
						});
						
						obj.before("railMouseDown", function() {
                            root.firstChild.focus();
						});
						obj.after("railMouseDown", function() {
						  eventName = "railMouseDown";
						});

						obj.after("slideEnd", function(event) {
							invokeSubmit(event);
						});


                        if (Yui.Lang.isValue(jsfProps.tabindex)) {
                            Yui.one(root).one(".yui3-slider-thumb").set("tabIndex", jsfProps.tabindex);
                        }
		                //add aria support
		                if (jsfProps.aria) {
		                    //add roles and attributes to the YUI slider widget
		                    root = document.getElementById(clientId);
		                    root.firstChild.setAttribute("role", "slider");
		                    root.firstChild.setAttribute("aria-valuemin", yuiProps.min);
		                    root.firstChild.setAttribute("aria-valuemax", yuiProps.max);
		                    root.firstChild.setAttribute("aria-valuenow",yuiProps.value );

		                    //TODO shouldn't it be configurable?
							var keydownTimeoutHandler = null;
		                    //listen for keydown event, to provide short-cut key support.
		                    //react on left, right, up, down, home and end key 
		                    Y.on("keydown", function(event) {
		                        //get the current value of the slider
                                var context = ice.component.getJSContext(clientId);
                                var kbObj = context.getComponent();
                                var valuenow = kbObj.get('value');
//                                var valuenow = parseInt(root.firstChild.getAttribute("aria-valuenow"));
		                        var valuebefore = valuenow;

                                var kdYuiProps = context.getJSProps();
                                var kdMin = kdYuiProps.min;
                                var kdMax = kdYuiProps.max;

                                var kdJsfProps = context.getJSFProps();
                                var stepPercent = kdJsfProps.stepPercent;
                                var step = Math.round(
                                    Math.abs(kdMax - kdMin) * stepPercent / 100);

		                        var isLeft = event.keyCode == 37;
		                        var isUp = event.keyCode == 38;
		                        var isRight = event.keyCode == 39;
		                        var isDown = event.keyCode == 40;                        
		                        var isHome = event.keyCode == 36;
		                        var isEnd = event.keyCode == 35;

                                if (isLeft || isDown) {
                                    //decrease slider value
                                    valuenow -= step;
                                    if (valuenow < kdMin) {
                                        valuenow = kdMin;
                                    }
		                        } else if (isRight || isUp) {
		                            //increase slider value
                                    valuenow += step;
		                            if (valuenow > kdMax) {
		                                valuenow = kdMax;
		                            }
		                        } else if (isHome) {
		                           //get the min value of slider 
		                           valuenow = kdMin;
		                        } else if (isEnd) {
		                           //get the max value of slider 
		                           valuenow = kdMax;		
		                        }

		                        //if value changed?
		                        if (valuebefore != valuenow)  { 
		                            //update slider value on client
//                                    var kbObj = context.getComponent();
		                            kbObj.set('value', valuenow);
		                            //notify server
							        clearTimeout(keydownTimeoutHandler);	
							        keydownTimeoutHandler = setTimeout (function(){
											//invoke submit
											invokeSubmit(event);		                            
											keydownTimeoutHandler = null;
										},  300);									
		                            //cancel event
		                        }
                                if (isLeft || isUp || isRight || isDown || isHome || isEnd) {
                                    event.halt();
                                }
		                    }, root);
		                } 

						Y.on("click", function(event) {
							root.firstChild.focus();
						}, root);
						//bind the initilized js component, so it can be reused for later calls
		                bindYUI(obj);
		        });
 			});
        });
   },
   
   //delegate call to ice.yui3.updateProperties(..)  with the reference of this lib
   updateProperties:function(clientId, yuiProps, jsfProps, events) {
      var context = ice.component.getJSContext(clientId);
      if (context && context.isAttached()) {
          var prevJSFProps = context.getJSFProps();
          if (prevJSFProps.hashCode != jsfProps.hashCode) {
              context.getComponent().destroy();
              document.getElementById(clientId)['JSContext'] = null;
              JSContext[clientId] = null;
          }
      }
      ice.yui3.updateProperties(clientId, yuiProps, jsfProps, events, this);
   },
 
   //delegate call to ice.yui3.getInstance(..) with the reference of this lib 
   getInstance:function(clientId, callback) {
       ice.yui3.getInstance(clientId, callback, this);
   }
};

/*
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations under
 * the License.
 *
 * The Original Code is ICEfaces 1.5 open source software code, released
 * November 5, 2006. The Initial Developer of the Original Code is ICEsoft
 * Technologies Canada, Corp. Portions created by ICEsoft are Copyright (C)
 * 2004-2011 ICEsoft Technologies Canada, Corp. All Rights Reserved.
 *
 * Contributor(s): _____________________.
 */

ice.component.tabset = {
    initialize:function(clientId, jsProps, jsfProps, bindYUI) {
       //logger.info('1. tabset initialize');
	 
	 ice.yui3.use(function(Y){ 
     Y.use('yui2-tabview', function(Yui/*, result*/) {
         /*
         if (!result.success) {
             alert("Load failure: " + result.msg);
         }
         */
	 Y.on('domready', function(){
	     var YAHOO = Y.YUI2;//TODO Yui.YUI2 ?
		 var Dom = YAHOO.util.Dom;

       var tabview = new YAHOO.widget.TabView(clientId);  
       tabview.set('orientation', jsProps.orientation);
       var thiz = this;
       
       //if tabset is client side, lets find out if the state is already stored.
       if (jsfProps.isClientSide) {
    	   if(ice.component.clientState.has(clientId)){
    		   tabview.set('activeIndex', ice.component.clientState.get(clientId));      
    	   }
    	   else {
    		   tabview.set('activeIndex', jsfProps.selectedIndex);      
    	   }
       }
       
       /*
        if (!Ice.component.registeredComponents[clientId]) {
            var onupdate = Ice.component.getProperty(clientId, 'onupdate');
            if (onupdate["new"] != null) {
                ice.onAfterUpdate(function() {
                    tabview = Ice.component.getInstance(clientId, Ice.component.tabset);
                    onupdate["new"](clientId, tabview );
                });
            }       
        }
        */
       
       //add hover effect 
       if (jsfProps.hover) {
           hoverEffect = function(event, attributes) {  
               target = ice.component_util.eventTarget(event);
               target = target.parentNode;
               if ("selected" == target.parentNode.className) return;         
               anim = new YAHOO.util.ColorAnim(target, attributes); 
               anim.animate(); 
           };       
           var tabs = tabview.get('tabs');
           //logger.info('tabs.length  '+ tabs.length);       
           for (i=0; i<tabs.length; i++) {
              tab = tabs[i].get('labelEl');
              tabs[i].get('labelEl').onmouseover = function(event) {
                  var attributes = { 
                       backgroundColor: { from: '#DEDBDE', to: '#9F9F9F' } 
                  }; 
                  hoverEffect(event, attributes);        
              }
              tabs[i].get('labelEl').onmouseout = function(event) {
                  var attributes = { 
                     backgroundColor: { from: '#9F9F9F', to: '#DEDBDE'  } 
                  }; 
                  hoverEffect(event, attributes);         
              }          
           }
       }
       //hover ends
               
       //logger.info('3. tabset initialize');
       var tabChange=function(event) {
            var context = ice.component.getJSContext(clientId);
            var tabview = context.getComponent();
            var sJSFProps = context.getJSFProps();
            event.target = document.getElementById(clientId);
            tbset = document.getElementById(clientId);
            currentIndex = tabview.getTabIndex(event.newValue);
            //YAHOO.log(" currentIndex="+currentIndex);
            tabIndexInfo = clientId + '='+ currentIndex;
            var params = function(parameter) {
							parameter('ice.focus', event.newValue.get('element').firstChild.id);
                            parameter('onevent', function(data) {
                                var context = ice.component.getJSContext(clientId);
                                var tabview = context.getComponent();
                                if (data.status == 'success') {
                                        var lastKnownSelectedIndex = ice.component.getJSContext(clientId).getJSFProps().selectedIndex;   
	                                    if (lastKnownSelectedIndex != currentIndex) {
	                                            tabview.removeListener('activeTabChange');
	                                            if (!jsfProps.isClientSide){
	                                                tabview.set('activeIndex', lastKnownSelectedIndex);
	                                            }else {
		                                  	    	tabview.selectTab(currentIndex);
	                                            }
	                                            tabview.addListener('activeTabChange', tabChange); 
	                                            currentIndex = lastKnownSelectedIndex; 
	                                    }
                                   try {
									document.getElementById(event.newValue.get('element').firstChild.id).focus();		
                                   } catch(e) {}    
								
									 
 
                                                                         
                                }
                            });
                        };
            if (sJSFProps.isClientSide){
            	//YAHOO.log(" clientSide and currentIndex="+currentIndex);
            	ice.component.clientState.set(clientId, currentIndex);
                //console.info('Client side tab ');
            } else {
                var targetElement = ice.component.tabset.getTabIndexField(tbset);
                if(targetElement) {
                	targetElement.value = tabIndexInfo;
                }            	
                //logger.info('Server side tab '+ event);
                try {
                    if (sJSFProps.isSingleSubmit) {
                    	//backup id
                    	var elementId = targetElement.id;
                    	//replace id with the id of tabset component, so the "execute" property can be set to tabset id
                    	targetElement.id = clientId;
                    	ice.se(event, targetElement, params);
                    	//restore id
                    	targetElement.id = elementId;
                    } else {
                        ice.submit(event, targetElement, params);                    
                    }
                } catch(e) {
                    logger.info(e);
                }                
            }//end if    
       }//tabchange; 
       
       //Check for aria support

       var onKeyDown = null;
       var Event = YAHOO.util.Event;
       //add aria + keyboard support
       if (jsfProps.aria) {
           var goNext = function(target) {
               var nextLi = Dom.getNextSibling(target);
               if (nextLi == null) {
                   goFirst(target);
               } else {
                   Dom.getFirstChild(nextLi).focus();
               }
           };
       
           var goPrevious= function(target) {
               var previousLi = Dom.getPreviousSibling(target);
               if (previousLi == null) {
                  goLast(target);
               } else {
                  Dom.getFirstChild(previousLi).focus();
               }
           };
           
           var goLast= function(target) {
               var lastLi = Dom.getLastChild(target.parentNode);  
               Dom.getFirstChild(lastLi).focus(); 
           };
           
           var goFirst= function(target) {
               var firstLi = Dom.getFirstChild(target.parentNode);
               Dom.getFirstChild(firstLi).focus();                             
           };
                   
           onKeyDown = function(event) {
                var target = Event.getTarget(event).parentNode;
                var charCode = Event.getCharCode(event);
                switch (charCode) {
                   case 37://Left
                   case 38://Up
                     goPrevious(target);
                     break;
                     
                   case 39://Right
                   case 40://Down
                     goNext(target);
                     break;                     
                    
                   case 36: //HOME
                     goFirst(target);
                     break;                   
                     
                   case 35: //End  
                     goLast(target);
                     break;    
                }
           };
       }
       var onKeyPress = function(event, index) {
            var context = ice.component.getJSContext(clientId);
            var tabview = context.getComponent();
            var target = Event.getTarget(event).parentNode;
			if(ice.component_util.isEventSourceInputElement(event)) {
				return true ;
			}
			//check for enter or space key
            var isEnter = Event.getCharCode(event) == 13 || 
					Event.getCharCode(event) == 32 ; 
            if (isEnter) {
               tabview.set('activeIndex', index);
			   event.cancelBubble = true;
            }
       };
       
       var tabs = tabview.get('tabs');
       for (i=0; i<tabs.length; i++) {
           if (onKeyDown){//do it for aria only
              tabs[i].on('keydown', onKeyDown);
           }
           //support enter key regardless of keyboard or aria support 
           tabs[i].on('keypress', onKeyPress, i); 
       }

    
	   //console.info('effect >>> '+ jsfProps.effect );
 
	   var animation = ice.animation.getAnimation(clientId, "transition");
	   
	   if (animation) {
		   //console.info('effect found... length ='+ jsfProps.effect.length + 'value = '+ jsfProps.effect);
		//   var effect = eval(jsfProps.effect);
		   tabview.contentTransition = function(newTab, oldTab) {	//console.info('1. server side tab ');
               var context = ice.component.getJSContext(clientId);
               var tabview = context.getComponent();
               var currentIndex = tabview.getTabIndex(newTab);

					var callback = function(_effect) {
					    //console.info('_EFFEFEFEF '+ _effect);

                        var context = ice.component.getJSContext(clientId);
                        var sJSFProps = context.getJSFProps();
                        var tbset = document.getElementById(clientId);
					    //console.info('3. onend server side tab ');
						oldTab.set('contentVisible', false);
						YAHOO.util.Dom.setStyle(newTab.get('contentEl').id, 'opacity', 0);
						newTab.set('contentVisible', true);
						//console.info('3.a onend server side tab ');
						 
						if (sJSFProps.isClientSide){
							
							ice.component.clientState.set(clientId, currentIndex);
							var Effect = new ice.yui3.effects['Appear'](newTab.get('contentEl').id);
							Effect.setContainerId(clientId);
							Effect.run();	
							//console.info('Client side tab ');
							
							
						} else {

						        tabIndexInfo = clientId + '='+ currentIndex;

							    var targetElement = ice.component.tabset.getTabIndexField(tbset);

								if(targetElement) {
									targetElement.value = tabIndexInfo;
								}            	
							var event ={};
							            var params = function(parameter) {

										var ele = document.getElementById(newTab.get('element').id).firstChild;
										parameter('ice.focus',  ele.id);
										parameter('onevent', function(data) { 
											if (data.status == 'success') {//console.info('Sucesssssss');
								   // YAHOO.util.Dom.setStyle(newTab.get('contentEl').id, 'opacity', 0);
									newTab.set('contentVisible', true);
									animation.chain.set('node', '#'+  newTab.get('contentEl').id);
                                        //set the focus back to the selected tab
                                       // var selectedTab = tabview.getTab(currentIndex);
                                                var ele = document.getElementById(newTab.get('element').id).firstChild;
                                                ele.focus();
 										//ele.parentNode.focus();
                                                                  									
											// _effect.set('node', '#'+ newTab.get('contentEl').id);
										  //  	Appear = new ice.yui3.effects.Appear(newTab.get('contentEl').id);
											//	Appear.setContainerId(clientId);
											//	Appear.run();
												/*
													var lastKnownSelectedIndex = ice.component.getJSContext(clientId).getJSFProps().selectedIndex;   
																						   if (lastKnownSelectedIndex != currentIndex) {
															tabview.removeListener('activeTabChange'); 
															tabview.set('activeIndex', lastKnownSelectedIndex);
															tabview.addListener('activeTabChange', tabChange); 
															currentIndex = lastKnownSelectedIndex; 
													  }
												*/
											   /*
												   var LIs = Dom.getFirstChild(document.getElementById(clientId)).children;

													//set the focus back to the selected tab
													if (LIs.length > currentIndex) {
														Dom.getFirstChild(LIs[currentIndex]).focus();
													}        
												 */                                    
											}
                            });
                        };
								
											try {
												if (sJSFProps.isSingleSubmit) {
													//backup id
													var elementId = targetElement.id;
													//replace id with the id of tabset component, so the "execute" property can be set to tabset id
													targetElement.id = clientId;
													ice.se(event, targetElement, params);
													//restore id
													targetElement.id = elementId;
												} else {
													ice.submit(event, targetElement, params);                    
												}
											} catch(e) {
												logger.info(e);
											} 
					
						}
					};

					//var Effect = new ice.yui3.effects[effect]({node: '#'+  oldTab.get('contentEl').id,  revert:true}, callback);
					//Effect.setContainerId(clientId);
					
					//console.info('2. server side tab '+ oldTab.get('contentEl').id);
					animation.setContainerId(clientId);
					animation.chain.set('node', '#'+  oldTab.get('contentEl').id);
					animation.chain.on('end', callback);
					//effect.set('node', '#'+  oldTab.get('contentEl').id);
					//effect.setContainerId(clientId);
				   // effect.revert = true;
					//effect.setPreRevert(callback);
					try {//console.info('run executed. ');
					//effect.run();
					//alert(animation.next());
					
					animation.chain.run(true);
		 
					} catch(e) {					//console.info('run executed. server side tab '+ e);
					}
					console.info('run executed. server side tab ');
		   }
	   } else { 
		   tabview.addListener('activeTabChange', tabChange);
	   }
       bindYUI(tabview);

	 }); // *** end of domready
	 }); // *** end of Y.use
	 }); // *** end of ice.yui3.use
   },
   
   //this function is responsible to provide an element that keeps tab index
   //only one field will be used per form element.
   getTabIndexField:function(tabset) {
	   //YAHOO.log("in getTabIndexField");
	   var _form = null;
	   try {
		   //see if the tabset is enclosed inside a form
	       _form = formOf(tabset);
	   } catch(e) {
		   //seems like tabset is not enclosed inside a form, now look for tabsetproxy component 
		   if (!_form) {
			   var tsc = document.getElementById(tabset.id + '_tsc');
			   if(tsc) {
				   try {
					   _form = formOf(tsc);
				   } catch(e) {
					   logger.info('ERROR: The tabSetProxy must be enclosed inside a Form element');
				   }
			   } else {
				   logger.info('ERROR: If tabset is not inside a form, then you must use tabSetProxy component');
			   }
		   }
	   }
	   //form element has been resolved by now
	   if (_form) {
		   var f = document.getElementById(_form.id + 'yti');
		   //if tabindex holder is not exist already, then create it lazily.
		   if (!f) {
			   f = this.createHiddenField(_form, _form.id + 'yti');
		   }
	       return f 
	   } else {
		   return null;   
	   }
   },
   
   createHiddenField:function(parent, id) {
	   var field = document.createElement('input'); 
	   field.setAttribute('type', 'hidden');
	   field.setAttribute('id', id);
	   field.setAttribute('name', 'yti');
	   parent.appendChild(field);
	   return field;
   },
 
   //delegate call to ice.yui.updateProperties(..)  with the reference of this lib
   updateProperties:function(clientId, jsProps, jsfProps, events) {
	   if (jsfProps.isClientSide){
		   var index = jsfProps.selectedIndex;
	       var lastKnownIndex = 0;
	       //if (index) YAHOO.log("updateProperties index="+index);
	       var context = ice.component.getJSContext(clientId);
	       if (context){
	    	   //YAHOO.log("updateProperties has context");
	    	   var tabviewObj = context.getComponent();	
	    	   lastKnownIndex = context.getJSFProps().selectedIndex;
	    	   //YAHOO.log("last know index is="+lastKnownIndex)
	           if (index != lastKnownIndex) {
	    		    //YAHOO.log("must switch indices");
	    	    	tabviewObj.selectTab(index);
	           }
    	   }
       }
       ice.yui3.updateProperties(clientId, jsProps, jsfProps, events, this);
       
   },
 
   //delegate call to ice.yui.getInstance(..) with the reference of this lib 
   getInstance:function(clientId, callback) {
       ice.component.getInstance(clientId, callback, this);
   }
};

