/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oidc.rp;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtException;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.jose.jwt.JwtUtils;
import org.apache.cxf.rs.security.oauth2.provider.OAuthJoseJwtConsumer;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;

public class OidcClaimsValidator
extends OAuthJoseJwtConsumer {
    private static final String SELF_ISSUED_ISSUER = "https://self-issued.me";
    private String issuerId;
    private WebClient jwkSetClient;
    private boolean supportSelfIssuedProvider;
    private boolean strictTimeValidation;
    private ConcurrentHashMap<String, JsonWebKey> keyMap = new ConcurrentHashMap();

    public void validateJwtClaims(JwtClaims claims, String clientId, boolean validateClaimsAlways) {
        String issuer = claims.getIssuer();
        if (issuer == null && validateClaimsAlways) {
            throw new OAuthServiceException("Invalid issuer");
        }
        if (this.supportSelfIssuedProvider && this.issuerId == null && issuer != null && SELF_ISSUED_ISSUER.equals(issuer)) {
            this.validateSelfIssuedProvider(claims, clientId, validateClaimsAlways);
        } else {
            if (issuer != null && !issuer.equals(this.issuerId)) {
                throw new OAuthServiceException("Invalid issuer");
            }
            if (claims.getSubject() == null) {
                throw new OAuthServiceException("Invalid subject");
            }
            String authorizedParty = (String)claims.getClaim("azp");
            if (authorizedParty != null && !authorizedParty.equals(clientId)) {
                throw new OAuthServiceException("Invalid authorized party");
            }
            List audiences = claims.getAudiences();
            if (StringUtils.isEmpty((List)audiences) && validateClaimsAlways || !StringUtils.isEmpty((List)audiences) && !audiences.contains(clientId)) {
                throw new OAuthServiceException("Invalid audience");
            }
            boolean expiredRequired = validateClaimsAlways || this.strictTimeValidation && claims.getIssuedAt() == null;
            try {
                JwtUtils.validateJwtExpiry((JwtClaims)claims, (int)this.getClockOffset(), (boolean)expiredRequired);
            }
            catch (JwtException ex) {
                throw new OAuthServiceException("ID Token has expired", (Throwable)ex);
            }
            boolean issuedAtRequired = validateClaimsAlways || this.strictTimeValidation && claims.getExpiryTime() == null;
            try {
                JwtUtils.validateJwtIssuedAt((JwtClaims)claims, (int)this.getTtl(), (int)this.getClockOffset(), (boolean)issuedAtRequired);
            }
            catch (JwtException ex) {
                throw new OAuthServiceException("Invalid issuedAt claim", (Throwable)ex);
            }
            try {
                JwtUtils.validateJwtNotBefore((JwtClaims)claims, (int)this.getClockOffset(), (boolean)false);
            }
            catch (JwtException ex) {
                throw new OAuthServiceException("ID Token can not be used yet", (Throwable)ex);
            }
        }
    }

    private void validateSelfIssuedProvider(JwtClaims claims, String clientId, boolean validateClaimsAlways) {
    }

    public void setIssuerId(String issuerId) {
        this.issuerId = issuerId;
    }

    public void setJwkSetClient(WebClient jwkSetClient) {
        this.jwkSetClient = jwkSetClient;
    }

    protected JwsSignatureVerifier getInitializedSignatureVerifier(JwtToken jwt) {
        JwsSignatureVerifier theJwsVerifier;
        JsonWebKey key = null;
        if (this.supportSelfIssuedProvider && SELF_ISSUED_ISSUER.equals(jwt.getClaim("issuer"))) {
            JsonWebKey publicKey;
            String thumbprint;
            String publicKeyJson = (String)jwt.getClaim("sub_jwk");
            if (publicKeyJson != null && (thumbprint = JwkUtils.getThumbprint((JsonWebKey)(publicKey = JwkUtils.readJwkKey((String)publicKeyJson)))).equals(jwt.getClaim("sub"))) {
                key = publicKey;
            }
            if (key == null) {
                throw new SecurityException("Self-issued JWK key is invalid or not available");
            }
        } else {
            String keyId = jwt.getJwsHeaders().getKeyId();
            JsonWebKey jsonWebKey = key = keyId != null ? this.keyMap.get(keyId) : null;
            if (key == null && this.jwkSetClient != null) {
                JsonWebKeys keys = (JsonWebKeys)this.jwkSetClient.get(JsonWebKeys.class);
                if (keyId != null) {
                    key = keys.getKey(keyId);
                } else if (keys.getKeys().size() == 1) {
                    key = (JsonWebKey)keys.getKeys().get(0);
                }
                this.keyMap.clear();
                this.keyMap.putAll(keys.getKeyIdMap());
            }
        }
        if ((theJwsVerifier = key != null ? JwsUtils.getSignatureVerifier((JsonWebKey)key, (SignatureAlgorithm)jwt.getJwsHeaders().getSignatureAlgorithm()) : super.getInitializedSignatureVerifier(jwt.getJwsHeaders())) == null) {
            throw new SecurityException("JWS Verifier is not available");
        }
        return theJwsVerifier;
    }

    public void setSupportSelfIssuedProvider(boolean supportSelfIssuedProvider) {
        this.supportSelfIssuedProvider = supportSelfIssuedProvider;
    }

    public void setStrictTimeValidation(boolean strictTimeValidation) {
        this.strictTimeValidation = strictTimeValidation;
    }
}

