/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.netty;

import io.netty.channel.epoll.Epoll;
import io.netty.channel.kqueue.KQueue;
import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.utils.Env;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckDependencies {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static final boolean isEpollAvailable() {
        try {
            return Env.isLinuxOs() && Epoll.isAvailable();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            ActiveMQClientLogger.LOGGER.unableToCheckEpollAvailabilitynoClass();
            return false;
        }
        catch (Throwable e) {
            ActiveMQClientLogger.LOGGER.unableToCheckEpollAvailability(e);
            return false;
        }
    }

    public static final boolean isKQueueAvailable() {
        try {
            return Env.isMacOs() && KQueue.isAvailable();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            ActiveMQClientLogger.LOGGER.unableToCheckKQueueAvailabilityNoClass();
            return false;
        }
        catch (Throwable e) {
            ActiveMQClientLogger.LOGGER.unableToCheckKQueueAvailability(e);
            return false;
        }
    }
}

