/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.xmlsec.AlgorithmPolicyParameters;
import org.opensaml.xmlsec.DecryptionConfiguration;
import org.opensaml.xmlsec.DecryptionParameters;
import org.opensaml.xmlsec.DecryptionParametersResolver;
import org.opensaml.xmlsec.criterion.DecryptionConfigurationCriterion;
import org.opensaml.xmlsec.criterion.DecryptionRecipientsCriterion;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.impl.AbstractSecurityParametersResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.slf4j.Logger;

public class BasicDecryptionParametersResolver
extends AbstractSecurityParametersResolver<DecryptionParameters>
implements DecryptionParametersResolver {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(BasicDecryptionParametersResolver.class);

    @Nonnull
    public Iterable<DecryptionParameters> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        DecryptionParameters params = this.resolveSingle(criteria);
        if (params != null) {
            return CollectionSupport.singletonList((Object)params);
        }
        return CollectionSupport.emptyList();
    }

    @Nullable
    public DecryptionParameters resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        if (criteria == null) {
            this.log.debug("CriteriaSet was null");
            return null;
        }
        DecryptionConfigurationCriterion criterion = (DecryptionConfigurationCriterion)Constraint.isNotNull((Object)((DecryptionConfigurationCriterion)criteria.get(DecryptionConfigurationCriterion.class)), (String)"Resolver requires an instance of DecryptionConfigurationCriterion");
        DecryptionParameters params = new DecryptionParameters();
        this.resolveAndPopulateIncludesExcludes((AlgorithmPolicyParameters)params, criteria, criterion.getConfigurations());
        params.setDataKeyInfoCredentialResolver(this.resolveDataKeyInfoCredentialResolver(criteria));
        params.setKEKKeyInfoCredentialResolver(this.resolveKEKKeyInfoCredentialResolver(criteria));
        params.setEncryptedKeyResolver(this.resolveEncryptedKeyResolver(criteria));
        params.setRecipients(this.resolveRecipients(criteria));
        this.logResult(params);
        return params;
    }

    protected void logResult(@Nonnull DecryptionParameters params) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Resolved DecryptionParameters:");
            this.log.debug("\tAlgorithm includes: {}", (Object)params.getIncludedAlgorithms());
            this.log.debug("\tAlgorithm excludes: {}", (Object)params.getExcludedAlgorithms());
            this.log.debug("\tData KeyInfoCredentialResolver: {}", (Object)(params.getDataKeyInfoCredentialResolver() != null ? "present" : "null"));
            this.log.debug("\tKEK KeyInfoCredentialResolver: {}", (Object)(params.getKEKKeyInfoCredentialResolver() != null ? "present" : "null"));
            this.log.debug("\tEncryptedKeyResolver: {}", (Object)(params.getEncryptedKeyResolver() != null ? "present" : "null"));
            this.log.debug("\tRecipients: {}", (Object)params.getRecipients());
        }
    }

    @Nullable
    protected EncryptedKeyResolver resolveEncryptedKeyResolver(@Nonnull CriteriaSet criteria) {
        DecryptionConfigurationCriterion criterion = (DecryptionConfigurationCriterion)criteria.get(DecryptionConfigurationCriterion.class);
        assert (criterion != null);
        for (DecryptionConfiguration config : criterion.getConfigurations()) {
            if (config.getEncryptedKeyResolver() == null) continue;
            return config.getEncryptedKeyResolver();
        }
        return null;
    }

    @Nullable
    protected KeyInfoCredentialResolver resolveKEKKeyInfoCredentialResolver(@Nonnull CriteriaSet criteria) {
        DecryptionConfigurationCriterion criterion = (DecryptionConfigurationCriterion)criteria.get(DecryptionConfigurationCriterion.class);
        assert (criterion != null);
        for (DecryptionConfiguration config : criterion.getConfigurations()) {
            if (config.getKEKKeyInfoCredentialResolver() == null) continue;
            return config.getKEKKeyInfoCredentialResolver();
        }
        return null;
    }

    @Nullable
    protected KeyInfoCredentialResolver resolveDataKeyInfoCredentialResolver(@Nonnull CriteriaSet criteria) {
        DecryptionConfigurationCriterion criterion = (DecryptionConfigurationCriterion)criteria.get(DecryptionConfigurationCriterion.class);
        assert (criterion != null);
        for (DecryptionConfiguration config : criterion.getConfigurations()) {
            if (config.getDataKeyInfoCredentialResolver() == null) continue;
            return config.getDataKeyInfoCredentialResolver();
        }
        return null;
    }

    private Set<String> resolveRecipients(@Nonnull CriteriaSet criteria) {
        DecryptionRecipientsCriterion recipientsCriterion;
        DecryptionConfigurationCriterion configCriterion = (DecryptionConfigurationCriterion)criteria.get(DecryptionConfigurationCriterion.class);
        assert (configCriterion != null);
        HashSet<String> recipients = new HashSet<String>();
        for (DecryptionConfiguration config : configCriterion.getConfigurations()) {
            if (config.getRecipients() == null) continue;
            recipients.addAll(config.getRecipients());
            break;
        }
        if ((recipientsCriterion = (DecryptionRecipientsCriterion)criteria.get(DecryptionRecipientsCriterion.class)) != null) {
            recipients.addAll(recipientsCriterion.getRecipients());
        }
        return recipients.isEmpty() ? null : recipients;
    }
}

