/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.io;

import java.nio.ByteBuffer;
import org.apache.daffodil.io.InputSource;
import org.apache.daffodil.lib.exceptions.Assert$;
import scala.Int$;

public class ByteBufferInputSource
extends InputSource {
    private final ByteBuffer bb;
    private final int positionOffset;

    public ByteBufferInputSource(ByteBuffer byteBuffer) {
        this.bb = byteBuffer.asReadOnlyBuffer();
        this.positionOffset = this.bb.position();
    }

    @Override
    public boolean areBytesAvailable(long nBytes) {
        return (long)this.bb.remaining() >= nBytes;
    }

    @Override
    public long knownBytesAvailable() {
        return Int$.MODULE$.int2long(this.bb.remaining());
    }

    @Override
    public int get() {
        if (!this.areBytesAvailable(1L)) {
            return -1;
        }
        return this.bb.get() & 0xFF;
    }

    @Override
    public boolean get(byte[] dest, int off, int len) {
        if (dest.length - off < len) {
            throw Assert$.MODULE$.abort("Invariant broken: dest.length.-(off).>=(len)");
        }
        if (!this.areBytesAvailable(Int$.MODULE$.int2long(len))) {
            return false;
        }
        this.bb.get(dest, off, len);
        return true;
    }

    @Override
    public long position() {
        return Int$.MODULE$.int2long(this.bb.position() - this.positionOffset);
    }

    @Override
    public void position(long bytePos0b) {
        this.bb.position((int)(bytePos0b + (long)this.positionOffset));
    }

    @Override
    public void lockPosition(long bytePos0b) {
    }

    @Override
    public void releasePosition(long bytePos0b) {
    }

    @Override
    public void compact() {
    }

    @Override
    public boolean hasReachedEndOfData() {
        return true;
    }

    @Override
    public void close() {
    }
}

