/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllHeapLongsSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllLongsSketch;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllDirectLongsSketchTest {
    private static final double PMF_EPS_FOR_K_8 = 0.35;
    private static final double PMF_EPS_FOR_K_128 = 0.025;
    private static final double PMF_EPS_FOR_K_256 = 0.013;
    private static final double NUMERIC_NOISE_TOLERANCE = 1.0E-6;
    private static final DefaultMemoryRequestServer memReqSvr = new DefaultMemoryRequestServer();
    private static final boolean enablePrinting = false;

    @Test
    public void empty() {
        KllLongsSketch sketch = KllDirectLongsSketchTest.getUpdatableDirectLongSketch(200, 0);
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)0L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)0);
        try {
            sketch.getRank(0L);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getQuantile(0.5);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getQuantiles(new double[]{0.0, 1.0});
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getPMF(new long[]{0L});
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getCDF(new long[0]);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertNotNull((Object)sketch.toString(true, true));
        Assert.assertNotNull((Object)sketch.toString());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void getQuantileInvalidArg() {
        KllLongsSketch sketch = KllDirectLongsSketchTest.getUpdatableDirectLongSketch(200, 0);
        sketch.update(1L);
        sketch.getQuantile(-1.0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void getQuantilesInvalidArg() {
        KllLongsSketch sketch = KllDirectLongsSketchTest.getUpdatableDirectLongSketch(200, 0);
        sketch.update(1L);
        sketch.getQuantiles(new double[]{2.0});
    }

    @Test
    public void oneValue() {
        KllLongsSketch sketch = KllDirectLongsSketchTest.getUpdatableDirectLongSketch(200, 0);
        sketch.update(1L);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)1L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)1);
        Assert.assertEquals((double)sketch.getRank(1L, QuantileSearchCriteria.EXCLUSIVE), (double)0.0);
        Assert.assertEquals((double)sketch.getRank(2L, QuantileSearchCriteria.EXCLUSIVE), (double)1.0);
        Assert.assertEquals((long)sketch.getMinItem(), (long)1L);
        Assert.assertEquals((long)sketch.getMaxItem(), (long)1L);
        Assert.assertEquals((long)sketch.getQuantile(0.5, QuantileSearchCriteria.EXCLUSIVE), (long)1L);
    }

    @Test
    public void manyValuesEstimationMode() {
        int i;
        KllLongsSketch sketch = KllDirectLongsSketchTest.getUpdatableDirectLongSketch(200, 0);
        int n = 1000000;
        for (i = 0; i < 1000000; ++i) {
            sketch.update((long)i);
        }
        Assert.assertEquals((long)sketch.getN(), (long)1000000L);
        for (i = 0; i < 1000000; ++i) {
            double trueRank = (double)i / 1000000.0;
            Assert.assertEquals((double)sketch.getRank((long)i), (double)trueRank, (double)0.013, (String)("for value " + i));
        }
        double[] pmf = sketch.getPMF(new long[]{500000L});
        Assert.assertEquals((int)pmf.length, (int)2);
        Assert.assertEquals((double)pmf[0], (double)0.5, (double)0.013);
        Assert.assertEquals((double)pmf[1], (double)0.5, (double)0.013);
        Assert.assertEquals((long)sketch.getMinItem(), (long)0L);
        Assert.assertEquals((long)sketch.getMaxItem(), (long)999999L);
        double[] ranks = new double[1001];
        double[] reverseRanks = new double[1001];
        for (int i2 = 0; i2 <= 1000; ++i2) {
            ranks[i2] = (double)i2 / 1000.0;
            reverseRanks[1000 - i2] = ranks[i2];
        }
        long[] quantiles = sketch.getQuantiles(ranks);
        long[] reverseQuantiles = sketch.getQuantiles(reverseRanks);
        long previousQuantile = 0L;
        for (int i3 = 0; i3 <= 1000; ++i3) {
            long quantile = sketch.getQuantile(ranks[i3]);
            Assert.assertEquals((long)quantile, (long)quantiles[i3]);
            Assert.assertEquals((long)quantile, (long)reverseQuantiles[1000 - i3]);
            Assert.assertTrue((previousQuantile <= quantile ? 1 : 0) != 0);
            previousQuantile = quantile;
        }
    }

    @Test
    public void getRankGetCdfGetPmfConsistency() {
        KllLongsSketch sketch = KllDirectLongsSketchTest.getUpdatableDirectLongSketch(200, 0);
        int n = 1000;
        long[] values = new long[1000];
        for (int i = 0; i < 1000; ++i) {
            sketch.update((long)i);
            values[i] = i;
        }
        double[] ranks = sketch.getCDF(values);
        double[] pmf = sketch.getPMF(values);
        double sumPmf = 0.0;
        for (int i = 0; i < 1000; ++i) {
            Assert.assertEquals((double)ranks[i], (double)sketch.getRank(values[i]), (double)1.0E-6, (String)("rank vs CDF for value " + i));
            Assert.assertEquals((double)ranks[i], (double)(sumPmf += pmf[i]), (double)1.0E-6, (String)("CDF vs PMF for value " + i));
        }
        Assert.assertEquals((double)(sumPmf += pmf[1000]), (double)1.0, (double)1.0E-6);
        Assert.assertEquals((double)ranks[1000], (double)1.0, (double)1.0E-6);
    }

    @Test
    public void merge() {
        KllLongsSketch sketch1 = KllDirectLongsSketchTest.getUpdatableDirectLongSketch(200, 0);
        KllLongsSketch sketch2 = KllDirectLongsSketchTest.getUpdatableDirectLongSketch(200, 0);
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((long)i);
            sketch2.update((long)(20000 - i - 1));
        }
        Assert.assertEquals((long)sketch1.getMinItem(), (long)0L);
        Assert.assertEquals((long)sketch1.getMaxItem(), (long)9999L);
        Assert.assertEquals((long)sketch2.getMinItem(), (long)10000L);
        Assert.assertEquals((long)sketch2.getMaxItem(), (long)19999L);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)20000L);
        Assert.assertEquals((long)sketch1.getMinItem(), (long)0L);
        Assert.assertEquals((long)sketch1.getMaxItem(), (long)19999L);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)10000.0, (double)130.0);
    }

    @Test
    public void mergeLowerK() {
        KllLongsSketch sketch1 = KllDirectLongsSketchTest.getUpdatableDirectLongSketch(256, 0);
        KllLongsSketch sketch2 = KllDirectLongsSketchTest.getUpdatableDirectLongSketch(128, 0);
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((long)i);
            sketch2.update((long)(20000 - i - 1));
        }
        Assert.assertEquals((long)sketch1.getMinItem(), (long)0L);
        Assert.assertEquals((long)sketch1.getMaxItem(), (long)9999L);
        Assert.assertEquals((long)sketch2.getMinItem(), (long)10000L);
        Assert.assertEquals((long)sketch2.getMaxItem(), (long)19999L);
        Assert.assertTrue((sketch1.getNormalizedRankError(false) < sketch2.getNormalizedRankError(false) ? 1 : 0) != 0);
        Assert.assertTrue((sketch1.getNormalizedRankError(true) < sketch2.getNormalizedRankError(true) ? 1 : 0) != 0);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertEquals((double)sketch1.getNormalizedRankError(false), (double)sketch2.getNormalizedRankError(false));
        Assert.assertEquals((double)sketch1.getNormalizedRankError(true), (double)sketch2.getNormalizedRankError(true));
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)20000L);
        Assert.assertEquals((long)sketch1.getMinItem(), (long)0L);
        Assert.assertEquals((long)sketch1.getMaxItem(), (long)19999L);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)10000.0, (double)250.0);
    }

    @Test
    public void mergeEmptyLowerK() {
        KllLongsSketch sketch1 = KllDirectLongsSketchTest.getUpdatableDirectLongSketch(256, 0);
        KllLongsSketch sketch2 = KllDirectLongsSketchTest.getUpdatableDirectLongSketch(128, 0);
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((long)i);
        }
        double rankErrorBeforeMerge = sketch1.getNormalizedRankError(true);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertEquals((double)sketch1.getNormalizedRankError(true), (double)rankErrorBeforeMerge);
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)10000L);
        Assert.assertEquals((long)sketch1.getMinItem(), (long)0L);
        Assert.assertEquals((long)sketch1.getMaxItem(), (long)9999L);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)5000.0, (double)65.0);
        sketch2.merge((KllSketch)sketch1);
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)10000L);
        Assert.assertEquals((long)sketch1.getMinItem(), (long)0L);
        Assert.assertEquals((long)sketch1.getMaxItem(), (long)9999L);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)5000.0, (double)65.0);
    }

    @Test
    public void mergeExactModeLowerK() {
        KllLongsSketch sketch1 = KllDirectLongsSketchTest.getUpdatableDirectLongSketch(256, 0);
        KllLongsSketch sketch2 = KllDirectLongsSketchTest.getUpdatableDirectLongSketch(128, 0);
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((long)i);
        }
        sketch2.update(1L);
        double rankErrorBeforeMerge = sketch1.getNormalizedRankError(true);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertEquals((double)sketch1.getNormalizedRankError(true), (double)rankErrorBeforeMerge);
    }

    @Test
    public void mergeMinMinValueFromOther() {
        KllLongsSketch sketch1 = KllDirectLongsSketchTest.getUpdatableDirectLongSketch(200, 0);
        KllLongsSketch sketch2 = KllDirectLongsSketchTest.getUpdatableDirectLongSketch(200, 0);
        sketch1.update(1L);
        sketch2.update(2L);
        sketch2.merge((KllSketch)sketch1);
        Assert.assertEquals((long)sketch2.getMinItem(), (long)1L);
    }

    @Test
    public void mergeMinAndMaxFromOther() {
        KllLongsSketch sketch1 = KllDirectLongsSketchTest.getUpdatableDirectLongSketch(200, 0);
        KllLongsSketch sketch2 = KllDirectLongsSketchTest.getUpdatableDirectLongSketch(200, 0);
        int n = 1000000;
        for (int i = 1; i <= n; ++i) {
            sketch1.update((long)i);
        }
        sketch2.merge((KllSketch)sketch1);
        Assert.assertEquals((long)sketch2.getMinItem(), (long)1L);
        Assert.assertEquals((long)sketch2.getMaxItem(), (long)1000000L);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void kTooSmall() {
        KllDirectLongsSketchTest.getUpdatableDirectLongSketch(7, 0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void kTooLarge() {
        KllDirectLongsSketchTest.getUpdatableDirectLongSketch(65536, 0);
    }

    @Test
    public void minK() {
        KllLongsSketch sketch = KllDirectLongsSketchTest.getUpdatableDirectLongSketch(8, 0);
        for (int i = 0; i < 1000; ++i) {
            sketch.update((long)i);
        }
        Assert.assertEquals((int)sketch.getK(), (int)8);
        Assert.assertEquals((double)sketch.getQuantile(0.5), (double)500.0, (double)175.0);
    }

    @Test
    public void maxK() {
        KllLongsSketch sketch = KllDirectLongsSketchTest.getUpdatableDirectLongSketch(65535, 0);
        for (int i = 0; i < 1000; ++i) {
            sketch.update((long)i);
        }
        Assert.assertEquals((int)sketch.getK(), (int)65535);
        Assert.assertEquals((double)sketch.getQuantile(0.5), (double)500.0, (double)6.5);
    }

    @Test
    public void serializeDeserializeEmptyViaCompactHeapify() {
        KllLongsSketch sketch1 = KllDirectLongsSketchTest.getUpdatableDirectLongSketch(200, 0);
        byte[] bytes = sketch1.toByteArray();
        KllLongsSketch sketch2 = KllLongsSketch.heapify((Memory)Memory.wrap((byte[])bytes));
        Assert.assertEquals((int)bytes.length, (int)sketch1.currentSerializedSizeBytes(false));
        Assert.assertTrue((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumRetained(), (int)sketch1.getNumRetained());
        Assert.assertEquals((long)sketch2.getN(), (long)sketch1.getN());
        Assert.assertEquals((double)sketch2.getNormalizedRankError(false), (double)sketch1.getNormalizedRankError(false));
        try {
            sketch2.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch2.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sketch2.currentSerializedSizeBytes(false), (int)sketch1.currentSerializedSizeBytes(false));
    }

    @Test
    public void serializeDeserializeEmptyViaUpdatableWritableWrap() {
        KllLongsSketch sketch1 = KllDirectLongsSketchTest.getUpdatableDirectLongSketch(200, 0);
        byte[] bytes = KllHelper.toByteArray((KllSketch)sketch1, (boolean)true);
        KllLongsSketch sketch2 = KllLongsSketch.writableWrap((WritableMemory)WritableMemory.writableWrap((byte[])bytes), (MemoryRequestServer)memReqSvr);
        Assert.assertEquals((int)bytes.length, (int)sketch1.currentSerializedSizeBytes(true));
        Assert.assertTrue((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumRetained(), (int)sketch1.getNumRetained());
        Assert.assertEquals((long)sketch2.getN(), (long)sketch1.getN());
        Assert.assertEquals((double)sketch2.getNormalizedRankError(false), (double)sketch1.getNormalizedRankError(false));
        try {
            sketch2.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch2.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sketch2.currentSerializedSizeBytes(true), (int)sketch1.currentSerializedSizeBytes(true));
    }

    @Test
    public void serializeDeserializeOneValueViaCompactHeapify() {
        KllLongsSketch sketch1 = KllDirectLongsSketchTest.getUpdatableDirectLongSketch(200, 0);
        sketch1.update(1L);
        byte[] bytes = sketch1.toByteArray();
        KllLongsSketch sketch2 = KllLongsSketch.heapify((Memory)Memory.wrap((byte[])bytes));
        Assert.assertEquals((int)bytes.length, (int)sketch1.currentSerializedSizeBytes(false));
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumRetained(), (int)1);
        Assert.assertEquals((long)sketch2.getN(), (long)1L);
        Assert.assertEquals((double)sketch2.getNormalizedRankError(false), (double)sketch1.getNormalizedRankError(false));
        Assert.assertTrue((sketch2.getMinItem() < Long.MAX_VALUE ? 1 : 0) != 0);
        Assert.assertTrue((sketch2.getMaxItem() > Long.MIN_VALUE ? 1 : 0) != 0);
        Assert.assertEquals((int)sketch2.currentSerializedSizeBytes(false), (int)16);
    }

    @Test
    public void serializeDeserializeOneValueViaUpdatableWritableWrap() {
        KllLongsSketch sketch1 = KllDirectLongsSketchTest.getUpdatableDirectLongSketch(200, 0);
        sketch1.update(1L);
        byte[] bytes = KllHelper.toByteArray((KllSketch)sketch1, (boolean)true);
        KllLongsSketch sketch2 = KllLongsSketch.writableWrap((WritableMemory)WritableMemory.writableWrap((byte[])bytes), (MemoryRequestServer)memReqSvr);
        Assert.assertEquals((int)bytes.length, (int)sketch1.currentSerializedSizeBytes(true));
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumRetained(), (int)1);
        Assert.assertEquals((long)sketch2.getN(), (long)1L);
        Assert.assertEquals((double)sketch2.getNormalizedRankError(false), (double)sketch1.getNormalizedRankError(false));
        Assert.assertEquals((long)sketch2.getMinItem(), (long)1L);
        Assert.assertEquals((long)sketch2.getMaxItem(), (long)1L);
        Assert.assertEquals((int)sketch2.currentSerializedSizeBytes(false), (int)16);
        Assert.assertEquals((int)sketch2.currentSerializedSizeBytes(true), (int)bytes.length);
    }

    @Test
    public void serializeDeserializeFullViaCompactHeapify() {
        KllLongsSketch sketch1 = KllDirectLongsSketchTest.getUpdatableDirectLongSketch(200, 1000);
        byte[] byteArr1 = sketch1.toByteArray();
        KllLongsSketch sketch2 = KllLongsSketch.heapify((Memory)Memory.wrap((byte[])byteArr1));
        Assert.assertEquals((int)byteArr1.length, (int)sketch1.currentSerializedSizeBytes(false));
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumRetained(), (int)sketch1.getNumRetained());
        Assert.assertEquals((long)sketch2.getN(), (long)sketch1.getN());
        Assert.assertEquals((double)sketch2.getNormalizedRankError(false), (double)sketch1.getNormalizedRankError(false));
        Assert.assertEquals((long)sketch2.getMinItem(), (long)sketch1.getMinItem());
        Assert.assertEquals((long)sketch2.getMaxItem(), (long)sketch1.getMaxItem());
        Assert.assertEquals((int)sketch2.currentSerializedSizeBytes(false), (int)sketch1.currentSerializedSizeBytes(false));
    }

    @Test
    public void serializeDeserializeFullViaUpdatableWritableWrap() {
        KllLongsSketch sketch1 = KllDirectLongsSketchTest.getUpdatableDirectLongSketch(200, 0);
        int n = 1000;
        for (int i = 1; i <= 1000; ++i) {
            sketch1.update((long)i);
        }
        byte[] bytes = KllHelper.toByteArray((KllSketch)sketch1, (boolean)true);
        KllLongsSketch sketch2 = KllLongsSketch.writableWrap((WritableMemory)WritableMemory.writableWrap((byte[])bytes), (MemoryRequestServer)memReqSvr);
        Assert.assertEquals((int)bytes.length, (int)sketch1.currentSerializedSizeBytes(true));
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumRetained(), (int)sketch1.getNumRetained());
        Assert.assertEquals((long)sketch2.getN(), (long)sketch1.getN());
        Assert.assertEquals((double)sketch2.getNormalizedRankError(false), (double)sketch1.getNormalizedRankError(false));
        Assert.assertEquals((long)sketch2.getMinItem(), (long)sketch1.getMinItem());
        Assert.assertEquals((long)sketch2.getMaxItem(), (long)sketch1.getMaxItem());
        Assert.assertEquals((int)sketch2.currentSerializedSizeBytes(true), (int)sketch1.currentSerializedSizeBytes(true));
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void outOfOrderSplitPoints() {
        KllLongsSketch sketch = KllDirectLongsSketchTest.getUpdatableDirectLongSketch(200, 0);
        sketch.update(0L);
        sketch.getCDF(new long[]{1L, 0L});
    }

    @Test
    public void checkSimpleMergeDirect() {
        int i;
        int k = 20;
        int n1 = 21;
        int n2 = 43;
        KllLongsSketch sk1 = KllLongsSketch.newHeapInstance((int)k);
        KllLongsSketch sk2 = KllLongsSketch.newHeapInstance((int)k);
        for (i = 1; i <= n1; ++i) {
            sk1.update((long)i);
        }
        for (i = 1; i <= n2; ++i) {
            sk2.update((long)(i + 100));
        }
        KllDirectLongsSketchTest.println("SK1:");
        KllDirectLongsSketchTest.println(sk1.toString(true, true));
        KllDirectLongsSketchTest.println("SK2:");
        KllDirectLongsSketchTest.println(sk2.toString(true, true));
        WritableMemory wmem1 = WritableMemory.writableWrap((byte[])KllHelper.toByteArray((KllSketch)sk1, (boolean)true));
        WritableMemory wmem2 = WritableMemory.writableWrap((byte[])KllHelper.toByteArray((KllSketch)sk2, (boolean)true));
        KllLongsSketch dsk1 = KllLongsSketch.writableWrap((WritableMemory)wmem1, (MemoryRequestServer)memReqSvr);
        KllLongsSketch dsk2 = KllLongsSketch.writableWrap((WritableMemory)wmem2, (MemoryRequestServer)memReqSvr);
        KllDirectLongsSketchTest.println("BEFORE MERGE");
        KllDirectLongsSketchTest.println(dsk1.toString(true, true));
        dsk1.merge((KllSketch)dsk2);
        KllDirectLongsSketchTest.println("AFTER MERGE");
        KllDirectLongsSketchTest.println(dsk1.toString(true, true));
    }

    @Test
    public void checkSketchInitializeDirectLongUpdatableMem() {
        int k = 20;
        KllDirectLongsSketchTest.println("#### CASE: LONG FULL DIRECT FROM UPDATABLE");
        KllLongsSketch sk2 = KllLongsSketch.newHeapInstance((int)k);
        for (int i = 1; i <= k + 1; ++i) {
            sk2.update((long)i);
        }
        byte[] compBytes = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])compBytes);
        KllDirectLongsSketchTest.println(KllPreambleUtil.toString((byte[])compBytes, (KllSketch.SketchType)KllSketch.SketchType.LONGS_SKETCH, (boolean)true));
        KllLongsSketch sk = KllLongsSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)(k + 1));
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getLongItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)3);
        Assert.assertEquals((long)sk.getMaxItem(), (long)21L);
        Assert.assertEquals((long)sk.getMinItem(), (long)1L);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllDirectLongsSketchTest.println("#### CASE: LONG EMPTY HEAPIFIED FROM UPDATABLE");
        sk2 = KllLongsSketch.newHeapInstance((int)k);
        compBytes = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        KllDirectLongsSketchTest.println(KllPreambleUtil.toString((byte[])compBytes, (KllSketch.SketchType)KllSketch.SketchType.LONGS_SKETCH, (boolean)true));
        sk = KllLongsSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getLongItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllDirectLongsSketchTest.println("#### CASE: LONG SINGLE HEAPIFIED FROM UPDATABLE");
        sk2 = KllLongsSketch.newHeapInstance((int)k);
        sk2.update(1L);
        compBytes = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        KllDirectLongsSketchTest.println(KllPreambleUtil.toString((byte[])compBytes, (KllSketch.SketchType)KllSketch.SketchType.LONGS_SKETCH, (boolean)true));
        sk = KllLongsSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getLongItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        Assert.assertEquals((long)sk.getMaxItem(), (long)1L);
        Assert.assertEquals((long)sk.getMinItem(), (long)1L);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkGetWritableMemory() {
        KllLongsSketch sketch = KllDirectLongsSketchTest.getUpdatableDirectLongSketch(200, 200);
        Assert.assertEquals((int)sketch.getK(), (int)200);
        Assert.assertEquals((long)sketch.getN(), (long)200L);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertTrue((boolean)sketch.isMemoryUpdatableFormat());
        Assert.assertFalse((boolean)sketch.isEstimationMode());
        Assert.assertTrue((boolean)sketch.isLongsSketch());
        Assert.assertFalse((boolean)sketch.isLevelZeroSorted());
        Assert.assertFalse((boolean)sketch.isDoublesSketch());
        WritableMemory wmem = sketch.getWritableMemory();
        KllHeapLongsSketch sk = KllHeapLongsSketch.heapifyImpl((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)200);
        Assert.assertEquals((long)sk.getN(), (long)200L);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isMemoryUpdatableFormat());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertTrue((boolean)sk.isLongsSketch());
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        Assert.assertFalse((boolean)sk.isDoublesSketch());
    }

    @Test
    public void checkReset() {
        WritableMemory dstMem = WritableMemory.allocate((int)3000);
        KllLongsSketch sk = KllLongsSketch.newDirectInstance((int)20, (WritableMemory)dstMem, (MemoryRequestServer)memReqSvr);
        for (int i = 1; i <= 100; ++i) {
            sk.update((long)i);
        }
        long n1 = sk.getN();
        long min1 = sk.getMinItem();
        long max1 = sk.getMaxItem();
        sk.reset();
        for (int i = 1; i <= 100; ++i) {
            sk.update((long)i);
        }
        long n2 = sk.getN();
        long min2 = sk.getMinItem();
        long max2 = sk.getMaxItem();
        Assert.assertEquals((long)n2, (long)n1);
        Assert.assertEquals((long)min2, (long)min1);
        Assert.assertEquals((long)max2, (long)max1);
    }

    @Test
    public void checkHeapify() {
        WritableMemory dstMem = WritableMemory.allocate((int)6000);
        KllLongsSketch sk = KllLongsSketch.newDirectInstance((int)20, (WritableMemory)dstMem, (MemoryRequestServer)memReqSvr);
        for (int i = 1; i <= 100; ++i) {
            sk.update((long)i);
        }
        KllHeapLongsSketch sk2 = KllHeapLongsSketch.heapifyImpl((Memory)dstMem);
        Assert.assertEquals((long)sk2.getMinItem(), (long)1L);
        Assert.assertEquals((long)sk2.getMaxItem(), (long)100L);
    }

    @Test
    public void checkMergeKllLongsSketch() {
        WritableMemory dstMem = WritableMemory.allocate((int)6000);
        KllLongsSketch sk = KllLongsSketch.newDirectInstance((int)20, (WritableMemory)dstMem, (MemoryRequestServer)memReqSvr);
        for (int i = 1; i <= 21; ++i) {
            sk.update((long)i);
        }
        KllLongsSketch sk2 = KllLongsSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk2.update((long)(i + 100));
        }
        sk.merge((KllSketch)sk2);
        Assert.assertEquals((long)sk.getMinItem(), (long)1L);
        Assert.assertEquals((long)sk.getMaxItem(), (long)121L);
    }

    @Test
    public void checkReverseMergeKllLongsSketch() {
        WritableMemory dstMem = WritableMemory.allocate((int)6000);
        KllLongsSketch sk = KllLongsSketch.newDirectInstance((int)20, (WritableMemory)dstMem, (MemoryRequestServer)memReqSvr);
        for (int i = 1; i <= 21; ++i) {
            sk.update((long)i);
        }
        KllLongsSketch sk2 = KllLongsSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk2.update((long)(i + 100));
        }
        sk2.merge((KllSketch)sk);
        Assert.assertEquals((long)sk2.getMinItem(), (long)1L);
        Assert.assertEquals((long)sk2.getMaxItem(), (long)121L);
    }

    @Test
    public void checkWritableWrapOfCompactForm() {
        KllLongsSketch sk = KllLongsSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk.update((long)i);
        }
        WritableMemory srcMem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        KllLongsSketch sk2 = KllLongsSketch.writableWrap((WritableMemory)srcMem, (MemoryRequestServer)memReqSvr);
        Assert.assertEquals((long)sk2.getMinItem(), (long)1L);
        Assert.assertEquals((long)sk2.getMaxItem(), (long)21L);
    }

    @Test
    public void checkReadOnlyExceptions() {
        int k = 20;
        long[] fltArr = new long[]{};
        long fltV = 1L;
        int idx = 1;
        boolean bool = true;
        KllLongsSketch sk = KllLongsSketch.newHeapInstance((int)k);
        KllLongsSketch sk2 = KllLongsSketch.wrap((Memory)Memory.wrap((byte[])sk.toByteArray()));
        try {
            sk2.incN(1);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.incNumLevels();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setLongItemsArray(fltArr);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setLongItemsArrayAt(idx, fltV);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setLevelZeroSorted(bool);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setMaxItem(fltV);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setMinItem(fltV);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setMinK(idx);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setN((long)idx);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setNumLevels(idx);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkMergeExceptions() {
        KllLongsSketch sk1 = KllLongsSketch.newHeapInstance((int)20);
        WritableMemory srcMem1 = WritableMemory.writableWrap((byte[])sk1.toByteArray());
        KllLongsSketch sk2 = KllLongsSketch.writableWrap((WritableMemory)srcMem1, (MemoryRequestServer)memReqSvr);
        sk2.merge((KllSketch)sk1);
    }

    @Test
    public void checkVectorUpdate() {
        WritableMemory dstMem = WritableMemory.allocate((int)6000);
        KllLongsSketch sk = KllLongsSketch.newDirectInstance((int)20, (WritableMemory)dstMem, (MemoryRequestServer)memReqSvr);
        long[] v = new long[21];
        for (int i = 0; i < 21; ++i) {
            v[i] = i + 1;
        }
        sk.update(v, 0, 21);
        KllDirectLongsSketchTest.println(sk.toString(true, true));
        int[] levelsArr = sk.getLevelsArray(KllSketch.SketchStructure.UPDATABLE);
        Assert.assertEquals((int)levelsArr[0], (int)22);
        long[] longsArr = sk.getLongItemsArray();
        Assert.assertEquals((long)longsArr[22], (long)21L);
    }

    @Test
    public void checkWeightedUpdate() {
        WritableMemory dstMem = WritableMemory.allocate((int)6000);
        KllLongsSketch sk = KllLongsSketch.newDirectInstance((int)8, (WritableMemory)dstMem, (MemoryRequestServer)memReqSvr);
        for (int i = 0; i < 16; ++i) {
            sk.update((long)(i + 1), 16L);
        }
        KllDirectLongsSketchTest.println(sk.toString(true, true));
        Assert.assertEquals((long)sk.getN(), (long)256L);
        Assert.assertEquals((long)sk.getMaxItem(), (long)16L);
        Assert.assertEquals((long)sk.getMinItem(), (long)1L);
    }

    private static KllLongsSketch getUpdatableDirectLongSketch(int k, int n) {
        KllLongsSketch sk = KllLongsSketch.newHeapInstance((int)k);
        for (int i = 1; i <= n; ++i) {
            sk.update((long)i);
        }
        byte[] byteArr = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])byteArr);
        KllLongsSketch dfsk = KllLongsSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        return dfsk;
    }

    @Test
    public void checkMergeExceptionsWrongType() {
        KllLongsSketch sk1 = KllLongsSketch.newHeapInstance((int)20);
        KllDoublesSketch sk2 = KllDoublesSketch.newHeapInstance((int)20);
        try {
            sk1.merge((KllSketch)sk2);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        try {
            sk2.merge((KllSketch)sk1);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    private static final void println(Object o) {
    }
}

