/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteOrder;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.Resource;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.ResourceImpl;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AllocateDirectMemoryTest {
    @Test
    public void simpleAllocateDirect() {
        int longs = 32;
        WritableMemory wMem2 = null;
        try (WritableMemory wMem = WritableMemory.allocateDirect((long)(longs << 3));){
            wMem2 = wMem;
            for (int i = 0; i < longs; ++i) {
                wMem.putLong((long)(i << 3), (long)i);
                Assert.assertEquals((long)wMem.getLong((long)(i << 3)), (long)i);
            }
            Assert.assertTrue((boolean)wMem.isAlive());
        }
        Assert.assertFalse((boolean)wMem2.isAlive());
    }

    @Test
    public void checkDefaultMemoryRequestServer() {
        int longs1 = 32;
        int bytes1 = longs1 << 3;
        try (WritableMemory origWmem = WritableMemory.allocateDirect((long)bytes1);){
            for (int i = 0; i < longs1; ++i) {
                origWmem.putLong((long)(i << 3), (long)i);
                Assert.assertEquals((long)origWmem.getLong((long)(i << 3)), (long)i);
            }
            AllocateDirectMemoryTest.println(origWmem.toString("Test", 0L, 256, true));
            int longs2 = 64;
            int bytes2 = longs2 << 3;
            origWmem.setMemoryRequestServer(Resource.defaultMemReqSvr);
            MemoryRequestServer myMemReqSvr = origWmem.getMemoryRequestServer();
            WritableMemory newWmem = myMemReqSvr.request(origWmem, (long)bytes2);
            Assert.assertTrue((boolean)newWmem.isHeap());
            for (int i = 0; i < longs2; ++i) {
                newWmem.putLong((long)(i << 3), (long)i);
                Assert.assertEquals((long)newWmem.getLong((long)(i << 3)), (long)i);
            }
        }
    }

    @Test
    public void checkNonNativeDirect() {
        MemoryRequestServer myMemReqSvr = Resource.defaultMemReqSvr;
        try (WritableMemory wmem = WritableMemory.allocateDirect((long)128L, (long)8L, (ByteOrder)ResourceImpl.NON_NATIVE_BYTE_ORDER, (MemoryRequestServer)myMemReqSvr);){
            wmem.putChar(0L, '\u0001');
            Assert.assertEquals((byte)wmem.getByte(1L), (byte)1);
        }
    }

    @Test
    public void checkExplicitCloseNoTWR() {
        long cap = 128L;
        WritableMemory wmem = null;
        wmem = WritableMemory.allocateDirect((long)128L);
        wmem.close();
    }

    @Test
    public void printlnTest() {
        AllocateDirectMemoryTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

