/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.hll;

import java.io.IOException;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;

public class SketchToString
extends EvalFunc<String> {
    private final boolean hllDetail_;
    private final boolean auxDetail_;

    public SketchToString() {
        this(false, false);
    }

    public SketchToString(String hllDetail, String auxDetail) {
        this(Boolean.parseBoolean(hllDetail), Boolean.parseBoolean(auxDetail));
    }

    private SketchToString(boolean hllDetail, boolean auxDetail) {
        this.hllDetail_ = hllDetail;
        this.auxDetail_ = auxDetail;
    }

    public String exec(Tuple sketchTuple) throws IOException {
        if (sketchTuple == null || sketchTuple.size() == 0) {
            return null;
        }
        DataByteArray dba = (DataByteArray)sketchTuple.get(0);
        HllSketch sketch = HllSketch.wrap((Memory)Memory.wrap((byte[])dba.get()));
        return sketch.toString(true, this.hllDetail_, this.auxDetail_);
    }
}

