/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.sampling;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.pig.data.DataReaderWriter;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.WritableByteArray;

public class ArrayOfTuplesSerDe
extends ArrayOfItemsSerDe<Tuple> {
    public byte[] serializeToByteArray(Tuple[] items) {
        WritableByteArray wba = new WritableByteArray();
        try (DataOutputStream os = new DataOutputStream((OutputStream)wba);){
            for (Tuple t : items) {
                DataReaderWriter.writeDatum((DataOutput)os, (Object)t);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error serializing tuple: " + e.getMessage());
        }
        return wba.getData();
    }

    public Tuple[] deserializeFromMemory(Memory mem, int numItems) {
        byte[] bytes = (byte[])((WritableMemory)mem).getArray();
        int offset = (int)((WritableMemory)mem).getRegionOffset(0L);
        int length = (int)mem.getCapacity();
        Tuple[] result = new Tuple[numItems];
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes, offset, length);
             DataInputStream dis = new DataInputStream(bais);){
            for (int i = 0; i < numItems; ++i) {
                result[i] = (Tuple)DataReaderWriter.readDatum((DataInput)dis);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error deserializing tuple: " + e.getMessage());
        }
        return result;
    }
}

