/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.ij;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.derby.impl.tools.ij.mtTestCase;
import org.apache.derby.impl.tools.ij.mtTime;

public class mtTestSuite {
    private Vector cases;
    private Vector last;
    private Vector init;
    private mtTime time;
    private int numThreads;
    private String rootDir = null;

    mtTestSuite(int n, mtTime mtTime2, Vector vector, Vector vector2, Vector vector3) {
        this.numThreads = n;
        this.time = mtTime2;
        this.cases = vector2;
        this.init = vector;
        this.last = vector3;
    }

    public void init() {
        boolean bl = this.loadCases(this.init);
        boolean bl2 = this.loadCases(this.cases);
        boolean bl3 = this.loadCases(this.last);
        if (bl || bl2 || bl3) {
            throw new Error("Initialization Error");
        }
    }

    private boolean loadCases(Vector vector) {
        if (vector == null) {
            return false;
        }
        boolean bl = false;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            mtTestCase mtTestCase2 = (mtTestCase)enumeration.nextElement();
            try {
                mtTestCase2.initialize(this.rootDir);
            }
            catch (Throwable throwable) {
                bl = true;
            }
        }
        return bl;
    }

    public void setRoot(String string) {
        this.rootDir = string;
    }

    public String getRoot() {
        return this.rootDir;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public Vector getCases() {
        return this.cases;
    }

    public Vector getInitCases() {
        return this.init;
    }

    public Vector getFinalCases() {
        return this.last;
    }

    public mtTime getTime() {
        return this.time;
    }

    public long getTimeMillis() {
        return (this.time.hours * 360 + this.time.minutes * 60 + this.time.seconds) * 1000;
    }

    public String toString() {
        int n;
        String string = "TEST CASES\nNumber of Threads: " + this.numThreads;
        string = string + "\nTime: " + this.time;
        string = string + "\nNumber of Initializers: " + this.init.size() + "\n";
        int n2 = this.init.size();
        for (n = 0; n < n2; ++n) {
            string = string + this.init.elementAt(n).toString() + "\n";
        }
        string = string + "\nNumber of Cases: " + this.cases.size() + "\n";
        n2 = this.cases.size();
        for (n = 0; n < n2; ++n) {
            string = string + this.cases.elementAt(n).toString() + "\n";
        }
        string = string + "\nNumber of Final Cases: " + this.last.size() + "\n";
        n2 = this.last.size();
        for (n = 0; n < n2; ++n) {
            string = string + this.last.elementAt(n).toString() + "\n";
        }
        return string;
    }

    public mtTestCase grabTestCase() {
        int n;
        mtTestCase mtTestCase2;
        int n2 = this.cases.size();
        while (!(mtTestCase2 = (mtTestCase)this.cases.elementAt(n = (int)(Math.random() * 1311.0 % (double)n2))).grab()) {
        }
        return mtTestCase2;
    }
}

