/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.store.StoreBaseTest;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;

public class Derby4923Test
extends StoreBaseTest {
    public Derby4923Test(String name) {
        super(name);
    }

    public void testDERBY_4923() throws SQLException, InterruptedException {
        int i;
        Statement stmt = this.createStatement();
        PreparedStatement insert_stmt = this.prepareStatement("INSERT INTO TESTBADUPDATE VALUES(?, ?)");
        PreparedStatement delete_stmt = this.prepareStatement("DELETE FROM TESTBADUPDATE");
        PreparedStatement update_stmt = this.prepareStatement("UPDATE TESTBADUPDATE set value = ? where id = ?");
        byte[] pad_blob = new byte[1];
        for (i = 1000; i < 2000; ++i) {
            insert_stmt.setInt(1, i);
            insert_stmt.setBytes(2, pad_blob);
            insert_stmt.executeUpdate();
        }
        this.commit();
        delete_stmt.executeUpdate();
        this.commit();
        this.callCompress(stmt.getConnection(), "APP", "TESTBADUPDATE", true, true, false, true);
        this.commit();
        pad_blob = new byte[1];
        for (i = 1; i < 4; ++i) {
            insert_stmt.setInt(1, i);
            insert_stmt.setBytes(2, pad_blob);
            insert_stmt.executeUpdate();
        }
        this.commit();
        pad_blob = new byte[3000];
        Arrays.fill(pad_blob, (byte)112);
        update_stmt.setBytes(1, pad_blob);
        update_stmt.setInt(2, 1);
        update_stmt.executeUpdate();
        this.commit();
        pad_blob = new byte[1500];
        Arrays.fill(pad_blob, (byte)112);
        update_stmt.setBytes(1, pad_blob);
        update_stmt.setInt(2, 2);
        update_stmt.executeUpdate();
        this.commit();
        pad_blob = new byte[4];
        Arrays.fill(pad_blob, (byte)112);
        update_stmt.setBytes(1, pad_blob);
        update_stmt.setInt(2, 2);
        update_stmt.executeUpdate();
        this.commit();
        pad_blob = new byte[3988];
        Arrays.fill(pad_blob, (byte)112);
        update_stmt.setBytes(1, pad_blob);
        update_stmt.setInt(2, 3);
        update_stmt.executeUpdate();
        this.commit();
        pad_blob = new byte[19680];
        Arrays.fill(pad_blob, (byte)112);
        update_stmt.setBytes(1, pad_blob);
        update_stmt.setInt(2, 2);
        update_stmt.executeUpdate();
        this.commit();
        stmt.close();
        insert_stmt.close();
        update_stmt.close();
    }

    private void callCompress(Connection conn, String schemaName, String tableName, boolean purgeRows, boolean defragmentRows, boolean truncateEnd, boolean commit_operation) throws SQLException {
        CallableStatement cstmt = conn.prepareCall("call SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE(?, ?, ?, ?, ?)");
        cstmt.setString(1, schemaName);
        cstmt.setString(2, tableName);
        cstmt.setInt(3, purgeRows ? 1 : 0);
        cstmt.setInt(4, defragmentRows ? 1 : 0);
        cstmt.setInt(5, truncateEnd ? 1 : 0);
        cstmt.execute();
        if (commit_operation) {
            conn.commit();
        }
    }

    protected static Test baseSuite(String name) {
        BaseTestSuite suite = new BaseTestSuite(name);
        suite.addTestSuite(Derby4923Test.class);
        return new CleanDatabaseTestSetup(DatabasePropertyTestSetup.setLockTimeouts((Test)suite, 2, 4)){

            @Override
            protected void decorateSQL(Statement stmt) throws SQLException {
                Connection conn = stmt.getConnection();
                CallableStatement cSt = conn.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '4096')");
                cSt.execute();
                stmt.executeUpdate("CREATE TABLE TESTBADUPDATE (id int, value blob(1M))");
                conn.setAutoCommit(false);
            }
        };
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("Derby4923Test");
        suite.addTest(Derby4923Test.baseSuite("Derby4923Test:embedded"));
        return suite;
    }
}

