/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.tools.ImportExportBaseTest;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ImportExportLobTest
extends ImportExportBaseTest {
    String fileName = SupportFilesSetup.getReadWrite("books.del").getPath();
    String lobsFileName = SupportFilesSetup.getReadWrite("books_lobs.dat").getPath();
    String lobsFileName2 = SupportFilesSetup.getReadWrite("unql_books_lobs.dat").getPath();

    public ImportExportLobTest(String name) throws SQLException {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite(ImportExportLobTest.class);
        suite.addTest(TestConfiguration.clientServerSuite(ImportExportLobTest.class));
        Object test = suite;
        test = new SupportFilesSetup((Test)test);
        return new CleanDatabaseTestSetup((Test)test){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                s.execute("CREATE TABLE BOOKS(id int,name varchar(30),content clob, pic blob )");
                ImportExportLobTest.loadData(s);
                s.execute("CREATE TABLE BOOKS_IMP(id int,name varchar(30),content clob,pic blob )");
                s.execute("CREATE TABLE hex_tab(id int,C1 varchar(20),C2 varchar(20),C3 varchar(20))");
                s.execute("CREATE TABLE derby_2925_lob(id int,name varchar(30), content clob,pic blob)");
            }
        };
    }

    protected void setUp() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("DELETE FROM BOOKS_IMP");
        s.close();
        SupportFilesSetup.deleteFile(this.fileName);
        SupportFilesSetup.deleteFile(this.lobsFileName);
    }

    public void testImportTableExportTable() throws SQLException, IOException {
        this.doExportTable("APP", "BOOKS", this.fileName, null, null, null);
        this.doImportTable("APP", "BOOKS_IMP", this.fileName, null, null, null, 0);
        this.verifyData(" * ");
    }

    public void testImportDataExportQuery() throws SQLException, IOException {
        this.doExportQuery("select * from BOOKS", this.fileName, null, null, null);
        this.doImportData(null, "BOOKS_IMP", null, null, this.fileName, null, null, null, 0);
        this.verifyData(" * ");
        this.doImportData(null, "BOOKS_IMP", "PIC, CONTENT, NAME, ID", "4, 3, 2, 1", this.fileName, null, null, null, 1);
        this.verifyData("PIC, CONTENT, NAME, ID");
        SupportFilesSetup.deleteFile(this.fileName);
        this.doExportQuery("select * from BOOKS_IMP", this.fileName, ";", "%", null);
        this.doImportData(null, "BOOKS_IMP", null, null, this.fileName, ";", "%", null, 1);
    }

    public void testImportDataExportQueryWithFewColumns() throws SQLException, IOException {
        this.doExportQuery("select id, name, content, pic from BOOKS", this.fileName, null, null, null);
        this.doImportData(null, "BOOKS_IMP", "ID,PIC", "1 , 4", this.fileName, null, null, null, 0);
        this.verifyData("ID,PIC");
        this.doImportData(null, "BOOKS_IMP", "ID, PIC, NAME", "1, 4, 2", this.fileName, null, null, null, 1);
        this.verifyData("ID, PIC, NAME");
        this.doImportData(null, "BOOKS_IMP", "ID, CONTENT, NAME", "1, 3, 2", this.fileName, null, null, null, 1);
        this.verifyData("ID, CONTENT, NAME");
        SupportFilesSetup.deleteFile(this.fileName);
        this.doExportQuery("select id, name, content, pic from BOOKS", this.fileName, "$", "!", null);
        this.doImportData(null, "BOOKS_IMP", "ID,PIC", "1 , 4", this.fileName, "$", "!", null, 0);
    }

    public void testImportWithInvalidHexStrings() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("insert into hex_tab values(1, 'row 1', 'clob 1', 'B1C201DA')");
        s.executeUpdate("insert into hex_tab values(2, 'row 2', 'clob2 ', 'B1C201A')");
        s.executeUpdate("insert into hex_tab values(3, '', 'clobs 3', '3122A1F20Z')");
        s.executeUpdate("insert into hex_tab values(4, 'row \"4', '3122A1F20Z', 'B1C2\"01DA')");
        s.close();
        this.doExportTable("APP", "HEX_TAB", this.fileName, null, null, null);
        SupportFilesSetup.deleteFile(this.fileName);
        try {
            this.doExportQuery("select * from hex_tab where id <= 2", this.fileName, null, null, null);
            this.doImportTable("APP", "BOOKS_IMP", this.fileName, null, null, null, 0);
            ImportExportLobTest.fail((String)"import did not fail on data with invalid hex string");
        }
        catch (SQLException e) {
            ImportExportLobTest.assertSQLState("XIE0N", e);
        }
        SupportFilesSetup.deleteFile(this.fileName);
        try {
            this.doExportQuery("select * from hex_tab where id = 3", this.fileName, null, null, null);
            this.doImportData(null, "BOOKS_IMP", "ID, PIC", "1,4", this.fileName, null, null, null, 1);
            ImportExportLobTest.fail((String)"import did not fail on data with invalid hex strings");
        }
        catch (SQLException e) {
            ImportExportLobTest.assertSQLState("XIE0N", e);
        }
        SupportFilesSetup.deleteFile(this.fileName);
        try {
            this.doExportQuery("select * from hex_tab where id = 4", this.fileName, null, null, null);
            this.doImportData(null, "BOOKS_IMP", "ID, PIC", "1,4", this.fileName, null, null, null, 1);
            ImportExportLobTest.fail((String)"import did not fail on data with invalid hex strings");
        }
        catch (SQLException e) {
            ImportExportLobTest.assertSQLState("XIE0N", e);
        }
    }

    public void testImportTableExportTableLobsInExtFile() throws SQLException, IOException {
        this.doExportTableLobsToExtFile("APP", "BOOKS", this.fileName, null, null, null, this.lobsFileName);
        this.doImportTableLobsFromExtFile("APP", "BOOKS_IMP", this.fileName, null, null, null, 0);
        this.verifyData(" * ");
    }

    public void testImportTableExportTableLobsInUnqalifiedExtFile() throws SQLException, IOException {
        SupportFilesSetup.deleteFile(this.lobsFileName2);
        this.doExportTableLobsToExtFile("APP", "BOOKS", this.fileName, "\t", "|", "UTF-16", this.lobsFileName2);
        if (JDBC.vmSupportsJDBC3()) {
            this.doImportTableLobsFromExtFile("APP", "BOOKS_IMP", this.fileName, "\t", "|", "UTF-16", 0);
            this.verifyData(" * ");
        }
    }

    public void testImportDataExportQueryLobsInExtFile() throws SQLException, IOException {
        this.doExportQueryLobsToExtFile("select * from BOOKS", this.fileName, null, null, "8859_1", this.lobsFileName);
        this.doImportDataLobsFromExtFile(null, "BOOKS_IMP", null, null, this.fileName, null, null, "8859_1", 0);
        this.verifyData(" * ");
        this.doImportDataLobsFromExtFile(null, "BOOKS_IMP", "PIC, CONTENT, NAME, ID", "4, 3, 2, 1", this.fileName, null, null, "8859_1", 1);
        this.verifyData("PIC, CONTENT, NAME, ID");
        SupportFilesSetup.deleteFile(this.fileName);
        SupportFilesSetup.deleteFile(this.lobsFileName);
        this.doExportQueryLobsToExtFile("select * from BOOKS_IMP", this.fileName, ";", "%", null, this.lobsFileName);
        this.doImportDataLobsFromExtFile(null, "BOOKS_IMP", null, null, this.fileName, ";", "%", null, 1);
    }

    public void testImportDataExportQueryWithFewColsLobsInExtFile() throws SQLException, IOException {
        this.doExportQueryLobsToExtFile("select id, name, content, pic from BOOKS", this.fileName, null, null, null, this.lobsFileName);
        this.doImportDataLobsFromExtFile(null, "BOOKS_IMP", "ID,PIC", "1 , 4", this.fileName, null, null, null, 0);
        this.verifyData("ID,PIC");
        this.doImportDataLobsFromExtFile(null, "BOOKS_IMP", "ID, PIC, NAME", "1, 4, 2", this.fileName, null, null, null, 1);
        this.verifyData("ID, PIC, NAME");
        this.doImportDataLobsFromExtFile(null, "BOOKS_IMP", "ID, CONTENT, NAME", "1, 3, 2", this.fileName, null, null, null, 1);
        this.verifyData("ID, CONTENT, NAME");
        SupportFilesSetup.deleteFile(this.fileName);
        SupportFilesSetup.deleteFile(this.lobsFileName);
        this.doExportQueryLobsToExtFile("select id, name, content, pic from BOOKS", this.fileName, "$", "!", null, this.lobsFileName);
        this.doImportDataLobsFromExtFile(null, "BOOKS_IMP", "ID,PIC", "1 , 4", this.fileName, "$", "!", null, 0);
    }

    public void testImportExportInvalideDelimiters() throws SQLException, IOException {
        try {
            this.doExportTableLobsToExtFile("APP", "BOOKS", this.fileName, null, "9", null, this.lobsFileName);
            ImportExportLobTest.fail();
        }
        catch (SQLException e) {
            ImportExportLobTest.assertSQLState("XIE0J", e);
        }
        SupportFilesSetup.deleteFile(this.fileName);
        SupportFilesSetup.deleteFile(this.lobsFileName);
        try {
            this.doExportQueryLobsToExtFile("select * from BOOKS", this.fileName, "|", "f", null, this.lobsFileName);
            ImportExportLobTest.fail();
        }
        catch (SQLException e) {
            ImportExportLobTest.assertSQLState("XIE0J", e);
        }
        SupportFilesSetup.deleteFile(this.fileName);
        SupportFilesSetup.deleteFile(this.lobsFileName);
        this.doExportQueryLobsToExtFile("select * from BOOKS where id < 10", this.fileName, null, null, null, this.lobsFileName);
        try {
            this.doImportTableLobsFromExtFile("APP", "BOOKS_IMP", this.fileName, "2", null, null, 0);
            ImportExportLobTest.fail();
        }
        catch (SQLException e) {
            ImportExportLobTest.assertSQLState("XIE0J", e);
        }
        try {
            this.doImportDataLobsFromExtFile(null, "BOOKS_IMP", null, null, this.fileName, null, "c", null, 1);
            ImportExportLobTest.fail();
        }
        catch (SQLException e) {
            ImportExportLobTest.assertSQLState("XIE0J", e);
        }
    }

    public void testImportTableExportWithInvalidLobFileName() throws SQLException, IOException {
        try {
            this.doExportTableLobsToExtFile("APP", "BOOKS", this.fileName, null, null, null, null);
            ImportExportLobTest.fail();
        }
        catch (SQLException e) {
            ImportExportLobTest.assertSQLState("XIE0Q", e);
        }
        SupportFilesSetup.deleteFile(this.fileName);
        this.doExportTableLobsToExtFile("APP", "BOOKS", this.fileName, null, null, null, this.lobsFileName);
        SupportFilesSetup.deleteFile(this.lobsFileName);
        try {
            this.doImportTableLobsFromExtFile("APP", "BOOKS_IMP", this.fileName, null, null, null, 0);
            ImportExportLobTest.fail();
        }
        catch (SQLException e) {
            ImportExportLobTest.assertSQLState("XIE0P", e);
        }
    }

    public void testDerby2955ExportQueryLobs() throws SQLException {
        this.doExportTableLobsToExtFile("APP", "DERBY_2925_LOB", this.fileName, "\t", "|", "UTF-16", this.lobsFileName);
        try {
            this.doExportTableLobsToExtFile("APP", "DERBY_2925_LOB", this.fileName, "\t", "|", "UTF-16", this.lobsFileName);
            ImportExportLobTest.fail((String)"export should have failed as the data file exists.");
        }
        catch (SQLException e) {
            ImportExportLobTest.assertSQLState("XIE0S", e);
        }
        SupportFilesSetup.deleteFile(this.fileName);
        SupportFilesSetup.deleteFile(this.lobsFileName);
        this.doExportTableLobsToExtFile("APP", "DERBY_2925_LOB", this.fileName, "\t", "|", "UTF-16", this.lobsFileName);
        SupportFilesSetup.deleteFile(this.fileName);
        try {
            this.doExportTableLobsToExtFile("APP", "DERBY_2925_LOB", this.fileName, "\t", "|", "UTF-16", this.lobsFileName);
            ImportExportLobTest.fail((String)"export should have failed as the data file exists.");
        }
        catch (SQLException e) {
            ImportExportLobTest.assertSQLState("XIE0T", e);
        }
    }

    private void verifyData(String cols) throws SQLException, IOException {
        Statement s1 = this.createStatement();
        ResultSet rsExport = s1.executeQuery("SELECT " + cols + " FROM BOOKS order by id");
        Statement s2 = this.createStatement();
        ResultSet rsImport = s2.executeQuery("SELECT " + cols + " FROM BOOKS_IMP order by id");
        JDBC.assertSameContents(rsExport, rsImport);
        s1.close();
        s2.close();
    }

    private static void loadData(Statement s) throws SQLException {
        s.executeUpdate("insert into books values (1, 'book 1', 'clob 1',cast(X'3743640ADE12337610' as blob))");
        s.executeUpdate("insert into books values (2, 'book 2', 'clob 2',  cast (X'' as blob))");
        s.executeUpdate("insert into books values (3, 'book 3', '', cast(X'42' as blob))");
        s.executeUpdate("insert into books values (4, 'book 4', 'clob 4',  cast (X'3233445578990122558820' as blob))");
        s.executeUpdate("insert into books values (5, null, 'clob 5',cast(X'3843640ADE12337610' as blob))");
        s.executeUpdate("insert into books values (6,  'book  6', null,  cast(X'3843640ADE12337610' as blob))");
        s.executeUpdate("insert into books values (7,  'book  7',  'clob 7' , null)");
        s.executeUpdate("insert into books values (8, '', null,  cast (X'3843640ADE12' as blob))");
        s.executeUpdate("insert into books values (9, 'book  9', null,  cast (X'' as blob))");
        s.executeUpdate("insert into books values (10, 'book ;10', '%asdadasdasd', cast (X'222C23B90A' as blob))");
        s.executeUpdate("insert into books values (11, '212C3B24', '2422412221',   cast (X'212421222C23B90A2124' as blob))");
        s.executeUpdate("insert into books values(12, 'Transaction Processing' , 'This books covers \"Transaction\" \"processing\" concepts',cast (X'144594322143423214ab35f2e54e' as blob))");
        s.executeUpdate("insert into books values(13, 'effective java' ,'describes how to write \" quality java \" code', cast (X'124594322143423214ab35f2e34c' as blob))");
        Connection conn = s.getConnection();
        String sql = "insert into books values(? , ? , ? , ?)";
        PreparedStatement ps = conn.prepareStatement(sql);
        int blobSize = 0;
        int id = 14;
        for (int i = 0; i < 17; ++i) {
            ps.setInt(1, id++);
            ps.setString(2, "book" + i);
            int clobSize = 1024 * i;
            LoopingAlphabetReader reader = new LoopingAlphabetReader(clobSize);
            ps.setCharacterStream(3, (Reader)reader, clobSize);
            LoopingAlphabetStream stream = new LoopingAlphabetStream(blobSize += 1024 * i);
            ps.setBinaryStream(4, (InputStream)stream, blobSize);
            ps.executeUpdate();
            if (i % 10 != 0) continue;
            conn.commit();
        }
        ps.close();
        conn.commit();
    }
}

