/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.junit;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.Test;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.CharacterStreamDescriptor;
import org.apache.derby.iapi.types.PositionedStream;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;

public class CharacterStreamDescriptorTest
extends BaseTestCase {
    public CharacterStreamDescriptorTest(String name) {
        super(name);
    }

    public void testDefaultValues() {
        ByteArrayInputStream emptyStream = new ByteArrayInputStream(new byte[0]);
        CharacterStreamDescriptor.Builder b = new CharacterStreamDescriptor.Builder().stream((InputStream)emptyStream);
        CharacterStreamDescriptor csd = b.build();
        CharacterStreamDescriptorTest.assertEquals((boolean)false, (boolean)csd.isBufferable());
        CharacterStreamDescriptorTest.assertEquals((boolean)false, (boolean)csd.isPositionAware());
        CharacterStreamDescriptorTest.assertEquals((long)0L, (long)csd.getDataOffset());
        CharacterStreamDescriptorTest.assertEquals((long)0L, (long)csd.getCurBytePos());
        CharacterStreamDescriptorTest.assertEquals((long)1L, (long)csd.getCurCharPos());
        CharacterStreamDescriptorTest.assertEquals((long)0L, (long)csd.getByteLength());
        CharacterStreamDescriptorTest.assertEquals((long)0L, (long)csd.getCharLength());
        CharacterStreamDescriptorTest.assertEquals((long)Long.MAX_VALUE, (long)csd.getMaxCharLength());
    }

    public void testSetValues() {
        long charLength = 1023L;
        long byteLength = 2046L;
        long curBytePos = 4L;
        long curCharPos = 2L;
        long dataOffset = 2L;
        long maxCharLen = 2459L;
        ByteArrayInputStream emptyStream = new ByteArrayInputStream(new byte[0]);
        CharacterStreamDescriptor.Builder b = new CharacterStreamDescriptor.Builder().bufferable(true).byteLength(2046L).charLength(1023L).curBytePos(4L).curCharPos(2L).dataOffset(2L).maxCharLength(2459L).stream((InputStream)emptyStream);
        CharacterStreamDescriptor csd = b.build();
        CharacterStreamDescriptorTest.assertEquals((boolean)true, (boolean)csd.isBufferable());
        CharacterStreamDescriptorTest.assertEquals((boolean)false, (boolean)csd.isPositionAware());
        CharacterStreamDescriptorTest.assertEquals((long)2L, (long)csd.getDataOffset());
        CharacterStreamDescriptorTest.assertEquals((long)4L, (long)csd.getCurBytePos());
        CharacterStreamDescriptorTest.assertEquals((long)2L, (long)csd.getCurCharPos());
        CharacterStreamDescriptorTest.assertEquals((long)2046L, (long)csd.getByteLength());
        CharacterStreamDescriptorTest.assertEquals((long)1023L, (long)csd.getCharLength());
        CharacterStreamDescriptorTest.assertEquals((long)2459L, (long)csd.getMaxCharLength());
        PositionedTestStream emptyPS = new PositionedTestStream(4L);
        csd = new CharacterStreamDescriptor.Builder().bufferable(true).positionAware(true).maxCharLength(2459L).stream(emptyPS.asInputStream()).build();
        CharacterStreamDescriptorTest.assertEquals((boolean)true, (boolean)csd.isBufferable());
        CharacterStreamDescriptorTest.assertEquals((boolean)true, (boolean)csd.isPositionAware());
        CharacterStreamDescriptorTest.assertEquals((long)2459L, (long)csd.getMaxCharLength());
        csd = new CharacterStreamDescriptor.Builder().bufferable(true).positionAware(true).dataOffset(2L).curCharPos(0L).stream(emptyPS.asInputStream()).build();
        CharacterStreamDescriptorTest.assertEquals((boolean)true, (boolean)csd.isBufferable());
        CharacterStreamDescriptorTest.assertEquals((boolean)true, (boolean)csd.isPositionAware());
        CharacterStreamDescriptorTest.assertEquals((long)2L, (long)csd.getDataOffset());
        CharacterStreamDescriptorTest.assertEquals((long)0L, (long)csd.getCurCharPos());
    }

    public void testCopyState() {
        long charLength = 1023L;
        long byteLength = 2046L;
        long curBytePos = 4L;
        long curCharPos = 2L;
        long dataOffset = 2L;
        long maxCharLen = 3021L;
        ByteArrayInputStream emptyStream = new ByteArrayInputStream(new byte[0]);
        CharacterStreamDescriptor.Builder b1 = new CharacterStreamDescriptor.Builder().bufferable(true).byteLength(2046L).charLength(1023L).curBytePos(4L).curCharPos(2L).dataOffset(2L).maxCharLength(3021L).stream((InputStream)emptyStream);
        CharacterStreamDescriptor csd1 = b1.build();
        CharacterStreamDescriptor.Builder b2 = new CharacterStreamDescriptor.Builder().copyState(csd1);
        CharacterStreamDescriptor csd2 = b2.build();
        CharacterStreamDescriptorTest.assertEquals((boolean)csd2.isBufferable(), (boolean)csd1.isBufferable());
        CharacterStreamDescriptorTest.assertEquals((boolean)csd2.isPositionAware(), (boolean)csd1.isPositionAware());
        CharacterStreamDescriptorTest.assertEquals((long)csd2.getDataOffset(), (long)csd1.getDataOffset());
        CharacterStreamDescriptorTest.assertEquals((long)csd2.getCurBytePos(), (long)csd1.getCurBytePos());
        CharacterStreamDescriptorTest.assertEquals((long)csd2.getCurCharPos(), (long)csd1.getCurCharPos());
        CharacterStreamDescriptorTest.assertEquals((long)csd2.getByteLength(), (long)csd1.getByteLength());
        CharacterStreamDescriptorTest.assertEquals((long)csd2.getCharLength(), (long)csd1.getCharLength());
        CharacterStreamDescriptorTest.assertEquals((long)csd2.getMaxCharLength(), (long)csd1.getMaxCharLength());
        CharacterStreamDescriptorTest.assertTrue((csd2.getStream() == csd1.getStream() ? 1 : 0) != 0);
        CharacterStreamDescriptor.Builder b3 = new CharacterStreamDescriptor.Builder().copyState(csd1).maxCharLength(8765L);
        CharacterStreamDescriptor csd3 = b3.build();
        CharacterStreamDescriptorTest.assertEquals((long)8765L, (long)csd3.getMaxCharLength());
        CharacterStreamDescriptor.Builder b4 = new CharacterStreamDescriptor.Builder().maxCharLength(8765L).copyState(csd1);
        CharacterStreamDescriptor csd4 = b4.build();
        CharacterStreamDescriptorTest.assertEquals((long)csd1.getMaxCharLength(), (long)csd4.getMaxCharLength());
    }

    public static Test suite() {
        return new BaseTestSuite(CharacterStreamDescriptorTest.class, "CharacterStreamDescriptorTest suite");
    }

    private static class PositionedTestStream
    extends InputStream
    implements PositionedStream {
        private final long pos;

        PositionedTestStream(long pos) {
            this.pos = pos;
        }

        @Override
        public int read() throws IOException {
            return -1;
        }

        public InputStream asInputStream() {
            return this;
        }

        public long getPosition() {
            return this.pos;
        }

        public void reposition(long requestedPos) throws IOException, StandardException {
        }
    }
}

