/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.ByteArrayInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.derby.iapi.services.io.AccessibleByteArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatIdInputStream;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.shared.common.sanity.SanityManager;

class DebugByteTeeOutputStream
extends FilterOutputStream {
    private AccessibleByteArrayOutputStream tee = new AccessibleByteArrayOutputStream(256);

    DebugByteTeeOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.tee.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.tee.write(b, off, len);
    }

    void checkObject(Formatable f) {
        ByteArrayInputStream in = new ByteArrayInputStream(this.tee.getInternalByteArray(), 0, this.tee.size());
        FormatIdInputStream fin = new FormatIdInputStream(in);
        Formatable f1 = null;
        try {
            f1 = (Formatable)fin.readObject();
            if (f1.equals(f)) {
                return;
            }
            if (f1.hashCode() == System.identityHashCode(f1) && f.hashCode() == System.identityHashCode(f)) {
                return;
            }
        }
        catch (Throwable t) {
            String err_msg = "FormatableError:read error    : " + t.toString() + "\nFormatableError:class written : " + f.getClass();
            err_msg = err_msg + (f1 == null ? "FormatableError:read back as null" : "FormatableError:class read    : " + f1.getClass());
            err_msg = err_msg + "FormatableError:write id      : " + FormatIdUtil.formatIdToString(f.getTypeFormatId());
            if (f1 != null) {
                err_msg = err_msg + "FormatableError:read id       : " + FormatIdUtil.formatIdToString(f1.getTypeFormatId());
            }
            System.out.println(err_msg);
            t.printStackTrace(System.out);
            SanityManager.DEBUG_PRINT("DebugByteTeeOutputStream", err_msg);
            SanityManager.showTrace(t);
        }
    }
}

