/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import junit.framework.Test;
import org.apache.derby.impl.drda.ProtocolTestAdapter;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.functionTests.util.ProtocolTestGrammar;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ProtocolTest
extends BaseTestCase {
    private static final String PREFIX = "org/apache/derbyTesting/functionTests/tests/derbynet/";
    private static final String NL = BaseTestCase.getSystemProperty("line.separator");
    private static final String MULTIVAL_START = "MULTIVALSTART";
    private static final String MULTIVAL_SEP = "SEP";
    private static final String MULTIVAL_END = "MULTIVALEND";
    private static final String UTF8_TEST_MATCH = "%UTF8TestString%";
    private static final String UTF8_TEST_STRING = "\u4f60\u597d\u4e16\u754cABCDEFGHIJKLMNOPQ";
    private final String filename;
    private final int startLine;
    private final int lineCount;
    private String commandSequence;
    private ProtocolTestAdapter adapter;

    private ProtocolTest(String string, String string2, int n, int n2) {
        super("testProtocolSequence");
        this.filename = string;
        this.commandSequence = string2;
        this.startLine = n;
        this.lineCount = n2;
    }

    public void testProtocolSequence() throws IOException, UnknownHostException {
        super.setName(this.filename + "_" + this.startLine + "_" + (this.startLine + this.lineCount));
        ProtocolTest.println(this.getName() + " :: STARTED");
        ProtocolTest.assertEquals((String)"Actual line count does not match the specified count", (int)this.lineCount, (int)(this.commandSequence.length() - this.commandSequence.replaceAll("\n", "").length() - 1));
        this.adapter = new ProtocolTestAdapter(ProtocolTest.createSocket());
        StringReader stringReader = new StringReader(this.commandSequence);
        try {
            this.processCommands(stringReader);
        }
        finally {
            try {
                this.adapter.close();
            }
            catch (IOException iOException) {
                ProtocolTest.alarm("adapter.close() failed: " + iOException.getMessage());
            }
        }
    }

    public void tearDown() throws Exception {
        this.commandSequence = null;
        this.adapter.close();
        this.adapter = null;
        super.tearDown();
    }

    private static Socket createSocket() throws IOException, UnknownHostException {
        Socket socket = null;
        final TestConfiguration testConfiguration = TestConfiguration.getCurrent();
        try {
            socket = AccessController.doPrivileged(new PrivilegedExceptionAction<Socket>(){

                @Override
                public Socket run() throws IOException, UnknownHostException {
                    return new Socket(testConfiguration.getHostName(), testConfiguration.getPort());
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getCause() instanceof IOException) {
                throw (IOException)privilegedActionException.getCause();
            }
            if (privilegedActionException.getCause() instanceof UnknownHostException) {
                throw (UnknownHostException)privilegedActionException.getCause();
            }
            ProtocolTest.fail("Unhandled exception", privilegedActionException);
        }
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(String string) throws IOException {
        File file = SupportFilesSetup.getReadOnly(string);
        ProtocolTest.assertTrue((String)("Missing file: " + string), (boolean)PrivilegedFileOpsForTests.exists(file));
        try (BufferedReader bufferedReader = new BufferedReader(PrivilegedFileOpsForTests.getFileReader(file));){
            this.processCommands(bufferedReader);
        }
    }

    private void processCommands(Reader reader) throws IOException {
        int n;
        StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
        boolean bl = false;
        while ((n = streamTokenizer.nextToken()) != -1) {
            ProtocolTest.assertFalse((String)("End signalled, data to process left: " + streamTokenizer.sval), (boolean)bl);
            switch (n) {
                case -2: {
                    break;
                }
                case -3: {
                    bl = this.processCommand(streamTokenizer);
                    break;
                }
            }
        }
    }

    private boolean processCommand(StreamTokenizer streamTokenizer) throws IOException {
        ProtocolTestGrammar protocolTestGrammar = ProtocolTestGrammar.cmdFromString(streamTokenizer.sval.toLowerCase(Locale.ENGLISH));
        if (protocolTestGrammar == null) {
            ProtocolTest.fail((String)("Unknown command '" + streamTokenizer.sval + "' in line " + this.ln(streamTokenizer)));
        }
        switch (protocolTestGrammar) {
            case INCLUDE: {
                this.processFile(this.getString(streamTokenizer));
                break;
            }
            case CREATE_DSS_REQUEST: {
                this.adapter.wCreateDssRequest();
                break;
            }
            case CREATE_DSS_OBJECT: {
                this.adapter.wCreateDssObject();
                break;
            }
            case CREATE_DSS_REPLY: {
                this.adapter.wCreateDssReply();
                break;
            }
            case END_DSS: {
                streamTokenizer.nextToken();
                streamTokenizer.pushBack();
                if (streamTokenizer.sval != null && streamTokenizer.sval.startsWith("0x")) {
                    this.adapter.wEndDss(this.getBytes(streamTokenizer)[0]);
                    break;
                }
                this.adapter.wEndDss();
                break;
            }
            case END_DDM: {
                this.adapter.wEndDdm();
                break;
            }
            case END_DDM_AND_DSS: {
                this.adapter.wEndDdmAndDss();
                break;
            }
            case START_DDM: {
                this.adapter.wStartDdm(this.getCP(streamTokenizer));
                break;
            }
            case WRITE_SCALAR_STRING: {
                this.adapter.wWriteScalarString(this.getCP(streamTokenizer), this.getString(streamTokenizer));
                break;
            }
            case WRITE_SCALAR_2BYTES: {
                this.adapter.wWriteScalar2Bytes(this.getCP(streamTokenizer), this.getIntOrCP(streamTokenizer));
                break;
            }
            case WRITE_SCALAR_1BYTE: {
                this.adapter.wWriteScalar1Byte(this.getCP(streamTokenizer), this.getInt(streamTokenizer));
                break;
            }
            case WRITE_SCALAR_BYTES: {
                this.adapter.wWriteScalarBytes(this.getCP(streamTokenizer), this.getBytes(streamTokenizer));
                break;
            }
            case WRITE_SCALAR_PADDED_BYTES: {
                this.adapter.wWriteScalarPaddedBytes(this.getCP(streamTokenizer), this.getBytes(streamTokenizer), this.getInt(streamTokenizer), ProtocolTestAdapter.SPACE);
                break;
            }
            case WRITE_BYTE: {
                this.adapter.wWriteByte(this.getInt(streamTokenizer));
                break;
            }
            case WRITE_BYTES: {
                this.adapter.wWriteBytes(this.getBytes(streamTokenizer));
                break;
            }
            case WRITE_SHORT: {
                this.adapter.wWriteShort(this.getInt(streamTokenizer));
                break;
            }
            case WRITE_INT: {
                this.adapter.wWriteInt(this.getInt(streamTokenizer));
                break;
            }
            case WRITE_CODEPOINT_4BYTES: {
                this.adapter.wWriteCodePoint4Bytes(this.getCP(streamTokenizer), this.getInt(streamTokenizer));
                break;
            }
            case WRITE_STRING: {
                String string = this.getString(streamTokenizer);
                this.adapter.wWriteBytes(this.getEBCDIC(string));
                break;
            }
            case WRITE_ENCODED_STRING: {
                this.writeEncodedString(this.getString(streamTokenizer), this.getString(streamTokenizer));
                break;
            }
            case WRITE_ENCODED_LDSTRING: {
                this.writeEncodedLDString(this.getString(streamTokenizer), this.getString(streamTokenizer), this.getInt(streamTokenizer));
                break;
            }
            case WRITE_PADDED_STRING: {
                String string = this.getString(streamTokenizer);
                this.adapter.wWriteBytes(this.getEBCDIC(string));
                int n = this.getInt(streamTokenizer);
                int n2 = string.length();
                if (n2 >= n) break;
                this.adapter.wPadBytes(ProtocolTestAdapter.SPACE, n - n2);
                break;
            }
            case READ_REPLY_DSS: {
                this.adapter.rReadReplyDss();
                break;
            }
            case SKIP_DSS: {
                this.adapter.rSkipDss();
                break;
            }
            case SKIP_DDM: {
                this.adapter.rSkipDdm();
                break;
            }
            case MORE_DATA: {
                String string = this.getString(streamTokenizer);
                boolean bl = Boolean.parseBoolean(string);
                ProtocolTest.assertEquals((String)"Too much/little data", (boolean)bl, (boolean)this.adapter.rMoreData());
                break;
            }
            case READ_LENGTH_AND_CODEPOINT: {
                this.readLengthAndCodePoint(streamTokenizer);
                break;
            }
            case READ_SCALAR_2BYTES: {
                this.readLengthAndCodePoint(streamTokenizer);
                int n = this.adapter.rReadNetworkShort();
                this.checkIntOrCP(streamTokenizer, n);
                break;
            }
            case READ_SCALAR_1BYTE: {
                this.readLengthAndCodePoint(streamTokenizer);
                byte by = this.adapter.rReadByte();
                this.checkIntOrCP(streamTokenizer, by);
                break;
            }
            case READ_SECMEC_AND_SECCHKCD: {
                this.readSecMecAndSECCHKCD();
                break;
            }
            case READ_BYTES: {
                ProtocolTest.assertTrue((String)"Mismatch between the byte arrays", (boolean)Arrays.equals(this.getBytes(streamTokenizer), this.adapter.rReadBytes()));
                break;
            }
            case READ_NETWORK_SHORT: {
                int n = this.adapter.rReadNetworkShort();
                this.checkIntOrCP(streamTokenizer, n);
                break;
            }
            case FLUSH: {
                this.adapter.wFlush();
                break;
            }
            case DISPLAY: {
                ProtocolTest.println(this.getString(streamTokenizer));
                break;
            }
            case CHECKERROR: {
                this.checkError(streamTokenizer);
                break;
            }
            case CHECK_SQLCARD: {
                this.checkSQLCARD(this.getInt(streamTokenizer), this.getString(streamTokenizer));
                break;
            }
            case END_TEST: {
                ProtocolTest.println(this.getName() + " :: FINISHED");
                return true;
            }
            case SKIP_BYTES: {
                this.adapter.rSkipBytes();
                break;
            }
            case SWITCH_TO_UTF8_CCSID_MANAGER: {
                this.adapter.setUtf8Ccsid();
                break;
            }
            case DELETE_DATABASE: {
                this.deleteDatabase(this.getString(streamTokenizer));
                break;
            }
            default: {
                ProtocolTest.fail((String)("Command in line " + this.ln(streamTokenizer) + " not implemented: " + protocolTestGrammar.toString()));
            }
        }
        return false;
    }

    private int getInt(StreamTokenizer streamTokenizer) throws IOException {
        int n = 1;
        int n2 = streamTokenizer.nextToken();
        if (streamTokenizer.sval != null && streamTokenizer.sval.equals("-")) {
            n = -1;
            n2 = streamTokenizer.nextToken();
        }
        if (n2 != -2) {
            ProtocolTest.assertNotNull((String)("Invalid string on line " + this.ln(streamTokenizer)), (Object)streamTokenizer.sval);
            String string = streamTokenizer.sval.toLowerCase(Locale.ENGLISH);
            if (!string.startsWith("0x")) {
                ProtocolTest.fail((String)("Expecting number, got " + streamTokenizer.sval + " on line " + this.ln(streamTokenizer)));
            } else {
                return this.convertHex(string, this.ln(streamTokenizer));
            }
        }
        return Double.valueOf(streamTokenizer.nval).intValue() * n;
    }

    private int convertHex(String string, int n) throws IOException {
        int n2 = 0;
        int n3 = string.length();
        if (n3 % 2 == 1 || n3 > 10) {
            ProtocolTest.fail((String)("Invalid length for byte string, " + n3 + " on line " + n));
        }
        for (int i = 2; i < n3; ++i) {
            n2 <<= 4;
            n2 += Byte.valueOf(string.substring(i, i + 1), 16).byteValue();
        }
        return n2;
    }

    private boolean checkIntOrCP(StreamTokenizer streamTokenizer, int n) throws IOException {
        boolean bl = false;
        int n2 = streamTokenizer.nextToken();
        Object object = " ";
        if (n2 == -3 && streamTokenizer.sval.trim().equals(MULTIVAL_START)) {
            do {
                int n3 = this.getIntOrCP(streamTokenizer);
                object = (String)object + n3 + " ";
                bl = bl || n == n3;
                streamTokenizer.nextToken();
            } while (streamTokenizer.sval.trim().equals(MULTIVAL_SEP));
            if (!streamTokenizer.sval.trim().equals(MULTIVAL_END)) {
                ProtocolTest.fail((String)("Invalid test file format, requires MULTIVALEND, got: " + streamTokenizer.sval));
            }
        } else {
            streamTokenizer.pushBack();
            int n4 = this.getIntOrCP(streamTokenizer);
            object = " " + n4;
            bl = n == n4;
        }
        ProtocolTest.assertTrue((String)("Expected '" + (String)object + "', got '" + n + "'"), (boolean)bl);
        return bl;
    }

    private int getIntOrCP(StreamTokenizer streamTokenizer) throws IOException {
        int n = streamTokenizer.nextToken();
        if (n == -2) {
            return Double.valueOf(streamTokenizer.nval).intValue();
        }
        if (n == -3) {
            return this.decodeCP(streamTokenizer.sval, this.ln(streamTokenizer));
        }
        ProtocolTest.fail((String)("Expecting number, got '" + streamTokenizer.sval + "' on line " + this.ln(streamTokenizer)));
        return 0;
    }

    private byte[] getBytes(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        ProtocolTest.assertNotNull((String)("Missing input on line " + this.ln(streamTokenizer)), (Object)streamTokenizer.sval);
        String string = streamTokenizer.sval.toLowerCase(Locale.ENGLISH);
        if (!string.startsWith("0x")) {
            return this.getEBCDIC(string);
        }
        int n = string.length();
        if (n % 2 == 1) {
            ProtocolTest.fail((String)("Invalid length for byte string, " + n + " on line " + this.ln(streamTokenizer)));
        }
        byte[] byArray = new byte[(n - 2) / 2];
        int n2 = 0;
        for (int i = 2; i < n; i += 2) {
            byArray[n2] = (byte)(Byte.valueOf(string.substring(i, i + 1), 16) << 4);
            int n3 = n2++;
            byArray[n3] = (byte)(byArray[n3] + Byte.valueOf(string.substring(i + 1, i + 2), 16));
        }
        return byArray;
    }

    private String getString(StreamTokenizer streamTokenizer) throws IOException {
        int n = streamTokenizer.nextToken();
        ProtocolTest.assertTrue((String)("Expected string, got number '" + streamTokenizer.nval + "' on line " + this.ln(streamTokenizer)), (n != -2 ? 1 : 0) != 0);
        if (streamTokenizer.sval.contains(UTF8_TEST_MATCH)) {
            return streamTokenizer.sval.replace(UTF8_TEST_MATCH, UTF8_TEST_STRING);
        }
        return streamTokenizer.sval;
    }

    private int getCP(StreamTokenizer streamTokenizer) throws IOException {
        String string = this.getString(streamTokenizer);
        return this.decodeCP(string, this.ln(streamTokenizer));
    }

    private int decodeCP(String string, int n) {
        Integer n2 = this.adapter.decodeCodePoint(string);
        ProtocolTest.assertNotNull((String)("Unknown codepoint '" + string + "' in line " + n), (Object)n2);
        return n2;
    }

    private void checkError(StreamTokenizer streamTokenizer) throws IOException {
        int n = 0;
        int n2 = 0;
        byte by = 0;
        byte by2 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        this.adapter.rReadReplyDss();
        int n3 = this.adapter.rReadLengthAndCodePoint(false);
        int n4 = this.getCP(streamTokenizer);
        this.assertCP(n4, n3);
        block7: while (this.adapter.rMoreDssData()) {
            int n5 = this.adapter.rReadLengthAndCodePoint(false);
            switch (n5) {
                case 4425: {
                    n = this.adapter.rReadNetworkShort();
                    continue block7;
                }
                case 12: {
                    n2 = this.adapter.rReadNetworkShort();
                    continue block7;
                }
                case 4415: {
                    by = this.adapter.rReadByte();
                    continue block7;
                }
                case 4426: {
                    by2 = this.adapter.rReadByte();
                    continue block7;
                }
                case 5124: {
                    while (this.adapter.rMoreDdmData()) {
                        arrayList.add(this.adapter.rReadNetworkShort());
                        arrayList2.add(this.adapter.rReadNetworkShort());
                    }
                    continue block7;
                }
            }
            this.adapter.rSkipBytes();
            ProtocolTest.println("Skipped bytes for codepoint " + n5 + " (" + this.adapter.lookupCodePoint(n5) + ")");
        }
        int n6 = this.getInt(streamTokenizer);
        ProtocolTest.assertEquals((String)("Wrong svrcod (0x" + Integer.toHexString(n6) + " != 0x" + Integer.toHexString(n) + ")"), (int)n6, (int)n);
        if (n3 == 4677) {
            n6 = this.getInt(streamTokenizer);
            ProtocolTest.assertEquals((String)("Wrong prccnvcd (0x" + Integer.toHexString(n6) + " != 0x" + Integer.toHexString(by) + ")"), (int)n6, (int)by);
        }
        if (n3 == 4684) {
            n6 = this.getInt(streamTokenizer);
            ProtocolTest.assertEquals((String)("Wrong synerrcd (0x" + Integer.toHexString(n6) + " != 0x" + Integer.toHexString(by2) + ")"), (int)n6, (int)by2);
            n6 = this.getIntOrCP(streamTokenizer);
            this.assertCP(n6, n2);
        }
        if (n3 == 4624) {
            for (int i = 0; i < arrayList.size(); ++i) {
                n6 = this.getCP(streamTokenizer);
                int n7 = (Integer)arrayList.get(i);
                this.assertCP(n6, n7);
                int n8 = (Integer)arrayList2.get(i);
                n6 = this.getInt(streamTokenizer);
                ProtocolTest.assertEquals((String)("Wrong manager level (0x" + Integer.toHexString(n6) + " != 0x" + Integer.toHexString(n8) + ")"), (int)n6, (int)n8);
            }
        }
    }

    private void readLengthAndCodePoint(StreamTokenizer streamTokenizer) throws IOException {
        int n = this.adapter.rReadLengthAndCodePoint(false);
        int n2 = this.getCP(streamTokenizer);
        this.assertCP(n2, n);
    }

    private void readSecMecAndSECCHKCD() throws IOException {
        boolean bl = true;
        do {
            int n = this.adapter.rReadLengthAndCodePoint(false);
            switch (n) {
                case 4514: {
                    int n2 = this.adapter.rReadNetworkShort();
                    ProtocolTest.println("SECMEC=" + n2);
                    break;
                }
                case 4516: {
                    int n2 = this.adapter.rReadByte();
                    ProtocolTest.println("SECCHKCD=" + n2);
                    bl = false;
                    break;
                }
                default: {
                    bl = false;
                }
            }
        } while (bl);
    }

    private void assertCP(int n, int n2) {
        String string = this.adapter.lookupCodePoint(n2);
        String string2 = this.adapter.lookupCodePoint(n);
        ProtocolTest.assertEquals((String)("Wrong codepoint (0x" + Integer.toHexString(n) + "/" + string2 + " != 0x" + Integer.toHexString(n2) + "/" + string + ")"), (int)n, (int)n2);
    }

    private byte[] getEBCDIC(String string) {
        return this.adapter.convertFromJavaString(string);
    }

    private void writeEncodedString(String string, String string2) {
        try {
            byte[] byArray = string.getBytes(string2);
            this.adapter.wWriteBytes(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ProtocolTest.fail("Unsupported encoding " + string2, unsupportedEncodingException);
        }
    }

    private void writeEncodedLDString(String string, String string2, int n) {
        try {
            byte[] byArray = string.getBytes(string2);
            if (n == 2) {
                this.adapter.wWriteShort(byArray.length);
            } else {
                this.adapter.wWriteInt(byArray.length);
            }
            this.adapter.wWriteBytes(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ProtocolTest.fail("Unsupported encoding " + string2, unsupportedEncodingException);
        }
    }

    private void checkSQLCARD(int n, String string) throws IOException {
        this.adapter.rReadReplyDss();
        int n2 = this.adapter.rReadLengthAndCodePoint(false);
        ProtocolTest.assertEquals((String)("Expected SQLCARD (0x2408), got " + Integer.toHexString(n2)), (int)9224, (int)n2);
        this.adapter.rReadByte();
        int n3 = this.adapter.rReadNetworkInt();
        ProtocolTest.assertEquals((String)("Expected " + Integer.toHexString(n) + ", got " + Integer.toHexString(n3)), (int)n, (int)n3);
        String string2 = this.adapter.rReadString(5, "UTF-8");
        ProtocolTest.assertEquals((String)"Wrong SQL state", (String)string, (String)string2);
        this.adapter.rSkipBytes();
    }

    private int ln(StreamTokenizer streamTokenizer) {
        return this.startLine + streamTokenizer.lineno() - 1;
    }

    private void deleteDatabase(String string) {
        String string2 = "jdbc:derby:" + string + ";shutdown=true";
        try {
            DriverManager.getConnection(string2);
        }
        catch (SQLException sQLException) {
            BaseJDBCTestCase.assertSQLState("08006", sQLException);
        }
        ProtocolTest.removeDirectory(ProtocolTest.getSystemProperty("derby.system.home") + File.separator + string);
    }

    public static Test suite() throws Exception {
        String string;
        BaseTestSuite baseTestSuite = new BaseTestSuite("Derby DRDA protocol tests");
        URL uRL = BaseTestCase.getTestResource("org/apache/derbyTesting/functionTests/tests/derbynet/protocol.tests");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(ProtocolTest.openTestResource(uRL), Charset.forName("UTF-8")));
        String string2 = ProtocolTestGrammar.END_TEST.toCmdString();
        int n = 1;
        int n2 = 1;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        while ((string = bufferedReader.readLine()) != null) {
            arrayList.add(string);
            stringBuilder.append(string).append(NL);
            if (string.toLowerCase(Locale.ENGLISH).startsWith(string2)) {
                baseTestSuite.addTest((Test)new ProtocolTest("protocol.tests", stringBuilder.toString(), n2, n - n2));
                arrayList.clear();
                stringBuilder.setLength(0);
                n2 = n + 1;
            }
            ++n;
        }
        bufferedReader.close();
        return new SecurityManagerSetup(TestConfiguration.clientServerDecorator((Test)new SupportFilesSetup((Test)baseTestSuite, new String[]{"functionTests/tests/derbynet/connect.inc", "functionTests/tests/derbynet/excsat_accsecrd1.inc", "functionTests/tests/derbynet/excsat_accsecrd2.inc", "functionTests/tests/derbynet/excsat_accsecrd_nordb.inc", "functionTests/tests/derbynet/excsat_secchk_nordbonaccsec.inc", "functionTests/tests/derbynet/excsat_secchk.inc", "functionTests/tests/derbynet/values1.inc", "functionTests/tests/derbynet/values64kblksz.inc"})), "org/apache/derbyTesting/functionTests/tests/derbynet/ProtocolTest.policy", true);
    }
}

