/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class OSReadOnlyTest
extends BaseJDBCTestCase {
    public OSReadOnlyTest(String string) {
        super(string);
    }

    private static Test newCleanDatabase(BaseTestSuite baseTestSuite) {
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                this.getConnection();
                statement.executeUpdate("CREATE TABLE foo (a int, b char(100))");
                statement.execute("insert into foo values (1, 'hello world')");
                statement.execute("insert into foo values (2, 'happy world')");
                statement.execute("insert into foo values (3, 'sad world')");
                statement.execute("insert into foo values (4, 'crazy world')");
                for (int i = 0; i < 7; ++i) {
                    statement.execute("insert into foo select * from foo");
                }
                statement.execute("create index fooi on foo(a, b)");
            }
        };
    }

    protected static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("OSReadOnly");
        BaseTestSuite baseTestSuite2 = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(OSReadOnlyTest.class);
        baseTestSuite2.addTest((Test)TestConfiguration.singleUseDatabaseDecorator(OSReadOnlyTest.newCleanDatabase(baseTestSuite)));
        return baseTestSuite2;
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("OSReadOnlyTest");
        baseTestSuite.addTest(OSReadOnlyTest.baseSuite("OSReadOnlyTest:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(OSReadOnlyTest.baseSuite("OSReadOnlyTest:client")));
        return baseTestSuite;
    }

    public void testOSReadOnly() throws Exception {
        if (!this.supportsSetReadOnly()) {
            OSReadOnlyTest.alarm("Read-only files can be modified. Skipping OSReadOnlyTest.");
            return;
        }
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        JDBC.assertFullResultSet(statement.executeQuery("select count(*) from foo"), new String[][]{{"512"}});
        statement.executeUpdate("delete from foo where a = 1");
        JDBC.assertFullResultSet(statement.executeQuery("select count(*) from foo"), new String[][]{{"384"}});
        this.rollback();
        JDBC.assertFullResultSet(statement.executeQuery("select count(*) from foo"), new String[][]{{"512"}});
        statement.executeUpdate("insert into foo select * from foo where a = 1");
        JDBC.assertFullResultSet(statement.executeQuery("select count(*) from foo"), new String[][]{{"640"}});
        this.commit();
        statement.executeUpdate("delete from foo where a = 1");
        JDBC.assertFullResultSet(statement.executeQuery("select count(*) from foo"), new String[][]{{"384"}});
        this.rollback();
        JDBC.assertFullResultSet(statement.executeQuery("select count(*) from foo"), new String[][]{{"640"}});
        this.setAutoCommit(false);
        TestConfiguration.getCurrent().shutdownDatabase();
        String string = this.getPhysicalDbName();
        this.moveDatabaseOnOS(string, "readOnly");
        this.changeFilePermissions("readOnly");
        this.createDummyLockFile("readOnly");
        DataSource dataSource = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(dataSource, "databaseName", "singleUse/readOnly");
        this.assertReadDB(dataSource);
        this.assertExpectedInsertBehaviour(dataSource, false, 10, "will fail");
        this.shutdownDB(dataSource);
        this.moveDatabaseOnOS("readOnly", "readWrite");
        dataSource = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(dataSource, "databaseName", "singleUse/readWrite");
        this.assertReadDB(dataSource);
        this.assertExpectedInsertBehaviour(dataSource, true, 20, "will go in");
        this.shutdownDB(dataSource);
        this.moveDatabaseOnOS("readWrite", "readOnly2");
        this.changeFilePermissions("readOnly2");
        this.createDummyLockFile("readOnly2");
        dataSource = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(dataSource, "databaseName", "singleUse/readOnly2");
        this.assertReadDB(dataSource);
        this.assertExpectedInsertBehaviour(dataSource, false, 30, "will also fail");
        this.shutdownDB(dataSource);
        this.moveDatabaseOnOS("readOnly2", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean supportsSetReadOnly() throws IOException {
        File file = PrivilegedFileOpsForTests.createTempFile("tmp", null, OSReadOnlyTest.currentDirectory());
        PrivilegedFileOpsForTests.setReadOnly(file);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = PrivilegedFileOpsForTests.getFileOutputStream(file);
            boolean bl = false;
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            boolean bl = true;
            return bl;
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            PrivilegedFileOpsForTests.delete(file);
        }
    }

    private String getPhysicalDbName() {
        String string = TestConfiguration.getCurrent().getJDBCUrl();
        return string.substring(string.lastIndexOf("oneuse"));
    }

    private void shutdownDB(DataSource dataSource) throws SQLException {
        JDBCDataSource.setBeanProperty(dataSource, "ConnectionAttributes", "shutdown=true");
        try {
            dataSource.getConnection();
            OSReadOnlyTest.fail((String)"expected an sqlexception 08006");
        }
        catch (SQLException sQLException) {
            OSReadOnlyTest.assertSQLState("08006", sQLException);
        }
    }

    private void assertReadDB(DataSource dataSource) throws SQLException {
        Connection connection = dataSource.getConnection();
        Statement statement = connection.createStatement();
        JDBC.assertFullResultSet(statement.executeQuery("select count(*) from foo where a=1"), new String[][]{{"256"}});
        JDBC.assertFullResultSet(statement.executeQuery("select count(*) from foo where a=2"), new String[][]{{"128"}});
        JDBC.assertFullResultSet(statement.executeQuery("select count(*) from foo where a=1 and b='hello world'"), new String[][]{{"256"}});
        statement.close();
        connection.close();
    }

    private void assertExpectedInsertBehaviour(DataSource dataSource, boolean bl, int n, String string) throws SQLException {
        Statement statement;
        Connection connection;
        block4: {
            connection = dataSource.getConnection();
            statement = connection.createStatement();
            if (bl) {
                statement.executeUpdate("insert into foo values (" + n + ", '" + string + "')");
                OSReadOnlyTest.assertTrue((statement.getUpdateCount() == 1 ? 1 : 0) != 0);
                JDBC.assertFullResultSet(statement.executeQuery("select count(*) from foo where a=" + n), new String[][]{{"1"}});
            } else {
                try {
                    statement.executeUpdate("insert into foo values (" + n + ", '" + string + "')");
                    OSReadOnlyTest.fail((String)"expected an error indicating the db is readonly");
                }
                catch (SQLException sQLException) {
                    if (sQLException.getSQLState().equals("25502") || sQLException.getSQLState().equals("40XD1")) break block4;
                    OSReadOnlyTest.fail((String)("unexpected sqlstate; expected 25502 or 40XD1, got: " + sQLException.getSQLState()));
                }
            }
        }
        statement.close();
        connection.close();
    }

    private void moveDatabaseOnOS(String string, String string2) throws IOException {
        File file = this.constructDbPath(string);
        File file2 = this.constructDbPath(string2);
        PrivilegedFileOpsForTests.copy(file, file2);
        OSReadOnlyTest.assertDirectoryDeleted(file);
    }

    private void createDummyLockFile(String string) {
        final File file = new File(this.constructDbPath(string), "db.lck");
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (!file.exists()) {
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        fileOutputStream.write(12);
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                file.setReadOnly();
                return null;
            }
        });
    }

    public void changeFilePermissions(String string) {
        File file = this.constructDbPath(string);
        OSReadOnlyTest.assertTrue((String)("Failed to change files in " + file + " to ReadOnly"), (boolean)OSReadOnlyTest.changeDirectoryToReadOnly(file));
    }

    private File constructDbPath(String string) {
        File file = new File(OSReadOnlyTest.getSystemProperty("user.dir"), "system");
        file = new File(file, "singleUse");
        return new File(file, string);
    }

    public static boolean changeDirectoryToReadOnly(File file) {
        if (null == file) {
            return false;
        }
        final File file2 = file;
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                String[] stringArray;
                boolean bl = true;
                if (!file2.isDirectory()) {
                    bl = false;
                }
                if ((stringArray = file2.list()) != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        File file = new File(file2, stringArray[i]);
                        if (file.isDirectory()) {
                            if (OSReadOnlyTest.changeDirectoryToReadOnly(file)) continue;
                            bl = false;
                            continue;
                        }
                        if (file.setReadOnly()) continue;
                        bl = false;
                    }
                }
                return bl;
            }
        });
    }
}

