/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.tools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ConnectWrongSubprotocolTest
extends BaseJDBCTestCase {
    public ConnectWrongSubprotocolTest(String string) {
        super(string);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new BaseTestSuite("empty: no support for Driver.sql.Manager with jsr 169");
        }
        if (!Derby.hasTools()) {
            return new BaseTestSuite("empty: no tools support");
        }
        Properties properties = new Properties();
        properties.setProperty("ij.connection.wrongSubprotocol", "jdbc:noone:fruitfly;create=true");
        Test test = TestConfiguration.embeddedSuite(ConnectWrongSubprotocolTest.class);
        return new SystemPropertyTestSetup(test, properties);
    }

    public void testConnectWrongSubprotocolWithSystemProperty() throws UnsupportedEncodingException, SQLException {
        String string = "";
        boolean bl = true;
        this.checkConnectWrongSubprotocol(string, bl);
    }

    public void testConnectWrongSubprotoctestolWithoutSystemProperty() throws UnsupportedEncodingException, SQLException {
        String string = "connect 'jdbc:noone:fruitfly;create=true';";
        boolean bl = false;
        this.checkConnectWrongSubprotocol(string, bl);
    }

    private void checkConnectWrongSubprotocol(String string, boolean bl) throws UnsupportedEncodingException, SQLException {
        String string2 = this.runIjScript(string, bl);
        ConnectWrongSubprotocolTest.assertTrue((string2.indexOf("08001") > -1 ? 1 : 0) != 0);
        ConnectWrongSubprotocolTest.assertTrue((string2.indexOf("No suitable driver") > -1 ? 1 : 0) != 0);
    }

    private String runIjScript(String string, boolean bl) throws UnsupportedEncodingException, SQLException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("US-ASCII"));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10240);
        Connection connection = this.getConnection();
        ij.runScript((Connection)connection, (InputStream)byteArrayInputStream, (String)"US-ASCII", (OutputStream)byteArrayOutputStream, (String)"US-ASCII", (boolean)bl);
        if (!connection.isClosed() && !connection.getAutoCommit()) {
            connection.commit();
        }
        return new String(byteArrayOutputStream.toByteArray(), "US-ASCII");
    }
}

