/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.derby.iapi.services.io.LimitInputStream;
import org.apache.derby.impl.load.ImportFileInputStream;
import org.apache.derby.shared.common.error.PublicAPI;
import org.apache.derby.shared.common.error.StandardException;

class ImportLobFile {
    private ImportFileInputStream lobInputStream = null;
    private LimitInputStream lobLimitIn;
    private Reader lobReader = null;
    private String dataCodeset;

    ImportLobFile(File lobFile, String dataCodeset) throws Exception {
        this.dataCodeset = dataCodeset;
        this.openLobFile(lobFile);
    }

    private void openLobFile(final File lobFile) throws Exception {
        RandomAccessFile lobRaf;
        try {
            try {
                lobRaf = AccessController.doPrivileged(new PrivilegedExceptionAction<RandomAccessFile>(){

                    @Override
                    public RandomAccessFile run() throws IOException {
                        return new RandomAccessFile(lobFile, "r");
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }
        catch (FileNotFoundException ex) {
            throw PublicAPI.wrapStandardException(StandardException.newException("XIE0P.S", lobFile.getPath()));
        }
        this.lobInputStream = new ImportFileInputStream(lobRaf);
        this.lobLimitIn = new LimitInputStream(this.lobInputStream);
    }

    public InputStream getBinaryStream(long offset, long length) throws IOException {
        this.lobInputStream.seek(offset);
        this.lobLimitIn.clearLimit();
        this.lobLimitIn.setLimit((int)length);
        return this.lobLimitIn;
    }

    public String getString(long offset, int length) throws IOException {
        this.lobInputStream.seek(offset);
        this.lobLimitIn.clearLimit();
        this.lobLimitIn.setLimit(length);
        this.lobReader = this.dataCodeset == null ? new InputStreamReader(this.lobLimitIn) : new InputStreamReader((InputStream)this.lobLimitIn, this.dataCodeset);
        StringBuffer sb = new StringBuffer();
        char[] buf = new char[1024];
        int noChars = this.lobReader.read(buf, 0, 1024);
        while (noChars != -1) {
            sb.append(buf, 0, noChars);
            noChars = this.lobReader.read(buf, 0, 1024);
        }
        return sb.toString();
    }

    public Reader getCharacterStream(long offset, long length) throws IOException {
        this.lobInputStream.seek(offset);
        this.lobLimitIn.clearLimit();
        this.lobLimitIn.setLimit((int)length);
        this.lobReader = this.dataCodeset == null ? new InputStreamReader(this.lobLimitIn) : new InputStreamReader((InputStream)this.lobLimitIn, this.dataCodeset);
        return this.lobReader;
    }

    public long getClobDataLength(long offset, long length) throws IOException {
        this.lobInputStream.seek(offset);
        this.lobLimitIn.clearLimit();
        this.lobLimitIn.setLimit((int)length);
        this.lobReader = this.dataCodeset == null ? new InputStreamReader(this.lobLimitIn) : new InputStreamReader((InputStream)this.lobLimitIn, this.dataCodeset);
        char[] buf = new char[1024];
        long lengthInChars = 0L;
        int noChars = this.lobReader.read(buf, 0, 1024);
        while (noChars != -1) {
            lengthInChars += (long)noChars;
            noChars = this.lobReader.read(buf, 0, 1024);
        }
        return lengthInChars;
    }

    public void close() throws IOException {
        if (this.lobReader != null) {
            this.lobReader.close();
        } else if (this.lobLimitIn != null) {
            this.lobLimitIn.close();
        } else if (this.lobInputStream != null) {
            this.lobInputStream.close();
        }
    }
}

