/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.services.io.FormatableIntHolder;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.ExpressionClassBuilderInterface;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.BaseJoinStrategy;
import org.apache.derby.impl.sql.compile.BaseTableNumbersVisitor;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derby.shared.common.util.ArrayUtil;

class HashJoinStrategy
extends BaseJoinStrategy {
    HashJoinStrategy() {
    }

    @Override
    public boolean feasible(Optimizable innerTable, OptimizablePredicateList predList, Optimizer optimizer) throws StandardException {
        ConglomerateDescriptor cd = null;
        if (!innerTable.isMaterializable()) {
            if (innerTable.optimizerTracingIsOn()) {
                innerTable.getOptimizerTracer().traceSkipUnmaterializableHashJoin();
            }
            return false;
        }
        if (innerTable.isTargetTable()) {
            return false;
        }
        if (predList != null && predList.size() > 0 && !(innerTable instanceof FromBaseTable)) {
            FromTable ft = (FromTable)innerTable;
            JBitSet tNums = new JBitSet(ft.getReferencedTableMap().size());
            BaseTableNumbersVisitor btnVis = new BaseTableNumbersVisitor(tNums);
            ft.accept(btnVis);
            JBitSet pNums = new JBitSet(tNums.size());
            for (int i = 0; i < predList.size(); ++i) {
                Predicate pred = (Predicate)predList.getOptPredicate(i);
                if (!pred.isJoinPredicate()) continue;
                pNums.or(pred.getReferencedSet());
            }
            tNums.and(pNums);
            if (tNums.getFirstSetBit() != -1) {
                return false;
            }
        }
        if (innerTable.isBaseTable()) {
            cd = innerTable.getCurrentAccessPath().getConglomerateDescriptor();
        }
        int[] hashKeyColumns = this.findHashKeyColumns(innerTable, cd, predList);
        if (innerTable.optimizerTracingIsOn()) {
            if (hashKeyColumns == null) {
                innerTable.getOptimizerTracer().traceSkipHashJoinNoHashKeys();
            } else {
                innerTable.getOptimizerTracer().traceHashKeyColumns(ArrayUtil.copy(hashKeyColumns));
            }
        }
        return hashKeyColumns != null;
    }

    @Override
    public boolean ignoreBulkFetch() {
        return true;
    }

    @Override
    public boolean multiplyBaseCostByOuterRows() {
        return false;
    }

    @Override
    public OptimizablePredicateList getBasePredicates(OptimizablePredicateList predList, OptimizablePredicateList basePredicates, Optimizable innerTable) throws StandardException {
        SanityManager.ASSERT(basePredicates.size() == 0, "The base predicate list should be empty.");
        for (int i = predList.size() - 1; i >= 0; --i) {
            OptimizablePredicate pred = predList.getOptPredicate(i);
            if (!innerTable.getReferencedTableMap().contains(pred.getReferencedMap())) continue;
            basePredicates.addOptPredicate(pred);
            predList.removeOptPredicate(i);
        }
        basePredicates.classify(innerTable, innerTable.getCurrentAccessPath().getConglomerateDescriptor());
        return basePredicates;
    }

    @Override
    public double nonBasePredicateSelectivity(Optimizable innerTable, OptimizablePredicateList predList) throws StandardException {
        double retval = 1.0;
        if (predList != null) {
            for (int i = 0; i < predList.size(); ++i) {
                if (predList.isRedundantPredicate(i)) continue;
                retval *= predList.getOptPredicate(i).selectivity(innerTable);
            }
        }
        return retval;
    }

    @Override
    public void putBasePredicates(OptimizablePredicateList predList, OptimizablePredicateList basePredicates) throws StandardException {
        for (int i = basePredicates.size() - 1; i >= 0; --i) {
            OptimizablePredicate pred = basePredicates.getOptPredicate(i);
            predList.addOptPredicate(pred);
            basePredicates.removeOptPredicate(i);
        }
    }

    @Override
    public void estimateCost(Optimizable innerTable, OptimizablePredicateList predList, ConglomerateDescriptor cd, CostEstimate outerCost, Optimizer optimizer, CostEstimate costEstimate) {
    }

    @Override
    public int maxCapacity(int userSpecifiedCapacity, int maxMemoryPerTable, double perRowUsage) {
        if (userSpecifiedCapacity >= 0) {
            return userSpecifiedCapacity;
        }
        if ((perRowUsage += (double)ClassSize.estimateHashEntrySize()) <= 1.0) {
            return maxMemoryPerTable;
        }
        return (int)((double)maxMemoryPerTable / perRowUsage);
    }

    @Override
    public String getName() {
        return "HASH";
    }

    @Override
    public int scanCostType() {
        return 1;
    }

    @Override
    public String getOperatorSymbol() {
        return "#";
    }

    @Override
    public String resultSetMethodName(boolean bulkFetch, boolean multiprobe, boolean validatingCheckConstraint) {
        return "getHashScanResultSet";
    }

    @Override
    public String joinResultSetMethodName() {
        return "getHashJoinResultSet";
    }

    @Override
    public String halfOuterJoinResultSetMethodName() {
        return "getHashLeftOuterJoinResultSet";
    }

    @Override
    public int getScanArgs(TransactionController tc, MethodBuilder mb, Optimizable innerTable, OptimizablePredicateList storeRestrictionList, OptimizablePredicateList nonStoreRestrictionList, ExpressionClassBuilderInterface acbi, int bulkFetch, int resultRowTemplate, int colRefItem, int indexColItem, int lockMode, boolean tableLocked, int isolationLevel, int maxMemoryPerTable, boolean genInListVals) throws StandardException {
        for (int i = storeRestrictionList.size() - 1; i >= 0; --i) {
            Predicate pred = (Predicate)storeRestrictionList.getOptPredicate(i);
            if (!pred.isInListProbePredicate()) continue;
            SanityManager.THROWASSERT("Found IN-list probing (" + pred.binaryRelOpColRefsToString() + ") while generating HASH join, which should not happen.");
        }
        ExpressionClassBuilder acb = (ExpressionClassBuilder)acbi;
        this.fillInScanArgs1(tc, mb, innerTable, storeRestrictionList, acb, resultRowTemplate);
        nonStoreRestrictionList.generateQualifiers(acb, mb, innerTable, true);
        mb.push(innerTable.initialCapacity());
        mb.push(innerTable.loadFactor());
        mb.push(innerTable.maxCapacity(this, maxMemoryPerTable));
        int[] hashKeyColumns = innerTable.hashKeyColumns();
        Object[] fihArray = FormatableIntHolder.getFormatableIntHolders(hashKeyColumns);
        FormatableArrayHolder hashKeyHolder = new FormatableArrayHolder(fihArray);
        int hashKeyItem = acb.addItem(hashKeyHolder);
        mb.push(hashKeyItem);
        this.fillInScanArgs2(mb, innerTable, bulkFetch, colRefItem, indexColItem, lockMode, tableLocked, isolationLevel);
        return 28;
    }

    @Override
    public void divideUpPredicateLists(Optimizable innerTable, OptimizablePredicateList originalRestrictionList, OptimizablePredicateList storeRestrictionList, OptimizablePredicateList nonStoreRestrictionList, OptimizablePredicateList requalificationRestrictionList, DataDictionary dd) throws StandardException {
        int index;
        int[] hashKeyColumns;
        ProjectRestrictNode prn;
        Predicate p1;
        int i;
        originalRestrictionList.copyPredicatesToOtherList(requalificationRestrictionList);
        ConglomerateDescriptor cd = innerTable.getTrulyTheBestAccessPath().getConglomerateDescriptor();
        originalRestrictionList.transferPredicates(storeRestrictionList, innerTable.getReferencedTableMap(), innerTable);
        for (i = storeRestrictionList.size() - 1; i >= 0; --i) {
            p1 = (Predicate)storeRestrictionList.getOptPredicate(i);
            if (p1.isStoreQualifier() || p1.isStartKey() || p1.isStopKey()) continue;
            storeRestrictionList.removeOptPredicate(i);
        }
        for (i = originalRestrictionList.size() - 1; i >= 0; --i) {
            p1 = (Predicate)originalRestrictionList.getOptPredicate(i);
            if (p1.isStoreQualifier()) continue;
            originalRestrictionList.removeOptPredicate(i);
        }
        originalRestrictionList.copyPredicatesToOtherList(nonStoreRestrictionList);
        Optimizable hashTableFor = innerTable;
        if (innerTable instanceof ProjectRestrictNode && (prn = (ProjectRestrictNode)innerTable).getChildResult() instanceof Optimizable) {
            hashTableFor = (Optimizable)((Object)prn.getChildResult());
        }
        if ((hashKeyColumns = this.findHashKeyColumns(hashTableFor, cd, nonStoreRestrictionList)) == null) {
            String name = cd != null && cd.isIndex() ? cd.getConglomerateName() : innerTable.getBaseTableName();
            throw StandardException.newException("42Y63", name, innerTable.getBaseTableName());
        }
        innerTable.setHashKeyColumns(hashKeyColumns);
        nonStoreRestrictionList.markAllPredicatesQualifiers();
        int[] conglomColumn = new int[hashKeyColumns.length];
        if (cd != null && cd.isIndex()) {
            for (index = 0; index < hashKeyColumns.length; ++index) {
                conglomColumn[index] = cd.getIndexDescriptor().baseColumnPositions()[hashKeyColumns[index]];
            }
        } else {
            for (index = 0; index < hashKeyColumns.length; ++index) {
                conglomColumn[index] = hashKeyColumns[index] + 1;
            }
        }
        for (index = hashKeyColumns.length - 1; index >= 0; --index) {
            nonStoreRestrictionList.putOptimizableEqualityPredicateFirst(innerTable, conglomColumn[index]);
        }
    }

    @Override
    public boolean isHashJoin() {
        return true;
    }

    @Override
    public boolean doesMaterialization() {
        return true;
    }

    private int[] findHashKeyColumns(Optimizable innerTable, ConglomerateDescriptor cd, OptimizablePredicateList predList) throws StandardException {
        int j;
        int[] columns;
        if (predList == null) {
            return null;
        }
        if (cd == null) {
            columns = new int[innerTable.getNumColumnsReturned()];
            for (j = 0; j < columns.length; ++j) {
                columns[j] = j + 1;
            }
        } else if (cd.isIndex()) {
            columns = cd.getIndexDescriptor().baseColumnPositions();
        } else {
            columns = new int[innerTable.getTableDescriptor().getNumberOfColumns()];
            for (j = 0; j < columns.length; ++j) {
                columns[j] = j + 1;
            }
        }
        ArrayList<Integer> hashKeys = new ArrayList<Integer>();
        for (int colCtr = 0; colCtr < columns.length; ++colCtr) {
            if (!predList.hasOptimizableEquijoin(innerTable, columns[colCtr])) continue;
            hashKeys.add(colCtr);
        }
        if (hashKeys.isEmpty()) {
            return null;
        }
        int[] keyCols = new int[hashKeys.size()];
        for (int index = 0; index < keyCols.length; ++index) {
            keyCols[index] = (Integer)hashKeys.get(index);
        }
        return keyCols;
    }

    public String toString() {
        return this.getName();
    }
}

