/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Decorator;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ClobUpdatableReaderTest
extends BaseJDBCTestCase {
    private final String dummy = "This is a new String";

    public ClobUpdatableReaderTest(String string) {
        super(string);
    }

    public void testUpdateableStoreReader() throws Exception {
        long l;
        this.getConnection().setAutoCommit(false);
        PreparedStatement preparedStatement = this.prepareStatement("insert into updateClob (id , data) values (? ,?)");
        preparedStatement.setInt(1, 2);
        StringBuffer stringBuffer = new StringBuffer();
        String string = "SampleSampleSample";
        for (int i = 0; i < 100000; ++i) {
            stringBuffer.append(string);
        }
        preparedStatement.setCharacterStream(2, (Reader)new StringReader(stringBuffer.toString()), stringBuffer.length());
        preparedStatement.execute();
        preparedStatement.close();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select data from updateClob where id = 2");
        resultSet.next();
        Clob clob = resultSet.getClob(1);
        resultSet.close();
        statement.close();
        ClobUpdatableReaderTest.assertEquals((long)stringBuffer.length(), (long)clob.length());
        Reader reader = clob.getCharacterStream();
        String string2 = "this is a new string";
        long l2 = reader.skip(100L);
        clob.setString(1001L, string2);
        for (long i = 1000L - l2; i > 0L; i -= l) {
            l = reader.skip(i);
        }
        char[] cArray = new char[string2.length()];
        int n = reader.read(cArray);
        ClobUpdatableReaderTest.assertEquals((String)"updated not reflected", (String)string2, (String)new String(cArray, 0, n));
        reader.close();
    }

    public void testUpdateableReader() throws Exception {
        this.getConnection().setAutoCommit(false);
        PreparedStatement preparedStatement = this.prepareStatement("insert into updateClob (id , data) values (? ,?)");
        preparedStatement.setInt(1, 1);
        StringBuffer stringBuffer = new StringBuffer();
        String string = "SampleSampleSample";
        for (int i = 0; i < 100; ++i) {
            stringBuffer.append(string);
        }
        preparedStatement.setCharacterStream(2, (Reader)new StringReader(stringBuffer.toString()), stringBuffer.length());
        preparedStatement.execute();
        preparedStatement.close();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select data from updateClob where id = 1");
        resultSet.next();
        Clob clob = resultSet.getClob(1);
        resultSet.close();
        statement.close();
        ClobUpdatableReaderTest.assertEquals((long)stringBuffer.length(), (long)clob.length());
        Reader reader = clob.getCharacterStream();
        char[] cArray = new char[stringBuffer.length()];
        reader.read(cArray);
        ClobUpdatableReaderTest.assertEquals((String)"mismatch from inserted string", (String)String.valueOf(cArray), (String)stringBuffer.toString());
        reader.close();
        clob.setString(50L, "This is a new String");
        reader = clob.getCharacterStream();
        reader.skip(49L);
        char[] cArray2 = new char["This is a new String".length()];
        reader.read(cArray2);
        ClobUpdatableReaderTest.assertEquals((String)"update not reflected", (String)"This is a new String", (String)String.valueOf(cArray2));
        clob.setString(75L, "This is a new String");
        reader.skip(25 - "This is a new String".length());
        char[] cArray3 = new char["This is a new String".length()];
        reader.read(cArray3);
        ClobUpdatableReaderTest.assertEquals((String)"update not reflected", (String)"This is a new String", (String)String.valueOf(cArray2));
        reader.close();
        String string2 = this.getUnicodeString();
        clob.setString(50L, string2);
        char[] cArray4 = new char[string2.length()];
        reader = clob.getCharacterStream();
        reader.skip(49L);
        reader.read(cArray4);
        ClobUpdatableReaderTest.assertEquals((String)"update not reflected", (String)string2, (String)String.valueOf(cArray4));
        reader.close();
        Writer writer = clob.setCharacterStream(1L);
        reader = clob.getCharacterStream();
        for (int i = 0; i < 10000; ++i) {
            writer.write("This is a new String");
        }
        writer.close();
        clob.setString(500L, string2);
        reader.skip(499L);
        char[] cArray5 = new char[string2.length()];
        reader.read(cArray5);
        ClobUpdatableReaderTest.assertEquals((String)"update not reflected", (String)string2, (String)String.valueOf(cArray5));
    }

    public void testMultiplexedOperationProblem() throws IOException, SQLException {
        this.getConnection().setAutoCommit(false);
        int n = 266000;
        PreparedStatement preparedStatement = this.prepareStatement("insert into updateClob (id, data) values (?,?)");
        preparedStatement.setInt(1, n);
        preparedStatement.setCharacterStream(2, (Reader)new LoopingAlphabetReader(n), n);
        ClobUpdatableReaderTest.assertEquals((int)1, (int)preparedStatement.executeUpdate());
        preparedStatement.close();
        PreparedStatement preparedStatement2 = this.prepareStatement("select data from updateClob where id = ?");
        preparedStatement2.setInt(1, n);
        ResultSet resultSet = preparedStatement2.executeQuery();
        ClobUpdatableReaderTest.assertTrue((String)("No Clob of length " + n + " in database"), (boolean)resultSet.next());
        Clob clob = resultSet.getClob(1);
        ClobUpdatableReaderTest.assertEquals((long)n, (long)clob.length());
        Reader reader = clob.getCharacterStream();
        int n2 = reader.read();
        n2 = this.assertCorrectChar(n2, reader.read());
        n2 = this.assertCorrectChar(n2, reader.read());
        ClobUpdatableReaderTest.assertEquals((long)n, (long)clob.length());
        for (int i = 2; i < 160000; ++i) {
            int n3 = reader.read();
            if (n3 == -1) {
                ClobUpdatableReaderTest.fail((String)("Failed at position " + i + ", stream should not be exhausted now"));
            }
            n2 = this.assertCorrectChar(n2, n3);
        }
        n2 = this.assertCorrectChar(n2, reader.read());
        n2 = this.assertCorrectChar(n2, reader.read());
        InputStream inputStream = clob.getAsciiStream();
        ClobUpdatableReaderTest.assertEquals((long)n, (long)clob.length());
        int n4 = inputStream.read();
        n4 = this.assertCorrectChar(n4, inputStream.read());
        n4 = this.assertCorrectChar(n4, inputStream.read());
        ClobUpdatableReaderTest.assertEquals((long)n, (long)clob.length());
        n4 = this.assertCorrectChar(n4, inputStream.read());
        n2 = this.assertCorrectChar(n2, reader.read());
        reader.close();
        inputStream.close();
        resultSet.close();
        preparedStatement2.close();
    }

    private int assertCorrectChar(int n, int n2) throws IOException {
        ClobUpdatableReaderTest.assertTrue((String)"Reached EOF unexpectedly", (n2 != -1 ? 1 : 0) != 0);
        if (n2 < 97 && n2 > 122) {
            ClobUpdatableReaderTest.fail((String)("Char out of range: " + n2));
        }
        if (n < 97 && n > 122) {
            ClobUpdatableReaderTest.fail((String)("Char out of range: " + n));
        }
        if (n > -1) {
            if (n == 122) {
                ClobUpdatableReaderTest.assertTrue((String)(n + " -> " + n2), (n2 == 97 ? 1 : 0) != 0);
            } else {
                ClobUpdatableReaderTest.assertTrue((String)(n + " -> " + n2), (n2 == n + 1 ? 1 : 0) != 0);
            }
        }
        return n2;
    }

    private String getUnicodeString() {
        char[] cArray = new char[]{'d', '\u03a9', '\u0e14', 'j'};
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            stringBuffer.append(cArray);
        }
        return stringBuffer.toString();
    }

    public void setUp() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("create table updateClob (id integer primary key, data clob)");
        statement.close();
        this.commit();
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ClobUpdatableReaderTest");
        baseTestSuite.addTest(TestConfiguration.defaultSuite(ClobUpdatableReaderTest.class));
        BaseTestSuite baseTestSuite2 = new BaseTestSuite("ClobUpdatableReaderTest:encrypted");
        baseTestSuite2.addTestSuite(ClobUpdatableReaderTest.class);
        baseTestSuite.addTest(Decorator.encryptedDatabase((Test)baseTestSuite2));
        return baseTestSuite;
    }

    @Override
    protected void tearDown() throws Exception {
        this.rollback();
        Statement statement = this.createStatement();
        statement.execute("drop table updateClob");
        statement.close();
        this.commit();
        super.tearDown();
    }
}

