/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derby.iapi.types.HarmonySerialBlob;
import org.apache.derby.iapi.types.HarmonySerialClob;
import org.apache.derbyTesting.functionTests.tests.lang.Price;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ProcedureTest
extends BaseJDBCTestCase {
    private static final String[] PROCEDURES = new String[]{"CREATE PROCEDURE RETRIEVE_DYNAMIC_RESULTS(number INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest.class.getName() + ".retrieveDynamicResults' DYNAMIC RESULT SETS 4", "CREATE PROCEDURE RETRIEVE_CLOSED_RESULT() LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest.class.getName() + ".retrieveClosedResult' DYNAMIC RESULT SETS 1", "CREATE PROCEDURE RETRIEVE_EXTERNAL_RESULT(DBNAME VARCHAR(128), DBUSER VARCHAR(128), DBPWD VARCHAR(128)) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest.class.getName() + ".retrieveExternalResult' DYNAMIC RESULT SETS 1", "CREATE PROCEDURE PROC_WITH_SIDE_EFFECTS(ret INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest.class.getName() + ".procWithSideEffects' DYNAMIC RESULT SETS 2", "CREATE PROCEDURE NESTED_RESULT_SETS(proctext VARCHAR(128)) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest.class.getName() + ".nestedDynamicResultSets' DYNAMIC RESULT SETS 6", "CREATE PROCEDURE INT_OUT(OUT X INTEGER) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest.class.getName() + ".intOut'"};
    private static final String[][] TABLES = new String[][]{{"SIMPLE_TABLE", "CREATE TABLE SIMPLE_TABLE (id INT)"}};

    public ProcedureTest(String string) {
        super(string);
    }

    public void testExecuteQueryWithNoDynamicResultSets() throws SQLException {
        Statement statement = this.createStatement();
        try {
            statement.executeQuery("CALL RETRIEVE_DYNAMIC_RESULTS(0)");
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sQLException) {
            this.assertNoResultSetFromExecuteQuery(sQLException);
        }
    }

    public void testExecuteQueryWithOneDynamicResultSet() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("CALL RETRIEVE_DYNAMIC_RESULTS(1)");
        ProcedureTest.assertNotNull((String)"executeQuery() returned null.", (Object)resultSet);
        ProcedureTest.assertSame((Object)statement, (Object)resultSet.getStatement());
        JDBC.assertDrainResultsHasData(resultSet);
    }

    public void testExecuteQueryWithMoreThanOneDynamicResultSet() throws SQLException {
        Statement statement = this.createStatement();
        try {
            statement.executeQuery("CALL RETRIEVE_DYNAMIC_RESULTS(2)");
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sQLException) {
            this.assertMultipleResultsFromExecuteQuery(sQLException);
        }
    }

    public void testExecuteUpdateWithNoDynamicResultSets() throws SQLException {
        Statement statement = this.createStatement();
        ProcedureTest.assertUpdateCount(statement, 0, "CALL RETRIEVE_DYNAMIC_RESULTS(0)");
        JDBC.assertNoMoreResults(statement);
    }

    public void testExecuteUpdateWithOneDynamicResultSet() throws SQLException {
        Statement statement = this.createStatement();
        try {
            statement.executeUpdate("CALL RETRIEVE_DYNAMIC_RESULTS(1)");
            ProcedureTest.fail((String)"executeUpdate() didn't fail.");
        }
        catch (SQLException sQLException) {
            this.assertResultsFromExecuteUpdate(sQLException);
        }
    }

    public void testExecuteQueryWithNoDynamicResultSets_prepared() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        preparedStatement.setInt(1, 0);
        try {
            preparedStatement.executeQuery();
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sQLException) {
            this.assertNoResultSetFromExecuteQuery(sQLException);
        }
    }

    public void testExecuteQueryWithOneDynamicResultSet_prepared() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        preparedStatement.setInt(1, 1);
        ResultSet resultSet = preparedStatement.executeQuery();
        ProcedureTest.assertNotNull((String)"executeQuery() returned null.", (Object)resultSet);
        ProcedureTest.assertSame((Object)preparedStatement, (Object)resultSet.getStatement());
        JDBC.assertDrainResultsHasData(resultSet);
    }

    public void testExecuteQueryWithMoreThanOneDynamicResultSet_prepared() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        preparedStatement.setInt(1, 2);
        try {
            preparedStatement.executeQuery();
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sQLException) {
            this.assertMultipleResultsFromExecuteQuery(sQLException);
        }
    }

    public void testExecuteUpdateWithNoDynamicResultSets_prepared() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        preparedStatement.setInt(1, 0);
        ProcedureTest.assertUpdateCount(preparedStatement, 0);
        JDBC.assertNoMoreResults(preparedStatement);
    }

    public void testExecuteUpdateWithOneDynamicResultSet_prepared() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        preparedStatement.setInt(1, 1);
        try {
            preparedStatement.executeUpdate();
            ProcedureTest.fail((String)"executeUpdate() didn't fail.");
        }
        catch (SQLException sQLException) {
            this.assertResultsFromExecuteUpdate(sQLException);
        }
    }

    public void testExecuteQueryWithNoDynamicResultSets_callable() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        callableStatement.setInt(1, 0);
        try {
            callableStatement.executeQuery();
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sQLException) {
            this.assertNoResultSetFromExecuteQuery(sQLException);
        }
    }

    public void testExecuteQueryWithOneDynamicResultSet_callable() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        callableStatement.setInt(1, 1);
        ResultSet resultSet = callableStatement.executeQuery();
        ProcedureTest.assertNotNull((String)"executeQuery() returned null.", (Object)resultSet);
        ProcedureTest.assertSame((Object)callableStatement, (Object)resultSet.getStatement());
        JDBC.assertDrainResultsHasData(resultSet);
    }

    public void testExecuteQueryWithMoreThanOneDynamicResultSet_callable() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        callableStatement.setInt(1, 2);
        try {
            callableStatement.executeQuery();
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sQLException) {
            this.assertMultipleResultsFromExecuteQuery(sQLException);
        }
    }

    public void testExecuteUpdateWithNoDynamicResultSets_callable() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        callableStatement.setInt(1, 0);
        ProcedureTest.assertUpdateCount(callableStatement, 0);
        JDBC.assertNoMoreResults(callableStatement);
    }

    public void testExecuteUpdateWithOneDynamicResultSet_callable() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        callableStatement.setInt(1, 1);
        try {
            callableStatement.executeUpdate();
            ProcedureTest.fail((String)"executeUpdate() didn't fail.");
        }
        catch (SQLException sQLException) {
            this.assertResultsFromExecuteUpdate(sQLException);
        }
    }

    public void testRollbackStoredProcWithExecuteQuery() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("CALL PROC_WITH_SIDE_EFFECTS(1)");
        resultSet.close();
        this.rollback();
        JDBC.assertEmpty(statement.executeQuery("SELECT * FROM SIMPLE_TABLE"));
    }

    public void testRollbackStoredProcWithExecuteUpdate() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("CALL PROC_WITH_SIDE_EFFECTS(0)");
        this.rollback();
        JDBC.assertEmpty(statement.executeQuery("SELECT * FROM SIMPLE_TABLE"));
    }

    public void testRollbackStoredProcWhenExecuteQueryReturnsNothing() throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(true);
        Statement statement = this.createStatement();
        try {
            statement.executeQuery("CALL PROC_WITH_SIDE_EFFECTS(0)");
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sQLException) {
            this.assertNoResultSetFromExecuteQuery(sQLException);
        }
        JDBC.assertEmpty(statement.executeQuery("SELECT * FROM SIMPLE_TABLE"));
    }

    public void testRollbackStoredProcWhenExecuteQueryReturnsTooMuch() throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(true);
        Statement statement = this.createStatement();
        try {
            statement.executeQuery("CALL PROC_WITH_SIDE_EFFECTS(2)");
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sQLException) {
            this.assertMultipleResultsFromExecuteQuery(sQLException);
        }
        JDBC.assertEmpty(statement.executeQuery("SELECT * FROM SIMPLE_TABLE"));
    }

    public void testRollbackStoredProcWhenExecuteUpdateReturnsResults() throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(true);
        Statement statement = this.createStatement();
        try {
            statement.executeUpdate("CALL PROC_WITH_SIDE_EFFECTS(1)");
            ProcedureTest.fail((String)"executeUpdate() didn't fail.");
        }
        catch (SQLException sQLException) {
            this.assertResultsFromExecuteUpdate(sQLException);
        }
        JDBC.assertEmpty(statement.executeQuery("SELECT * FROM SIMPLE_TABLE"));
    }

    public void testRollbackStoredProcWhenExecuteQueryReturnsNothing_prepared() throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(true);
        PreparedStatement preparedStatement = this.prepareStatement("CALL PROC_WITH_SIDE_EFFECTS(?)");
        preparedStatement.setInt(1, 0);
        try {
            preparedStatement.executeQuery();
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sQLException) {
            this.assertNoResultSetFromExecuteQuery(sQLException);
        }
        Statement statement = this.createStatement();
        JDBC.assertEmpty(statement.executeQuery("SELECT * FROM SIMPLE_TABLE"));
    }

    public void testRollbackStoredProcWhenExecuteQueryReturnsTooMuch_prepared() throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(true);
        PreparedStatement preparedStatement = this.prepareStatement("CALL PROC_WITH_SIDE_EFFECTS(?)");
        preparedStatement.setInt(1, 2);
        try {
            preparedStatement.executeQuery();
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sQLException) {
            this.assertMultipleResultsFromExecuteQuery(sQLException);
        }
        Statement statement = this.createStatement();
        JDBC.assertEmpty(statement.executeQuery("SELECT * FROM SIMPLE_TABLE"));
    }

    public void testRollbackStoredProcWhenExecuteUpdateReturnsResults_prepared() throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(true);
        PreparedStatement preparedStatement = this.prepareStatement("CALL PROC_WITH_SIDE_EFFECTS(?)");
        preparedStatement.setInt(1, 1);
        try {
            preparedStatement.executeUpdate();
            ProcedureTest.fail((String)"executeUpdate() didn't fail.");
        }
        catch (SQLException sQLException) {
            this.assertResultsFromExecuteUpdate(sQLException);
        }
        Statement statement = this.createStatement();
        JDBC.assertEmpty(statement.executeQuery("SELECT * FROM SIMPLE_TABLE"));
    }

    public void testClosedDynamicResultSetsFromExecuteQuery() throws SQLException {
        Statement statement = this.createStatement();
        try {
            ResultSet resultSet = statement.executeQuery("CALL RETRIEVE_CLOSED_RESULT()");
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sQLException) {
            this.assertNoResultSetFromExecuteQuery(sQLException);
        }
    }

    public void testClosedDynamicResultSetsFromExecuteUpdate() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("CALL RETRIEVE_CLOSED_RESULT()");
        JDBC.assertNoMoreResults(statement);
    }

    public void testDynamicResultSetsFromOtherConnectionWithExecuteQuery() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("CALL RETRIEVE_EXTERNAL_RESULT(?,?,?)");
        preparedStatement.setString(1, this.getTestConfiguration().getDefaultDatabaseName());
        preparedStatement.setString(2, this.getTestConfiguration().getUserName());
        preparedStatement.setString(3, this.getTestConfiguration().getUserPassword());
        try {
            preparedStatement.executeQuery();
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sQLException) {
            this.assertNoResultSetFromExecuteQuery(sQLException);
        }
    }

    public void testDynamicResultSetsFromOtherConnectionWithExecuteUpdate() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("CALL RETRIEVE_EXTERNAL_RESULT(?,?,?)");
        preparedStatement.setString(1, this.getTestConfiguration().getDefaultDatabaseName());
        preparedStatement.setString(2, this.getTestConfiguration().getUserName());
        preparedStatement.setString(3, this.getTestConfiguration().getUserPassword());
        preparedStatement.executeUpdate();
        JDBC.assertNoMoreResults(preparedStatement);
    }

    public void testGetBlobFromIntParameter() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call int_out(?)");
        callableStatement.registerOutParameter(1, 4);
        callableStatement.execute();
        try {
            callableStatement.getBlob(1);
            ProcedureTest.fail((String)"getBlob() on int parameter expected to fail");
        }
        catch (SQLException sQLException) {
            ProcedureTest.assertSQLState("22005", sQLException);
        }
    }

    public void testGetClobFromIntParameter() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call int_out(?)");
        callableStatement.registerOutParameter(1, 4);
        callableStatement.execute();
        try {
            callableStatement.getClob(1);
            ProcedureTest.fail((String)"getClob() on int parameter expected to fail");
        }
        catch (SQLException sQLException) {
            ProcedureTest.assertSQLState("22005", sQLException);
        }
    }

    public void testStatementSeverityErrorInProcedure() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create procedure proc_5280() language java parameter style java external name '" + ((Object)((Object)this)).getClass().getName() + ".proc_5280' reads sql data");
        statement.execute("call proc_5280()");
    }

    public static void proc_5280() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        try {
            statement.execute("drop table this_table_does_not_exist");
            ProcedureTest.fail((String)"dropping non-existent table should fail");
        }
        catch (SQLException sQLException) {
            ProcedureTest.assertSQLState("42Y55", sQLException);
        }
        JDBC.assertSingleValueResultSet(statement.executeQuery("values 1"), "1");
    }

    public void test_2515() throws Exception {
        Connection connection = this.getConnection();
        PreparedStatement preparedStatement = connection.prepareStatement("create type price_2515 external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        preparedStatement.execute();
        preparedStatement.close();
        preparedStatement = connection.prepareStatement("create procedure proc_2515\n(\n\tin passNumber int,\n\tout returnMessage varchar( 32672 ),\n\tinout bigintArg bigint,\n\tinout blobArg blob,\ninout booleanArg boolean,\ninout charArg char( 6 ),\ninout charForBitDataArg char( 3 ) for bit data,\ninout clobArg clob,\ninout dateArg date,\ninout decimalArg decimal,\ninout doubleArg double,\ninout intArg int,\ninout longVarcharArg long varchar,\ninout longVarcharForBitDataArg long varchar for bit data,\ninout realArg real,\ninout smallintArg smallint,\ninout timeArg time,\ninout timestampArg timestamp,\ninout priceArg price_2515,\ninout varcharArg varchar( 20 ),\ninout varcharForBitDataArg varchar( 3 ) for bit data\n)\nparameter style java language java no sql\nexternal name '" + ProcedureTest.class.getName() + ".proc_2515'");
        preparedStatement.execute();
        preparedStatement.close();
        CallableStatement callableStatement = connection.prepareCall("call proc_2515( ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ? )");
        AllTypesTuple allTypesTuple = ProcedureTest.makeFirstAllTypesTuple();
        int n = 2;
        callableStatement.registerOutParameter(n++, 12);
        callableStatement.registerOutParameter(n, -5);
        callableStatement.setLong(n++, (long)allTypesTuple.get_bigintArg());
        callableStatement.registerOutParameter(n, 2004);
        callableStatement.setBlob(n++, allTypesTuple.get_blobArg());
        callableStatement.registerOutParameter(n, 16);
        callableStatement.setBoolean(n++, (boolean)allTypesTuple.get_booleanArg());
        callableStatement.registerOutParameter(n, 1);
        callableStatement.setString(n++, allTypesTuple.get_charArg());
        callableStatement.registerOutParameter(n, -2);
        callableStatement.setBytes(n++, allTypesTuple.get_charForBitDataArg());
        callableStatement.registerOutParameter(n, 2005);
        callableStatement.setClob(n++, allTypesTuple.get_clobArg());
        callableStatement.registerOutParameter(n, 91);
        callableStatement.setDate(n++, allTypesTuple.get_dateArg());
        callableStatement.registerOutParameter(n, 3);
        callableStatement.setBigDecimal(n++, allTypesTuple.get_decimalArg());
        callableStatement.registerOutParameter(n, 8);
        callableStatement.setDouble(n++, (double)allTypesTuple.get_doubleArg());
        callableStatement.registerOutParameter(n, 4);
        callableStatement.setInt(n++, (int)allTypesTuple.get_intArg());
        callableStatement.registerOutParameter(n, -1);
        callableStatement.setString(n++, allTypesTuple.get_longVarcharArg());
        callableStatement.registerOutParameter(n, -4);
        callableStatement.setBytes(n++, allTypesTuple.get_longVarcharForBitDataArg());
        callableStatement.registerOutParameter(n, 7);
        callableStatement.setFloat(n++, allTypesTuple.get_realArg().floatValue());
        callableStatement.registerOutParameter(n, 5);
        callableStatement.setShort(n++, allTypesTuple.get_smallintArg().shortValue());
        callableStatement.registerOutParameter(n, 92);
        callableStatement.setTime(n++, allTypesTuple.get_timeArg());
        callableStatement.registerOutParameter(n, 93);
        callableStatement.setTimestamp(n++, allTypesTuple.get_timestampArg());
        callableStatement.registerOutParameter(n, 2000);
        callableStatement.setObject(n++, (Object)allTypesTuple.get_priceArg());
        callableStatement.registerOutParameter(n, 12);
        callableStatement.setString(n++, allTypesTuple.get_varcharArg());
        callableStatement.registerOutParameter(n, -3);
        callableStatement.setBytes(n++, allTypesTuple.get_varcharForBitDataArg());
        callableStatement.setInt(1, 0);
        callableStatement.execute();
        ProcedureTest.assertEquals((String)"", (String)callableStatement.getString(2));
        ProcedureTest.assertEquals((String)"", (String)ProcedureTest.makeSecondAllTypesTuple().compare(this.getActualReturnArgs(callableStatement)));
        callableStatement.setInt(1, 1);
        callableStatement.execute();
        ProcedureTest.assertEquals((String)"", (String)callableStatement.getString(2));
        ProcedureTest.assertEquals((String)"", (String)ProcedureTest.makeThirdAllTypesTuple().compare(this.getActualReturnArgs(callableStatement)));
        callableStatement.setInt(1, 2);
        callableStatement.execute();
        ProcedureTest.assertEquals((String)"", (String)callableStatement.getString(2));
        ProcedureTest.assertEquals((String)"", (String)ProcedureTest.makeFourthAllTypesTuple().compare(this.getActualReturnArgs(callableStatement)));
        preparedStatement = connection.prepareStatement("drop procedure proc_2515");
        preparedStatement.execute();
        preparedStatement.close();
        preparedStatement = connection.prepareStatement("drop type price_2515 restrict");
        preparedStatement.execute();
        preparedStatement.close();
    }

    private AllTypesTuple getActualReturnArgs(CallableStatement callableStatement) throws Exception {
        int n = 3;
        return new AllTypesTuple((Long)callableStatement.getObject(n++), (Blob)callableStatement.getObject(n++), (Boolean)callableStatement.getObject(n++), (String)callableStatement.getObject(n++), (byte[])callableStatement.getObject(n++), (Clob)callableStatement.getObject(n++), (Date)callableStatement.getObject(n++), (BigDecimal)callableStatement.getObject(n++), (Double)callableStatement.getObject(n++), (Integer)callableStatement.getObject(n++), (String)callableStatement.getObject(n++), (byte[])callableStatement.getObject(n++), (Float)callableStatement.getObject(n++), (Integer)callableStatement.getObject(n++), (Time)callableStatement.getObject(n++), (Timestamp)callableStatement.getObject(n++), (Price)callableStatement.getObject(n++), (String)callableStatement.getObject(n++), (byte[])callableStatement.getObject(n++));
    }

    public void testInOutParamNotSet() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create procedure proc_2516 (inout i int) language java parameter style java external name '" + ((Object)((Object)this)).getClass().getName() + ".proc_2516' no sql");
        CallableStatement callableStatement = this.prepareCall("call proc_2516(?)");
        callableStatement.registerOutParameter(1, 4);
        ProcedureTest.assertStatementError("07000", callableStatement);
        callableStatement.setInt(1, 0);
        callableStatement.execute();
        ProcedureTest.assertEquals((int)10, (int)callableStatement.getInt(1));
        callableStatement.clearParameters();
        ProcedureTest.assertStatementError("07000", callableStatement);
        callableStatement.setInt(1, 1);
        callableStatement.execute();
        ProcedureTest.assertEquals((int)10, (int)callableStatement.getInt(1));
    }

    public static void proc_2516(Integer[] integerArray) {
        integerArray[0] = 10;
    }

    public void testMaxNumberOfParameters() throws SQLException {
        this.testMaxNumberOfParameters(255, true);
        this.testMaxNumberOfParameters(256, false);
        this.testMaxNumberOfParameters(10000, false);
    }

    private void testMaxNumberOfParameters(int n, boolean bl) throws SQLException {
        String string = ((Object)((Object)this)).getClass().getName() + ".procWithManyParams";
        this.setAutoCommit(false);
        StringBuffer stringBuffer = new StringBuffer("create procedure ");
        stringBuffer.append("PROC_WITH_LOTS_OF_PARAMETERS").append('(');
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append('p').append(i).append(" int");
        }
        stringBuffer.append(") language java parameter style java external name '");
        stringBuffer.append(string).append("' no sql");
        Statement statement = this.createStatement();
        statement.execute(stringBuffer.toString());
        DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
        JDBC.assertFullResultSet(databaseMetaData.getProcedures(null, null, "PROC_WITH_LOTS_OF_PARAMETERS"), (Object[][])new Object[][]{{"", "APP", "PROC_WITH_LOTS_OF_PARAMETERS", null, null, null, string, 1, new JDBC.GeneratedId()}}, false);
        JDBC.assertDrainResults(databaseMetaData.getProcedureColumns(null, null, "PROC_WITH_LOTS_OF_PARAMETERS", "%"), n);
        stringBuffer.setLength(0);
        stringBuffer.append("call ").append("PROC_WITH_LOTS_OF_PARAMETERS").append('(');
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(i);
        }
        stringBuffer.append(')');
        if (bl) {
            statement.execute(stringBuffer.toString());
        } else {
            this.assertCallError("42X50", stringBuffer.toString());
        }
        this.rollback();
    }

    public static void procWithManyParams(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17, int n18, int n19, int n20, int n21, int n22, int n23, int n24, int n25, int n26, int n27, int n28, int n29, int n30, int n31, int n32, int n33, int n34, int n35, int n36, int n37, int n38, int n39, int n40, int n41, int n42, int n43, int n44, int n45, int n46, int n47, int n48, int n49, int n50, int n51, int n52, int n53, int n54, int n55, int n56, int n57, int n58, int n59, int n60, int n61, int n62, int n63, int n64, int n65, int n66, int n67, int n68, int n69, int n70, int n71, int n72, int n73, int n74, int n75, int n76, int n77, int n78, int n79, int n80, int n81, int n82, int n83, int n84, int n85, int n86, int n87, int n88, int n89, int n90, int n91, int n92, int n93, int n94, int n95, int n96, int n97, int n98, int n99, int n100, int n101, int n102, int n103, int n104, int n105, int n106, int n107, int n108, int n109, int n110, int n111, int n112, int n113, int n114, int n115, int n116, int n117, int n118, int n119, int n120, int n121, int n122, int n123, int n124, int n125, int n126, int n127, int n128, int n129, int n130, int n131, int n132, int n133, int n134, int n135, int n136, int n137, int n138, int n139, int n140, int n141, int n142, int n143, int n144, int n145, int n146, int n147, int n148, int n149, int n150, int n151, int n152, int n153, int n154, int n155, int n156, int n157, int n158, int n159, int n160, int n161, int n162, int n163, int n164, int n165, int n166, int n167, int n168, int n169, int n170, int n171, int n172, int n173, int n174, int n175, int n176, int n177, int n178, int n179, int n180, int n181, int n182, int n183, int n184, int n185, int n186, int n187, int n188, int n189, int n190, int n191, int n192, int n193, int n194, int n195, int n196, int n197, int n198, int n199, int n200, int n201, int n202, int n203, int n204, int n205, int n206, int n207, int n208, int n209, int n210, int n211, int n212, int n213, int n214, int n215, int n216, int n217, int n218, int n219, int n220, int n221, int n222, int n223, int n224, int n225, int n226, int n227, int n228, int n229, int n230, int n231, int n232, int n233, int n234, int n235, int n236, int n237, int n238, int n239, int n240, int n241, int n242, int n243, int n244, int n245, int n246, int n247, int n248, int n249, int n250, int n251, int n252, int n253, int n254, int n255) {
    }

    private void assertNoResultSetFromExecuteQuery(SQLException sQLException) {
        ProcedureTest.assertSQLState("Unexpected SQL state.", "X0Y78", sQLException);
    }

    private void assertMultipleResultsFromExecuteQuery(SQLException sQLException) {
        ProcedureTest.assertSQLState("Unexpected SQL state.", "X0Y78", sQLException);
    }

    private void assertResultsFromExecuteUpdate(SQLException sQLException) {
        ProcedureTest.assertSQLState("Unexpected SQL state.", "X0Y79", sQLException);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ProcedureTest");
        baseTestSuite.addTest(ProcedureTest.baseSuite("ProcedureTest:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(ProcedureTest.baseSuite("ProcedureTest:client")));
        return baseTestSuite;
    }

    private static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        if (!JDBC.vmSupportsJDBC3()) {
            return baseTestSuite;
        }
        baseTestSuite.addTestSuite(ProcedureTest.class);
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                int n;
                for (n = 0; n < PROCEDURES.length; ++n) {
                    statement.execute(PROCEDURES[n]);
                }
                for (n = 0; n < TABLES.length; ++n) {
                    statement.execute(TABLES[n][1]);
                }
            }
        };
    }

    public void setUp() throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        Statement statement = this.createStatement();
        for (int i = 0; i < TABLES.length; ++i) {
            statement.execute("DELETE FROM " + TABLES[i][0]);
        }
        this.commit();
    }

    public static void retrieveDynamicResults(int n, ResultSet[] resultSetArray, ResultSet[] resultSetArray2, ResultSet[] resultSetArray3, ResultSet[] resultSetArray4) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        if (n > 0) {
            resultSetArray[0] = connection.createStatement().executeQuery("VALUES(1)");
        }
        if (n > 1) {
            resultSetArray2[0] = connection.createStatement().executeQuery("VALUES(1)");
        }
        if (n > 2) {
            resultSetArray3[0] = connection.createStatement().executeQuery("VALUES(1)");
        }
        if (n > 3) {
            resultSetArray4[0] = connection.createStatement().executeQuery("VALUES(1)");
        }
        connection.close();
    }

    public static void retrieveClosedResult(ResultSet[] resultSetArray) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        resultSetArray[0] = connection.createStatement().executeQuery("VALUES(1)");
        resultSetArray[0].close();
        connection.close();
    }

    public static void retrieveExternalResult(String string, String string2, String string3, ResultSet[] resultSetArray) throws SQLException {
        String string4 = "jdbc:derby:" + string;
        Connection connection = DriverManager.getConnection(string4, string2, string3);
        resultSetArray[0] = connection.createStatement().executeQuery("VALUES(1)");
    }

    public static void procWithSideEffects(int n, ResultSet[] resultSetArray, ResultSet[] resultSetArray2) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        statement.executeUpdate("INSERT INTO SIMPLE_TABLE VALUES (42)");
        if (n > 0) {
            resultSetArray[0] = connection.createStatement().executeQuery("VALUES(1)");
        }
        if (n > 1) {
            resultSetArray2[0] = connection.createStatement().executeQuery("VALUES(1)");
        }
        connection.close();
    }

    public static void nestedDynamicResultSets(String string, ResultSet[] resultSetArray, ResultSet[] resultSetArray2, ResultSet[] resultSetArray3, ResultSet[] resultSetArray4, ResultSet[] resultSetArray5, ResultSet[] resultSetArray6) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        CallableStatement callableStatement = connection.prepareCall("CALL " + string);
        callableStatement.execute();
        resultSetArray6[0] = callableStatement.getResultSet();
        if (!callableStatement.getMoreResults(2)) {
            return;
        }
        resultSetArray3[0] = callableStatement.getResultSet();
        if (!callableStatement.getMoreResults(2)) {
            return;
        }
        resultSetArray4[0] = callableStatement.getResultSet();
        if (!callableStatement.getMoreResults(2)) {
            return;
        }
        resultSetArray2[0] = callableStatement.getResultSet();
        if (!callableStatement.getMoreResults(2)) {
            return;
        }
        resultSetArray[0] = callableStatement.getResultSet();
        if (!callableStatement.getMoreResults(2)) {
            return;
        }
        resultSetArray5[0] = callableStatement.getResultSet();
    }

    public static void intOut(int[] nArray) {
        nArray[0] = 42;
    }

    public static AllTypesTuple makeFirstAllTypesTuple() throws Exception {
        return new AllTypesTuple(1L, (Blob)new HarmonySerialBlob(new byte[]{1, 1, 1}), Boolean.TRUE, "firstt", new byte[]{1, 1, 1}, (Clob)new HarmonySerialClob("firstt"), new Date(1L), new BigDecimal("1"), 1.0, 1, new String("firstt"), new byte[]{1, 1, 1}, Float.valueOf(1.0f), 1, new Time(1L), new Timestamp(1L), new Price("USD", new BigDecimal("1"), new Timestamp(1L)), "firstt", new byte[]{1, 1, 1});
    }

    public static AllTypesTuple makeSecondAllTypesTuple() throws Exception {
        return new AllTypesTuple(2L, (Blob)new HarmonySerialBlob(new byte[]{2, 2, 2}), Boolean.FALSE, "second", new byte[]{2, 2, 2}, (Clob)new HarmonySerialClob("second"), new Date(2L), new BigDecimal("2"), 2.0, 2, new String("second"), new byte[]{2, 2, 2}, Float.valueOf(2.0f), 2, new Time(2L), new Timestamp(2L), new Price("USD", new BigDecimal("2"), new Timestamp(2L)), "second", new byte[]{2, 2, 2});
    }

    public static AllTypesTuple makeThirdAllTypesTuple() throws Exception {
        return new AllTypesTuple(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public static AllTypesTuple makeFourthAllTypesTuple() throws Exception {
        return ProcedureTest.makeFirstAllTypesTuple();
    }

    public static void proc_2515(int n, String[] stringArray, Long[] longArray, Blob[] blobArray, Boolean[] booleanArray, String[] stringArray2, byte[][] byArray, Clob[] clobArray, Date[] dateArray, BigDecimal[] bigDecimalArray, Double[] doubleArray, Integer[] integerArray, String[] stringArray3, byte[][] byArray2, Float[] floatArray, Integer[] integerArray2, Time[] timeArray, Timestamp[] timestampArray, Price[] priceArray, String[] stringArray4, byte[][] byArray3) throws Exception {
        AllTypesTuple allTypesTuple;
        AllTypesTuple allTypesTuple2;
        AllTypesTuple allTypesTuple3 = new AllTypesTuple(longArray[0], blobArray[0], booleanArray[0], stringArray2[0], byArray[0], clobArray[0], dateArray[0], bigDecimalArray[0], doubleArray[0], integerArray[0], stringArray3[0], byArray2[0], floatArray[0], integerArray2[0], timeArray[0], timestampArray[0], priceArray[0], stringArray4[0], byArray3[0]);
        switch (n) {
            case 0: {
                allTypesTuple2 = ProcedureTest.makeFirstAllTypesTuple();
                allTypesTuple = ProcedureTest.makeSecondAllTypesTuple();
                break;
            }
            case 1: {
                allTypesTuple2 = ProcedureTest.makeSecondAllTypesTuple();
                allTypesTuple = ProcedureTest.makeThirdAllTypesTuple();
                break;
            }
            default: {
                allTypesTuple2 = ProcedureTest.makeThirdAllTypesTuple();
                allTypesTuple = ProcedureTest.makeFourthAllTypesTuple();
            }
        }
        stringArray[0] = allTypesTuple2.compare(allTypesTuple3);
        longArray[0] = allTypesTuple.get_bigintArg();
        blobArray[0] = allTypesTuple.get_blobArg();
        booleanArray[0] = allTypesTuple.get_booleanArg();
        stringArray2[0] = allTypesTuple.get_charArg();
        byArray[0] = allTypesTuple.get_charForBitDataArg();
        clobArray[0] = allTypesTuple.get_clobArg();
        dateArray[0] = allTypesTuple.get_dateArg();
        bigDecimalArray[0] = allTypesTuple.get_decimalArg();
        doubleArray[0] = allTypesTuple.get_doubleArg();
        integerArray[0] = allTypesTuple.get_intArg();
        stringArray3[0] = allTypesTuple.get_longVarcharArg();
        byArray2[0] = allTypesTuple.get_longVarcharForBitDataArg();
        floatArray[0] = allTypesTuple.get_realArg();
        integerArray2[0] = allTypesTuple.get_smallintArg();
        timeArray[0] = allTypesTuple.get_timeArg();
        timestampArray[0] = allTypesTuple.get_timestampArg();
        priceArray[0] = allTypesTuple.get_priceArg();
        stringArray4[0] = allTypesTuple.get_varcharArg();
        byArray3[0] = allTypesTuple.get_varcharForBitDataArg();
    }

    public void testGetMoreResults() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table MRS.FIVERS(i integer)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into MRS.FIVERS values (?)");
        for (int i = 1; i <= 20; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.executeUpdate();
        }
        statement.executeUpdate("create procedure MRS.FIVEJP() parameter style JAVA READS SQL DATA dynamic result sets 5 language java external name 'org.apache.derbyTesting.functionTests.util.ProcedureTest.fivejp'");
        CallableStatement callableStatement = this.prepareCall("CALL MRS.FIVEJP()");
        Object[] objectArray = new ResultSet[5];
        this.defaultGetMoreResults(callableStatement, (ResultSet[])objectArray);
        Arrays.fill(objectArray, null);
        this.closeCurrentGetMoreResults(callableStatement, (ResultSet[])objectArray);
        Arrays.fill(objectArray, null);
        this.keepCurrentGetMoreResults(callableStatement, (ResultSet[])objectArray);
        Arrays.fill(objectArray, null);
        this.mixedGetMoreResults(callableStatement, (ResultSet[])objectArray);
        Arrays.fill(objectArray, null);
        this.checkExecuteClosesResults(callableStatement, (ResultSet[])objectArray);
        Arrays.fill(objectArray, null);
        this.checkCSCloseClosesResults(callableStatement, (ResultSet[])objectArray);
        Arrays.fill(objectArray, null);
        CallableStatement callableStatement2 = this.prepareCall("CALL NESTED_RESULT_SETS('MRS.FIVEJP()')");
        this.defaultGetMoreResults(callableStatement2, (ResultSet[])objectArray);
    }

    private void checkExecuteClosesResults(CallableStatement callableStatement, ResultSet[] resultSetArray) throws SQLException {
        int n;
        callableStatement.execute();
        int n2 = 0;
        do {
            resultSetArray[n2++] = callableStatement.getResultSet();
            ProcedureTest.assertSame((Object)callableStatement, (Object)resultSetArray[n2 - 1].getStatement());
        } while (callableStatement.getMoreResults(2));
        for (n = 0; n < 5; ++n) {
            JDBC.assertDrainResults(resultSetArray[n]);
        }
        callableStatement.execute();
        for (n = 0; n < 5; ++n) {
            JDBC.assertClosed(resultSetArray[n]);
        }
    }

    private void checkCSCloseClosesResults(CallableStatement callableStatement, ResultSet[] resultSetArray) throws SQLException {
        int n;
        callableStatement.execute();
        int n2 = 0;
        do {
            resultSetArray[n2++] = callableStatement.getResultSet();
            ProcedureTest.assertSame((Object)callableStatement, (Object)resultSetArray[n2 - 1].getStatement());
        } while (callableStatement.getMoreResults(2));
        for (n = 0; n < 5; ++n) {
            JDBC.assertDrainResults(resultSetArray[n]);
        }
        callableStatement.close();
        for (n = 0; n < 5; ++n) {
            JDBC.assertClosed(resultSetArray[n]);
        }
    }

    private void mixedGetMoreResults(CallableStatement callableStatement, ResultSet[] resultSetArray) throws SQLException {
        callableStatement.execute();
        resultSetArray[0] = callableStatement.getResultSet();
        ProcedureTest.assertSame((Object)callableStatement, (Object)resultSetArray[0].getStatement());
        boolean bl = callableStatement.getMoreResults(2);
        if (!bl) {
            ProcedureTest.fail((String)"FAIL - no second result set");
        }
        resultSetArray[1] = callableStatement.getResultSet();
        ProcedureTest.assertSame((Object)callableStatement, (Object)resultSetArray[1].getStatement());
        resultSetArray[0].next();
        ProcedureTest.assertEquals((int)2, (int)resultSetArray[0].getInt(1));
        resultSetArray[1].next();
        ProcedureTest.assertEquals((int)3, (int)resultSetArray[1].getInt(1));
        bl = callableStatement.getMoreResults(1);
        if (!bl) {
            ProcedureTest.fail((String)"FAIL - no third result set");
        }
        resultSetArray[2] = callableStatement.getResultSet();
        ProcedureTest.assertSame((Object)callableStatement, (Object)resultSetArray[2].getStatement());
        ProcedureTest.assertEquals((int)2, (int)resultSetArray[0].getInt(1));
        JDBC.assertClosed(resultSetArray[1]);
        resultSetArray[2].next();
        ProcedureTest.assertEquals((int)4, (int)resultSetArray[2].getInt(1));
        bl = callableStatement.getMoreResults(2);
        if (!bl) {
            ProcedureTest.fail((String)"FAIL - no fourth result set");
        }
        resultSetArray[3] = callableStatement.getResultSet();
        ProcedureTest.assertSame((Object)callableStatement, (Object)resultSetArray[3].getStatement());
        resultSetArray[3].next();
        ProcedureTest.assertEquals((int)2, (int)resultSetArray[0].getInt(1));
        JDBC.assertClosed(resultSetArray[1]);
        ProcedureTest.assertEquals((int)4, (int)resultSetArray[2].getInt(1));
        ProcedureTest.assertEquals((int)5, (int)resultSetArray[3].getInt(1));
        bl = callableStatement.getMoreResults(3);
        if (!bl) {
            ProcedureTest.fail((String)"FAIL - no fifth result set");
        }
        resultSetArray[4] = callableStatement.getResultSet();
        ProcedureTest.assertSame((Object)callableStatement, (Object)resultSetArray[4].getStatement());
        resultSetArray[4].next();
        JDBC.assertClosed(resultSetArray[0]);
        JDBC.assertClosed(resultSetArray[1]);
        JDBC.assertClosed(resultSetArray[2]);
        JDBC.assertClosed(resultSetArray[3]);
        ProcedureTest.assertEquals((int)6, (int)resultSetArray[4].getInt(1));
        bl = callableStatement.getMoreResults(2);
        if (bl) {
            ProcedureTest.fail((String)"FAIL - too many result sets");
        }
        JDBC.assertClosed(resultSetArray[0]);
        JDBC.assertClosed(resultSetArray[1]);
        JDBC.assertClosed(resultSetArray[2]);
        JDBC.assertClosed(resultSetArray[3]);
        ProcedureTest.assertEquals((int)6, (int)resultSetArray[4].getInt(1));
        resultSetArray[4].close();
    }

    private void keepCurrentGetMoreResults(CallableStatement callableStatement, ResultSet[] resultSetArray) throws SQLException {
        int n;
        callableStatement.execute();
        for (n = 0; n < 5; ++n) {
            resultSetArray[n] = callableStatement.getResultSet();
            ProcedureTest.assertSame((Object)callableStatement, (Object)resultSetArray[n].getStatement());
            resultSetArray[n].next();
            ProcedureTest.assertEquals((int)(2 + n), (int)resultSetArray[n].getInt(1));
            if (n < 4) {
                ProcedureTest.assertTrue((boolean)callableStatement.getMoreResults(2));
                continue;
            }
            ProcedureTest.assertFalse((boolean)callableStatement.getMoreResults(2));
        }
        for (n = 0; n < 5; ++n) {
            JDBC.assertDrainResults(resultSetArray[n]);
        }
    }

    private void closeCurrentGetMoreResults(CallableStatement callableStatement, ResultSet[] resultSetArray) throws SQLException {
        int n;
        callableStatement.execute();
        for (n = 0; n < 5; ++n) {
            resultSetArray[n] = callableStatement.getResultSet();
            ProcedureTest.assertSame((Object)callableStatement, (Object)resultSetArray[n].getStatement());
            resultSetArray[n].next();
            ProcedureTest.assertEquals((int)(2 + n), (int)resultSetArray[n].getInt(1));
            if (n < 4) {
                ProcedureTest.assertTrue((boolean)callableStatement.getMoreResults(1));
                continue;
            }
            ProcedureTest.assertFalse((boolean)callableStatement.getMoreResults(1));
        }
        for (n = 0; n < 5; ++n) {
            JDBC.assertClosed(resultSetArray[n]);
        }
    }

    private void defaultGetMoreResults(CallableStatement callableStatement, ResultSet[] resultSetArray) throws SQLException {
        int n;
        callableStatement.execute();
        for (n = 0; n < 5; ++n) {
            resultSetArray[n] = callableStatement.getResultSet();
            ProcedureTest.assertSame((Object)callableStatement, (Object)resultSetArray[n].getStatement());
            resultSetArray[n].next();
            ProcedureTest.assertEquals((int)(2 + n), (int)resultSetArray[n].getInt(1));
            if (n < 4) {
                ProcedureTest.assertTrue((boolean)callableStatement.getMoreResults());
                continue;
            }
            ProcedureTest.assertFalse((boolean)callableStatement.getMoreResults());
        }
        for (n = 0; n < 5; ++n) {
            JDBC.assertClosed(resultSetArray[n]);
        }
    }

    public static final class AllTypesTuple {
        private Long _bigintArg;
        private Blob _blobArg;
        private Boolean _booleanArg;
        private String _charArg;
        private byte[] _charForBitDataArg;
        private Clob _clobArg;
        private Date _dateArg;
        private BigDecimal _decimalArg;
        private Double _doubleArg;
        private Integer _intArg;
        private String _longVarcharArg;
        private byte[] _longVarcharForBitDataArg;
        private Float _realArg;
        private Integer _smallintArg;
        private Time _timeArg;
        private Timestamp _timestampArg;
        private Price _priceArg;
        private String _varcharArg;
        private byte[] _varcharForBitDataArg;

        public AllTypesTuple(Long l, Blob blob, Boolean bl, String string, byte[] byArray, Clob clob, Date date, BigDecimal bigDecimal, Double d, Integer n, String string2, byte[] byArray2, Float f, Integer n2, Time time, Timestamp timestamp, Price price, String string3, byte[] byArray3) {
            this._bigintArg = l;
            this._blobArg = blob;
            this._booleanArg = bl;
            this._charArg = string;
            this._charForBitDataArg = byArray;
            this._clobArg = clob;
            this._dateArg = date;
            this._decimalArg = bigDecimal;
            this._doubleArg = d;
            this._intArg = n;
            this._longVarcharArg = string2;
            this._longVarcharForBitDataArg = byArray2;
            this._realArg = f;
            this._smallintArg = n2;
            this._timeArg = time;
            this._timestampArg = timestamp;
            this._priceArg = price;
            this._varcharArg = string3;
            this._varcharForBitDataArg = byArray3;
        }

        public Long get_bigintArg() {
            return this._bigintArg;
        }

        public Blob get_blobArg() {
            return this._blobArg;
        }

        public Boolean get_booleanArg() {
            return this._booleanArg;
        }

        public String get_charArg() {
            return this._charArg;
        }

        public byte[] get_charForBitDataArg() {
            return this._charForBitDataArg;
        }

        public Clob get_clobArg() {
            return this._clobArg;
        }

        public Date get_dateArg() {
            return this._dateArg;
        }

        public BigDecimal get_decimalArg() {
            return this._decimalArg;
        }

        public Double get_doubleArg() {
            return this._doubleArg;
        }

        public Integer get_intArg() {
            return this._intArg;
        }

        public String get_longVarcharArg() {
            return this._longVarcharArg;
        }

        public byte[] get_longVarcharForBitDataArg() {
            return this._longVarcharForBitDataArg;
        }

        public Float get_realArg() {
            return this._realArg;
        }

        public Integer get_smallintArg() {
            return this._smallintArg;
        }

        public Time get_timeArg() {
            return this._timeArg;
        }

        public Timestamp get_timestampArg() {
            return this._timestampArg;
        }

        public Price get_priceArg() {
            return this._priceArg;
        }

        public String get_varcharArg() {
            return this._varcharArg;
        }

        public byte[] get_varcharForBitDataArg() {
            return this._varcharForBitDataArg;
        }

        public String compare(AllTypesTuple allTypesTuple) throws Exception {
            Object object = "";
            object = (String)object + this.compare("_bigintArg", this._bigintArg, allTypesTuple._bigintArg);
            object = (String)object + this.compare("_blobArg", this.getBlobBytes(), allTypesTuple.getBlobBytes());
            object = (String)object + this.compare("_booleanArg", this._booleanArg, allTypesTuple._booleanArg);
            object = (String)object + this.compare("_charArg", this._charArg, allTypesTuple._charArg);
            object = (String)object + this.compare("_charForBitDataArg", this._charForBitDataArg, allTypesTuple._charForBitDataArg);
            object = (String)object + this.compare("_clobArg", this.getClobString(), allTypesTuple.getClobString());
            object = (String)object + this.compare("_dateArg", this.getDateString(), allTypesTuple.getDateString());
            object = (String)object + this.compare("_decimalArg", this._decimalArg, allTypesTuple._decimalArg);
            object = (String)object + this.compare("_doubleArg", this._doubleArg, allTypesTuple._doubleArg);
            object = (String)object + this.compare("_intArg", this._intArg, allTypesTuple._intArg);
            object = (String)object + this.compare("_longVarcharArg", this._longVarcharArg, allTypesTuple._longVarcharArg);
            object = (String)object + this.compare("_longVarcharForBitDataArg", this._longVarcharForBitDataArg, allTypesTuple._longVarcharForBitDataArg);
            object = (String)object + this.compare("_realArg", this._realArg, allTypesTuple._realArg);
            object = (String)object + this.compare("_smallintArg", this._smallintArg, allTypesTuple._smallintArg);
            object = (String)object + this.compare("_timeArg", this.getTimeString(), allTypesTuple.getTimeString());
            object = (String)object + this.compare("_timestampArg", this._timestampArg, allTypesTuple._timestampArg);
            object = (String)object + this.compare("_priceArg", this._priceArg, allTypesTuple._priceArg);
            object = (String)object + this.compare("_varcharArg", this._varcharArg, allTypesTuple._varcharArg);
            object = (String)object + this.compare("_varcharForBitDataArg", this._varcharForBitDataArg, allTypesTuple._varcharForBitDataArg);
            return object;
        }

        private byte[] getBlobBytes() throws Exception {
            if (this._blobArg == null) {
                return null;
            }
            return this._blobArg.getBytes(1L, (int)this._blobArg.length());
        }

        private String getClobString() throws Exception {
            if (this._clobArg == null) {
                return null;
            }
            return this._clobArg.getSubString(1L, (int)this._clobArg.length());
        }

        private String getDateString() {
            if (this._dateArg == null) {
                return null;
            }
            return this._dateArg.toString();
        }

        private String getTimeString() {
            if (this._timeArg == null) {
                return null;
            }
            return this._timeArg.toString();
        }

        private String compare(String string, Object object, Object object2) {
            if (object == null) {
                if (object2 == null) {
                    return "";
                }
                return string + ": left was null but right was " + object2;
            }
            if (object2 == null) {
                return string + ": left = " + object + " but right is null";
            }
            if (object instanceof byte[]) {
                return this.compareBytes(string, (byte[])object, (byte[])object2);
            }
            if (object.equals(object2)) {
                return "";
            }
            return string + ": left = " + object + " but right = " + object2;
        }

        private String compareBytes(String string, byte[] byArray, byte[] byArray2) {
            int n = byArray.length;
            if (n != byArray2.length) {
                return string + ": left count = " + n + " but right count = " + byArray2.length;
            }
            for (int i = 0; i < n; ++i) {
                if (byArray[i] == byArray2[i]) continue;
                return string + ": left[ " + i + " ] = " + byArray[i] + " but right[ " + i + " ] = " + byArray2[i];
            }
            return "";
        }
    }
}

