/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.UnsupportedEncodingException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;

public class RoutineTest
extends BaseJDBCTestCase {
    private static final String CANNOT_STUFF_NULL_INTO_PRIMITIVE = "39004";

    public RoutineTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite(RoutineTest.class, "RoutineTest");
        return new CleanDatabaseTestSetup((Test)baseTestSuite);
    }

    public void testFunctionResultDataTypeValidation() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE FUNCTION SMALLINT_P_SHORT(VARCHAR(10)) RETURNS SMALLINT EXTERNAL NAME 'java.lang.Short.parseShort' LANGUAGE JAVA PARAMETER STYLE JAVA");
        PreparedStatement preparedStatement = this.prepareStatement("VALUES SMALLINT_P_SHORT(?)");
        preparedStatement.setString(1, "123");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "123");
        statement.executeUpdate("CREATE FUNCTION SMALLINT_O_INTEGER(VARCHAR(10)) RETURNS SMALLINT EXTERNAL NAME 'java.lang.Integer.valueOf' LANGUAGE JAVA PARAMETER STYLE JAVA");
        preparedStatement = this.prepareStatement("VALUES SMALLINT_O_INTEGER(?)");
        preparedStatement.setString(1, "123");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "123");
        statement.executeUpdate("CREATE FUNCTION INTEGER_P_INT(VARCHAR(10)) RETURNS INTEGER EXTERNAL NAME 'java.lang.Integer.parseInt' LANGUAGE JAVA PARAMETER STYLE JAVA");
        preparedStatement = this.prepareStatement("VALUES INTEGER_P_INT(?)");
        preparedStatement.setString(1, "123");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "123");
        statement.executeUpdate("CREATE FUNCTION INTEGER_O_INTEGER(VARCHAR(10)) RETURNS INTEGER EXTERNAL NAME 'java.lang.Integer.valueOf' LANGUAGE JAVA PARAMETER STYLE JAVA");
        preparedStatement = this.prepareStatement("VALUES INTEGER_O_INTEGER(?)");
        preparedStatement.setString(1, "123");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "123");
        statement.executeUpdate("CREATE FUNCTION BIGINT_P_LONG(VARCHAR(10)) RETURNS BIGINT EXTERNAL NAME 'java.lang.Long.parseLong' LANGUAGE JAVA PARAMETER STYLE JAVA");
        preparedStatement = this.prepareStatement("VALUES BIGINT_P_LONG(?)");
        preparedStatement.setString(1, "123");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "123");
        statement.executeUpdate("CREATE FUNCTION BIGINT_O_LONG(VARCHAR(10)) RETURNS BIGINT EXTERNAL NAME 'java.lang.Long.valueOf' LANGUAGE JAVA PARAMETER STYLE JAVA");
        preparedStatement = this.prepareStatement("VALUES BIGINT_O_LONG(?)");
        preparedStatement.setString(1, "123");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "123");
        statement.executeUpdate("CREATE FUNCTION REAL_P_FLOAT(VARCHAR(10)) RETURNS REAL EXTERNAL NAME 'java.lang.Float.parseFloat' LANGUAGE JAVA PARAMETER STYLE JAVA");
        preparedStatement = this.prepareStatement("VALUES REAL_P_FLOAT(?)");
        preparedStatement.setString(1, "123.0");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "123.0");
        statement.executeUpdate("CREATE FUNCTION REAL_O_FLOAT(VARCHAR(10)) RETURNS REAL EXTERNAL NAME 'java.lang.Float.valueOf' LANGUAGE JAVA PARAMETER STYLE JAVA");
        preparedStatement = this.prepareStatement("VALUES REAL_O_FLOAT(?)");
        preparedStatement.setString(1, "123.0");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "123.0");
        statement.executeUpdate("CREATE FUNCTION DOUBLE_P_DOUBLE(VARCHAR(10)) RETURNS DOUBLE EXTERNAL NAME 'java.lang.Double.parseDouble' LANGUAGE JAVA PARAMETER STYLE JAVA");
        preparedStatement = this.prepareStatement("VALUES DOUBLE_P_DOUBLE(?)");
        preparedStatement.setString(1, "123.0");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "123.0");
        statement.executeUpdate("CREATE FUNCTION DOUBLE_O_DOUBLE(VARCHAR(10)) RETURNS DOUBLE EXTERNAL NAME 'java.lang.Double.valueOf' LANGUAGE JAVA PARAMETER STYLE JAVA");
        preparedStatement = this.prepareStatement("VALUES DOUBLE_O_DOUBLE(?)");
        preparedStatement.setString(1, "123.0");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "123.0");
        preparedStatement.close();
        statement.close();
    }

    public void testFunctionReturnsNullOnNullInput() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE FUNCTION SMALLINT_P_SHORT_RN(VARCHAR(10)) RETURNS SMALLINT EXTERNAL NAME 'java.lang.Short.parseShort' LANGUAGE JAVA PARAMETER STYLE JAVA RETURNS NULL ON NULL INPUT");
        PreparedStatement preparedStatement = this.prepareStatement("VALUES SMALLINT_P_SHORT_RN(?)");
        preparedStatement.setString(1, "123");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "123");
        preparedStatement.setString(1, null);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        statement.executeUpdate("CREATE FUNCTION SMALLINT_O_INTEGER_RN(VARCHAR(10)) RETURNS SMALLINT EXTERNAL NAME 'java.lang.Integer.valueOf' LANGUAGE JAVA PARAMETER STYLE JAVA RETURNS NULL ON NULL INPUT");
        preparedStatement = this.prepareStatement("VALUES SMALLINT_O_INTEGER_RN(?)");
        preparedStatement.setString(1, "123");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "123");
        preparedStatement.setString(1, null);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        statement.executeUpdate("CREATE FUNCTION INTEGER_P_INT_RN(VARCHAR(10)) RETURNS INTEGER EXTERNAL NAME 'java.lang.Integer.parseInt' LANGUAGE JAVA PARAMETER STYLE JAVA RETURNS NULL ON NULL INPUT");
        preparedStatement = this.prepareStatement("VALUES INTEGER_P_INT_RN(?)");
        preparedStatement.setString(1, "123");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "123");
        statement.executeUpdate("CREATE FUNCTION INTEGER_O_INTEGER_RN(VARCHAR(10)) RETURNS INTEGER EXTERNAL NAME 'java.lang.Integer.valueOf' LANGUAGE JAVA PARAMETER STYLE JAVA RETURNS NULL ON NULL INPUT");
        preparedStatement = this.prepareStatement("VALUES INTEGER_O_INTEGER_RN(?)");
        preparedStatement.setString(1, "123");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "123");
        preparedStatement.setString(1, null);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        statement.executeUpdate("CREATE FUNCTION BIGINT_P_LONG_RN(VARCHAR(10)) RETURNS BIGINT EXTERNAL NAME 'java.lang.Long.parseLong' LANGUAGE JAVA PARAMETER STYLE JAVA RETURNS NULL ON NULL INPUT");
        preparedStatement = this.prepareStatement("VALUES BIGINT_P_LONG_RN(?)");
        preparedStatement.setString(1, "123");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "123");
        preparedStatement.setString(1, null);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        statement.executeUpdate("CREATE FUNCTION BIGINT_O_LONG_NR(VARCHAR(10)) RETURNS BIGINT EXTERNAL NAME 'java.lang.Long.valueOf' LANGUAGE JAVA PARAMETER STYLE JAVA RETURNS NULL ON NULL INPUT");
        preparedStatement = this.prepareStatement("VALUES BIGINT_O_LONG_NR(?)");
        preparedStatement.setString(1, "123");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "123");
        preparedStatement.setString(1, null);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        statement.executeUpdate("CREATE FUNCTION REAL_P_FLOAT_NR(VARCHAR(10)) RETURNS REAL EXTERNAL NAME 'java.lang.Float.parseFloat' LANGUAGE JAVA PARAMETER STYLE JAVA RETURNS NULL ON NULL INPUT");
        preparedStatement = this.prepareStatement("VALUES REAL_P_FLOAT_NR(?)");
        preparedStatement.setString(1, "123.0");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "123.0");
        preparedStatement.setString(1, null);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        statement.executeUpdate("CREATE FUNCTION REAL_O_FLOAT_NR(VARCHAR(10)) RETURNS REAL EXTERNAL NAME 'java.lang.Float.valueOf' LANGUAGE JAVA PARAMETER STYLE JAVA RETURNS NULL ON NULL INPUT");
        preparedStatement = this.prepareStatement("VALUES REAL_O_FLOAT_NR(?)");
        preparedStatement.setString(1, "123.0");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "123.0");
        preparedStatement.setString(1, null);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        statement.executeUpdate("CREATE FUNCTION DOUBLE_P_DOUBLE_NR(VARCHAR(10)) RETURNS DOUBLE EXTERNAL NAME 'java.lang.Double.parseDouble' LANGUAGE JAVA PARAMETER STYLE JAVA RETURNS NULL ON NULL INPUT");
        preparedStatement = this.prepareStatement("VALUES DOUBLE_P_DOUBLE_NR(?)");
        preparedStatement.setString(1, "123.0");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "123.0");
        preparedStatement.setString(1, null);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        statement.executeUpdate("CREATE FUNCTION DOUBLE_O_DOUBLE_NR(VARCHAR(10)) RETURNS DOUBLE EXTERNAL NAME 'java.lang.Double.valueOf' LANGUAGE JAVA PARAMETER STYLE JAVA RETURNS NULL ON NULL INPUT");
        preparedStatement = this.prepareStatement("VALUES DOUBLE_O_DOUBLE_NR(?)");
        preparedStatement.setString(1, "123.0");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "123.0");
        preparedStatement.setString(1, null);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        preparedStatement.close();
        statement.close();
    }

    public void testFunctionNullHandling() throws SQLException, UnsupportedEncodingException {
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE FUNCTION SV_NOCALL(INTEGER) RETURNS VARCHAR(10) RETURNS NULL ON NULL INPUT EXTERNAL NAME 'java.lang.String.valueOf'  LANGUAGE JAVA PARAMETER STYLE JAVA");
        statement.executeUpdate("CREATE FUNCTION SV_CALL(INTEGER) RETURNS VARCHAR(10) CALLED ON NULL INPUT EXTERNAL NAME 'java.lang.String.valueOf' LANGUAGE JAVA PARAMETER STYLE JAVA");
        statement.executeUpdate("CREATE FUNCTION SV_DEFAULT(INTEGER) RETURNS VARCHAR(10) EXTERNAL NAME 'java.lang.String.valueOf' LANGUAGE JAVA PARAMETER STYLE JAVA");
        PreparedStatement preparedStatement = this.prepareStatement("VALUES SV_NOCALL(?)");
        preparedStatement.setInt(1, 42);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "42");
        preparedStatement.setNull(1, 4);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        preparedStatement.close();
        preparedStatement = this.prepareStatement("VALUES SV_CALL(?)");
        preparedStatement.setInt(1, 52);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "52");
        preparedStatement.setNull(1, 4);
        RoutineTest.assertStatementError(CANNOT_STUFF_NULL_INTO_PRIMITIVE, preparedStatement);
        preparedStatement.close();
        preparedStatement = this.prepareStatement("VALUES SV_DEFAULT(?)");
        preparedStatement.setInt(1, 62);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "62");
        preparedStatement.setNull(1, 4);
        RoutineTest.assertStatementError(CANNOT_STUFF_NULL_INTO_PRIMITIVE, preparedStatement);
        preparedStatement.close();
        statement.executeUpdate("CREATE FUNCTION CONCAT_NOCALL(VARCHAR(10), VARCHAR(10)) RETURNS VARCHAR(20) RETURNS NULL ON NULL INPUT EXTERNAL NAME '" + RoutineTest.class.getName() + ".concat'  LANGUAGE JAVA PARAMETER STYLE JAVA");
        statement.executeUpdate("CREATE FUNCTION CONCAT_CALL(VARCHAR(10), VARCHAR(10)) RETURNS VARCHAR(20) CALLED ON NULL INPUT EXTERNAL NAME '" + RoutineTest.class.getName() + ".concat'  LANGUAGE JAVA PARAMETER STYLE JAVA");
        preparedStatement = this.prepareStatement("VALUES CONCAT_NOCALL(?, ?)");
        preparedStatement.setString(1, "good");
        preparedStatement.setString(2, "bye");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "goodbye");
        preparedStatement.setString(1, null);
        preparedStatement.setString(2, "bye");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        preparedStatement.setString(1, "good");
        preparedStatement.setString(2, null);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        preparedStatement.setString(1, null);
        preparedStatement.setString(2, null);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        preparedStatement.close();
        preparedStatement = this.prepareStatement("VALUES CONCAT_CALL(?, ?)");
        preparedStatement.setString(1, "good");
        preparedStatement.setString(2, "bye");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "goodbye");
        preparedStatement.setString(1, null);
        preparedStatement.setString(2, "bye");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "s1NULLbye");
        preparedStatement.setString(1, "good");
        preparedStatement.setString(2, null);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "goods2NULL");
        preparedStatement.setString(1, null);
        preparedStatement.setString(2, null);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "s1NULLs2NULL");
        preparedStatement.close();
        preparedStatement = this.prepareStatement("VALUES CONCAT_NOCALL(CONCAT_NOCALL(?, 'RNNI'), CONCAT_CALL(?, 'CONI'))");
        preparedStatement.setString(1, "p1");
        preparedStatement.setString(2, "p2");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "p1RNNIp2CONI");
        preparedStatement.setString(1, null);
        preparedStatement.setString(2, "p2");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        preparedStatement.setString(1, "p1");
        preparedStatement.setString(2, null);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "p1RNNIs1NULLCONI");
        preparedStatement.setString(1, null);
        preparedStatement.setString(2, null);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        preparedStatement.close();
        preparedStatement = this.prepareStatement("VALUES CONCAT_CALL(CONCAT_NOCALL(?, 'RNNI'), CONCAT_CALL(?, 'CONI'))");
        preparedStatement.setString(1, "p1");
        preparedStatement.setString(2, "p2");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "p1RNNIp2CONI");
        preparedStatement.setString(1, null);
        preparedStatement.setString(2, "p2");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "s1NULLp2CONI");
        preparedStatement.setString(1, "p1");
        preparedStatement.setString(2, null);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "p1RNNIs1NULLCONI");
        preparedStatement.setString(1, null);
        preparedStatement.setString(2, null);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "s1NULLs1NULLCONI");
        preparedStatement.close();
        statement.executeUpdate("CREATE FUNCTION SAME_NOCALL(INTEGER) RETURNS INTEGER RETURNS NULL ON NULL INPUT EXTERNAL NAME '" + RoutineTest.class.getName() + ".same'  LANGUAGE JAVA PARAMETER STYLE JAVA");
        statement.executeUpdate("CREATE FUNCTION SAME_CALL(INTEGER) RETURNS INTEGER CALLED ON NULL INPUT EXTERNAL NAME '" + RoutineTest.class.getName() + ".same'  LANGUAGE JAVA PARAMETER STYLE JAVA");
        preparedStatement = this.prepareStatement("VALUES SAME_NOCALL(SAME_NOCALL(?))");
        preparedStatement.setInt(1, 41);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "41");
        preparedStatement.setNull(1, 4);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        preparedStatement.close();
        preparedStatement = this.prepareStatement("VALUES SAME_NOCALL(SAME_CALL(?))");
        preparedStatement.setInt(1, 47);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "47");
        preparedStatement.setNull(1, 4);
        RoutineTest.assertStatementError(CANNOT_STUFF_NULL_INTO_PRIMITIVE, preparedStatement);
        preparedStatement.close();
        preparedStatement = this.prepareStatement("VALUES SAME_CALL(SAME_NOCALL(?))");
        preparedStatement.setInt(1, 41);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "41");
        preparedStatement.setNull(1, 4);
        RoutineTest.assertStatementError(CANNOT_STUFF_NULL_INTO_PRIMITIVE, preparedStatement);
        preparedStatement.close();
        preparedStatement = this.prepareStatement("VALUES SAME_CALL(SAME_CALL(?))");
        preparedStatement.setInt(1, 53);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "53");
        preparedStatement.setNull(1, 4);
        RoutineTest.assertStatementError(CANNOT_STUFF_NULL_INTO_PRIMITIVE, preparedStatement);
        preparedStatement.close();
        statement.executeUpdate("CREATE FUNCTION NOON_NOCALL(TIME) RETURNS TIME RETURNS NULL ON NULL INPUT EXTERNAL NAME '" + RoutineTest.class.getName() + ".nullAtNoon'  LANGUAGE JAVA PARAMETER STYLE JAVA");
        statement.executeUpdate("CREATE FUNCTION NOON_CALL(TIME) RETURNS TIME CALLED ON NULL INPUT EXTERNAL NAME '" + RoutineTest.class.getName() + ".nullAtNoon'  LANGUAGE JAVA PARAMETER STYLE JAVA");
        Time time = Time.valueOf("12:00:00");
        Time time2 = Time.valueOf("15:30:00");
        preparedStatement = this.prepareStatement("VALUES NOON_NOCALL(?)");
        preparedStatement.setTime(1, time2);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), time2.toString());
        preparedStatement.setTime(1, time);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        preparedStatement.setTime(1, null);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        preparedStatement.close();
        preparedStatement = this.prepareStatement("VALUES NOON_CALL(?)");
        preparedStatement.setTime(1, time2);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), time2.toString());
        preparedStatement.setTime(1, time);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        preparedStatement.setTime(1, null);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "11:00:00");
        preparedStatement.close();
        preparedStatement = this.prepareStatement("VALUES NOON_NOCALL(NOON_NOCALL(?))");
        preparedStatement.setTime(1, time2);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), time2.toString());
        preparedStatement.setTime(1, time);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        preparedStatement.setTime(1, null);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        preparedStatement.close();
        preparedStatement = this.prepareStatement("VALUES NOON_NOCALL(NOON_CALL(?))");
        preparedStatement.setTime(1, time2);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), time2.toString());
        preparedStatement.setTime(1, time);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        preparedStatement.setTime(1, null);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "11:30:00");
        preparedStatement.close();
        preparedStatement = this.prepareStatement("VALUES NOON_CALL(NOON_NOCALL(?))");
        preparedStatement.setTime(1, time2);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), time2.toString());
        preparedStatement.setTime(1, time);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "11:00:00");
        preparedStatement.setTime(1, null);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "11:00:00");
        preparedStatement.close();
        preparedStatement = this.prepareStatement("VALUES NOON_CALL(NOON_CALL(?))");
        preparedStatement.setTime(1, time2);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), time2.toString());
        preparedStatement.setTime(1, time);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "11:00:00");
        preparedStatement.setTime(1, null);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "11:30:00");
        preparedStatement.close();
        statement.close();
    }

    public void testAggregateArgument() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE TABLE TEST (I INT)");
        statement.executeUpdate("INSERT INTO TEST VALUES(1)");
        statement.executeUpdate("INSERT INTO TEST VALUES(2)");
        statement.executeUpdate("CREATE FUNCTION CheckCount(count integer) RETURNS INTEGER PARAMETER STYLE JAVA NO SQL LANGUAGE JAVA EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.lang.RoutineTest.checkCount'");
        ResultSet resultSet = statement.executeQuery("select checkCount(count(*)) from test");
        JDBC.assertSingleValueResultSet(resultSet, "2");
    }

    public void test_4459() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("create function getNullInt() returns int language java parameter style java\nexternal name '" + RoutineTest.class.getName() + ".getNullInt'");
        statement.executeUpdate("create function negateInt( a int ) returns int language java parameter style java\nexternal name '" + RoutineTest.class.getName() + ".negateInt'");
        RoutineTest.assertStatementError(CANNOT_STUFF_NULL_INTO_PRIMITIVE, statement, "values( negateInt( cast( null as int) ) )");
        RoutineTest.assertStatementError(CANNOT_STUFF_NULL_INTO_PRIMITIVE, statement, "values( negateInt( getNullInt() ) )");
    }

    public void test_5749() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t5749(v varchar(5))");
        statement.executeUpdate("create procedure p5749 (a varchar(5)) modifies sql data external name '" + RoutineTest.class.getName() + ".p5749' language java parameter style java");
        CallableStatement callableStatement = this.prepareCall("call p5749(?)");
        callableStatement.setString(1, "123456");
        try {
            callableStatement.execute();
            RoutineTest.fail();
        }
        catch (SQLException sQLException) {
            RoutineTest.assertSQLState("22001", sQLException);
        }
        try {
            statement.executeUpdate("call p5749('123456')");
            RoutineTest.fail();
        }
        catch (SQLException sQLException) {
            RoutineTest.assertSQLState("22001", sQLException);
        }
        PreparedStatement preparedStatement = this.prepareStatement("insert into t5749 values(?)");
        preparedStatement.setString(1, "123456");
        try {
            preparedStatement.execute();
            RoutineTest.fail();
        }
        catch (SQLException sQLException) {
            RoutineTest.assertSQLState("22001", sQLException);
        }
    }

    public void test_6511() throws Exception {
        Connection connection = this.getConnection();
        this.vet_6511(connection, "boolean", "booleanpToBoolean", "booleanToBooleanp", "true");
        this.vet_6511(connection, "int", "intToInteger", "integerToInt", "1");
        this.vet_6511(connection, "bigint", "longpToLong", "longToLongp", "1");
        this.vet_6511(connection, "smallint", "shortpToInteger", "integerToShortp", "1");
        this.vet_6511(connection, "double", "doublepToDouble", "doubleToDoublep", "1.0");
        this.vet_6511(connection, "real", "floatpToFloat", "floatToFloatp", "1.0");
    }

    private void vet_6511(Connection connection, String string, String string2, String string3, String string4) throws Exception {
        this.createFunction_6511(connection, string, string2);
        this.createFunction_6511(connection, string, string3);
        this.vetChaining_6511(connection, string2, string2, string4);
        this.vetChaining_6511(connection, string2, string3, string4);
        this.vetChaining_6511(connection, string3, string2, string4);
        this.vetChaining_6511(connection, string3, string3, string4);
        this.dropFunction_6511(connection, string2);
        this.dropFunction_6511(connection, string3);
    }

    private void createFunction_6511(Connection connection, String string, String string2) throws Exception {
        this.goodStatement(connection, "create function " + string2 + "( val " + string + " ) returns " + string + "\nlanguage java parameter style java deterministic no sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + "." + string2 + "'");
    }

    private void dropFunction_6511(Connection connection, String string) throws Exception {
        this.goodStatement(connection, "drop function " + string);
    }

    private void vetChaining_6511(Connection connection, String string, String string2, String string3) throws Exception {
        this.assertResults(connection, "values " + string2 + "( " + string + "( " + string3 + " ) )", new String[][]{{string3}}, false);
    }

    public static String concat(String string, String string2) {
        if (string == null) {
            string = "s1NULL";
        }
        if (string2 == null) {
            string2 = "s2NULL";
        }
        return string.concat(string2);
    }

    public static int same(int n) {
        return n;
    }

    public static Time nullAtNoon(Time time) {
        if (time == null) {
            return Time.valueOf("11:00:00");
        }
        String string = time.toString();
        if ("11:00:00".equals(string)) {
            return Time.valueOf("11:30:00");
        }
        if ("12:00:00".equals(string)) {
            return null;
        }
        return time;
    }

    public static int checkCount(int n) throws SQLException {
        if (n == 0) {
            throw new SQLException("No results found", "38777");
        }
        return n;
    }

    public static int negateInt(int n) {
        return -n;
    }

    public static Integer getNullInt() {
        return null;
    }

    public static void p5749(String string) {
    }

    public static Boolean booleanpToBoolean(boolean bl) {
        return bl;
    }

    public static boolean booleanToBooleanp(Boolean bl) throws Exception {
        if (bl == null) {
            throw new Exception("This method does not allow nulls!");
        }
        return bl;
    }

    public static Integer intToInteger(int n) {
        return n;
    }

    public static int integerToInt(Integer n) throws Exception {
        if (n == null) {
            throw new Exception("This method does not allow nulls!");
        }
        return n;
    }

    public static Long longpToLong(long l) {
        return l;
    }

    public static long longToLongp(Long l) throws Exception {
        if (l == null) {
            throw new Exception("This method does not allow nulls!");
        }
        return l;
    }

    public static Integer shortpToInteger(short s) {
        return s;
    }

    public static short integerToShortp(Integer n) throws Exception {
        if (n == null) {
            throw new Exception("This method does not allow nulls!");
        }
        return n.shortValue();
    }

    public static Float floatpToFloat(float f) {
        return Float.valueOf(f);
    }

    public static float floatToFloatp(Float f) throws Exception {
        if (f == null) {
            throw new Exception("This method does not allow nulls!");
        }
        return f.floatValue();
    }

    public static Double doublepToDouble(double d) {
        return d;
    }

    public static double doubleToDoublep(Double d) throws Exception {
        if (d == null) {
            throw new Exception("This method does not allow nulls!");
        }
        return d;
    }
}

