/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.store.AutomaticIndexStatisticsTest;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Derby5582AutomaticIndexStatisticsTest
extends AutomaticIndexStatisticsTest {
    private static final String PRIVTGNAME = "privtg";

    public Derby5582AutomaticIndexStatisticsTest(String string) {
        super(string);
    }

    public void testDerby5582() throws InterruptedException {
        ThreadGroup threadGroup = new ThreadGroup(PRIVTGNAME);
        Derby5582Runner derby5582Runner = new Derby5582Runner();
        Thread thread = new Thread(threadGroup, derby5582Runner, "runner-thread");
        thread.start();
        thread.join();
        Exception exception = derby5582Runner.getSavedError();
        if (exception != null) {
            Derby5582AutomaticIndexStatisticsTest.fail(exception.getMessage(), exception);
        }
    }

    public static Test suite() {
        Derby5582AutomaticIndexStatisticsTest derby5582AutomaticIndexStatisticsTest = new Derby5582AutomaticIndexStatisticsTest("testDerby5582");
        Derby5582SecurityManager derby5582SecurityManager = new Derby5582SecurityManager();
        return TestConfiguration.additionalDatabaseDecorator((Test)new SecurityManagerSetup((Test)derby5582AutomaticIndexStatisticsTest, null, derby5582SecurityManager), "masterDb");
    }

    public class Derby5582Runner
    implements Runnable {
        private Exception savedError = null;

        @Override
        public void run() {
            try {
                Derby5582AutomaticIndexStatisticsTest.this.testStatsUpdatedOnGrowth();
            }
            catch (SQLException sQLException) {
                this.savedError = sQLException;
            }
        }

        public Exception getSavedError() {
            return this.savedError;
        }
    }

    public static class Derby5582SecurityManager
    extends SecurityManager {
        @Override
        public void checkAccess(ThreadGroup threadGroup) {
            ThreadGroup threadGroup2 = Thread.currentThread().getThreadGroup();
            if (threadGroup.getName().equals(Derby5582AutomaticIndexStatisticsTest.PRIVTGNAME) && !threadGroup2.getName().equals("main")) {
                throw new SecurityException("No permission to private ThreadGroup privtg");
            }
            super.checkAccess(threadGroup);
        }
    }
}

