/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.tools;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;

public class SysinfoLocaleTest
extends BaseTestCase {
    private static final String SYSINFO_CLASS_NAME = "org.apache.derby.tools.sysinfo";
    private static final String ENCODING = "UTF-8";
    private final Locale defaultLocale;
    private final Properties _props;
    private final boolean localizedToGerman;
    private final String name;
    private Locale savedLocale;
    private static final String[] GERMAN_STRINGS = new String[]{"BS-Name", "Java-Benutzername", "Derby-Informationen", "Informationen zum Gebietsschema"};
    private static final String[] ITALIAN_STRINGS = new String[]{"Nome SO", "Home utente Java", "Informazioni su Derby", "Informazioni sulle impostazioni nazionali"};

    private SysinfoLocaleTest(Locale locale, boolean bl, String string, Properties properties) {
        super("testSysinfoLocale");
        this.defaultLocale = locale;
        this.localizedToGerman = bl;
        this._props = properties;
        this.name = super.getName() + ":" + string;
    }

    public String getName() {
        return this.name;
    }

    protected void setUp() {
        this.savedLocale = Locale.getDefault();
        Locale.setDefault(this.defaultLocale);
    }

    protected void tearDown() throws Exception {
        Locale.setDefault(this.savedLocale);
        this.savedLocale = null;
        super.tearDown();
    }

    public static Test suite() {
        if (!Derby.hasTools()) {
            return new BaseTestSuite("empty: no tools support");
        }
        BaseTestSuite baseTestSuite = new BaseTestSuite("SysinfoLocaleTest");
        baseTestSuite.addTest(SysinfoLocaleTest.createTest(Locale.ITALY, null, false));
        baseTestSuite.addTest(SysinfoLocaleTest.createTest(Locale.ITALY, "it_IT", false));
        baseTestSuite.addTest(SysinfoLocaleTest.createTest(Locale.ITALY, "de_DE", true));
        baseTestSuite.addTest(SysinfoLocaleTest.createTest(Locale.GERMANY, null, true));
        baseTestSuite.addTest(SysinfoLocaleTest.createTest(Locale.GERMANY, "it_IT", false));
        baseTestSuite.addTest(SysinfoLocaleTest.createTest(Locale.GERMANY, "de_DE", true));
        return SecurityManagerSetup.noSecurityManager((Test)baseTestSuite);
    }

    private static Test createTest(Locale locale, String string, boolean bl) {
        Properties properties = new Properties();
        if (string != null) {
            properties.setProperty("derby.ui.locale", string);
        }
        properties.setProperty("derby.ui.codeset", ENCODING);
        String string2 = "defaultLocale=" + locale + ",uiLocale=" + string;
        SysinfoLocaleTest sysinfoLocaleTest = new SysinfoLocaleTest(locale, bl, string2, properties);
        return new SystemPropertyTestSetup((Test)sysinfoLocaleTest, properties);
    }

    private static void runSysinfo() throws Exception {
        URL uRL = SecurityManagerSetup.getURL(SYSINFO_CLASS_NAME);
        URL uRL2 = SysinfoLocaleTest.getEmmaJar();
        URL[] uRLArray = null;
        uRLArray = uRL2 != null ? new URL[]{uRL, uRL2} : new URL[]{uRL};
        ClassLoader classLoader = Connection.class.getClassLoader();
        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, classLoader);
        Class<?> clazz = Class.forName(SYSINFO_CLASS_NAME, true, uRLClassLoader);
        Method method = clazz.getMethod("main", String[].class);
        method.invoke(null, new Object[]{new String[0]});
    }

    private static String getSysinfoOutput() throws Exception {
        PrintStream printStream = System.out;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            System.setOut(new PrintStream((OutputStream)byteArrayOutputStream, true, ENCODING));
            SysinfoLocaleTest.runSysinfo();
        }
        finally {
            System.setOut(printStream);
        }
        return byteArrayOutputStream.toString(ENCODING);
    }

    private String getSysinfoOutputWithModules() throws Exception {
        String string;
        Object object2;
        String string2;
        String string3 = JVMInfo.getSystemModulePath();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string4 = this.defaultLocale.getCountry();
        if (string4 != null && string4.length() > 0) {
            arrayList.add("-Duser.country=" + string4);
        }
        if ((string2 = this.defaultLocale.getLanguage()) != null && string2.length() > 0) {
            arrayList.add("-Duser.language=" + string2);
        }
        for (Object object2 : this._props.keySet()) {
            string = (String)object2;
            String string5 = this._props.getProperty(string);
            arrayList.add("-D" + object2 + "=" + string5);
        }
        arrayList.add("-m");
        arrayList.add("org.apache.derby.tools/org.apache.derby.tools.sysinfo");
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        object2 = BaseTestCase.execJavaCmd(null, string3, stringArray, null, true, true);
        string = SysinfoLocaleTest.readProcessOutput((Process)object2);
        return string;
    }

    private void assertContains(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string.indexOf(string2) != -1) continue;
            SysinfoLocaleTest.fail((String)("Substring '" + string2 + "' not found in output: " + string));
        }
    }

    public void testSysinfoLocale() throws Exception {
        String string = JVMInfo.isModuleAware() ? this.getSysinfoOutputWithModules() : SysinfoLocaleTest.getSysinfoOutput();
        String[] stringArray = this.localizedToGerman ? GERMAN_STRINGS : ITALIAN_STRINGS;
        this.assertContains(stringArray, string);
    }
}

