/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Properties;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.DatabaseMetaDataTest;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.AdditionalDb;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.BasicSetup;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Changes10_1;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Changes10_10;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Changes10_11;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Changes10_12;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Changes10_13;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Changes10_14;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Changes10_2;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Changes10_3;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Changes10_4;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Changes10_5;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Changes10_6;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Changes10_7;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Changes10_9;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.PhaseChanger;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeChange;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeClassLoader;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Version;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

class UpgradeRun
extends UpgradeClassLoader {
    private static final String QUOTE = "\"";
    static final AdditionalDb[] ADDITIONAL_DBS = new AdditionalDb[]{new AdditionalDb("COLLATED_DB_10_3", true), new AdditionalDb("NO_ENCRYPT_10_2", true), new AdditionalDb("ENCRYPT_10_2", true), new AdditionalDb("ROLES_10_5", false), new AdditionalDb("BUILTIN_10_9", false), new AdditionalDb("DERBY-4753", true)};

    UpgradeRun() {
    }

    public static Test suite(int[] nArray, boolean bl) {
        ClassLoader classLoader = UpgradeRun.makeClassLoader(nArray);
        if (classLoader == null) {
            BaseTestSuite baseTestSuite = new BaseTestSuite("Empty: Skipped upgrade Tests (no jars) for " + UpgradeRun.getTextVersion(nArray));
            return baseTestSuite;
        }
        if (JVMInfo.isModuleAware() && UpgradeRun.lessThan(nArray, new int[]{10, 2, 2, 0})) {
            BaseTestSuite baseTestSuite = new BaseTestSuite("Empty: Skipped upgrade Tests (cannot use module path for " + UpgradeRun.getTextVersion(nArray) + " because it comes before before 10.2.2.0).");
            return baseTestSuite;
        }
        BaseTestSuite baseTestSuite = new BaseTestSuite("Upgrade Tests from " + UpgradeRun.getTextVersion(nArray));
        BaseTestCase.traceit("Prepare to run upgrade tests from " + UpgradeRun.getTextVersion(nArray));
        for (int i = 0; i < UpgradeChange.PHASES.length; ++i) {
            ClassLoader classLoader2 = null;
            boolean bl2 = false;
            switch (i) {
                case 0: 
                case 2: 
                case 4: {
                    classLoader2 = classLoader;
                    bl2 = true;
                    break;
                }
            }
            String string = UpgradeRun.getTextVersion(nArray) + " Upgrade Phase: " + UpgradeChange.PHASES[i] + " ";
            Test test = UpgradeRun.baseSuite(string, i, nArray);
            PhaseChanger phaseChanger = new PhaseChanger(test, i, classLoader2, nArray, bl);
            phaseChanger = UpgradeRun.handleJavaSE6(i, nArray, (Test)phaseChanger);
            Test test2 = UpgradeRun.adjustForModules((Test)phaseChanger, nArray, bl2, classLoader);
            baseTestSuite.addTest(test2);
        }
        TestSetup testSetup = TestConfiguration.singleUseDatabaseDecorator((Test)baseTestSuite);
        for (int i = 0; i < ADDITIONAL_DBS.length; ++i) {
            testSetup = UpgradeRun.ADDITIONAL_DBS[i].shutDown ? TestConfiguration.additionalDatabaseDecorator((Test)testSetup, UpgradeRun.ADDITIONAL_DBS[i].logicalName) : TestConfiguration.additionalDatabaseDecoratorNoShutdown((Test)testSetup, UpgradeRun.ADDITIONAL_DBS[i].logicalName);
        }
        Properties properties = new Properties();
        properties.setProperty("derby.database.allowPreReleaseUpgrade", "true");
        testSetup = new SystemPropertyTestSetup((Test)testSetup, properties);
        return SecurityManagerSetup.noSecurityManager((Test)testSetup);
    }

    private static Test adjustForModules(Test test, int[] nArray, boolean bl, ClassLoader classLoader) {
        if (!JVMInfo.isModuleAware()) {
            return test;
        }
        if (!bl) {
            return test;
        }
        Version version = new Version(nArray);
        URLClassLoader uRLClassLoader = (URLClassLoader)classLoader.getParent();
        URL[] uRLArray = uRLClassLoader.getURLs();
        int n = uRLArray.length;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(File.pathSeparator);
            }
            stringBuilder.append(uRLArray[i].toString());
        }
        String string = stringBuilder.toString();
        String[] stringArray = new String[]{"derby.system.home=system", "derby.database.allowPreReleaseUpgrade=true"};
        ArrayList<String> arrayList = new ArrayList<String>();
        if (version.compareTo(Version.V_10_3_0_0) >= 0) {
            arrayList.add("-noSecurityManager");
        }
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        return TestConfiguration.clientServerDecorator(test, stringArray, stringArray2, true, string, false, true);
    }

    private static Test baseSuite(String string, int n, int[] nArray) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        int n2 = nArray[0];
        int n3 = nArray[1];
        if (n != 4) {
            baseTestSuite.addTest(BasicSetup.suite());
            if (n2 == 10) {
                if (n3 < 1) {
                    baseTestSuite.addTest(Changes10_1.suite());
                }
                if (n3 < 2) {
                    baseTestSuite.addTest(Changes10_2.suite());
                }
                if (n3 < 3) {
                    baseTestSuite.addTest(Changes10_3.suite(n));
                }
                if (n3 < 4) {
                    baseTestSuite.addTest(Changes10_4.suite(n));
                }
                if (n3 < 5) {
                    baseTestSuite.addTest(Changes10_5.suite(n));
                }
                if (n3 < 6) {
                    baseTestSuite.addTest(Changes10_6.suite(n));
                }
                if (n3 < 7) {
                    baseTestSuite.addTest(Changes10_7.suite(n));
                }
                if (n3 < 9) {
                    baseTestSuite.addTest(Changes10_9.suite(n));
                }
                if (n3 < 10) {
                    baseTestSuite.addTest(Changes10_10.suite(n));
                }
                if (n3 < 11) {
                    baseTestSuite.addTest(Changes10_11.suite(n));
                }
                if (n3 < 12) {
                    baseTestSuite.addTest(Changes10_12.suite(n));
                }
                if (n3 < 13) {
                    baseTestSuite.addTest(Changes10_13.suite(n));
                }
                if (n3 < 14) {
                    baseTestSuite.addTest(Changes10_14.suite(n));
                }
            }
            switch (n) {
                case 0: {
                    break;
                }
                case 2: {
                    break;
                }
                case 1: 
                case 3: {
                    UpgradeRun.runDataBaseMetaDataTest(baseTestSuite, n3);
                }
            }
        } else {
            baseTestSuite.addTest((Test)new BasicSetup("noConnectionAfterHardUpgrade"));
        }
        if (n == 1 && UpgradeRun.suffersFromDerby4835or5289(nArray)) {
            baseTestSuite.addTest((Test)new BasicSetup("dropAllTriggerPlans"));
        }
        return TestConfiguration.connectionDSDecorator((Test)baseTestSuite);
    }

    private static boolean suffersFromDerby4835or5289(int[] nArray) {
        return UpgradeRun.lessThan(new int[]{10, 5, 0, 0}, nArray) && UpgradeRun.lessThan(nArray, new int[]{10, 5, 3, 2}) || UpgradeRun.lessThan(new int[]{10, 6, 0, 0}, nArray) && UpgradeRun.lessThan(nArray, new int[]{10, 6, 2, 3}) || UpgradeRun.lessThan(new int[]{10, 7, 0, 0}, nArray) && UpgradeRun.lessThan(nArray, new int[]{10, 7, 1, 4}) || UpgradeRun.lessThan(new int[]{10, 8, 0, 0}, nArray) && UpgradeRun.lessThan(nArray, new int[]{10, 8, 2, 2});
    }

    static boolean lessThan(int[] nArray, int[] nArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < nArray2[i]) {
                return true;
            }
            if (nArray[i] <= nArray2[i]) continue;
            return false;
        }
        return false;
    }

    private static Test handleJavaSE6(int n, int[] nArray, Test test) {
        boolean bl = false;
        switch (n) {
            case 0: 
            case 2: {
                if (nArray[0] != 10 || nArray[1] >= 3 || nArray[1] >= 2 && nArray[2] >= 2) break;
                bl = true;
                break;
            }
        }
        if (bl) {
            return TestConfiguration.forceJDBC3Embedded(test);
        }
        return test;
    }

    private static void runDataBaseMetaDataTest(BaseTestSuite baseTestSuite, int n) {
        BaseTestSuite baseTestSuite2 = new BaseTestSuite("DatabaseMetaData subsuite");
        Method[] methodArray = DatabaseMetaDataTest.class.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            String string;
            Method method = methodArray[i];
            if (method.getParameterTypes().length > 0 || !method.getReturnType().equals(Void.TYPE) || !(string = method.getName()).startsWith("test") || string.equals("testGetTablesModify") && n < 1 || string.equals("testGetTablePrivileges") && n < 2 || string.equals("testGetColumnPrivileges") && n < 2) continue;
            baseTestSuite2.addTest((Test)new DatabaseMetaDataTest(string));
        }
        baseTestSuite.addTest(TestConfiguration.changeUserDecorator((Test)baseTestSuite2, "DMDT", "DMDT"));
    }
}

