/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derby.client.ClientConnectionPoolDataSourceInterface;
import org.apache.derby.client.ClientXADataSourceInterface;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.AssertEventCatcher;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.cdsXid;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.functionTests.util.SecurityCheck;
import org.apache.derbyTesting.functionTests.util.TestRoutines;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCClient;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class J2EEDataSourceTest
extends BaseJDBCTestCase {
    private static final String dbName = TestConfiguration.getCurrent().getDefaultDatabaseName();
    protected static Hashtable<String, Connection> conns = new Hashtable();
    private static final String CONNSTRING_FORMAT = "\\S+@\\-?[0-9]+.* \\(XID = .*\\), \\(SESSIONID = [0-9]+\\), \\(DATABASE = [A-Za-z]+\\), \\(DRDAID = .*\\) ";
    private final Object nogc = SecurityCheck.class;

    public J2EEDataSourceTest(String string) {
        super(string);
    }

    private static Test getTimeoutSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Lower lock timeout" + string);
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("timeoutTestDerby1144PooledDS"));
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("timeoutTestDerby1144XADS"));
        return DatabasePropertyTestSetup.setLockTimeouts((Test)baseTestSuite, 3, 5);
    }

    private static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ClientAndEmbedded" + string);
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("testGlobalLocalInterleaf"));
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("testSetIsolationWithStatement"));
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("testJira95pds"));
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("testJira95xads"));
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("testBadConnectionAttributeSyntax"));
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("testCloseActiveConnection_DS"));
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("testCloseActiveConnection_CP"));
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("testCloseActiveConnection_XA_local"));
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("testCloseActiveConnection_XA_global"));
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("testDescriptionProperty"));
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("testConnectionErrorEvent"));
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("testIsolationWithFourConnections"));
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("testConnectionEventListenerIsNull"));
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("testReadOnlyToWritableTran"));
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("testAutoCommitOnXAResourceStart"));
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("testAllDataSources"));
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("testClosedCPDSConnection"));
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("testClosedXADSConnection"));
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("testSetSchemaInXAConnection"));
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("testPooledReuseOnClose"));
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("testSchemaIsReset"));
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("testSchemaIsResetWhenDeleted"));
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("testDerby3799"));
        return baseTestSuite;
    }

    private static Test getClientSuite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Client/Server");
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("testClientDSConnectionAttributes"));
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("testClientTraceFileDSConnectionAttribute"));
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("testClientMessageTextConnectionAttribute"));
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("testConnectionFlowCommit"));
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("testConnectionFlowCommitAlt"));
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("testDerby2026LoginTimeout"));
        return baseTestSuite;
    }

    private static Test getEmbeddedSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Embedded" + string);
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("testDSRequestAuthentication"));
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("testReuseAcrossGlobalLocal"));
        baseTestSuite.addTest((Test)new J2EEDataSourceTest("testXAHoldability"));
        return baseTestSuite;
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            BaseTestSuite baseTestSuite = new BaseTestSuite("J2EEDatasourceTest cannot run with JSR169");
            return baseTestSuite;
        }
        BaseTestSuite baseTestSuite = new BaseTestSuite("J2EEDataSourceTest suite");
        baseTestSuite.addTest(J2EEDataSourceTest.baseSuite(":embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(J2EEDataSourceTest.baseSuite(":client")));
        baseTestSuite.addTest((Test)new SupportFilesSetup(TestConfiguration.clientServerDecorator(J2EEDataSourceTest.getClientSuite())));
        baseTestSuite.addTest(J2EEDataSourceTest.getEmbeddedSuite("embedded"));
        baseTestSuite.addTest(J2EEDataSourceTest.getTimeoutSuite(":embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(J2EEDataSourceTest.getTimeoutSuite(":client")));
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                TestRoutines.installRoutines(this.getConnection());
                statement.executeUpdate("create table autocommitxastart(i int)");
                statement.executeUpdate("insert into autocommitxastart values 1,2,3,4,5");
                statement.executeUpdate("create schema SCHEMA_Patricio");
                statement.executeUpdate("create table SCHEMA_Patricio.Patricio (id VARCHAR(255), value INTEGER)");
                statement.executeUpdate("create table intTable(i int)");
                statement.executeUpdate("create table hold_30 (id int not null primary key, b char(30))");
                statement.executeUpdate("create procedure checkConn2(in dsname varchar(20)) parameter style java language java modifies SQL DATA external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.J2EEDataSourceTest." + J2EEDataSourceTest.getNestedMethodName() + "'");
                statement.execute("create table derby3799 (dClob clob)");
                statement.executeUpdate("insert into derby3799 values ('myLittleTestClob')");
            }
        };
    }

    @Override
    public void tearDown() throws Exception {
        for (int i = 0; i < 6; ++i) {
            String string = "trace" + (i + 1) + ".out";
            File file = new File(string);
            if (!PrivilegedFileOpsForTests.exists(file)) continue;
            PrivilegedFileOpsForTests.delete(file);
        }
        super.tearDown();
    }

    public void testConnectionErrorEvent() throws SQLException, Exception {
        Object object;
        AssertEventCatcher assertEventCatcher = new AssertEventCatcher(12);
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        PooledConnection pooledConnection = connectionPoolDataSource.getPooledConnection();
        pooledConnection.addConnectionEventListener(assertEventCatcher);
        Connection connection = pooledConnection.getConnection();
        J2EEDataSourceTest.dropTable(connection, "TAB1");
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        if (J2EEDataSourceTest.usingEmbedded()) {
            this.getTestConfiguration().shutdownDatabase();
        } else {
            this.getTestConfiguration().stopNetworkServer();
        }
        try {
            connection.prepareStatement("CREATE TABLE TAB1(COL1 INT NOT NULL)");
            J2EEDataSourceTest.fail((String)"SQLException should be thrown!");
        }
        catch (SQLException sQLException) {
            if (J2EEDataSourceTest.usingEmbedded()) {
                J2EEDataSourceTest.assertSQLState("08003", sQLException);
            }
            J2EEDataSourceTest.assertSQLState("08006", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.prepareStatement("CREATE TABLE TAB1(COL1 INT NOT NULL)", 1);
            J2EEDataSourceTest.fail((String)"SQLException of 08003 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            object = new int[]{1};
            connection.prepareStatement("CREATE TABLE TAB1(COL1 INT NOT NULL)", (int[])object);
            J2EEDataSourceTest.fail((String)"SQLException of 08003 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            object = new String[]{"col1"};
            connection.prepareStatement("CREATE TABLE TAB1(COL1 INT NOT NULL)", (String[])object);
            J2EEDataSourceTest.fail((String)"SQLException of 08003 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.prepareStatement("CREATE TABLE TAB1(COL1 INT NOT NULL)", 1003, 1007);
            J2EEDataSourceTest.fail((String)"SQLException of 08003 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.prepareStatement("CREATE TABLE TAB1(COL1 INT NOT NULL)", 1003, 1007, 2);
            J2EEDataSourceTest.fail((String)"SQLException of 08003 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.createStatement();
            J2EEDataSourceTest.fail((String)"SQLException of 08003 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.createStatement(1003, 1007, 2);
            J2EEDataSourceTest.fail((String)"SQLException of 08003 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.createStatement(1003, 1007);
            J2EEDataSourceTest.fail((String)"SQLException of 08003 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.prepareCall("CREATE TABLE TAB1(COL1 INT NOT NULL)", 1003, 1007);
            J2EEDataSourceTest.fail((String)"SQLException of 08003 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.prepareCall("CREATE TABLE TAB1(COL1 INT NOT NULL)");
            J2EEDataSourceTest.fail((String)"SQLException of 08003 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.prepareCall("CREATE TABLE TAB1(COL1 INT NOT NULL)", 1003, 1007, 2);
            J2EEDataSourceTest.fail((String)"SQLException of 08003 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.nativeSQL("CREATE TABLE TAB1(COL1 INT NOT NULL)");
            J2EEDataSourceTest.fail((String)"SQLException of 08003 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.getAutoCommit();
            J2EEDataSourceTest.fail((String)"SQLException of 08003 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.setAutoCommit(false);
            J2EEDataSourceTest.fail((String)"SQLException of 08003 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.getHoldability();
            J2EEDataSourceTest.fail((String)"SQLException of 08003 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.setHoldability(1);
            J2EEDataSourceTest.fail((String)"SQLException of 08003 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.commit();
            J2EEDataSourceTest.fail((String)"SQLException of 08003 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.rollback();
            J2EEDataSourceTest.fail((String)"SQLException of 08003 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.setSavepoint();
            J2EEDataSourceTest.fail((String)"SQLException of 08003 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.setSavepoint("savept1");
            J2EEDataSourceTest.fail((String)"SQLException of 08003 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.rollback(null);
            J2EEDataSourceTest.fail((String)"SQLException of 08003 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.releaseSavepoint(null);
            J2EEDataSourceTest.fail((String)"SQLException of 08003 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.setTransactionIsolation(2);
            J2EEDataSourceTest.fail((String)"SQLException of 08003 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.getTransactionIsolation();
            J2EEDataSourceTest.fail((String)"SQLException of 08003 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.getWarnings();
            J2EEDataSourceTest.fail((String)"SQLException of 08003 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.clearWarnings();
            J2EEDataSourceTest.fail((String)"SQLException of 08003 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.getMetaData();
            J2EEDataSourceTest.fail((String)"SQLException of 08003 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.isReadOnly();
            J2EEDataSourceTest.fail((String)"SQLException of 08003 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.setReadOnly(true);
            J2EEDataSourceTest.fail((String)"SQLException of 08003 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.setCatalog(null);
            J2EEDataSourceTest.fail((String)"SQLException of 08003 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.getCatalog();
            J2EEDataSourceTest.fail((String)"SQLException of 08003 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.getTypeMap();
            J2EEDataSourceTest.fail((String)"SQLException of 08003 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.setTypeMap(null);
            J2EEDataSourceTest.fail((String)"SQLException of 08003 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        if (J2EEDataSourceTest.usingEmbedded()) {
            object = Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
            ((Class)object).getConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            this.getTestConfiguration().startNetworkServer();
        }
        connection = this.getConnection();
        connection.close();
    }

    public void testConnectionEventListenerIsNull() throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        this.subtestCloseEventWithNullListener(connectionPoolDataSource.getPooledConnection());
        this.subtestErrorEventWithNullListener(connectionPoolDataSource.getPooledConnection());
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        this.subtestCloseEventWithNullListener(xADataSource.getXAConnection());
        this.subtestErrorEventWithNullListener(xADataSource.getXAConnection());
    }

    private void subtestCloseEventWithNullListener(PooledConnection pooledConnection) throws SQLException {
        pooledConnection.addConnectionEventListener(null);
        pooledConnection.getConnection().close();
        pooledConnection.close();
    }

    private void subtestErrorEventWithNullListener(PooledConnection pooledConnection) throws SQLException {
        pooledConnection.addConnectionEventListener(null);
        Connection connection = pooledConnection.getConnection();
        this.getTestConfiguration().shutdownDatabase();
        try {
            connection.prepareStatement("VALUES 1");
            J2EEDataSourceTest.fail((String)"Statement should fail after database shutdown");
        }
        catch (SQLException sQLException) {
            if (J2EEDataSourceTest.usingEmbedded()) {
                J2EEDataSourceTest.assertSQLState("08003", sQLException);
            }
            J2EEDataSourceTest.assertSQLState("08006", sQLException);
        }
        connection.close();
        pooledConnection.close();
    }

    private void testCloseActiveConnection(Connection connection, boolean bl, boolean bl2) throws SQLException {
        if (bl2) {
            J2EEDataSourceTest.assertFalse((String)"auto-commit should be false in XA", (boolean)bl);
        }
        J2EEDataSourceTest.assertEquals((String)"auto-commit", (boolean)bl, (boolean)connection.getAutoCommit());
        Statement statement = connection.createStatement();
        JDBC.assertDrainResults(statement.executeQuery("SELECT * FROM SYS.SYSTABLES"));
        statement.close();
        try {
            connection.close();
            J2EEDataSourceTest.assertTrue((String)"close() should fail", (bl || bl2 ? 1 : 0) != 0);
        }
        catch (SQLException sQLException) {
            if (bl || bl2) {
                throw sQLException;
            }
            J2EEDataSourceTest.assertSQLState("25001", sQLException);
        }
        if (!bl && !bl2) {
            connection.rollback();
        }
        connection.close();
    }

    public void testCloseActiveConnection_DS() throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource();
        this.testCloseActiveConnection(dataSource.getConnection(), true, false);
        Connection connection = dataSource.getConnection();
        connection.setAutoCommit(false);
        this.testCloseActiveConnection(connection, false, false);
    }

    public void testCloseActiveConnection_CP() throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        PooledConnection pooledConnection = connectionPoolDataSource.getPooledConnection();
        this.testCloseActiveConnection(pooledConnection.getConnection(), true, false);
        Connection connection = pooledConnection.getConnection();
        connection.setAutoCommit(false);
        this.testCloseActiveConnection(connection, false, false);
        pooledConnection.close();
    }

    public void testCloseActiveConnection_XA_local() throws SQLException {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        XAConnection xAConnection = xADataSource.getXAConnection();
        this.testCloseActiveConnection(xAConnection.getConnection(), true, false);
        Connection connection = xAConnection.getConnection();
        connection.setAutoCommit(false);
        this.testCloseActiveConnection(connection, false, false);
        xAConnection.close();
    }

    public void testCloseActiveConnection_XA_global() throws SQLException, XAException {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        XAConnection xAConnection = xADataSource.getXAConnection();
        XAResource xAResource = xAConnection.getXAResource();
        cdsXid cdsXid2 = new cdsXid(1, 2, 3);
        xAResource.start(cdsXid2, 0);
        this.testCloseActiveConnection(xAConnection.getConnection(), false, true);
        Connection connection = xAConnection.getConnection();
        connection.setAutoCommit(false);
        this.testCloseActiveConnection(connection, false, true);
        xAResource.end(cdsXid2, 0x4000000);
        xAConnection.close();
    }

    public void testCreateInDatabaseName_XA() throws SQLException, XAException {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        String string = TestConfiguration.getCurrent().getDefaultDatabaseName();
        J2EEDataSource.setBeanProperty(xADataSource, "databaseName", string + ";create=true");
        XAConnection xAConnection = xADataSource.getXAConnection();
        Connection connection = xAConnection.getConnection();
        connection.setAutoCommit(false);
        connection.close();
    }

    public void testCreateInDatabaseName_Pooled() throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        PooledConnection pooledConnection = connectionPoolDataSource.getPooledConnection();
        String string = TestConfiguration.getCurrent().getDefaultDatabaseName();
        J2EEDataSource.setBeanProperty(connectionPoolDataSource, "databaseName", string + ";create=true");
        Connection connection = pooledConnection.getConnection();
        connection.setAutoCommit(false);
        connection.close();
        pooledConnection.close();
    }

    public void testCreateInDatabaseName_DS() throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource();
        String string = TestConfiguration.getCurrent().getDefaultDatabaseName();
        JDBCDataSource.setBeanProperty(dataSource, "databaseName", string + ";create=true");
        Connection connection = dataSource.getConnection();
        connection.setAutoCommit(false);
        connection.close();
    }

    public void testPooledReuseOnClose() throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        this.subtestPooledReuseOnClose(connectionPoolDataSource.getPooledConnection());
        this.subtestPooledCloseOnClose(connectionPoolDataSource.getPooledConnection());
        this.subtestPooledRemoveListenerOnClose(connectionPoolDataSource.getPooledConnection());
        this.subtestPooledAddListenerOnClose(connectionPoolDataSource.getPooledConnection());
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        this.subtestPooledReuseOnClose(xADataSource.getXAConnection());
        this.subtestPooledCloseOnClose(xADataSource.getXAConnection());
        this.subtestPooledRemoveListenerOnClose(xADataSource.getXAConnection());
        this.subtestPooledAddListenerOnClose(xADataSource.getXAConnection());
    }

    private void subtestPooledReuseOnClose(final PooledConnection pooledConnection) throws SQLException {
        final Connection[] connectionArray = new Connection[1];
        pooledConnection.addConnectionEventListener(new ConnectionEventListener(){

            @Override
            public void connectionClosed(ConnectionEvent connectionEvent) {
                PooledConnection pooledConnection2 = (PooledConnection)connectionEvent.getSource();
                Assert.assertSame((Object)pooledConnection, (Object)pooledConnection2);
                try {
                    connectionArray[0] = pooledConnection2.getConnection();
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException);
                }
            }

            @Override
            public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
            }
        });
        Connection connection = pooledConnection.getConnection();
        connection.close();
        Connection connection2 = connectionArray[0];
        J2EEDataSourceTest.assertNotNull((Object)connection2);
        connection2.createStatement().close();
        pooledConnection.close();
    }

    private void subtestPooledCloseOnClose(final PooledConnection pooledConnection) throws SQLException {
        pooledConnection.addConnectionEventListener(new ConnectionEventListener(){

            @Override
            public void connectionClosed(ConnectionEvent connectionEvent) {
                PooledConnection pooledConnection2 = (PooledConnection)connectionEvent.getSource();
                Assert.assertSame((Object)pooledConnection, (Object)pooledConnection2);
                try {
                    pooledConnection2.close();
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException);
                }
            }

            @Override
            public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
            }
        });
        pooledConnection.getConnection().close();
        try {
            pooledConnection.getConnection();
            J2EEDataSourceTest.fail((String)"PooledConnection should be closed");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
    }

    private void subtestPooledRemoveListenerOnClose(final PooledConnection pooledConnection) throws SQLException {
        final int[] nArray = new int[1];
        pooledConnection.addConnectionEventListener(new ConnectionEventListener(){

            @Override
            public void connectionClosed(ConnectionEvent connectionEvent) {
                PooledConnection pooledConnection2 = (PooledConnection)connectionEvent.getSource();
                Assert.assertSame((Object)pooledConnection, (Object)pooledConnection2);
                nArray[0] = nArray[0] + 1;
                pooledConnection2.removeConnectionEventListener(this);
            }

            @Override
            public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
            }
        });
        final int[] nArray2 = new int[1];
        pooledConnection.addConnectionEventListener(new ConnectionEventListener(){

            @Override
            public void connectionClosed(ConnectionEvent connectionEvent) {
                PooledConnection pooledConnection2 = (PooledConnection)connectionEvent.getSource();
                Assert.assertSame((Object)pooledConnection, (Object)pooledConnection2);
                nArray2[0] = nArray2[0] + 1;
            }

            @Override
            public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
            }
        });
        J2EEDataSourceTest.assertEquals((int)0, (int)nArray[0]);
        J2EEDataSourceTest.assertEquals((int)0, (int)nArray2[0]);
        pooledConnection.getConnection().close();
        J2EEDataSourceTest.assertEquals((int)1, (int)nArray[0]);
        J2EEDataSourceTest.assertEquals((int)1, (int)nArray2[0]);
        pooledConnection.getConnection().close();
        J2EEDataSourceTest.assertEquals((int)1, (int)nArray[0]);
        J2EEDataSourceTest.assertEquals((int)2, (int)nArray2[0]);
        pooledConnection.close();
    }

    private void subtestPooledAddListenerOnClose(final PooledConnection pooledConnection) throws SQLException {
        final int[] nArray = new int[2];
        pooledConnection.addConnectionEventListener(new ConnectionEventListener(){

            @Override
            public void connectionClosed(ConnectionEvent connectionEvent) {
                Assert.assertSame((Object)pooledConnection, (Object)connectionEvent.getSource());
                nArray[0] = nArray[0] + 1;
                pooledConnection.addConnectionEventListener(new ConnectionEventListener(){

                    @Override
                    public void connectionClosed(ConnectionEvent connectionEvent) {
                        Assert.assertSame((Object)pooledConnection, (Object)connectionEvent.getSource());
                        nArray[1] = nArray[1] + 1;
                    }

                    @Override
                    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
                    }
                });
            }

            @Override
            public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
            }
        });
        int n = 0;
        for (int i = 0; i < 5; ++i) {
            J2EEDataSourceTest.assertEquals((String)"close count (main)", (int)i, (int)nArray[0]);
            J2EEDataSourceTest.assertEquals((String)"close count (added)", (int)n, (int)nArray[1]);
            n += i;
            pooledConnection.getConnection().close();
        }
        pooledConnection.close();
    }

    public void testAllDataSources() throws SQLException, Exception {
        Connection connection = this.getConnection();
        CallableStatement callableStatement = connection.prepareCall("call checkConn2(?)");
        callableStatement.setString(1, "Nested");
        try {
            callableStatement.execute();
            J2EEDataSourceTest.fail((String)"SQLException of 40XC0 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("40XC0", sQLException);
        }
        callableStatement.setString(1, "Nested2");
        callableStatement.execute();
        String string = "OK";
        String string2 = "XJ081";
        String string3 = "0A000";
        Object[] objectArray = new Object[]{1, "XJ010", 2, true, false, string, string2, string3};
        this.assertConnectionOK(objectArray, "DriverManager ", connection);
        if (J2EEDataSourceTest.usingEmbedded()) {
            this.assertTenConnectionsUnique();
        }
        DataSource dataSource = JDBCDataSource.getDataSource();
        if (J2EEDataSourceTest.usingEmbedded()) {
            J2EEDataSourceTest.assertToString(dataSource);
        }
        DataSource dataSource2 = dataSource;
        this.assertConnectionOK(objectArray, "DataSource", dataSource2.getConnection());
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        if (J2EEDataSourceTest.usingEmbedded()) {
            J2EEDataSourceTest.assertToString(connectionPoolDataSource);
        }
        PooledConnection pooledConnection = connectionPoolDataSource.getPooledConnection();
        if (J2EEDataSourceTest.usingEmbedded()) {
            SecurityCheck.assertSourceSecurity(pooledConnection, "javax.sql.PooledConnection");
        }
        AssertEventCatcher assertEventCatcher = new AssertEventCatcher(1);
        pooledConnection.addConnectionEventListener(assertEventCatcher);
        this.assertConnectionOK(objectArray, "ConnectionPoolDataSource", pooledConnection.getConnection());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        this.assertConnectionOK(objectArray, "ConnectionPoolDataSource", pooledConnection.getConnection());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        if (J2EEDataSourceTest.usingEmbedded()) {
            J2EEDataSourceTest.assertToString(xADataSource);
        }
        TestConfiguration.getCurrent().shutdownDatabase();
        connection = this.getConnection();
        callableStatement = connection.prepareCall("call checkConn2(?)");
        if (J2EEDataSourceTest.usingEmbedded()) {
            SecurityCheck.assertSourceSecurity(callableStatement, "java.sql.CallableStatement");
        }
        callableStatement.setString(1, "Nested");
        try {
            callableStatement.execute();
            J2EEDataSourceTest.fail((String)"SQLException of 40XC0 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("40XC0", sQLException);
        }
        callableStatement.setString(1, "Nested2");
        callableStatement.execute();
        XAConnection xAConnection = xADataSource.getXAConnection();
        if (J2EEDataSourceTest.usingEmbedded()) {
            SecurityCheck.assertSourceSecurity(xAConnection, "javax.sql.XAConnection");
        }
        AssertEventCatcher assertEventCatcher2 = new AssertEventCatcher(3);
        xAConnection.addConnectionEventListener(assertEventCatcher2);
        this.assertConnectionOK(objectArray, "XADataSource", xAConnection.getConnection());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher2.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher2.didConnectionErrorEventHappen());
        assertEventCatcher2.resetState();
        pooledConnection = connectionPoolDataSource.getPooledConnection();
        AssertEventCatcher assertEventCatcher3 = new AssertEventCatcher(2);
        pooledConnection.addConnectionEventListener(assertEventCatcher3);
        this.assertConnectionOK(objectArray, "ConnectionPoolDataSource", pooledConnection.getConnection());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher3.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher3.didConnectionErrorEventHappen());
        assertEventCatcher3.resetState();
        xAConnection = xADataSource.getXAConnection();
        AssertEventCatcher assertEventCatcher4 = new AssertEventCatcher(4);
        xAConnection.addConnectionEventListener(assertEventCatcher4);
        this.assertConnectionOK(objectArray, "XADataSource", xAConnection.getConnection());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher4.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher4.didConnectionErrorEventHappen());
        assertEventCatcher4.resetState();
        this.assertConnectionOK(objectArray, "XADataSource", xAConnection.getConnection());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher4.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher4.didConnectionErrorEventHappen());
        assertEventCatcher4.resetState();
        xAConnection.close();
        xAConnection = xADataSource.getXAConnection();
        AssertEventCatcher assertEventCatcher5 = new AssertEventCatcher(5);
        xAConnection.addConnectionEventListener(assertEventCatcher5);
        XAResource xAResource = xAConnection.getXAResource();
        if (J2EEDataSourceTest.usingEmbedded()) {
            SecurityCheck.assertSourceSecurity(xAResource, "javax.transaction.xa.XAResource");
        }
        cdsXid cdsXid2 = new cdsXid(1, 35, 47);
        xAResource.start(cdsXid2, 0);
        Connection connection2 = xAConnection.getConnection();
        connection2.close();
        objectArray[0] = 2;
        if (J2EEDataSourceTest.usingEmbedded()) {
            objectArray[1] = "XJ058";
        }
        objectArray[3] = false;
        this.assertConnectionOK(objectArray, "Global XADataSource", xAConnection.getConnection());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher5.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher5.didConnectionErrorEventHappen());
        assertEventCatcher5.resetState();
        this.assertConnectionOK(objectArray, "Global XADataSource", xAConnection.getConnection());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher5.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher5.didConnectionErrorEventHappen());
        assertEventCatcher5.resetState();
        xAResource.end(cdsXid2, 0x4000000);
        objectArray[0] = 1;
        objectArray[3] = true;
        this.assertConnectionOK(objectArray, "Switch to local XADataSource", xAConnection.getConnection());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher5.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher5.didConnectionErrorEventHappen());
        assertEventCatcher5.resetState();
        this.assertConnectionOK(objectArray, "Switch to local XADataSource", xAConnection.getConnection());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher5.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher5.didConnectionErrorEventHappen());
        assertEventCatcher5.resetState();
        Connection connection3 = xAConnection.getConnection();
        xAResource.start(cdsXid2, 0x200000);
        objectArray[0] = 2;
        objectArray[3] = false;
        this.assertConnectionOK(objectArray, "Switch to global XADataSource", connection3);
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher5.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher5.didConnectionErrorEventHappen());
        assertEventCatcher5.resetState();
        this.assertConnectionOK(objectArray, "Switch to global XADataSource", xAConnection.getConnection());
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher5.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher5.didConnectionErrorEventHappen());
        assertEventCatcher5.resetState();
        xAResource.end(cdsXid2, 0x4000000);
        xAResource.commit(cdsXid2, true);
        xAConnection.close();
    }

    public void testClosedCPDSConnection() throws SQLException, Exception {
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        PooledConnection pooledConnection;
        ConnectionPoolDataSource connectionPoolDataSource;
        block5: {
            connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
            pooledConnection = connectionPoolDataSource.getPooledConnection();
            connection = pooledConnection.getConnection();
            statement = connection.createStatement();
            statement.executeUpdate("delete from intTable");
            connection.setAutoCommit(false);
            statement.executeUpdate("insert into intTable values(1)");
            connection = pooledConnection.getConnection();
            resultSet = connection.createStatement().executeQuery("select count(*) from intTable");
            resultSet.next();
            J2EEDataSourceTest.assertEquals((int)0, (int)resultSet.getInt(1));
            connection.close();
            try {
                resultSet.next();
                J2EEDataSourceTest.fail((String)"ResultSet is open for a closed connection obtained from PooledConnection");
            }
            catch (SQLException sQLException) {
                if (J2EEDataSourceTest.usingEmbedded()) {
                    J2EEDataSourceTest.assertSQLState("08003", sQLException);
                }
                if (!J2EEDataSourceTest.usingDerbyNetClient()) break block5;
                J2EEDataSourceTest.assertSQLState("XCL16", sQLException);
            }
        }
        try {
            statement.executeUpdate("update intTable set i = 1");
            J2EEDataSourceTest.fail((String)"Statement is open for a closed connection obtained from PooledConnection");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        pooledConnection.close();
        pooledConnection = null;
        J2EEDataSourceTest.PoolReset("ConnectionPoolDataSource", connectionPoolDataSource.getPooledConnection());
        statement.close();
        resultSet.close();
        connection.close();
    }

    public void testClosedXADSConnection() throws SQLException, Exception {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        XAConnection xAConnection = xADataSource.getXAConnection();
        Connection connection = xAConnection.getConnection();
        Statement statement = connection.createStatement();
        connection.setAutoCommit(false);
        statement.executeUpdate("insert into intTable values(2)");
        connection = xAConnection.getConnection();
        ResultSet resultSet = connection.createStatement().executeQuery("select count(*) from intTable");
        resultSet.next();
        J2EEDataSourceTest.assertEquals((int)0, (int)resultSet.getInt(1));
        resultSet.close();
        connection.close();
        xAConnection.close();
        xAConnection = null;
        J2EEDataSourceTest.PoolReset("XADataSource", xADataSource.getXAConnection());
    }

    public void testGlobalLocalInterleaf() throws SQLException, XAException {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        XAConnection xAConnection = xADataSource.getXAConnection();
        AssertEventCatcher assertEventCatcher = new AssertEventCatcher(6);
        xAConnection.addConnectionEventListener(assertEventCatcher);
        XAResource xAResource = xAConnection.getXAResource();
        cdsXid cdsXid2 = new cdsXid(1, 93, 103);
        Connection connection = xAConnection.getConnection();
        this.assertConnectionState(1, 2, true, false, connection);
        xAResource.start(cdsXid2, 0);
        this.assertConnectionState(2, 2, false, false, connection);
        connection.setTransactionIsolation(1);
        connection.setReadOnly(true);
        this.setHoldability(connection, false);
        boolean bl = false;
        if (J2EEDataSourceTest.usingEmbedded()) {
            bl = true;
        }
        this.assertConnectionState(2, 1, false, bl, connection);
        xAResource.end(cdsXid2, 0x4000000);
        this.assertConnectionState(2, 1, true, bl, connection);
        connection.setTransactionIsolation(2);
        connection.setReadOnly(false);
        this.setHoldability(connection, false);
        this.assertConnectionState(2, 2, true, false, connection);
        xAResource.start(cdsXid2, 0x200000);
        this.assertConnectionState(2, 1, false, bl, connection);
        xAResource.end(cdsXid2, 0x4000000);
        this.assertConnectionState(2, 2, true, false, connection);
        xAResource.start(cdsXid2, 0x200000);
        this.assertConnectionState(2, 1, false, bl, connection);
        xAResource.end(cdsXid2, 0x2000000);
        this.assertConnectionState(2, 2, true, false, connection);
        xAResource.start(cdsXid2, 0x8000000);
        this.assertConnectionState(2, 1, false, bl, connection);
        xAResource.end(cdsXid2, 0x4000000);
        this.assertConnectionState(2, 2, true, false, connection);
        connection.setTransactionIsolation(1);
        connection.setReadOnly(true);
        this.setHoldability(connection, true);
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        connection.close();
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        connection = xAConnection.getConnection();
        this.assertConnectionState(1, 2, true, false, connection);
        connection.close();
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        xAResource.start(cdsXid2, 0x200000);
        connection = xAConnection.getConnection();
        this.assertConnectionState(2, 1, false, bl, connection);
        connection.close();
        xAResource.end(cdsXid2, 0x4000000);
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        connection = xAConnection.getConnection();
        connection.setTransactionIsolation(4);
        this.assertConnectionState(1, 4, true, false, connection);
        xAResource.start(cdsXid2, 0x200000);
        this.assertConnectionState(2, 1, false, bl, connection);
        xAResource.end(cdsXid2, 0x4000000);
        this.assertConnectionState(1, 4, true, false, connection);
        xAResource.commit(cdsXid2, true);
        this.assertConnectionState(1, 4, true, false, connection);
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        connection.close();
        J2EEDataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
    }

    public void testSetIsolationWithStatement() throws SQLException, XAException {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        XAConnection xAConnection = xADataSource.getXAConnection();
        AssertEventCatcher assertEventCatcher = new AssertEventCatcher(6);
        xAConnection.addConnectionEventListener(assertEventCatcher);
        XAResource xAResource = xAConnection.getXAResource();
        Connection connection = xAConnection.getConnection();
        Statement statement = connection.createStatement();
        this.assertConnectionState(1, 2, true, false, connection);
        connection.setTransactionIsolation(1);
        this.assertConnectionState(1, 1, true, false, connection);
        statement.executeUpdate("set current isolation = RR");
        this.assertConnectionState(1, 8, true, false, connection);
        cdsXid cdsXid2 = new cdsXid(1, 35, 47);
        xAResource.start(cdsXid2, 0);
        this.assertConnectionState(2, 8, false, false, connection);
        xAResource.end(cdsXid2, 0x4000000);
        this.assertConnectionState(1, 8, true, false, connection);
        statement.executeUpdate("set current isolation = RS");
        this.assertConnectionState(1, 4, true, false, connection);
        xAResource.start(cdsXid2, 0x200000);
        this.assertConnectionState(2, 8, false, false, connection);
        xAResource.end(cdsXid2, 0x4000000);
        this.assertConnectionState(1, 4, true, false, connection);
        cdsXid cdsXid3 = new cdsXid(1, 93, 103);
        xAResource.start(cdsXid3, 0);
        this.assertConnectionState(2, 4, false, false, connection);
        Statement statement2 = connection.createStatement();
        statement2.executeUpdate("create table testglobal (i int)");
        xAResource.end(cdsXid3, 0x4000000);
        xAResource.start(cdsXid2, 0x200000);
        this.assertConnectionState(2, 8, false, false, connection);
        xAResource.end(cdsXid2, 0x4000000);
        this.assertConnectionState(1, 4, true, false, connection);
        xAResource.start(cdsXid2, 0x200000);
        this.assertConnectionState(2, 8, false, false, connection);
        statement.executeUpdate("set current isolation = UR");
        this.assertConnectionState(2, 1, false, false, connection);
        xAResource.end(cdsXid2, 0x4000000);
        this.assertConnectionState(1, 1, true, false, connection);
        xAResource.start(cdsXid3, 0x200000);
        this.assertConnectionState(2, 4, false, false, connection);
        xAResource.end(cdsXid3, 0x4000000);
        xAResource.rollback(cdsXid3);
        this.assertConnectionState(1, 1, true, false, connection);
        xAResource.rollback(cdsXid2);
        this.assertConnectionState(1, 1, true, false, connection);
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
    }

    public void testReuseAcrossGlobalLocal() throws SQLException, XAException {
        if (J2EEDataSourceTest.usingDerbyNetClient()) {
            return;
        }
        int[] nArray = new int[]{1, 2, 3};
        int[] nArray2 = new int[]{3};
        int[] nArray3 = new int[]{1, 4};
        int[] nArray4 = new int[]{2, 12, 12};
        int[] nArray5 = new int[]{1004, 1007, 1001, 444, 713, 19, 1};
        int[] nArray6 = new int[]{1004, 1007, 1001, 888, 317, 91, 1};
        int[] nArray7 = new int[]{1004, 1007, 1001, 999, 137, 85, 1};
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        XAConnection xAConnection = xADataSource.getXAConnection();
        AssertEventCatcher assertEventCatcher = new AssertEventCatcher(6);
        xAConnection.addConnectionEventListener(assertEventCatcher);
        XAResource xAResource = xAConnection.getXAResource();
        cdsXid cdsXid2 = new cdsXid(1, 103, 119);
        Connection connection = xAConnection.getConnection();
        connection.setTransactionIsolation(4);
        connection.setAutoCommit(false);
        J2EEDataSourceTest.assertLocks(null, connection);
        Statement statement = connection.createStatement();
        statement.setCursorName("SN1");
        statement.executeUpdate("insert into intTable values 1,2,3");
        Statement statement2 = connection.createStatement();
        statement2.setCursorName("sruBatch");
        Statement statement3 = this.createFloatStatementForStateChecking(nArray5, connection);
        PreparedStatement preparedStatement = this.createFloatStatementForStateChecking(new int[]{1, 4}, nArray6, connection, "select i from intTable where i = ?");
        CallableStatement callableStatement = this.createFloatCallForStateChecking(new int[]{2, 12, 12}, nArray7, connection, "CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?,?)");
        PreparedStatement preparedStatement2 = connection.prepareStatement("select * from intTable where i > ?");
        preparedStatement2.setCursorName("params");
        preparedStatement2.setInt(1, 2);
        J2EEDataSourceTest.resultSetQuery("params", nArray2, preparedStatement2.executeQuery());
        statement2.addBatch("insert into intTable values 4");
        J2EEDataSourceTest.queryOnStatement("SN1", nArray, connection, statement);
        connection.commit();
        xAResource.start(cdsXid2, 0);
        J2EEDataSourceTest.queryOnStatement("SN1", nArray, connection, statement);
        statement2.addBatch("insert into intTable values 5");
        Statement statement4 = connection.createStatement();
        statement4.setCursorName("OAK2");
        J2EEDataSourceTest.queryOnStatement("OAK2", nArray, connection, statement4);
        J2EEDataSourceTest.queryOnStatement("SN1", nArray, connection, statement);
        nArray5[6] = 2;
        nArray6[6] = 2;
        nArray7[6] = 2;
        this.assertStatementState(null, nArray5, statement3);
        this.assertStatementState(nArray3, nArray6, preparedStatement);
        this.assertStatementState(nArray4, nArray7, callableStatement);
        J2EEDataSourceTest.resultSetQuery("params", nArray2, preparedStatement2.executeQuery());
        xAResource.end(cdsXid2, 0x4000000);
        J2EEDataSourceTest.queryOnStatement("SN1", nArray, connection, statement);
        J2EEDataSourceTest.queryOnStatement("OAK2", nArray, connection, statement4);
        statement2.addBatch("insert into intTable values 6,7");
        Statement statement5 = connection.createStatement();
        statement5.setCursorName("SF3");
        J2EEDataSourceTest.queryOnStatement("SF3", nArray, connection, statement5);
        nArray5[6] = 1;
        nArray6[6] = 1;
        nArray7[6] = 1;
        this.assertStatementState(null, nArray5, statement3);
        this.assertStatementState(nArray3, nArray6, preparedStatement);
        this.assertStatementState(nArray4, nArray7, callableStatement);
        J2EEDataSourceTest.resultSetQuery("params", nArray2, preparedStatement2.executeQuery());
        J2EEDataSourceTest.assertLocks(new int[]{14, 14}, connection);
        connection.commit();
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        XAConnection xAConnection2 = xADataSource.getXAConnection();
        AssertEventCatcher assertEventCatcher2 = new AssertEventCatcher(5);
        xAConnection2.addConnectionEventListener(assertEventCatcher2);
        XAResource xAResource2 = xAConnection2.getXAResource();
        xAResource2.start(cdsXid2, 0x200000);
        Connection connection2 = xAConnection2.getConnection();
        J2EEDataSourceTest.queryOnStatement("SN1", nArray, connection, statement);
        J2EEDataSourceTest.queryOnStatement("OAK2", nArray, connection, statement4);
        J2EEDataSourceTest.queryOnStatement("SF3", nArray, connection, statement5);
        statement2.addBatch("insert into intTable values 8");
        this.assertStatementState(null, nArray5, statement3);
        this.assertStatementState(nArray3, nArray6, preparedStatement);
        this.assertStatementState(nArray4, nArray7, callableStatement);
        J2EEDataSourceTest.assertLocks(new int[]{14, 12}, connection);
        int[] nArray8 = statement2.executeBatch();
        int[] nArray9 = new int[]{1, 1, 2, 1};
        for (int i = 0; i < nArray8.length; ++i) {
            J2EEDataSourceTest.assertEquals((int)nArray9[i], (int)nArray8[i]);
        }
        J2EEDataSourceTest.queryOnStatement("sruBatch", new int[]{1, 2, 3, 4, 5, 6, 7, 8}, connection, statement2);
        xAResource2.end(cdsXid2, 0x4000000);
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher2.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)assertEventCatcher2.didConnectionErrorEventHappen());
        assertEventCatcher2.resetState();
        xAConnection2.close();
        xAConnection2.close();
        xAConnection2.addConnectionEventListener(null);
        xAConnection2.removeConnectionEventListener(null);
        try {
            xAConnection2.getXAResource();
            J2EEDataSourceTest.fail((String)"expected SQLException on closed XAConnection.getXAResource");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        try {
            xAConnection2.getConnection();
            J2EEDataSourceTest.fail((String)"expected SQLException on XAConnection.getConnection");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        try {
            xAResource2.start(cdsXid2, 0x200000);
            J2EEDataSourceTest.fail((String)"expected XAException on XAResource.TMJOIN");
        }
        catch (XAException xAException) {
            this.assertXAException("XAResource.start", xAException);
        }
        try {
            xAResource2.end(cdsXid2, 0x200000);
            J2EEDataSourceTest.fail((String)"expected XAException on XAResource.TMJOIN");
        }
        catch (XAException xAException) {
            this.assertXAException("XAResource.end", xAException);
        }
        try {
            xAResource2.commit(cdsXid2, true);
            J2EEDataSourceTest.fail((String)"expected XAException on XAResource.commit");
        }
        catch (XAException xAException) {
            this.assertXAException("XAResource.commit", xAException);
        }
        try {
            xAResource2.prepare(cdsXid2);
            J2EEDataSourceTest.fail((String)"expected XAException on XAResource.prepare");
        }
        catch (XAException xAException) {
            this.assertXAException("XAResource.prepare", xAException);
        }
        try {
            xAResource2.recover(0);
            J2EEDataSourceTest.fail((String)"expected XAException on XAResource.recover");
        }
        catch (XAException xAException) {
            this.assertXAException("XAResource.recover", xAException);
        }
        try {
            xAResource2.prepare(cdsXid2);
            J2EEDataSourceTest.fail((String)"expected XAException on XAResource.prepare");
        }
        catch (XAException xAException) {
            this.assertXAException("XAResource.prepare", xAException);
        }
        try {
            xAResource2.isSameRM(xAResource2);
            J2EEDataSourceTest.fail((String)"expected XAException on XAResource.isSameRM");
        }
        catch (XAException xAException) {
            this.assertXAException("XAResource.isSameRM", xAException);
        }
        connection.rollback();
        statement3.close();
        preparedStatement.close();
        callableStatement.close();
        preparedStatement2.close();
        statement2.close();
        statement.close();
        statement4.close();
        statement5.close();
        connection.close();
        connection2.close();
        xAConnection.removeConnectionEventListener(null);
        xAConnection.close();
        xAConnection2.close();
        TestConfiguration.getCurrent().shutdownDatabase();
    }

    public void testSetSchemaInXAConnection() throws SQLException {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        XAConnection xAConnection = xADataSource.getXAConnection();
        Connection connection = xAConnection.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("SET SCHEMA SCHEMA_Patricio");
        statement.close();
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO Patricio VALUES (?, ?)");
        preparedStatement.setString(1, "Patricio");
        preparedStatement.setInt(2, 3);
        preparedStatement.executeUpdate();
        J2EEDataSourceTest.assertEquals((int)1, (int)preparedStatement.getUpdateCount());
        preparedStatement.close();
        connection.close();
        xAConnection.close();
    }

    public void testSchemaIsReset() throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        J2EEDataSource.setBeanProperty(connectionPoolDataSource, "createDatabase", "create");
        this.doTestSchemaIsReset(connectionPoolDataSource.getPooledConnection("USERSCHEMA", "secret"), "USERSCHEMA");
        if (J2EEDataSourceTest.usingDerbyNetClient()) {
            J2EEDataSource.setBeanProperty(connectionPoolDataSource, "maxStatements", 7);
            this.doTestSchemaIsReset(connectionPoolDataSource.getPooledConnection("USERSCHEMA", "secret"), "USERSCHEMA");
        }
    }

    private void doTestSchemaIsReset(PooledConnection pooledConnection, String string) throws SQLException {
        Connection connection = pooledConnection.getConnection();
        JDBC.assertCurrentSchema(connection, string);
        JDBC.assertCurrentUser(connection, string);
        Statement statement = connection.createStatement();
        statement.execute("set schema APP");
        statement.close();
        JDBC.assertCurrentSchema(connection, "APP");
        JDBC.assertCurrentUser(connection, string);
        connection.close();
        Connection connection2 = pooledConnection.getConnection();
        JDBC.assertCurrentSchema(connection2, string);
        JDBC.assertCurrentUser(connection2, string);
        connection2.close();
        Connection connection3 = pooledConnection.getConnection();
        JDBC.assertCurrentSchema(connection3, string);
        JDBC.assertCurrentUser(connection3, string);
        connection3.close();
        pooledConnection.close();
    }

    public void testSchemaIsResetWhenDeleted() throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        J2EEDataSource.setBeanProperty(connectionPoolDataSource, "createDatabase", "create");
        PooledConnection pooledConnection = connectionPoolDataSource.getPooledConnection("AUSER", "secret");
        Connection connection = pooledConnection.getConnection();
        JDBC.assertCurrentSchema(connection, "AUSER");
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table schematest (id int)");
        statement.executeUpdate("drop table schematest");
        statement.executeUpdate("drop schema AUSER restrict");
        statement.close();
        connection.close();
        connection = pooledConnection.getConnection();
        JDBC.assertCurrentSchema(connection, "AUSER");
        statement = connection.createStatement();
        statement.executeUpdate("create table schematest (id int)");
        statement.executeUpdate("drop table schematest");
        statement.close();
        JDBC.assertCurrentSchema(connection, "AUSER");
        connection.close();
        pooledConnection.close();
    }

    public void testConnectionFlowCommit() throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        PooledConnection pooledConnection = connectionPoolDataSource.getPooledConnection();
        Connection connection = pooledConnection.getConnection();
        this.testConnectionFlowCommitWork(connection);
        connection.close();
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        XAConnection xAConnection = xADataSource.getXAConnection();
        connection = xAConnection.getConnection();
        this.testConnectionFlowCommitWork(connection);
        connection.close();
        DataSource dataSource = JDBCDataSource.getDataSource();
        connection = dataSource.getConnection();
        this.testConnectionFlowCommitWork(connection);
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDerby2026LoginTimeout() throws SQLException {
        AutoCloseable autoCloseable;
        Object object;
        Object object2;
        Object object3;
        DataSource dataSource = null;
        try {
            dataSource = JDBCDataSource.getDataSource();
            dataSource.setLoginTimeout(10);
            object3 = dataSource.getConnection();
            object2 = object3.prepareCall("CALL TESTROUTINE.SLEEP(20000)");
            object2.execute();
            object3.rollback();
        }
        finally {
            if (dataSource != null) {
                dataSource.setLoginTimeout(0);
            }
        }
        object3 = null;
        try {
            object3 = J2EEDataSource.getConnectionPoolDataSource();
            object3.setLoginTimeout(10);
            object2 = object3.getPooledConnection();
            object = object2.getConnection();
            autoCloseable = object.prepareCall("CALL TESTROUTINE.SLEEP(20000)");
            autoCloseable.execute();
            object.rollback();
            object.close();
            object = object2.getConnection();
            autoCloseable = object.prepareCall("CALL TESTROUTINE.SLEEP(20000)");
            autoCloseable.execute();
            object.rollback();
        }
        finally {
            if (object3 != null) {
                object3.setLoginTimeout(0);
            }
        }
        object2 = null;
        try {
            object2 = J2EEDataSource.getXADataSource();
            object2.setLoginTimeout(10);
            object = object2.getXAConnection();
            autoCloseable = object.getConnection();
            CallableStatement callableStatement = autoCloseable.prepareCall("CALL TESTROUTINE.SLEEP(20000)");
            callableStatement.execute();
            autoCloseable.rollback();
            autoCloseable.close();
            autoCloseable = object.getConnection();
            callableStatement = autoCloseable.prepareCall("CALL TESTROUTINE.SLEEP(20000)");
            callableStatement.execute();
            autoCloseable.rollback();
        }
        finally {
            if (object2 != null) {
                object2.setLoginTimeout(0);
            }
        }
    }

    private void testConnectionFlowCommitWork(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
        int n = J2EEDataSourceTest.getClientTransactionID(connection);
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("values 1");
        resultSet.next();
        J2EEDataSourceTest.assertEquals((int)1, (int)resultSet.getInt(1));
        resultSet.close();
        connection.commit();
        connection.commit();
        int n2 = J2EEDataSourceTest.getClientTransactionID(connection);
        J2EEDataSourceTest.assertTrue((String)("Should have had 1 xact, startXactId = " + n + " endXactId = " + n2), (n2 - n == 1 ? 1 : 0) != 0);
        statement.close();
    }

    public void testConnectionFlowRollbackAlt() throws IOException, SQLException {
        Object[] objectArray = new Object[]{JDBCDataSource.getDataSource(), J2EEDataSource.getConnectionPoolDataSource(), J2EEDataSource.getXADataSource()};
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            int n = this.testConnectionFlowCommitRollback(object, false, false);
            int n2 = this.testConnectionFlowCommitRollback(object, true, false);
            J2EEDataSourceTest.assertEquals((String)("Rollback optimization not working for connections originating from " + object.getClass().getName()), (int)n, (int)n2);
        }
    }

    public void testConnectionFlowCommitAlt() throws IOException, SQLException {
        Object[] objectArray = new Object[]{JDBCDataSource.getDataSource(), J2EEDataSource.getConnectionPoolDataSource(), J2EEDataSource.getXADataSource()};
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            int n = this.testConnectionFlowCommitRollback(object, false, true);
            int n2 = this.testConnectionFlowCommitRollback(object, true, true);
            J2EEDataSourceTest.assertEquals((String)("Commit optimization not working for connections originating from " + object.getClass().getName()), (int)n, (int)n2);
        }
    }

    private int testConnectionFlowCommitRollback(Object object, boolean bl, boolean bl2) throws IOException, SQLException {
        String string;
        Connection connection;
        int n = bl ? 25 : 0;
        boolean bl3 = object instanceof XADataSource;
        boolean bl4 = object instanceof ConnectionPoolDataSource;
        String string2 = bl3 ? "xa_" : (bl4 ? "cp_" : "");
        String string3 = "ds_" + string2 + (bl ? "base_" : "extra_") + (bl2 ? "commit" : "rollback");
        File file = SupportFilesSetup.getReadWrite(string3 + ".trace");
        J2EEDataSource.setBeanProperty(object, "traceFile", PrivilegedFileOpsForTests.getAbsolutePath(file));
        J2EEDataSource.setBeanProperty(object, "traceFileAppend", Boolean.FALSE);
        J2EEDataSource.setBeanProperty(object, "traceLevel", -1);
        PooledConnection pooledConnection = null;
        if (bl3) {
            pooledConnection = ((XADataSource)object).getXAConnection();
            connection = pooledConnection.getConnection();
        } else if (bl4) {
            pooledConnection = ((ClientConnectionPoolDataSourceInterface)object).getPooledConnection();
            connection = pooledConnection.getConnection();
        } else {
            connection = ((DataSource)object).getConnection();
        }
        connection.setAutoCommit(false);
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table " + string3 + " (id int)");
        connection.commit();
        this.endTranscation(connection, bl2, n);
        PreparedStatement preparedStatement = connection.prepareStatement("insert into " + string3 + " values (?)");
        for (int i = 0; i < 10; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.executeUpdate();
            this.endTranscation(connection, bl2, n);
        }
        preparedStatement.close();
        connection.commit();
        ResultSet resultSet = statement.executeQuery("select count(*) from " + string3);
        resultSet.next();
        resultSet.getInt(1);
        resultSet.close();
        this.endTranscation(connection, bl2, n);
        resultSet = statement.executeQuery("values 7");
        J2EEDataSourceTest.assertTrue((boolean)resultSet.next());
        J2EEDataSourceTest.assertEquals((int)7, (int)resultSet.getInt(1));
        resultSet.close();
        statement.close();
        this.endTranscation(connection, bl2, n);
        connection.close();
        if (pooledConnection != null) {
            pooledConnection.close();
        }
        statement = this.createStatement();
        resultSet = statement.executeQuery("select count(*) from " + string3);
        resultSet.next();
        J2EEDataSourceTest.assertEquals((String)"Potential COMMIT/ROLLBACK protocol error", (int)(bl2 ? 10 : 0), (int)resultSet.getInt(1));
        String string4 = "SEND BUFFER: " + (bl3 ? "SYNCCTL" : (bl2 ? "RDBCMM" : "RDBRLLBCK"));
        int n2 = 0;
        BufferedReader bufferedReader = new BufferedReader(PrivilegedFileOpsForTests.getFileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            if (!string.startsWith("[derby]") || string.indexOf(string4) == -1) continue;
            J2EEDataSourceTest.println((bl2 ? "COMMIT: " : "ROLLBACK: ") + string);
            ++n2;
        }
        bufferedReader.close();
        J2EEDataSourceTest.assertTrue((String)"Parsing failed, no COMMITS/ROLLBACKS detected", (n2 > 0 ? 1 : 0) != 0);
        J2EEDataSourceTest.println(object.getClass().getName() + ", invokeExtra=" + bl + ", isCommit=" + bl2 + ", tokenCount=" + n2);
        return n2;
    }

    private void endTranscation(Connection connection, boolean bl, int n) throws SQLException {
        if (bl) {
            connection.commit();
            for (int i = 0; i < n; ++i) {
                connection.commit();
            }
        } else {
            connection.rollback();
            for (int i = 0; i < n; ++i) {
                connection.rollback();
            }
        }
    }

    public void testIsolationWithFourConnections() throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        PooledConnection pooledConnection = connectionPoolDataSource.getPooledConnection();
        Connection connection = pooledConnection.getConnection();
        connection.setAutoCommit(false);
        connection.setTransactionIsolation(2);
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) FROM SYS.SYSTABLES");
        resultSet.next();
        int n = resultSet.getInt(1);
        resultSet.close();
        connection.rollback();
        connection.close();
        connection = pooledConnection.getConnection();
        connection.close();
        connection = pooledConnection.getConnection();
        connection.setTransactionIsolation(2);
        J2EEDataSourceTest.assertEquals((int)2, (int)connection.getTransactionIsolation());
        connection.close();
        connection = pooledConnection.getConnection();
        connection.setTransactionIsolation(1);
        J2EEDataSourceTest.assertEquals((int)1, (int)connection.getTransactionIsolation());
        connection.close();
    }

    public void testAutoCommitOnXAResourceStart() throws SQLException, XAException {
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        cdsXid cdsXid2;
        XAConnection xAConnection;
        block13: {
            XADataSource xADataSource = J2EEDataSource.getXADataSource();
            xAConnection = xADataSource.getXAConnection();
            cdsXid2 = null;
            if (J2EEDataSourceTest.usingEmbedded()) {
                cdsXid2 = new cdsXid(4, 23, 76);
            } else if (J2EEDataSourceTest.usingDerbyNetClient()) {
                cdsXid2 = new cdsXid(5, 23, 76);
            }
            connection = xAConnection.getConnection();
            J2EEDataSourceTest.assertTrue((boolean)connection.getAutoCommit());
            statement = connection.createStatement(1003, 1007, 2);
            resultSet = statement.executeQuery("select i from autocommitxastart");
            resultSet.next();
            J2EEDataSourceTest.assertEquals((int)1, (int)resultSet.getInt(1));
            resultSet.next();
            J2EEDataSourceTest.assertEquals((int)2, (int)resultSet.getInt(1));
            xAConnection.getXAResource().start(cdsXid2, 0);
            xAConnection.getXAResource().end(cdsXid2, 0x4000000);
            try {
                resultSet.next();
                J2EEDataSourceTest.fail((String)"expected an exception indicating resultset is closed.");
            }
            catch (SQLException sQLException) {
                if (!J2EEDataSourceTest.usingDerbyNetClient()) break block13;
                J2EEDataSourceTest.assertSQLState("XCL16", sQLException);
            }
        }
        connection.setAutoCommit(false);
        J2EEDataSourceTest.assertFalse((boolean)connection.getAutoCommit());
        resultSet = statement.executeQuery("select i from autocommitxastart");
        resultSet.next();
        J2EEDataSourceTest.assertEquals((int)1, (int)resultSet.getInt(1));
        resultSet.next();
        J2EEDataSourceTest.assertEquals((int)2, (int)resultSet.getInt(1));
        if (J2EEDataSourceTest.usingEmbedded()) {
            cdsXid2 = new cdsXid(4, 93, 103);
        } else if (J2EEDataSourceTest.usingDerbyNetClient()) {
            cdsXid2 = new cdsXid(5, 93, 103);
        }
        try {
            xAConnection.getXAResource().start(cdsXid2, 0);
        }
        catch (XAException xAException) {
            if (J2EEDataSourceTest.usingEmbedded()) {
                J2EEDataSourceTest.assertNull((Object)xAException.getMessage());
            } else if (J2EEDataSourceTest.usingDerbyNetClient()) {
                J2EEDataSourceTest.assertTrue((xAException.getMessage().indexOf("XAER_OUTSIDE") >= 0 ? 1 : 0) != 0);
            }
            J2EEDataSourceTest.assertEquals((int)-9, (int)xAException.errorCode);
        }
        resultSet.next();
        J2EEDataSourceTest.assertEquals((int)3, (int)resultSet.getInt(1));
        resultSet.close();
        connection.rollback();
        connection.close();
        xAConnection.close();
    }

    public void testReadOnlyToWritableTran() throws SQLException, Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("delete from autocommitxastart where i = 6");
        statement.executeUpdate("delete from autocommitxastart where i = 7");
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        XAConnection xAConnection = xADataSource.getXAConnection();
        cdsXid cdsXid2 = new cdsXid(5, 119, -127);
        Connection connection = xAConnection.getConnection();
        Statement statement2 = connection.createStatement();
        XAResource xAResource = xAConnection.getXAResource();
        xAResource.start(cdsXid2, 0);
        connection.setReadOnly(true);
        if (J2EEDataSourceTest.usingEmbedded()) {
            this.assertConnectionState(2, 2, false, true, connection);
        } else if (J2EEDataSourceTest.usingDerbyNetClient()) {
            this.assertConnectionState(2, 2, false, false, connection);
        }
        ResultSet resultSet = statement2.executeQuery("select count(*) from autocommitxastart");
        resultSet.next();
        J2EEDataSourceTest.assertEquals((int)5, (int)resultSet.getInt(1));
        resultSet.close();
        xAResource.end(cdsXid2, 0x4000000);
        xAResource.commit(cdsXid2, true);
        connection.close();
        connection = xAConnection.getConnection();
        statement2 = connection.createStatement();
        xAResource.start(cdsXid2, 0);
        this.assertConnectionState(2, 2, false, false, connection);
        statement2.executeUpdate("insert into autocommitxastart values 6,7");
        resultSet = statement2.executeQuery("select count(*) from autocommitxastart");
        resultSet.next();
        J2EEDataSourceTest.assertEquals((int)7, (int)resultSet.getInt(1));
        xAResource.end(cdsXid2, 0x4000000);
        xAResource.commit(cdsXid2, true);
        connection.close();
        xAConnection.close();
        statement2.close();
    }

    public void testJira95pds() throws Exception {
        try {
            ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
            JDBCDataSource.setBeanProperty(connectionPoolDataSource, "databaseName", "jdbc:derby:boo");
            connectionPoolDataSource.getPooledConnection();
            J2EEDataSourceTest.fail((String)"expected an SQLException!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("XCY00", sQLException);
        }
        catch (Exception exception) {
            throw exception;
        }
    }

    public void testJira95xads() throws SQLException {
        try {
            XADataSource xADataSource = J2EEDataSource.getXADataSource();
            JDBCDataSource.setBeanProperty(xADataSource, "databaseName", "jdbc:derby:boo");
            xADataSource.getXAConnection().getConnection();
            J2EEDataSourceTest.fail((String)"expected an SQLException!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("XCY00", sQLException);
        }
    }

    public void testBadConnectionAttributeSyntax() throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "ConnectionAttributes", "bad");
        try {
            connectionPoolDataSource.getPooledConnection();
            J2EEDataSourceTest.fail((String)"should have seen an error");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("XJ028", sQLException);
        }
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        JDBCDataSource.setBeanProperty(xADataSource, "ConnectionAttributes", "bad");
        try {
            xADataSource.getXAConnection();
            J2EEDataSourceTest.fail((String)"should have seen an error");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("XJ028", sQLException);
        }
    }

    public void testClientDSConnectionAttributes() throws SQLException, ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        ClientXADataSourceInterface clientXADataSourceInterface;
        ClientConnectionPoolDataSourceInterface clientConnectionPoolDataSourceInterface;
        Class<?> clazz;
        if (J2EEDataSourceTest.usingEmbedded()) {
            return;
        }
        if (JDBC.vmSupportsJNDI()) {
            clazz = Class.forName("org.apache.derby.jdbc.ClientConnectionPoolDataSource");
            clientConnectionPoolDataSourceInterface = (ClientConnectionPoolDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            clazz = Class.forName("org.apache.derby.jdbc.BasicClientConnectionPoolDataSource40");
            clientConnectionPoolDataSourceInterface = (ClientConnectionPoolDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        clientConnectionPoolDataSourceInterface.setPortNumber(TestConfiguration.getCurrent().getPort());
        J2EEDataSourceTest.dsCPConnectionRequests(new String[]{"08001", "08001", "08001", "08001", "08001", "08001", "08001", "08001", "08001"}, (ConnectionPoolDataSource)clientConnectionPoolDataSourceInterface);
        clientConnectionPoolDataSourceInterface.setConnectionAttributes("databaseName=" + dbName);
        J2EEDataSourceTest.dsCPConnectionRequests(new String[]{"08001", "08001", "08001", "08001", "08001", "08001", "08001", "08001", "08001"}, (ConnectionPoolDataSource)clientConnectionPoolDataSourceInterface);
        clientConnectionPoolDataSourceInterface.setConnectionAttributes(null);
        clientConnectionPoolDataSourceInterface.setConnectionAttributes("databaseName=kangaroo");
        clientConnectionPoolDataSourceInterface.setDatabaseName(dbName);
        J2EEDataSourceTest.dsCPConnectionRequests(new String[]{"OK", "08001", "OK", "OK", "08001", "08001", "OK", "OK", "OK"}, (ConnectionPoolDataSource)clientConnectionPoolDataSourceInterface);
        clientConnectionPoolDataSourceInterface.setConnectionAttributes(null);
        clientConnectionPoolDataSourceInterface.setDatabaseName(null);
        if (JDBC.vmSupportsJNDI()) {
            clazz = Class.forName("org.apache.derby.jdbc.ClientXADataSource");
            clientXADataSourceInterface = (ClientXADataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            clazz = Class.forName("org.apache.derby.jdbc.BasicClientXADataSource40");
            clientXADataSourceInterface = (ClientXADataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        clientXADataSourceInterface.setPortNumber(TestConfiguration.getCurrent().getPort());
        J2EEDataSourceTest.dsXAConnectionRequests(new String[]{"08001", "08001", "08001", "08001", "08001", "08001", "08001", "08001", "08001"}, (XADataSource)clientXADataSourceInterface);
        clientXADataSourceInterface.setConnectionAttributes("databaseName=wombat");
        J2EEDataSourceTest.dsXAConnectionRequests(new String[]{"08001", "08001", "08001", "08001", "08001", "08001", "08001", "08001", "08001"}, (XADataSource)clientXADataSourceInterface);
        clientXADataSourceInterface.setConnectionAttributes(null);
        clientXADataSourceInterface.setConnectionAttributes("databaseName=kangaroo");
        clientXADataSourceInterface.setDatabaseName("wombat");
        J2EEDataSourceTest.dsXAConnectionRequests(new String[]{"OK", "08001", "OK", "OK", "08001", "08001", "OK", "OK", "OK"}, (XADataSource)clientXADataSourceInterface);
        clientXADataSourceInterface.setConnectionAttributes(null);
        clientXADataSourceInterface.setDatabaseName(null);
    }

    public void testDSRequestAuthentication() throws Exception {
        JDBCClient jDBCClient = this.getTestConfiguration().getJDBCClient();
        String string = jDBCClient.getDataSourceClassName();
        Class<?> clazz = Class.forName(string);
        DataSource dataSource = (DataSource)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        JDBCDataSource.setBeanProperty(dataSource, "attributesAsPassword", Boolean.TRUE);
        J2EEDataSourceTest.dsConnectionRequests(new String[]{"XJ004", "XJ004", "XJ004", "XJ028", "XJ028", "XJ004", "XJ004", "XJ004", "XJ004"}, dataSource);
        JDBCDataSource.setBeanProperty(dataSource, "attributesAsPassword", Boolean.FALSE);
        JDBCDataSource.setBeanProperty(dataSource, "attributesAsPassword", Boolean.TRUE);
        JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", "databaseName=kangaroo");
        J2EEDataSourceTest.dsConnectionRequests(new String[]{"XJ004", "XJ004", "XJ004", "XJ028", "XJ028", "XJ004", "XJ004", "XJ004", "XJ004"}, dataSource);
        JDBCDataSource.setBeanProperty(dataSource, "attributesAsPassword", Boolean.FALSE);
        JDBCDataSource.clearStringBeanProperty(dataSource, "connectionAttributes");
        J2EEDataSourceTest.setDatabaseProperty("derby.user.fred", "wilma");
        J2EEDataSourceTest.setDatabaseProperty("derby.user.APP", "APP");
        J2EEDataSourceTest.setDatabaseProperty("derby.authentication.provider", "BUILTIN");
        J2EEDataSourceTest.setDatabaseProperty("derby.connection.requireAuthentication", "true");
        JDBCDataSource.setBeanProperty(dataSource, "shutdownDatabase", "shutdown");
        try {
            dataSource.getConnection();
            J2EEDataSourceTest.fail((String)"shutdown should raise exception");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("XJ015", sQLException);
        }
        JDBCDataSource.clearStringBeanProperty(dataSource, "databaseName");
        JDBCDataSource.clearStringBeanProperty(dataSource, "shutdownDatabase");
        JDBCDataSource.setBeanProperty(dataSource, "attributesAsPassword", Boolean.TRUE);
        J2EEDataSourceTest.dsConnectionRequests(new String[]{"XJ004", "XJ004", "XJ004", "XJ028", "XJ028", "XJ004", "XJ004", "XJ004", "XJ004"}, dataSource);
        JDBCDataSource.setBeanProperty(dataSource, "attributesAsPassword", Boolean.FALSE);
        JDBCDataSource.setBeanProperty(dataSource, "attributesAsPassword", Boolean.TRUE);
        JDBCDataSource.setBeanProperty(dataSource, "user", "fred");
        JDBCDataSource.setBeanProperty(dataSource, "password", "databaseName=" + dbName + ";password=wilma");
        J2EEDataSourceTest.dsConnectionRequests(new String[]{"XJ004", "XJ004", "XJ004", "XJ028", "XJ028", "XJ004", "XJ004", "XJ004", "XJ004"}, dataSource);
        JDBCDataSource.setBeanProperty(dataSource, "attributesAsPassword", Boolean.FALSE);
        JDBCDataSource.clearStringBeanProperty(dataSource, "user");
        JDBCDataSource.clearStringBeanProperty(dataSource, "password");
        dataSource = null;
        String string2 = jDBCClient.getConnectionPoolDataSourceClassName();
        clazz = Class.forName(string2);
        ConnectionPoolDataSource connectionPoolDataSource = (ConnectionPoolDataSource)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        J2EEDataSourceTest.dsCPConnectionRequests(new String[]{"XJ004", "XJ004", "XJ004", "XJ004", "XJ004", "XJ004", "XJ004", "XJ004", "XJ004"}, connectionPoolDataSource);
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "connectionAttributes", "databaseName=" + dbName);
        J2EEDataSourceTest.dsCPConnectionRequests(new String[]{"XJ004", "XJ004", "XJ004", "XJ004", "XJ004", "XJ004", "XJ004", "XJ004", "XJ004"}, connectionPoolDataSource);
        JDBCDataSource.clearStringBeanProperty(connectionPoolDataSource, "connectionAttributes");
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "attributesAsPassword", Boolean.TRUE);
        J2EEDataSourceTest.dsCPConnectionRequests(new String[]{"XJ004", "XJ004", "XJ004", "XJ028", "XJ028", "XJ004", "XJ004", "XJ004", "XJ004"}, connectionPoolDataSource);
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "attributesAsPassword", Boolean.FALSE);
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "attributesAsPassword", Boolean.TRUE);
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "user", "fred");
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "password", "databaseName=" + dbName + ";password=wilma");
        J2EEDataSourceTest.dsCPConnectionRequests(new String[]{"XJ004", "XJ004", "XJ004", "XJ028", "XJ028", "XJ004", "XJ004", "XJ004", "XJ004"}, connectionPoolDataSource);
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "attributesAsPassword", Boolean.FALSE);
        JDBCDataSource.clearStringBeanProperty(connectionPoolDataSource, "user");
        JDBCDataSource.clearStringBeanProperty(connectionPoolDataSource, "password");
        connectionPoolDataSource = null;
        String string3 = jDBCClient.getXADataSourceClassName();
        clazz = Class.forName(string3);
        XADataSource xADataSource = (XADataSource)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        J2EEDataSourceTest.dsXAConnectionRequests(new String[]{"08006", "08006", "08006", "08006", "08006", "08006", "08006", "08006", "08006"}, xADataSource);
        JDBCDataSource.setBeanProperty(xADataSource, "databaseName", dbName);
        J2EEDataSourceTest.dsXAConnectionRequests(new String[]{"08004", "08004", "08004", "OK", "08004", "08004", "08004", "08004", "08004"}, xADataSource);
        JDBCDataSource.clearStringBeanProperty(xADataSource, "databaseName");
        JDBCDataSource.setBeanProperty(xADataSource, "connectionAttributes", "databaseName=" + dbName);
        J2EEDataSourceTest.dsXAConnectionRequests(new String[]{"08006", "08006", "08006", "08006", "08006", "08006", "08006", "08006", "08006"}, xADataSource);
        JDBCDataSource.clearStringBeanProperty(xADataSource, "connectionAttributes");
        JDBCDataSource.setBeanProperty(xADataSource, "attributesAsPassword", Boolean.TRUE);
        J2EEDataSourceTest.dsXAConnectionRequests(new String[]{"08006", "08006", "08006", "08006", "08006", "08006", "08006", "08006", "08006"}, xADataSource);
        JDBCDataSource.setBeanProperty(xADataSource, "attributesAsPassword", Boolean.FALSE);
        JDBCDataSource.setBeanProperty(xADataSource, "databaseName", dbName);
        JDBCDataSource.setBeanProperty(xADataSource, "attributesAsPassword", Boolean.TRUE);
        J2EEDataSourceTest.dsXAConnectionRequests(new String[]{"08004", "08004", "08004", "XJ028", "XJ028", "08004", "08004", "OK", "08004"}, xADataSource);
        JDBCDataSource.setBeanProperty(xADataSource, "attributesAsPassword", Boolean.FALSE);
        JDBCDataSource.clearStringBeanProperty(xADataSource, "databaseName");
        J2EEDataSourceTest.setDatabaseProperty("derby.connection.requireAuthentication", "false");
        TestConfiguration.getCurrent().shutdownDatabase();
    }

    public void testClientTraceFileDSConnectionAttribute() throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        String string = "trace3.out";
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "connectionAttributes", "traceFile=" + string);
        ((PooledConnection)J2EEDataSourceTest.getPhysicalConnection(connectionPoolDataSource)).close();
        JDBCDataSource.clearStringBeanProperty(connectionPoolDataSource, "connectionAttributes");
        string = "trace4.out";
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "traceFile", string);
        ((PooledConnection)J2EEDataSourceTest.getPhysicalConnection(connectionPoolDataSource)).close();
        connectionPoolDataSource = null;
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        string = "trace5.out";
        JDBCDataSource.setBeanProperty(xADataSource, "connectionAttributes", "traceFile=" + string);
        ((XAConnection)J2EEDataSourceTest.getPhysicalConnection(xADataSource)).close();
        JDBCDataSource.clearStringBeanProperty(xADataSource, "connectionAttributes");
        string = "trace6.out";
        JDBCDataSource.setBeanProperty(xADataSource, "traceFile", string);
        ((XAConnection)J2EEDataSourceTest.getPhysicalConnection(xADataSource)).close();
        J2EEDataSourceTest.assertTraceFilesExistAndCanBeDeleted();
    }

    private static void assertTraceFilesExistAndCanBeDeleted() {
        for (int i = 3; i <= 6; ++i) {
            File file = new File("trace" + i + ".out");
            J2EEDataSourceTest.assertTrue((String)"Doesn't exist", (boolean)PrivilegedFileOpsForTests.exists(file));
            J2EEDataSourceTest.assertTrue((String)"Delete failed", (boolean)PrivilegedFileOpsForTests.delete(file));
        }
    }

    public void testClientMessageTextConnectionAttribute() throws SQLException, ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        ClientXADataSourceInterface clientXADataSourceInterface;
        ClientConnectionPoolDataSourceInterface clientConnectionPoolDataSourceInterface;
        Class<?> clazz;
        String string = "retrieveMessageText";
        if (JDBC.vmSupportsJNDI()) {
            clazz = Class.forName("org.apache.derby.jdbc.ClientConnectionPoolDataSource");
            clientConnectionPoolDataSourceInterface = (ClientConnectionPoolDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            clazz = Class.forName("org.apache.derby.jdbc.BasicClientConnectionPoolDataSource40");
            clientConnectionPoolDataSourceInterface = (ClientConnectionPoolDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        clientConnectionPoolDataSourceInterface.setPortNumber(TestConfiguration.getCurrent().getPort());
        clientConnectionPoolDataSourceInterface.setDatabaseName(dbName);
        clientConnectionPoolDataSourceInterface.setConnectionAttributes(string + "=false");
        PooledConnection pooledConnection = clientConnectionPoolDataSourceInterface.getPooledConnection();
        J2EEDataSourceTest.assertMessageText(pooledConnection.getConnection(), "false");
        pooledConnection.close();
        clientConnectionPoolDataSourceInterface.setConnectionAttributes(string + "=true");
        pooledConnection = clientConnectionPoolDataSourceInterface.getPooledConnection();
        J2EEDataSourceTest.assertMessageText(pooledConnection.getConnection(), "true");
        clientConnectionPoolDataSourceInterface.setConnectionAttributes(null);
        pooledConnection.close();
        if (JDBC.vmSupportsJNDI()) {
            clazz = Class.forName("org.apache.derby.jdbc.ClientXADataSource");
            clientXADataSourceInterface = (ClientXADataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            clazz = Class.forName("org.apache.derby.jdbc.BasicClientXADataSource40");
            clientXADataSourceInterface = (ClientXADataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        clientXADataSourceInterface.setPortNumber(TestConfiguration.getCurrent().getPort());
        clientXADataSourceInterface.setDatabaseName(dbName);
        clientXADataSourceInterface.setConnectionAttributes(string + "=false");
        XAConnection xAConnection = clientXADataSourceInterface.getXAConnection();
        J2EEDataSourceTest.assertMessageText(xAConnection.getConnection(), "false");
        xAConnection.close();
        clientXADataSourceInterface.setConnectionAttributes(string + "=true");
        xAConnection = clientXADataSourceInterface.getXAConnection();
        J2EEDataSourceTest.assertMessageText(xAConnection.getConnection(), "true");
        xAConnection.close();
        clientXADataSourceInterface.setConnectionAttributes(null);
    }

    private static void assertMessageText(Connection connection, String string) throws SQLException {
        try {
            connection.createStatement().executeQuery("SELECT * FROM APP.NOTTHERE");
            J2EEDataSourceTest.fail((String)"SQLException of 42X05 should be thrown!");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("42X05", sQLException);
            if (string.equals("true")) {
                J2EEDataSourceTest.assertTrue((sQLException.getMessage().indexOf("does not exist") >= 0 ? 1 : 0) != 0);
            } else {
                J2EEDataSourceTest.assertTrue((sQLException.getMessage().indexOf("does not exist") == -1 ? 1 : 0) != 0);
            }
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                J2EEDataSourceTest.println("Ignored error on close: " + sQLException.getMessage());
            }
        }
    }

    public void testDescriptionProperty() throws SQLException, Exception {
        this.subTestDataSourceDescription((DataSource)((Object)J2EEDataSource.getConnectionPoolDataSource()));
        this.subTestDataSourceDescription((DataSource)((Object)J2EEDataSource.getXADataSource()));
    }

    private void subTestDataSourceDescription(DataSource dataSource) throws Exception {
        String string = "Everything you ever wanted to know about this datasource";
        JDBCDataSource.setBeanProperty(dataSource, "description", string);
        J2EEDataSourceTest.getPhysicalConnection(dataSource);
        J2EEDataSourceTest.assertEquals((Object)string, (Object)JDBCDataSource.getBeanProperty(dataSource, "description"));
        JDBCDataSource.clearStringBeanProperty(dataSource, "description");
        J2EEDataSourceTest.assertNull((Object)JDBCDataSource.getBeanProperty(dataSource, "description"));
    }

    public void testXAHoldability() throws SQLException, XAException {
        if (J2EEDataSourceTest.usingDerbyNetClient()) {
            return;
        }
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        XAConnection xAConnection = xADataSource.getXAConnection();
        XAResource xAResource = xAConnection.getXAResource();
        cdsXid cdsXid2 = new cdsXid(25, 21, 1);
        Connection connection = xAConnection.getConnection();
        J2EEDataSourceTest.assertTrue((boolean)connection.getAutoCommit());
        J2EEDataSourceTest.assertEquals((int)1, (int)connection.getHoldability());
        xAResource.start(cdsXid2, 0);
        J2EEDataSourceTest.assertFalse((boolean)connection.getAutoCommit());
        J2EEDataSourceTest.assertEquals((int)2, (int)connection.getHoldability());
        xAResource.end(cdsXid2, 0x4000000);
        connection.commit();
        connection.close();
        cdsXid2 = new cdsXid(27, 21, 1);
        xAResource.start(cdsXid2, 0);
        connection = xAConnection.getConnection();
        J2EEDataSourceTest.assertEquals((int)2, (int)connection.getHoldability());
        J2EEDataSourceTest.assertFalse((boolean)connection.getAutoCommit());
        xAResource.end(cdsXid2, 0x4000000);
        connection.rollback();
        Connection connection2 = xAConnection.getConnection();
        connection2.setAutoCommit(false);
        connection2.setHoldability(2);
        J2EEDataSourceTest.assertEquals((int)2, (int)connection2.getHoldability());
        Statement statement = connection2.createStatement();
        J2EEDataSourceTest.assertEquals((int)2, (int)statement.getResultSetHoldability());
        statement.executeUpdate("insert into hold_30 values (1,'init2'), (2, 'init3'), (3,'init3')");
        statement.executeUpdate("insert into hold_30 values (4,'init4'), (5, 'init5'), (6,'init6')");
        statement.executeUpdate("insert into hold_30 values (7,'init7'), (8, 'init8'), (9,'init9')");
        J2EEDataSourceTest.assertEquals((int)2, (int)statement.getResultSetHoldability());
        Statement statement2 = connection2.createStatement(1003, 1007, 1);
        PreparedStatement preparedStatement = connection2.prepareStatement("select id from hold_30 for update", 1003, 1007, 1);
        CallableStatement callableStatement = connection2.prepareCall("select id from hold_30 for update", 1003, 1007, 1);
        J2EEDataSourceTest.assertEquals((int)1, (int)statement2.getResultSetHoldability());
        J2EEDataSourceTest.assertEquals((int)1, (int)preparedStatement.getResultSetHoldability());
        J2EEDataSourceTest.assertEquals((int)1, (int)callableStatement.getResultSetHoldability());
        ResultSet resultSet = statement2.executeQuery("select id from hold_30 for update");
        resultSet.next();
        J2EEDataSourceTest.assertEquals((int)1, (int)resultSet.getInt(1));
        resultSet.next();
        J2EEDataSourceTest.assertEquals((int)2, (int)resultSet.getInt(1));
        connection2.commit();
        resultSet.next();
        J2EEDataSourceTest.assertEquals((int)3, (int)resultSet.getInt(1));
        connection2.commit();
        cdsXid2 = new cdsXid(23, 21, 1);
        xAResource.start(cdsXid2, 0);
        Statement statement3 = connection2.createStatement();
        PreparedStatement preparedStatement2 = connection2.prepareStatement("select id from hold_30");
        CallableStatement callableStatement2 = connection2.prepareCall("select id from hold_30");
        J2EEDataSourceTest.assertEquals((int)2, (int)connection2.getHoldability());
        J2EEDataSourceTest.assertEquals((int)2, (int)statement.getResultSetHoldability());
        if (J2EEDataSourceTest.usingEmbedded()) {
            J2EEDataSourceTest.assertEquals((int)2, (int)statement2.getResultSetHoldability());
        } else if (J2EEDataSourceTest.usingDerbyNetClient()) {
            J2EEDataSourceTest.assertEquals((int)1, (int)statement2.getResultSetHoldability());
        }
        J2EEDataSourceTest.assertEquals((int)2, (int)statement3.getResultSetHoldability());
        J2EEDataSourceTest.assertEquals((int)2, (int)preparedStatement2.getResultSetHoldability());
        J2EEDataSourceTest.assertEquals((int)2, (int)callableStatement2.getResultSetHoldability());
        ResultSet resultSet2 = statement.executeQuery("select id from hold_30 for update");
        resultSet2.next();
        J2EEDataSourceTest.assertEquals((int)1, (int)resultSet2.getInt(1));
        resultSet2.next();
        J2EEDataSourceTest.assertEquals((int)2, (int)resultSet2.getInt(1));
        xAResource.end(cdsXid2, 0x4000000);
        try {
            resultSet2.next();
            J2EEDataSourceTest.fail((String)"rsx's connection not active id ");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        try {
            resultSet.next();
            J2EEDataSourceTest.fail((String)"rsh's connection not active id ");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("XCL16", sQLException);
        }
        xAResource.start(cdsXid2, 0x200000);
        Statement statement4 = connection2.createStatement();
        PreparedStatement preparedStatement3 = connection2.prepareStatement("select id from hold_30");
        CallableStatement callableStatement3 = connection2.prepareCall("select id from hold_30");
        J2EEDataSourceTest.assertEquals((int)2, (int)connection2.getHoldability());
        J2EEDataSourceTest.assertEquals((int)2, (int)statement.getResultSetHoldability());
        if (J2EEDataSourceTest.usingEmbedded()) {
            J2EEDataSourceTest.assertEquals((int)2, (int)statement2.getResultSetHoldability());
        } else if (J2EEDataSourceTest.usingDerbyNetClient()) {
            J2EEDataSourceTest.assertEquals((int)1, (int)statement2.getResultSetHoldability());
        }
        J2EEDataSourceTest.assertEquals((int)2, (int)statement3.getResultSetHoldability());
        J2EEDataSourceTest.assertEquals((int)2, (int)preparedStatement2.getResultSetHoldability());
        J2EEDataSourceTest.assertEquals((int)2, (int)callableStatement2.getResultSetHoldability());
        J2EEDataSourceTest.assertEquals((int)2, (int)statement4.getResultSetHoldability());
        J2EEDataSourceTest.assertEquals((int)2, (int)preparedStatement3.getResultSetHoldability());
        J2EEDataSourceTest.assertEquals((int)2, (int)callableStatement3.getResultSetHoldability());
        if (J2EEDataSourceTest.usingEmbedded()) {
            resultSet2.next();
            J2EEDataSourceTest.assertEquals((int)3, (int)resultSet2.getInt(1));
        }
        xAResource.end(cdsXid2, 0x4000000);
        if (xAResource.prepare(cdsXid2) != 3) {
            xAResource.commit(cdsXid2, false);
        }
        try {
            resultSet2.next();
            J2EEDataSourceTest.fail((String)"rsx's connection not active id (B)");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("XCL16", sQLException);
        }
        try {
            resultSet.next();
            J2EEDataSourceTest.fail((String)"rsh's should be closed (B)");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("XCL16", sQLException);
        }
        connection2.setHoldability(1);
        J2EEDataSourceTest.assertEquals((int)1, (int)connection2.getHoldability());
        cdsXid2 = new cdsXid(24, 21, 1);
        xAResource.start(cdsXid2, 0);
        J2EEDataSourceTest.assertEquals((int)2, (int)connection2.getHoldability());
        try {
            connection2.setHoldability(1);
            J2EEDataSourceTest.fail((String)"allowed to set hold mode in xa transaction");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("XJ05C", sQLException);
        }
        Statement statement5 = connection2.createStatement(1003, 1007, 1);
        J2EEDataSourceTest.assertEquals((int)2, (int)statement.getResultSetHoldability());
        J2EEDataSourceTest.assertErrorCode(10000, connection2.getWarnings());
        statement5.close();
        statement5 = connection2.prepareStatement("select id from hold_30", 1003, 1007, 1);
        J2EEDataSourceTest.assertEquals((int)2, (int)statement.getResultSetHoldability());
        J2EEDataSourceTest.assertErrorCode(10000, connection2.getWarnings());
        statement5.close();
        statement5 = connection2.prepareCall("CALL SYSCS_UTIL.SYSCS_CHECKPOINT_DATABASE()", 1003, 1007, 1);
        J2EEDataSourceTest.assertEquals((int)2, (int)statement.getResultSetHoldability());
        J2EEDataSourceTest.assertErrorCode(10000, connection2.getWarnings());
        statement5.close();
        if (J2EEDataSourceTest.usingEmbedded()) {
            J2EEDataSourceTest.assertEquals((int)2, (int)statement2.getResultSetHoldability());
            statement2.executeQuery("select id from hold_30").close();
            statement2.execute("select id from hold_30");
            statement2.getResultSet().close();
            J2EEDataSourceTest.assertEquals((int)2, (int)preparedStatement.getResultSetHoldability());
            preparedStatement.executeQuery().close();
            preparedStatement.execute();
            preparedStatement.getResultSet().close();
            J2EEDataSourceTest.assertEquals((int)2, (int)callableStatement.getResultSetHoldability());
            callableStatement.executeQuery().close();
            callableStatement.execute();
            callableStatement.getResultSet().close();
        }
        statement2.executeUpdate("insert into hold_30 values(10, 'init10')");
        xAResource.end(cdsXid2, 0x4000000);
        J2EEDataSourceTest.assertEquals((int)1, (int)connection2.getHoldability());
        statement.close();
        statement2.close();
        callableStatement.close();
        preparedStatement.close();
        resultSet2.close();
        statement3.close();
        preparedStatement2.close();
        callableStatement2.close();
        statement4.close();
        preparedStatement3.close();
        callableStatement3.close();
        connection2.close();
        xAConnection.close();
        TestConfiguration.getCurrent().shutdownDatabase();
    }

    public void testConnectionLeakInDatabaseMetaData() throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        PooledConnection pooledConnection = connectionPoolDataSource.getPooledConnection();
        Connection connection = pooledConnection.getConnection();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        J2EEDataSourceTest.assertSame((Object)connection, (Object)databaseMetaData.getConnection());
        connection.close();
        Connection connection2 = pooledConnection.getConnection();
        DatabaseMetaData databaseMetaData2 = connection2.getMetaData();
        J2EEDataSourceTest.assertSame((Object)connection2, (Object)databaseMetaData2.getConnection());
        try {
            databaseMetaData.getConnection();
            J2EEDataSourceTest.fail((String)"Should have thrown no current connection exception");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        connection2.close();
        pooledConnection.close();
        try {
            databaseMetaData2.getConnection();
            J2EEDataSourceTest.fail((String)"Should have thrown no current connection exception");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
    }

    public void testDerby3799() throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        PooledConnection pooledConnection = connectionPoolDataSource.getPooledConnection();
        Connection connection = pooledConnection.getConnection();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select dClob from derby3799");
        J2EEDataSourceTest.assertTrue((boolean)resultSet.next());
        resultSet.getString(1);
        resultSet.close();
        connection.close();
        Connection connection2 = pooledConnection.getConnection();
        statement = connection2.createStatement();
        resultSet = statement.executeQuery("select dClob from derby3799");
        J2EEDataSourceTest.assertTrue((boolean)resultSet.next());
        resultSet.getString(1);
        connection2.close();
    }

    public void timeoutTestDerby1144PooledDS() throws SQLException {
        PooledConnection pooledConnection = null;
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        pooledConnection = connectionPoolDataSource.getPooledConnection();
        J2EEDataSourceTest.assertPooledConnHoldability("PooledConnection", pooledConnection);
        pooledConnection.close();
        pooledConnection = connectionPoolDataSource.getPooledConnection();
        J2EEDataSourceTest.assertPooledConnAutoCommit("PooledConnection", pooledConnection);
        pooledConnection.close();
        pooledConnection = connectionPoolDataSource.getPooledConnection();
        this.assertPooledConnIso("PooledConnection", pooledConnection);
        pooledConnection.close();
    }

    public void timeoutTestDerby1144XADS() throws SQLException {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        XAConnection xAConnection = xADataSource.getXAConnection();
        this.assertPooledConnIso("XAConnection", xAConnection);
        xAConnection.close();
    }

    private static void assertPooledConnAutoCommit(String string, PooledConnection pooledConnection) throws SQLException {
        Connection connection = pooledConnection.getConnection();
        connection.setAutoCommit(true);
        connection = pooledConnection.getConnection();
        boolean bl = connection.getAutoCommit();
        J2EEDataSourceTest.assertTrue((boolean)bl);
        connection.close();
    }

    private static void assertPooledConnHoldability(String string, PooledConnection pooledConnection) throws SQLException {
        Connection connection = pooledConnection.getConnection();
        connection.setHoldability(2);
        connection = pooledConnection.getConnection();
        J2EEDataSourceTest.assertConnHoldability(connection, 1);
        connection.close();
    }

    private static void assertConnHoldability(Connection connection, int n) throws SQLException {
        int n2 = connection.getHoldability();
        J2EEDataSourceTest.assertEquals((int)n, (int)n2);
    }

    private void assertPooledConnIso(String string, PooledConnection pooledConnection) throws SQLException {
        Connection connection = pooledConnection.getConnection();
        J2EEDataSourceTest.setupDerby1144Table(connection);
        connection.setTransactionIsolation(1);
        this.assertIsoLocks(connection, 1);
        connection.close();
        Connection connection2 = pooledConnection.getConnection();
        this.assertIsoLocks(connection2, 2);
    }

    private static void setupDerby1144Table(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        statement.executeUpdate("INSERT INTO intTable VALUES(1)");
        statement.executeUpdate("INSERT INTO intTable VALUES(2)");
        connection.commit();
    }

    private void assertIsoLocks(Connection connection, int n) throws SQLException {
        int n2 = connection.getTransactionIsolation();
        J2EEDataSourceTest.assertEquals((int)n, (int)n2);
        boolean bl = this.selectTimesoutDuringUpdate(connection);
        switch (n2) {
            case 1: {
                J2EEDataSourceTest.assertFalse((boolean)bl);
                break;
            }
            case 2: {
                J2EEDataSourceTest.assertTrue((boolean)bl);
                break;
            }
            default: {
                System.out.println("No test support for isolation level");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean selectTimesoutDuringUpdate(Connection connection) throws SQLException {
        Connection connection2 = null;
        connection.setAutoCommit(false);
        try {
            connection2 = this.openDefaultConnection();
            connection2.setAutoCommit(false);
            Statement statement = connection2.createStatement();
            statement.executeUpdate("update intTable set i = 3");
            Statement statement2 = connection.createStatement();
            JDBC.assertDrainResults(statement2.executeQuery("Select * from intTable"));
            statement2.close();
        }
        catch (SQLException sQLException) {
            if (sQLException.getSQLState().equals("40XL1")) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            try {
                connection.rollback();
                connection2.rollback();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
        return false;
    }

    private void assertConnectionState(int n, int n2, boolean bl, boolean bl2, Connection connection) throws SQLException {
        J2EEDataSourceTest.assertEquals((int)n, (int)connection.getHoldability());
        J2EEDataSourceTest.assertEquals((int)n2, (int)connection.getTransactionIsolation());
        J2EEDataSourceTest.assertEquals((boolean)bl, (boolean)connection.getAutoCommit());
        J2EEDataSourceTest.assertEquals((boolean)bl2, (boolean)connection.isReadOnly());
    }

    private static void setDatabaseProperty(String string, String string2) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource();
        Connection connection = dataSource.getConnection();
        CallableStatement callableStatement = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, ?)");
        callableStatement.setString(1, string);
        callableStatement.setString(2, string2);
        callableStatement.execute();
        callableStatement.close();
        connection.close();
    }

    private void setHoldability(Connection connection, boolean bl) throws SQLException {
        connection.setHoldability(bl ? 1 : 2);
    }

    private static void dsConnectionRequests(String[] stringArray, DataSource dataSource) {
        if (J2EEDataSourceTest.usingEmbedded()) {
            SecurityCheck.assertSourceSecurity(dataSource, "javax.sql.DataSource");
        }
        try {
            dataSource.getConnection();
            if (!stringArray[0].equals("OK")) {
                J2EEDataSourceTest.fail((String)" expected connection to fail, but was OK");
            }
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState(stringArray[0], sQLException);
        }
        J2EEDataSourceTest.dsConnectionRequest(stringArray[1], dataSource, null, null);
        J2EEDataSourceTest.dsConnectionRequest(stringArray[2], dataSource, "fred", null);
        J2EEDataSourceTest.dsConnectionRequest(stringArray[3], dataSource, "fred", "wilma");
        J2EEDataSourceTest.dsConnectionRequest(stringArray[4], dataSource, null, "wilma");
        J2EEDataSourceTest.dsConnectionRequest(stringArray[5], dataSource, null, "databaseName=wombat");
        J2EEDataSourceTest.dsConnectionRequest(stringArray[6], dataSource, "fred", "databaseName=wombat");
        J2EEDataSourceTest.dsConnectionRequest(stringArray[7], dataSource, "fred", "databaseName=wombat;password=wilma");
        J2EEDataSourceTest.dsConnectionRequest(stringArray[8], dataSource, "fred", "databaseName=wombat;password=betty");
    }

    private static void dsConnectionRequest(String string, DataSource dataSource, String string2, String string3) {
        try {
            dataSource.getConnection(string2, string3);
            if (!string.equals("OK")) {
                J2EEDataSourceTest.fail((String)" expected connection to fail, but was OK");
            }
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState(string, sQLException);
        }
    }

    private static void dsCPConnectionRequests(String[] stringArray, ConnectionPoolDataSource connectionPoolDataSource) {
        try {
            connectionPoolDataSource.getPooledConnection();
            if (!stringArray[0].equals("OK")) {
                J2EEDataSourceTest.fail((String)" expected connection to fail, but was OK");
            }
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState(stringArray[0], sQLException);
        }
        J2EEDataSourceTest.dsConnectionRequest(stringArray[1], connectionPoolDataSource, null, null);
        J2EEDataSourceTest.dsConnectionRequest(stringArray[2], connectionPoolDataSource, "fred", null);
        J2EEDataSourceTest.dsConnectionRequest(stringArray[3], connectionPoolDataSource, "fred", "wilma");
        J2EEDataSourceTest.dsConnectionRequest(stringArray[4], connectionPoolDataSource, null, "wilma");
        J2EEDataSourceTest.dsConnectionRequest(stringArray[5], connectionPoolDataSource, null, "databaseName=wombat");
        J2EEDataSourceTest.dsConnectionRequest(stringArray[6], connectionPoolDataSource, "fred", "databaseName=wombat");
        J2EEDataSourceTest.dsConnectionRequest(stringArray[7], connectionPoolDataSource, "fred", "databaseName=wombat;password=wilma");
        J2EEDataSourceTest.dsConnectionRequest(stringArray[8], connectionPoolDataSource, "fred", "databaseName=wombat;password=betty");
    }

    private static void dsConnectionRequest(String string, ConnectionPoolDataSource connectionPoolDataSource, String string2, String string3) {
        try {
            connectionPoolDataSource.getPooledConnection(string2, string3);
            if (!string.equals("OK")) {
                J2EEDataSourceTest.fail((String)" expected connection to fail, but was OK");
            }
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState(string, sQLException);
        }
    }

    private static void dsXAConnectionRequests(String[] stringArray, XADataSource xADataSource) {
        try {
            xADataSource.getXAConnection();
            if (!stringArray[0].equals("OK")) {
                J2EEDataSourceTest.fail((String)" expected connection to fail, but was OK");
            }
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState(stringArray[0], sQLException);
        }
        J2EEDataSourceTest.dsConnectionRequest(stringArray[1], xADataSource, null, null);
        J2EEDataSourceTest.dsConnectionRequest(stringArray[2], xADataSource, "fred", null);
        J2EEDataSourceTest.dsConnectionRequest(stringArray[3], xADataSource, "fred", "wilma");
        J2EEDataSourceTest.dsConnectionRequest(stringArray[4], xADataSource, null, "wilma");
        J2EEDataSourceTest.dsConnectionRequest(stringArray[5], xADataSource, null, "databaseName=" + dbName);
        J2EEDataSourceTest.dsConnectionRequest(stringArray[6], xADataSource, "fred", "databaseName=" + dbName);
        J2EEDataSourceTest.dsConnectionRequest(stringArray[7], xADataSource, "fred", "databaseName=" + dbName + ";password=wilma");
        J2EEDataSourceTest.dsConnectionRequest(stringArray[8], xADataSource, "fred", "databaseName=" + dbName + ";password=betty");
    }

    private static void dsConnectionRequest(String string, XADataSource xADataSource, String string2, String string3) {
        try {
            xADataSource.getXAConnection(string2, string3);
            if (!string.equals("OK")) {
                J2EEDataSourceTest.fail((String)" expected connection to fail, but was OK");
            }
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState(string, sQLException);
        }
    }

    protected void assertXAException(String string, XAException xAException) {
        if (J2EEDataSourceTest.usingEmbedded()) {
            J2EEDataSourceTest.assertEquals((String)"No current connection.", (String)xAException.getMessage());
        } else if (J2EEDataSourceTest.usingDerbyNetClient()) {
            J2EEDataSourceTest.assertEquals((String)"XAER_RMFAIL : No current connection.", (String)xAException.getMessage());
        }
        Throwable throwable = xAException.getCause();
        if (throwable instanceof SQLException) {
            J2EEDataSourceTest.assertSQLState("08003", (SQLException)throwable);
        }
    }

    private static void queryOnStatement(String string, int[] nArray, Connection connection, Statement statement) throws SQLException {
        if (J2EEDataSourceTest.usingEmbedded()) {
            J2EEDataSourceTest.assertEquals((Object)connection, (Object)statement.getConnection());
        }
        J2EEDataSourceTest.resultSetQuery(string, nArray, statement.executeQuery("select * from intTable"));
    }

    private static void resultSetQuery(String string, int[] nArray, ResultSet resultSet) throws SQLException {
        if (J2EEDataSourceTest.usingEmbedded()) {
            SecurityCheck.assertSourceSecurity(resultSet, "java.sql.ResultSet");
        }
        J2EEDataSourceTest.assertEquals((String)string, (String)resultSet.getCursorName());
        int n = 0;
        while (resultSet.next()) {
            J2EEDataSourceTest.assertEquals((int)nArray[n], (int)resultSet.getInt(1));
            ++n;
        }
        J2EEDataSourceTest.assertEquals((int)nArray.length, (int)n++);
        resultSet.close();
    }

    private static void assertLocks(int[] nArray, Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT XID, sum(cast (LOCKCOUNT AS INT)) FROM SYSCS_DIAG.LOCK_TABLE AS L GROUP BY XID");
        int n = 0;
        while (resultSet.next()) {
            if (nArray != null) {
                J2EEDataSourceTest.assertEquals((int)nArray[n], (int)resultSet.getInt(2));
            } else {
                J2EEDataSourceTest.fail((String)"expected no locks");
            }
            ++n;
        }
        if (nArray != null) {
            J2EEDataSourceTest.assertEquals((int)nArray.length, (int)n);
        }
        resultSet.close();
        statement.close();
    }

    private void assertStatementState(int[] nArray, int[] nArray2, Statement statement) throws SQLException {
        J2EEDataSourceTest.assertEquals((int)nArray2[0], (int)statement.getResultSetType());
        J2EEDataSourceTest.assertEquals((int)nArray2[1], (int)statement.getResultSetConcurrency());
        J2EEDataSourceTest.assertEquals((int)nArray2[2], (int)statement.getFetchDirection());
        J2EEDataSourceTest.assertEquals((int)nArray2[3], (int)statement.getFetchSize());
        J2EEDataSourceTest.assertEquals((int)nArray2[4], (int)statement.getMaxFieldSize());
        J2EEDataSourceTest.assertEquals((int)nArray2[5], (int)statement.getMaxRows());
        J2EEDataSourceTest.assertEquals((int)nArray2[6], (int)statement.getResultSetHoldability());
        if (statement instanceof PreparedStatement) {
            PreparedStatement preparedStatement = (PreparedStatement)statement;
            ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
            J2EEDataSourceTest.assertEquals((int)nArray[0], (int)parameterMetaData.getParameterCount());
            for (int i = 1; i <= parameterMetaData.getParameterCount(); ++i) {
                J2EEDataSourceTest.assertEquals((int)nArray[i], (int)parameterMetaData.getParameterType(i));
            }
        }
    }

    private Statement createFloatStatementForStateChecking(int[] nArray, Connection connection) throws SQLException {
        Statement statement = this.internalCreateFloatStatementForStateChecking(connection);
        statement.setCursorName("StokeNewington");
        statement.setFetchDirection(1001);
        statement.setFetchSize(444);
        statement.setMaxFieldSize(713);
        statement.setMaxRows(19);
        this.assertStatementState(null, nArray, statement);
        return statement;
    }

    private Statement internalCreateFloatStatementForStateChecking(Connection connection) throws SQLException {
        return connection.createStatement(1004, 1007, 1);
    }

    private PreparedStatement createFloatStatementForStateChecking(int[] nArray, int[] nArray2, Connection connection, String string) throws SQLException {
        PreparedStatement preparedStatement = this.internalCreateFloatStatementForStateChecking(connection, string);
        preparedStatement.setCursorName("StokeNewington");
        preparedStatement.setFetchDirection(1001);
        preparedStatement.setFetchSize(888);
        preparedStatement.setMaxFieldSize(317);
        preparedStatement.setMaxRows(91);
        this.assertStatementState(nArray, nArray2, preparedStatement);
        return preparedStatement;
    }

    private PreparedStatement internalCreateFloatStatementForStateChecking(Connection connection, String string) throws SQLException {
        return connection.prepareStatement(string, 1004, 1007, 1);
    }

    private CallableStatement createFloatCallForStateChecking(int[] nArray, int[] nArray2, Connection connection, String string) throws SQLException {
        CallableStatement callableStatement = this.internalCreateFloatCallForStateChecking(connection, string);
        callableStatement.setCursorName("StokeNewington");
        callableStatement.setFetchDirection(1001);
        callableStatement.setFetchSize(999);
        callableStatement.setMaxFieldSize(137);
        callableStatement.setMaxRows(85);
        this.assertStatementState(nArray, nArray2, callableStatement);
        return callableStatement;
    }

    private CallableStatement internalCreateFloatCallForStateChecking(Connection connection, String string) throws SQLException {
        return connection.prepareCall(string, 1004, 1007, 1);
    }

    private void assertConnectionOK(Object[] objectArray, String string, Connection connection) throws SQLException {
        Map<String, Class<?>> map;
        J2EEDataSourceTest.assertEquals((int)((Integer)objectArray[0]), (int)connection.getHoldability());
        try {
            connection.releaseSavepoint(connection.setSavepoint());
            if (connection.getAutoCommit()) {
                J2EEDataSourceTest.fail((String)"expected a SQLExpection (savepoint with autocommit on");
            }
            if (!((String)objectArray[1]).equals("OK")) {
                J2EEDataSourceTest.fail((String)"expected a SQLExpection (savepoint with autocommit on");
            }
        }
        catch (SQLException sQLException) {
            if (connection.getAutoCommit()) {
                J2EEDataSourceTest.assertSQLState("XJ010", sQLException);
            }
            if (((String)objectArray[1]).equals("OK")) {
                throw sQLException;
            }
            J2EEDataSourceTest.assertSQLState((String)objectArray[1], sQLException);
        }
        if (J2EEDataSourceTest.usingEmbedded()) {
            SecurityCheck.assertSourceSecurity(connection, "java.sql.Connection");
            SecurityCheck.assertSourceSecurity(connection.getMetaData(), "java.sql.DatabaseMetaData");
        }
        J2EEDataSourceTest.assertEquals((int)((Integer)objectArray[2]), (int)connection.getTransactionIsolation());
        J2EEDataSourceTest.assertEquals((boolean)((Boolean)objectArray[3]), (boolean)connection.getAutoCommit());
        J2EEDataSourceTest.assertEquals((boolean)((Boolean)objectArray[4]), (boolean)connection.isReadOnly());
        if (string.endsWith("DataSource")) {
            J2EEDataSourceTest.assertNull((Object)connection.getWarnings());
        }
        Statement statement = connection.createStatement();
        this.assertStatementOK(string, connection, statement);
        this.assertStatementOK(string, connection, connection.createStatement(1004, 1007));
        Connection connection2 = connection.getMetaData().getConnection();
        if (!J2EEDataSourceTest.usingDerbyNetClient() && string.indexOf("DataSource") >= 0) {
            J2EEDataSourceTest.assertEquals((Object)connection2, (Object)connection);
        }
        try {
            map = Collections.emptyMap();
            connection.setTypeMap(map);
            if (!((String)objectArray[5]).equals("OK")) {
                J2EEDataSourceTest.fail((String)" expected an sqlexception on setTypeMap(EMPTY_MAP)");
            }
        }
        catch (SQLException sQLException) {
            if (((String)objectArray[5]).equals("OK")) {
                throw sQLException;
            }
            J2EEDataSourceTest.assertSQLState((String)objectArray[5], sQLException);
        }
        try {
            connection.setTypeMap(null);
            J2EEDataSourceTest.fail((String)"setTypeMap(null) should throw exception");
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState((String)objectArray[6], sQLException);
        }
        try {
            map = new HashMap();
            map.put("name", Class.class);
            connection.setTypeMap(map);
            if (!((String)objectArray[7]).equals("OK")) {
                J2EEDataSourceTest.fail((String)" expected an sqlexception on setTypeMap(map)");
            }
        }
        catch (SQLException sQLException) {
            if (((String)objectArray[7]).equals("OK")) {
                throw sQLException;
            }
            J2EEDataSourceTest.assertSQLState((String)objectArray[7], sQLException);
        }
        this.assertConnectionPreClose(string, connection);
        connection.close();
        connection.close();
        try {
            connection.createStatement();
            J2EEDataSourceTest.fail((String)(string + " <closedconn>.createStatement(), expected 08003 - No current connection"));
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
        try {
            statement.execute("values 1");
            J2EEDataSourceTest.fail((String)(string + " <closedstmt>.execute(), expected 08003 - No current connection"));
        }
        catch (SQLException sQLException) {
            J2EEDataSourceTest.assertSQLState("08003", sQLException);
        }
    }

    private void assertConnectionPreClose(String string, Connection connection) throws SQLException {
        connection.setHoldability(2);
        if (!string.equals("Nested2")) {
            try {
                connection.setReadOnly(true);
            }
            catch (SQLException sQLException) {
                J2EEDataSourceTest.assertSQLState("25501", sQLException);
            }
        }
    }

    private void assertStatementOK(String string, Connection connection, Statement statement) throws SQLException {
        ResultSet resultSet;
        Connection connection2;
        if (J2EEDataSourceTest.usingEmbedded()) {
            SecurityCheck.assertSourceSecurity(statement, "java.sql.Statement");
        }
        if ((connection2 = statement.getConnection()) != connection && !J2EEDataSourceTest.usingDerbyNetClient() && string.indexOf("DataSource") >= 0) {
            J2EEDataSourceTest.fail((String)"incorrect connection object returned for Statement.getConnection()");
        }
        statement.addBatch("insert into intTable values 1");
        statement.addBatch("insert into intTable values 2,3");
        int[] nArray = statement.executeBatch();
        if (nArray[0] != 1) {
            J2EEDataSourceTest.fail((String)"invalid update count for first batch statement");
        }
        if (nArray[1] != 2) {
            J2EEDataSourceTest.fail((String)"invalid update count for second batch statement");
        }
        if ((resultSet = statement.executeQuery("VALUES 1")).getStatement() != statement) {
            J2EEDataSourceTest.fail((String)("incorrect Statement object returned for ResultSet.getStatement for " + string));
        }
        resultSet.close();
        statement.close();
    }

    private static void PoolReset(String string, PooledConnection pooledConnection) throws SQLException {
        J2EEDataSourceTest.PoolResetWork("1", "C", pooledConnection.getConnection());
        J2EEDataSourceTest.PoolResetWork("2", "", pooledConnection.getConnection());
        J2EEDataSourceTest.PoolResetWork("3", "D", pooledConnection.getConnection());
        pooledConnection.close();
    }

    private static void PoolResetWork(String string, String string2, Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        if (string2.equals("C")) {
            statement.execute("CREATE TABLE PoolResetWork (id int generated always as identity, name varchar(25))");
        }
        ResultSet resultSet = statement.executeQuery("VALUES IDENTITY_VAL_LOCAL()");
        resultSet.next();
        String string3 = resultSet.getString(1);
        if (!resultSet.wasNull() || string3 != null) {
            J2EEDataSourceTest.fail((String)("initial call to IDENTITY_VAL_LOCAL is not NULL!" + string3));
        }
        resultSet.close();
        statement.executeUpdate("INSERT INTO PoolResetWork(name) values ('derby-222')");
        resultSet = statement.executeQuery("VALUES IDENTITY_VAL_LOCAL()");
        resultSet.next();
        string3 = resultSet.getString(1);
        J2EEDataSourceTest.assertEquals((String)string, (String)string3);
        resultSet.close();
        if (string2.equals("D")) {
            statement.execute("DROP TABLE PoolResetWork");
        }
        statement.close();
        connection.close();
    }

    private static void assertToString(Connection connection) throws Exception {
        J2EEDataSourceTest.assertStringFormat(connection);
        String string = connection.toString();
        if (conns.containsKey(string)) {
            throw new Exception("ERROR: Connection toString() is not unique: " + string);
        }
        conns.put(string, connection);
    }

    private static void assertStringFormat(PooledConnection pooledConnection) throws Exception {
        String string = J2EEDataSourceTest.assertStringPrefix(pooledConnection);
        String string2 = pooledConnection.toString();
        String string3 = string + " \\(ID = [0-9]+\\), Physical Connection = <none>|\\S+@\\-?[0-9]+.* \\(XID = .*\\), \\(SESSIONID = [0-9]+\\), \\(DATABASE = [A-Za-z]+\\), \\(DRDAID = .*\\) ";
        J2EEDataSourceTest.assertTrue((boolean)string2.matches(string3));
    }

    private static void assertStringFormat(Connection connection) {
        J2EEDataSourceTest.assertStringPrefix(connection);
        String string = connection.toString();
        J2EEDataSourceTest.assertTrue((String)("\nexpected format:\n \\S+@\\-?[0-9]+.* \\(XID = .*\\), \\(SESSIONID = [0-9]+\\), \\(DATABASE = [A-Za-z]+\\), \\(DRDAID = .*\\) \nactual value:\n " + string), (boolean)string.matches(CONNSTRING_FORMAT));
    }

    private static String assertStringPrefix(Object object) {
        String string = object.toString();
        String string2 = object.getClass().getName() + "@" + object.hashCode();
        J2EEDataSourceTest.assertTrue((boolean)string.startsWith(string2));
        return string2;
    }

    private static void assertToString(DataSource dataSource) throws Exception {
        J2EEDataSourceTest.clearConnections();
        int n = 10;
        for (int i = 0; i < n; ++i) {
            Connection connection = dataSource.getConnection();
            J2EEDataSourceTest.assertToString(connection);
        }
        J2EEDataSourceTest.clearConnections();
    }

    private static void clearConnections() throws SQLException {
        for (Connection connection : conns.values()) {
            connection.close();
        }
        conns.clear();
    }

    private void assertTenConnectionsUnique() throws Exception {
        J2EEDataSourceTest.clearConnections();
        int n = 10;
        for (int i = 0; i < n; ++i) {
            Connection connection = this.openDefaultConnection();
            J2EEDataSourceTest.assertToString(connection);
        }
        J2EEDataSourceTest.clearConnections();
    }

    private static void assertToString(XADataSource xADataSource) throws Exception {
        Object object;
        XAConnection xAConnection2;
        int n = 10;
        HashMap<String, XAConnection> hashMap = new HashMap<String, XAConnection>();
        for (int i = 0; i < n; ++i) {
            xAConnection2 = xADataSource.getXAConnection();
            J2EEDataSourceTest.assertStringFormat(xAConnection2);
            object = xAConnection2.toString();
            J2EEDataSourceTest.assertNull(hashMap.get(object));
            hashMap.put((String)object, xAConnection2);
        }
        Iterator iterator = hashMap.values().iterator();
        J2EEDataSourceTest.clearConnections();
        while (iterator.hasNext()) {
            xAConnection2 = (XAConnection)iterator.next();
            object = xAConnection2.getConnection();
            J2EEDataSourceTest.assertToString((Connection)object);
        }
        J2EEDataSourceTest.clearConnections();
        for (XAConnection xAConnection2 : hashMap.values()) {
            xAConnection2.close();
        }
        hashMap.clear();
    }

    private static void assertToString(ConnectionPoolDataSource connectionPoolDataSource) throws Exception {
        Object object;
        PooledConnection pooledConnection2;
        int n = 10;
        HashMap<String, PooledConnection> hashMap = new HashMap<String, PooledConnection>();
        for (int i = 0; i < n; ++i) {
            pooledConnection2 = connectionPoolDataSource.getPooledConnection();
            J2EEDataSourceTest.assertStringFormat(pooledConnection2);
            object = pooledConnection2.toString();
            J2EEDataSourceTest.assertNull(hashMap.get(object));
            hashMap.put((String)object, pooledConnection2);
        }
        Iterator iterator = hashMap.values().iterator();
        J2EEDataSourceTest.clearConnections();
        while (iterator.hasNext()) {
            pooledConnection2 = (PooledConnection)iterator.next();
            object = pooledConnection2.getConnection();
            J2EEDataSourceTest.assertToString((Connection)object);
        }
        J2EEDataSourceTest.clearConnections();
        for (PooledConnection pooledConnection2 : hashMap.values()) {
            pooledConnection2.close();
        }
        hashMap.clear();
    }

    private static String getNestedMethodName() {
        return "checkNesConn";
    }

    public static void checkNesConn(String string) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (J2EEDataSourceTest.usingEmbedded()) {
            string2 = "OK";
            string3 = "XJ081";
            string4 = "0A000";
        } else if (J2EEDataSourceTest.usingDerbyNetClient()) {
            string2 = "0A000";
            string3 = "0A000";
            string4 = "0A000";
        }
        Object[] objectArray = new Object[]{1, "OK", 2, false, false, string2, string3, string4};
        new J2EEDataSourceTest("J2EEDataSourceTest").assertConnectionOK(objectArray, string, connection);
    }

    public static Object getPhysicalConnection(Object object) throws SQLException {
        if (object instanceof XADataSource) {
            return ((XADataSource)object).getXAConnection();
        }
        if (object instanceof ConnectionPoolDataSource) {
            return ((ConnectionPoolDataSource)object).getPooledConnection();
        }
        if (object instanceof DataSource) {
            return ((DataSource)object).getConnection();
        }
        throw new IllegalArgumentException("Not a data source: " + object.getClass());
    }
}

