/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import junit.framework.Test;
import org.apache.derby.iapi.types.HarmonySerialBlob;
import org.apache.derby.iapi.types.HarmonySerialClob;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Decorator;
import org.apache.derbyTesting.junit.TestConfiguration;

public class UserDefinedAggregatesTest
extends GeneratedColumnsHelper {
    public static final String OBJECT_EXISTS = "X0Y68";
    public static final String ILLEGAL_AGGREGATE = "42ZC3";
    public static final String NAME_COLLISION = "X0Y87";
    public static final String MISSING_FUNCTION = "42Y03";
    public static final String MISSING_SCHEMA = "42Y07";
    public static final String BAD_AGGREGATE_USAGE = "42903";
    public static final String BAD_AGG_PLACEMENT = "42Y35";
    public static final String INPUT_MISMATCH = "42Y22";
    public static final String BAD_GEN_COL = "42XA1";
    public static final String INPUT_OUTSIDE_BOUNDS = "42ZC6";
    public static final String RETURN_OUTSIDE_BOUNDS = "42ZC7";
    public static final String XML_TYPE = "42ZB3";
    public static final String INT_TRUNCATION = "22003";
    public static final String CAST_FAILURE = "22018";
    public static final String AGG_IN_GROUP_BY = "42Y26";
    public static final String NESTED_AGGS = "42Y33";
    public static final String UNTYPED_NULL = "42Y83";
    public static final String MISSING_CLASS = "42ZC8";
    public static final String AGG_IN_ON_CLAUSE = "42Z07";
    public static final String BAD_CONSTRAINT = "42Y01";
    public static final String DEPENDENCY_VIOLATION = "X0Y30";

    public UserDefinedAggregatesTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("UserDefinedAggregatesTest");
        baseTestSuite.addTest(TestConfiguration.defaultSuite(UserDefinedAggregatesTest.class));
        baseTestSuite.addTest(UserDefinedAggregatesTest.collatedSuite("en"));
        return baseTestSuite;
    }

    private static Test collatedSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("UserDefinedAggregatesTest:territory=" + string);
        baseTestSuite.addTest(TestConfiguration.defaultSuite(UserDefinedAggregatesTest.class));
        return Decorator.territoryCollatedDatabase((Test)baseTestSuite, string);
    }

    public void test_01_basicSyntax() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create schema uda_schema\n");
        this.goodStatement(connection, "create schema uda_schema2\n");
        this.goodStatement(connection, "create schema uda_schema3\n");
        this.goodStatement(connection, "create derby aggregate mode_01 for int external name 'foo.bar.Wibble'");
        this.goodStatement(connection, "create derby aggregate uda_schema.mode_012 for int external name 'foo.bar.Wibble'");
        this.expectExecutionError(connection, OBJECT_EXISTS, "create derby aggregate mode_01 for int external name 'foo.bar.Wibble'");
        this.expectExecutionError(connection, OBJECT_EXISTS, "create derby aggregate uda_schema.mode_012 for int external name 'foo.bar.Wibble'");
        this.expectCompilationError("42X01", "drop derby aggregate mode_01");
        this.goodStatement(connection, "drop derby aggregate mode_01 restrict");
        this.goodStatement(connection, "create function uda_schema3.agg_collide( a int ) returns int language\njava parameter style java external name 'Foo.f'");
        this.goodStatement(connection, "create function uda_schema3.agg_nocollide( a int, b int ) returns int language java\nparameter style java external name 'Foo.f'");
        this.expectExecutionError(connection, NAME_COLLISION, "create derby aggregate uda_schema3.agg_collide for int external name 'foo.bar.Wibble'");
        this.goodStatement(connection, "create derby aggregate uda_schema3.agg_nocollide for int external name 'foo.bar.Wibble'");
        this.goodStatement(connection, "create function agg_collide( a int ) returns int language java parameter style java external name 'Foo.f'");
        this.goodStatement(connection, "create function agg_nocollide( a int, b int ) returns int language java parameter style java external name 'Foo.f'");
        this.expectExecutionError(connection, NAME_COLLISION, "create derby aggregate agg_collide for int external name 'foo.bar.Wibble'");
        this.goodStatement(connection, "create derby aggregate agg_nocollide for int external name 'foo.bar.Wibble'");
        this.goodStatement(connection, "create derby aggregate func_collide for int external name 'foo.bar.Wibble'");
        this.goodStatement(connection, "create derby aggregate func_nocollide for int external name 'foo.bar.Wibble'");
        this.expectExecutionError(connection, NAME_COLLISION, "create function func_collide( a int ) returns int language java parameter style java external name 'Foo.f'");
        this.goodStatement(connection, "create function func_nocollide( a int, b int ) returns int language java parameter style java external name 'Foo.f'");
        this.goodStatement(connection, "create derby aggregate uda_schema3.func_collide for int external name 'foo.bar.Wibble'");
        this.goodStatement(connection, "create derby aggregate uda_schema3.func_nocollide for int external name 'foo.bar.Wibble'");
        this.expectExecutionError(connection, NAME_COLLISION, "create function uda_schema3.func_collide( a int ) returns int language java parameter style java external name 'Foo.f'");
        this.goodStatement(connection, "create function uda_schema3.func_nocollide( a int, b int ) returns int language\njava parameter style java external name 'Foo.f'");
        this.expectExecutionError(connection, "X0Y54", "drop schema uda_schema restrict");
        this.goodStatement(connection, "drop derby aggregate uda_schema.mode_012 restrict");
        this.goodStatement(connection, "drop schema uda_schema restrict");
        this.expectCompilationError("42Y55", "drop derby aggregate mode_01 restrict");
        this.expectCompilationError("42Y55", "drop derby aggregate mode_011 restrict");
        this.expectCompilationError("42Y55", "drop derby aggregate uda_schema2.mode_01 restrict");
    }

    public void test_02_builtinConflicts() throws Exception {
        Connection connection = this.getConnection();
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "abs");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "absval");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "acos");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "asin");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "atan");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "ceil");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "ceiling");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "cos");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "cosh");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "cot");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "date");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "day");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "degrees");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "exp");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "floor");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "lcase");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "length");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "ln");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "log");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "log10");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "month");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "radians");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "rand");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "sign");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "sin");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "sinh");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "sqrt");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "tan");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "tanh");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "time");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "timestamp");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "ucase");
        this.goodStatement(connection, "create derby aggregate locate for int external name 'foo.bar.Wibble'");
        this.goodStatement(connection, "drop derby aggregate locate restrict");
    }

    private void badAggregate(Connection connection, String string, String string2) throws Exception {
        String string3 = "create derby aggregate " + string2 + " for int external name 'foo.bar.Wibble'";
        this.expectCompilationError(string, string3);
    }

    public void test_03_keywordConflicts() throws Exception {
        Connection connection = this.getConnection();
        this.badAggregate(connection, "42X01", "bigint");
        this.badAggregate(connection, "42X01", "char");
        this.badAggregate(connection, "42X01", "double");
        this.badAggregate(connection, "42X01", "hour");
        this.badAggregate(connection, "42X01", "integer");
        this.badAggregate(connection, "42X01", "ltrim");
        this.badAggregate(connection, "42X01", "lower");
        this.badAggregate(connection, "42X01", "minute");
        this.badAggregate(connection, "42X01", "rtrim");
        this.badAggregate(connection, "42X01", "second");
        this.badAggregate(connection, "42X01", "smallint");
        this.badAggregate(connection, "42X01", "trim");
        this.badAggregate(connection, "42X01", "upper");
        this.badAggregate(connection, "42X01", "varchar");
        this.badAggregate(connection, "42X01", "year");
        this.badAggregate(connection, "42X01", "any");
        this.badAggregate(connection, "42X01", "avg");
        this.badAggregate(connection, "42X01", "max");
        this.badAggregate(connection, "42X01", "min");
        this.badAggregate(connection, "42X01", "some");
        this.badAggregate(connection, "42X01", "sum");
    }

    public void test_04_nonReservedAggregateConflicts() throws Exception {
        Connection connection = this.getConnection();
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "collect");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "count");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "every");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "fusion");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "intersection");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "stddev_pop");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "stddev_samp");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "var_pop");
        this.badAggregate(connection, ILLEGAL_AGGREGATE, "var_samp");
    }

    public void test_05_basicSelectList() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create schema agg_schema\n");
        this.goodStatement(connection, "create derby aggregate mode_05 for int\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.ModeAggregate'");
        this.goodStatement(connection, "create derby aggregate agg_schema.mode_052 for int\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.ModeAggregate'");
        this.goodStatement(connection, "create table mode_05_inputs( a int, b int )");
        this.goodStatement(connection, "insert into mode_05_inputs( a, b ) values ( 1, 1 ), ( 1, 2 ), ( 1, 2 ), ( 1, 2 ), ( 2, 3 ), ( 2, 3 ), ( 2, 4 )");
        this.assertResults(connection, "select mode_05( b ) from mode_05_inputs", new String[][]{{"2"}}, false);
        this.assertResults(connection, "select app.mode_05( b ) from mode_05_inputs", new String[][]{{"2"}}, false);
        this.assertResults(connection, "select agg_schema.mode_052( b ) from mode_05_inputs", new String[][]{{"2"}}, false);
        this.assertResults(connection, "select a, mode_05( b ) from mode_05_inputs group by a", new String[][]{{"1", "2"}, {"2", "3"}}, false);
        this.assertResults(connection, "select a, app.mode_05( b ) from mode_05_inputs group by a", new String[][]{{"1", "2"}, {"2", "3"}}, false);
        this.assertResults(connection, "select mode_05( distinct b ) from mode_05_inputs", new String[][]{{"4"}}, false);
        this.assertResults(connection, "select agg_schema.mode_052( distinct b ) from mode_05_inputs", new String[][]{{"4"}}, false);
        this.assertResults(connection, "select a, mode_05( distinct b ) from mode_05_inputs group by a", new String[][]{{"1", "2"}, {"2", "4"}}, false);
        this.assertResults(connection, "select a, agg_schema.mode_052( distinct b ) from mode_05_inputs group by a", new String[][]{{"1", "2"}, {"2", "4"}}, false);
        this.expectCompilationError(MISSING_FUNCTION, "select agg_schema.mode_05( b ) from mode_05_inputs");
        this.expectCompilationError("42X94", "select agg_schema.mode_05( distinct b ) from mode_05_inputs");
        this.expectCompilationError(MISSING_SCHEMA, "select missing_schema.mode_05( b ) from mode_05_inputs");
        this.expectCompilationError(MISSING_SCHEMA, "select missing_schema.mode_05( distinct b ) from mode_05_inputs");
        this.expectCompilationError(BAD_AGGREGATE_USAGE, "select * from mode_05_inputs where mode_05( b ) = 4");
        this.expectCompilationError(BAD_AGGREGATE_USAGE, "select * from mode_05_inputs where mode_05( distinct b ) = 4");
        this.expectCompilationError(BAD_AGGREGATE_USAGE, "select * from mode_05_inputs where app.mode_05( b ) = 4");
        this.expectCompilationError(BAD_AGGREGATE_USAGE, "select * from mode_05_inputs where app.mode_05( distinct b ) = 4");
        this.expectCompilationError(BAD_AGG_PLACEMENT, "select * from mode_05_inputs order by mode_05( b )");
        this.assertResults(connection, "select mode_05( b ) from mode_05_inputs order by mode_05( b )", new String[][]{{"2"}}, false);
        this.assertResults(connection, "select a, mode_05( b ) from mode_05_inputs group by a order by mode_05( b )", new String[][]{{"1", "2"}, {"2", "3"}}, false);
        this.assertResults(connection, "select a, mode_05( b ) from mode_05_inputs group by a order by mode_05( b ) desc", new String[][]{{"2", "3"}, {"1", "2"}}, false);
        this.assertResults(connection, "select a, mode_05( b ) from mode_05_inputs group by a having mode_05( b ) = 3", new String[][]{{"2", "3"}}, false);
        this.assertResults(connection, "select a, count( b ) from mode_05_inputs group by a having mode_05( b ) = 3", new String[][]{{"2", "3"}}, false);
        this.assertResults(connection, "select a, sum( b ) from mode_05_inputs group by a having mode_05( b ) = 3", new String[][]{{"2", "10"}}, false);
        this.assertResults(connection, "select mode_05( b ) from mode_05_inputs order by app.mode_05( b )", new String[][]{{"2"}}, false);
        this.assertResults(connection, "select a, mode_05( b ) from mode_05_inputs group by a order by app.mode_05( b )", new String[][]{{"1", "2"}, {"2", "3"}}, false);
        this.assertResults(connection, "select a, mode_05( b ) from mode_05_inputs group by a order by app.mode_05( b ) desc", new String[][]{{"2", "3"}, {"1", "2"}}, false);
        this.assertResults(connection, "select a, mode_05( b ) from mode_05_inputs group by a having app.mode_05( b ) = 3", new String[][]{{"2", "3"}}, false);
        this.assertResults(connection, "select a, count( b ) from mode_05_inputs group by a having app.mode_05( b ) = 3", new String[][]{{"2", "3"}}, false);
        this.assertResults(connection, "select a, sum( b ) from mode_05_inputs group by a having app.mode_05( b ) = 3", new String[][]{{"2", "10"}}, false);
        this.assertResults(connection, "select app.mode_05( b ) from mode_05_inputs order by app.mode_05( b )", new String[][]{{"2"}}, false);
        this.assertResults(connection, "select a, app.mode_05( b ) from mode_05_inputs group by a order by app.mode_05( b )", new String[][]{{"1", "2"}, {"2", "3"}}, false);
        this.assertResults(connection, "select a, app.mode_05( b ) from mode_05_inputs group by a order by app.mode_05( b ) desc", new String[][]{{"2", "3"}, {"1", "2"}}, false);
        this.assertResults(connection, "select a, app.mode_05( b ) from mode_05_inputs group by a having app.mode_05( b ) = 3", new String[][]{{"2", "3"}}, false);
        this.assertResults(connection, "select app.mode_05( b ) from mode_05_inputs order by mode_05( b )", new String[][]{{"2"}}, false);
        this.assertResults(connection, "select a, app.mode_05( b ) from mode_05_inputs group by a order by mode_05( b )", new String[][]{{"1", "2"}, {"2", "3"}}, false);
        this.assertResults(connection, "select a, app.mode_05( b ) from mode_05_inputs group by a order by mode_05( b ) desc", new String[][]{{"2", "3"}, {"1", "2"}}, false);
        this.assertResults(connection, "select a, app.mode_05( b ) from mode_05_inputs group by a having mode_05( b ) = 3", new String[][]{{"2", "3"}}, false);
    }

    public void test_06_parameterizedAggregates() throws Exception {
        Connection connection = this.getConnection();
        this.vetParameterizedAggregate(connection, "intMode", "int", "org.apache.derbyTesting.functionTests.tests.lang.GenericMode$IntMode", "( 1, 1 ), ( 1, 2 ), ( 1, 2 ), ( 1, 2 ), ( 2, 3 ), ( 2, 3 ), ( 2, 4 )", new String[][]{{"2"}}, new String[][]{{"1", "2"}, {"2", "3"}}, new String[][]{{"4"}}, new String[][]{{"1", "2"}, {"2", "4"}});
        this.vetParameterizedAggregate(connection, "varcharMode", "varchar( 5 )", "org.apache.derbyTesting.functionTests.tests.lang.GenericMode$StringMode", "( 1, 'a' ), ( 1, 'ab' ), ( 1, 'ab' ), ( 1, 'ab' ), ( 2, 'abc' ), ( 2, 'abc' ), ( 2, 'abcd' )", new String[][]{{"ab"}}, new String[][]{{"1", "ab"}, {"2", "abc"}}, new String[][]{{"abcd"}}, new String[][]{{"1", "ab"}, {"2", "abcd"}});
    }

    private void vetParameterizedAggregate(Connection connection, String string, String string2, String string3, String string4, String[][] stringArray, String[][] stringArray2, String[][] stringArray3, String[][] stringArray4) throws Exception {
        String string5 = string + "_mode_inputs";
        this.goodStatement(connection, "create derby aggregate " + string + " for " + string2 + "\nexternal name '" + string3 + "'");
        this.goodStatement(connection, "create table " + string5 + "( a int, b " + string2 + " )");
        this.goodStatement(connection, "insert into " + string5 + "( a, b ) values " + string4);
        this.assertResults(connection, "select " + string + "( b ) from " + string5, stringArray, false);
        this.assertResults(connection, "select a, " + string + "( b ) from " + string5 + " group by a", stringArray2, false);
        if (stringArray3 != null) {
            this.assertResults(connection, "select " + string + "( distinct b ) from " + string5, stringArray3, false);
        }
        if (stringArray4 != null) {
            this.assertResults(connection, "select a, " + string + "( distinct b ) from " + string5 + " group by a", stringArray4, false);
        }
    }

    public void test_07_restrictedDrops() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create derby aggregate mode_07 for int external name 'org.apache.derbyTesting.functionTests.tests.lang.ModeAggregate'");
        this.goodStatement(connection, "create table mode_inputs_07( a int, b int )");
        this.goodStatement(connection, "create view v_dbo_07( a, modeOfA ) as select a, mode_07( b ) from mode_inputs_07 group by a");
        this.expectExecutionError(connection, "X0Y23", "drop derby aggregate mode_07 restrict");
        this.goodStatement(connection, "drop view v_dbo_07");
        this.goodStatement(connection, "create table t_source_07( a int )");
        this.goodStatement(connection, "create table t_target_07( a int )");
        this.goodStatement(connection, "create trigger t_insert_trigger_07\nafter insert on t_source_07\nfor each row\ninsert into t_target_07( a ) select mode_07( b ) from mode_inputs_07\n");
        this.expectExecutionError(connection, "X0Y24", "drop derby aggregate mode_07 restrict");
        this.goodStatement(connection, "drop trigger t_insert_trigger_07");
        this.goodStatement(connection, "drop derby aggregate mode_07 restrict");
    }

    public void test_08_basicUDTaggregates() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create type FullName external name 'org.apache.derbyTesting.functionTests.tests.lang.FullName' language java");
        this.goodStatement(connection, "create function makeFullName( firstName varchar( 32672 ), lastName varchar( 32672 ) )\nreturns FullName language java parameter style java\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.FullName.makeFullName'");
        this.goodStatement(connection, "create derby aggregate fullNameMode for FullName\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GenericMode$FullNameMode'");
        this.goodStatement(connection, "create table fullNameMode_inputs( a int, b FullName )");
        this.goodStatement(connection, "insert into fullNameMode_inputs( a, b )\nvalues\n( 1, makeFullName( 'one', 'name'  ) ),\n( 1, makeFullName( 'two', 'name' ) ),\n( 1, makeFullName( 'two', 'name' ) ),\n( 1, makeFullName( 'two', 'name' ) ),\n( 2, makeFullName( 'three', 'name' ) ),\n( 2, makeFullName( 'three', 'name' ) ),\n( 2, makeFullName( 'four', 'name' ) )\n");
        this.assertResults(connection, "select fullNameMode( b ) from fullNameMode_inputs", new String[][]{{"two name"}}, false);
        this.assertResults(connection, "select a, fullNameMode( b ) from fullNameMode_inputs group by a", new String[][]{{"1", "two name"}, {"2", "three name"}}, false);
    }

    public void test_09_genericAggregates() throws Exception {
        Connection connection = this.getConnection();
        this.vetParameterizedAggregate(connection, "intMode_09", "int", "org.apache.derbyTesting.functionTests.tests.lang.GenericMode", "( 1, 1 ), ( 1, 2 ), ( 1, 2 ), ( 1, 2 ), ( 2, 3 ), ( 2, 3 ), ( 2, 4 )", new String[][]{{"2"}}, new String[][]{{"1", "2"}, {"2", "3"}}, new String[][]{{"4"}}, new String[][]{{"1", "2"}, {"2", "4"}});
        this.vetParameterizedAggregate(connection, "varcharMode_09", "varchar( 5 )", "org.apache.derbyTesting.functionTests.tests.lang.GenericMode", "( 1, 'a' ), ( 1, 'ab' ), ( 1, 'ab' ), ( 1, 'ab' ), ( 2, 'abc' ), ( 2, 'abc' ), ( 2, 'abcd' )", new String[][]{{"ab"}}, new String[][]{{"1", "ab"}, {"2", "abc"}}, new String[][]{{"abcd"}}, new String[][]{{"1", "ab"}, {"2", "abcd"}});
        this.goodStatement(connection, "create type FullName_09 external name 'org.apache.derbyTesting.functionTests.tests.lang.FullName' language java");
        this.goodStatement(connection, "create function makeFullName_09( firstName varchar( 32672 ), lastName varchar( 32672 ) )\nreturns FullName_09 language java parameter style java\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.FullName.makeFullName'\n");
        this.vetParameterizedAggregate(connection, "fullNameMode_09", "FullName_09", "org.apache.derbyTesting.functionTests.tests.lang.GenericMode", "( 1, makeFullName_09( 'one', 'name'  ) ),\n( 1, makeFullName_09( 'two', 'name' ) ),\n( 1, makeFullName_09( 'two', 'name' ) ),\n( 1, makeFullName_09( 'two', 'name' ) ),\n( 2, makeFullName_09( 'three', 'name' ) ),\n( 2, makeFullName_09( 'three', 'name' ) ),\n( 2, makeFullName_09( 'four', 'name' ) )\n", new String[][]{{"two name"}}, new String[][]{{"1", "two name"}, {"2", "three name"}}, null, null);
    }

    public void test_10_negative() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create derby aggregate intMode_10 for int\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GenericMode$IntMode'\n");
        this.goodStatement(connection, "create table intMode_10_inputs( a int, b varchar( 10 ) )");
        this.expectCompilationError(INPUT_MISMATCH, "select intMode_10( b ) from intMode_10_inputs");
        this.expectCompilationError(BAD_GEN_COL, "create table t_shouldFail( a int, b int generated always as ( intMode_10( a ) ) )");
        this.goodStatement(connection, "create type Price_10 external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java");
        this.goodStatement(connection, "create table t_price_10( a int, b Price_10 )");
        this.goodStatement(connection, "create derby aggregate priceMode_10 for Price_10\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GenericMode'\n");
        this.expectCompilationError(INPUT_OUTSIDE_BOUNDS, "select priceMode_10( b ) from t_price_10");
        this.expectCompilationError(INPUT_OUTSIDE_BOUNDS, "select a, priceMode_10( b ) from t_price_10 group by a");
        this.goodStatement(connection, "create table t_price_10_1( a int, b int )");
        this.goodStatement(connection, "create derby aggregate priceMode_10_1 for int returns Price_10\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GenericMode'");
        this.expectCompilationError(RETURN_OUTSIDE_BOUNDS, "select priceMode_10_1( b ) from t_price_10_1");
        this.expectCompilationError(RETURN_OUTSIDE_BOUNDS, "select a, priceMode_10_1( b ) from t_price_10_1 group by a");
        this.expectCompilationError(NESTED_AGGS, "select max( intMode_10( columnnumber ) ) from sys.syscolumns");
        this.expectCompilationError(NESTED_AGGS, "select intMode_10( max( columnnumber ) ) from sys.syscolumns");
        this.expectCompilationError(UNTYPED_NULL, "select intMode_10( null ) from sys.syscolumns");
        this.goodStatement(connection, "create derby aggregate intMode_missing_10 for int external name 'missing.Missing'");
        this.expectCompilationError(MISSING_CLASS, "select intMode_missing_10( columnnumber ) from sys.syscolumns");
        this.expectCompilationError(BAD_AGGREGATE_USAGE, "select * from sys.syscolumns where intMode_10( columnnumber ) = 1");
        this.expectCompilationError(BAD_AGG_PLACEMENT, "select case when columnnumber = 1 then 1 else intMode_10( columnnumber ) end from sys.syscolumns");
        this.expectCompilationError(BAD_AGG_PLACEMENT, "select case when columnnumber = 1 then intMode_10( columnnumber ) else 1 end from sys.syscolumns");
        this.expectCompilationError(BAD_AGG_PLACEMENT, "select case when columnnumber = intMode_10( columnnumber ) then 0 else 1 end from sys.syscolumns");
        this.expectCompilationError(BAD_AGGREGATE_USAGE, "values ( intMode_10( 1 ) )");
        this.expectCompilationError(BAD_CONSTRAINT, "create table badTable( a int, b int check ( intMode_10( b ) > 1 ) )");
        this.expectCompilationError(AGG_IN_ON_CLAUSE, "select * from sys.syscolumns l join sys.syscolumns r on intMode_10( r.columnnumber ) = l.columnnumber");
        this.goodStatement(connection, "create table intMode_10_inputs_1( a int, b int )");
        this.expectCompilationError(BAD_AGG_PLACEMENT, "update intMode_10_inputs_1 set b = intMode_10( b )");
    }

    public void test_11_datatypes() throws Exception {
        Connection connection = this.getConnection();
        this.vetDatatypeCount(connection, 22);
        this.vetParameterizedAggregate(connection, "booleanMode_11", "boolean", "org.apache.derbyTesting.functionTests.tests.lang.GenericMode$BooleanMode", "( 1, false ), ( 1, true ), (1, false ), ( 2, true ), ( 2, true ), ( 3, false ), ( 3, true ), ( 3, true )", new String[][]{{"true"}}, new String[][]{{"1", "false"}, {"2", "true"}, {"3", "true"}}, new String[][]{{"true"}}, new String[][]{{"1", "true"}, {"2", "true"}, {"3", "true"}});
        this.vetParameterizedAggregate(connection, "bigintMode_11", "bigint", "org.apache.derbyTesting.functionTests.tests.lang.GenericMode$BigintMode", "( 1, 1 ), ( 1, 2 ), (1, 2 ), ( 2, 2 ), ( 2, 3 ), ( 3, 3 ), ( 3, 4 ), ( 3, 5 )", new String[][]{{"2"}}, new String[][]{{"1", "2"}, {"2", "3"}, {"3", "5"}}, new String[][]{{"5"}}, new String[][]{{"1", "2"}, {"2", "3"}, {"3", "5"}});
        this.vetParameterizedAggregate(connection, "smallintMode_11", "smallint", "org.apache.derbyTesting.functionTests.tests.lang.GenericMode$IntMode", "( 1, 1 ), ( 1, 2 ), (1, 2 ), ( 2, 2 ), ( 2, 3 ), ( 3, 3 ), ( 3, 4 ), ( 3, 5 )", new String[][]{{"2"}}, new String[][]{{"1", "2"}, {"2", "3"}, {"3", "5"}}, new String[][]{{"5"}}, new String[][]{{"1", "2"}, {"2", "3"}, {"3", "5"}});
        this.vetParameterizedAggregate(connection, "intMode_11", "int", "org.apache.derbyTesting.functionTests.tests.lang.GenericMode$IntMode", "( 1, 1 ), ( 1, 2 ), (1, 2 ), ( 2, 2 ), ( 2, 3 ), ( 3, 3 ), ( 3, 4 ), ( 3, 5 )", new String[][]{{"2"}}, new String[][]{{"1", "2"}, {"2", "3"}, {"3", "5"}}, new String[][]{{"5"}}, new String[][]{{"1", "2"}, {"2", "3"}, {"3", "5"}});
        this.vetParameterizedAggregate(connection, "decimalMode_11", "decimal( 5, 2 )", "org.apache.derbyTesting.functionTests.tests.lang.GenericMode$BigDecimalMode", "( 1, 1.11 ), ( 1, 2.22 ), (1, 2.22 ), ( 2, 2.22 ), ( 2, 3.33 ), ( 3, 3.33 ), ( 3, 4.44 ), ( 3, 5.55 )", new String[][]{{"2.22"}}, new String[][]{{"1", "2.22"}, {"2", "3.33"}, {"3", "5.55"}}, new String[][]{{"5.55"}}, new String[][]{{"1", "2.22"}, {"2", "3.33"}, {"3", "5.55"}});
        this.vetParameterizedAggregate(connection, "numericMode_11", "numeric( 5, 2 )", "org.apache.derbyTesting.functionTests.tests.lang.GenericMode$BigDecimalMode", "( 1, 1.11 ), ( 1, 2.22 ), (1, 2.22 ), ( 2, 2.22 ), ( 2, 3.33 ), ( 3, 3.33 ), ( 3, 4.44 ), ( 3, 5.55 )", new String[][]{{"2.22"}}, new String[][]{{"1", "2.22"}, {"2", "3.33"}, {"3", "5.55"}}, new String[][]{{"5.55"}}, new String[][]{{"1", "2.22"}, {"2", "3.33"}, {"3", "5.55"}});
        this.vetParameterizedAggregate(connection, "doubleMode_11", "double", "org.apache.derbyTesting.functionTests.tests.lang.GenericMode$DoubleMode", "( 1, 1.11 ), ( 1, 2.22 ), (1, 2.22 ), ( 2, 2.22 ), ( 2, 3.33 ), ( 3, 3.33 ), ( 3, 4.44 ), ( 3, 5.55 )", new String[][]{{"2.22"}}, new String[][]{{"1", "2.22"}, {"2", "3.33"}, {"3", "5.55"}}, new String[][]{{"5.55"}}, new String[][]{{"1", "2.22"}, {"2", "3.33"}, {"3", "5.55"}});
        this.vetParameterizedAggregate(connection, "floatMode_11", "float", "org.apache.derbyTesting.functionTests.tests.lang.GenericMode$DoubleMode", "( 1, 1.11 ), ( 1, 2.22 ), (1, 2.22 ), ( 2, 2.22 ), ( 2, 3.33 ), ( 3, 3.33 ), ( 3, 4.44 ), ( 3, 5.55 )", new String[][]{{"2.22"}}, new String[][]{{"1", "2.22"}, {"2", "3.33"}, {"3", "5.55"}}, new String[][]{{"5.55"}}, new String[][]{{"1", "2.22"}, {"2", "3.33"}, {"3", "5.55"}});
        this.vetParameterizedAggregate(connection, "realMode_11", "real", "org.apache.derbyTesting.functionTests.tests.lang.GenericMode$RealMode", "( 1, 1.11 ), ( 1, 2.22 ), (1, 2.22 ), ( 2, 2.22 ), ( 2, 3.33 ), ( 3, 3.33 ), ( 3, 4.44 ), ( 3, 5.55 )", new String[][]{{"2.22"}}, new String[][]{{"1", "2.22"}, {"2", "3.33"}, {"3", "5.55"}}, new String[][]{{"5.55"}}, new String[][]{{"1", "2.22"}, {"2", "3.33"}, {"3", "5.55"}});
        this.vetParameterizedAggregate(connection, "charMode_11", "char( 4 )", "org.apache.derbyTesting.functionTests.tests.lang.GenericMode$StringMode", "( 1, 'aaaa' ), ( 1, 'abaa' ), ( 1, 'aaaa' ), ( 2, 'abaa' ), ( 2, 'abaa' ), ( 2, 'abca' ), ( 3, 'abaa' ), ( 3, 'abaa' ), ( 3, 'abcd' )", new String[][]{{"abaa"}}, new String[][]{{"1", "aaaa"}, {"2", "abaa"}, {"3", "abaa"}}, new String[][]{{"abcd"}}, new String[][]{{"1", "abaa"}, {"2", "abca"}, {"3", "abcd"}});
        this.vetParameterizedAggregate(connection, "varcharMode_11", "varchar( 4 )", "org.apache.derbyTesting.functionTests.tests.lang.GenericMode$StringMode", "( 1, 'aaaa' ), ( 1, 'abaa' ), ( 1, 'aaaa' ), ( 2, 'abaa' ), ( 2, 'abaa' ), ( 2, 'abca' ), ( 3, 'abaa' ), ( 3, 'abaa' ), ( 3, 'abcd' )", new String[][]{{"abaa"}}, new String[][]{{"1", "aaaa"}, {"2", "abaa"}, {"3", "abaa"}}, new String[][]{{"abcd"}}, new String[][]{{"1", "abaa"}, {"2", "abca"}, {"3", "abcd"}});
        this.vetParameterizedAggregate(connection, "longvarcharMode_11", "long varchar", "org.apache.derbyTesting.functionTests.tests.lang.GenericMode$StringMode", "( 1, 'aaaa' ), ( 1, 'abaa' ), ( 1, 'aaaa' ), ( 2, 'abaa' ), ( 2, 'abaa' ), ( 2, 'abca' ), ( 3, 'abaa' ), ( 3, 'abaa' ), ( 3, 'abcd' )", new String[][]{{"abaa"}}, new String[][]{{"1", "aaaa"}, {"2", "abaa"}, {"3", "abaa"}}, null, null);
        this.goodStatement(connection, "create function makeBlob_11( contents varchar( 32672 ) ) returns blob\nlanguage java parameter style java no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UserDefinedAggregatesTest.makeBlob'\n");
        this.vetParameterizedAggregate(connection, "blobMode_11", "blob", "org.apache.derbyTesting.functionTests.tests.lang.LobMode$BlobMode", "( 1, makeBlob_11( 'a' ) ),\n( 1, makeBlob_11( 'ab' ) ),\n( 1, makeBlob_11( 'ab' ) ),\n( 2, makeBlob_11( 'ab' ) ),\n( 2, makeBlob_11( 'abc' ) ),\n( 3, makeBlob_11( 'a' ) ),\n( 3, makeBlob_11( 'ab' ) ),\n( 3, makeBlob_11( 'abcd' ) )", new String[][]{{"6162"}}, new String[][]{{"1", "6162"}, {"2", "616263"}, {"3", "61626364"}}, null, null);
        this.goodStatement(connection, "create function makeClob_11( contents varchar( 32672 ) ) returns clob\nlanguage java parameter style java no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UserDefinedAggregatesTest.makeClob'\n");
        this.vetParameterizedAggregate(connection, "clobMode_11", "clob", "org.apache.derbyTesting.functionTests.tests.lang.LobMode$ClobMode", "( 1, makeClob_11( 'a' ) ),\n( 1, makeClob_11( 'ab' ) ),\n( 1, makeClob_11( 'ab' ) ),\n( 2, makeClob_11( 'ab' ) ),\n( 2, makeClob_11( 'abc' ) ),\n( 3, makeClob_11( 'a' ) ),\n( 3, makeClob_11( 'ab' ) ),\n( 3, makeClob_11( 'abcd' ) )", new String[][]{{"ab"}}, new String[][]{{"1", "ab"}, {"2", "abc"}, {"3", "abcd"}}, null, null);
        this.goodStatement(connection, "create function makeBinary_11( contents varchar( 32672 ) ) returns char( 4 ) for bit data\nlanguage java parameter style java no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UserDefinedAggregatesTest.makeBinary'\n");
        this.vetParameterizedAggregate(connection, "binaryMode_11", "char( 4 ) for bit data", "org.apache.derbyTesting.functionTests.tests.lang.LobMode$BinaryMode", "( 1, makeBinary_11( 'abaa' ) ),\n( 1, makeBinary_11( 'abaa' ) ),\n( 1, makeBinary_11( 'abca' ) ),\n( 2, makeBinary_11( 'abaa' ) ),\n( 2, makeBinary_11( 'abca' ) ),\n( 2, makeBinary_11( 'abaa' ) ),\n( 3, makeBinary_11( 'aaaa' ) ),\n( 3, makeBinary_11( 'abcd' ) ),\n( 3, makeBinary_11( 'abcd' ) )\n", new String[][]{{"61626161"}}, new String[][]{{"1", "61626161"}, {"2", "61626161"}, {"3", "61626364"}}, new String[][]{{"61626364"}}, new String[][]{{"1", "61626361"}, {"2", "61626361"}, {"3", "61626364"}});
        this.goodStatement(connection, "create function makeVarbinary_11( contents varchar( 32672 ) ) returns varchar( 4 ) for bit data\nlanguage java parameter style java no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UserDefinedAggregatesTest.makeBinary'\n");
        this.vetParameterizedAggregate(connection, "varbinaryMode_11", "varchar( 4 ) for bit data", "org.apache.derbyTesting.functionTests.tests.lang.LobMode$BinaryMode", "( 1, makeVarbinary_11( 'abaa' ) ),\n( 1, makeVarbinary_11( 'abaa' ) ),\n( 1, makeVarbinary_11( 'abca' ) ),\n( 2, makeVarbinary_11( 'abaa' ) ),\n( 2, makeVarbinary_11( 'abca' ) ),\n( 2, makeVarbinary_11( 'abaa' ) ),\n( 3, makeVarbinary_11( 'aaaa' ) ),\n( 3, makeVarbinary_11( 'abcd' ) ),\n( 3, makeVarbinary_11( 'abcd' ) )\n", new String[][]{{"61626161"}}, new String[][]{{"1", "61626161"}, {"2", "61626161"}, {"3", "61626364"}}, new String[][]{{"61626364"}}, new String[][]{{"1", "61626361"}, {"2", "61626361"}, {"3", "61626364"}});
        this.goodStatement(connection, "create function makeLongvarbinary_11( contents varchar( 32672 ) ) returns long varchar for bit data\nlanguage java parameter style java no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UserDefinedAggregatesTest.makeBinary'\n");
        this.vetParameterizedAggregate(connection, "longvarbinaryMode_11", "long varchar for bit data", "org.apache.derbyTesting.functionTests.tests.lang.LobMode$BinaryMode", "( 1, makeLongvarbinary_11( 'abaa' ) ),\n( 1, makeLongvarbinary_11( 'abaa' ) ),\n( 1, makeLongvarbinary_11( 'abca' ) ),\n( 2, makeLongvarbinary_11( 'abaa' ) ),\n( 2, makeLongvarbinary_11( 'abca' ) ),\n( 2, makeLongvarbinary_11( 'abaa' ) ),\n( 3, makeLongvarbinary_11( 'aaaa' ) ),\n( 3, makeLongvarbinary_11( 'abcd' ) ),\n( 3, makeLongvarbinary_11( 'abcd' ) )\n", new String[][]{{"61626161"}}, new String[][]{{"1", "61626161"}, {"2", "61626161"}, {"3", "61626364"}}, null, null);
        this.vetParameterizedAggregate(connection, "dateMode_11", "date", "org.apache.derbyTesting.functionTests.tests.lang.LobMode$DateMode", "( 1, date( '1994-02-23' ) ),\n( 1, date( '1994-02-23' ) ),\n( 1, date( '1995-02-23' ) ),\n( 2, date( '1995-02-23' ) ),\n( 2, date( '1995-02-23' ) ),\n( 2, date( '1996-02-23' ) ),\n( 3, date( '1993-02-23' ) ),\n( 3, date( '1993-02-23' ) ),\n( 3, date( '1995-02-23' ) )\n", new String[][]{{"1995-02-23"}}, new String[][]{{"1", "1994-02-23"}, {"2", "1995-02-23"}, {"3", "1993-02-23"}}, new String[][]{{"1996-02-23"}}, new String[][]{{"1", "1995-02-23"}, {"2", "1996-02-23"}, {"3", "1995-02-23"}});
        this.vetParameterizedAggregate(connection, "timestampMode_11", "timestamp", "org.apache.derbyTesting.functionTests.tests.lang.LobMode$TimestampMode", "( 1, timestamp( '1994-02-23 03:20:20' ) ),\n( 1, timestamp( '1994-02-23 03:20:20' ) ),\n( 1, timestamp( '1995-02-23 03:20:20' ) ),\n( 2, timestamp( '1995-02-23 03:20:20' ) ),\n( 2, timestamp( '1995-02-23 03:20:20' ) ),\n( 2, timestamp( '1996-02-23 03:20:20' ) ),\n( 3, timestamp( '1993-02-23 03:20:20' ) ),\n( 3, timestamp( '1993-02-23 03:20:20' ) ),\n( 3, timestamp( '1995-02-23 03:20:20' ) )\n", new String[][]{{"1995-02-23 03:20:20.0"}}, new String[][]{{"1", "1994-02-23 03:20:20.0"}, {"2", "1995-02-23 03:20:20.0"}, {"3", "1993-02-23 03:20:20.0"}}, new String[][]{{"1996-02-23 03:20:20.0"}}, new String[][]{{"1", "1995-02-23 03:20:20.0"}, {"2", "1996-02-23 03:20:20.0"}, {"3", "1995-02-23 03:20:20.0"}});
        this.vetParameterizedAggregate(connection, "timeMode_11", "time", "org.apache.derbyTesting.functionTests.tests.lang.LobMode$TimeMode", "( 1, time( '03:20:20' ) ),\n( 1, time( '03:20:20' ) ),\n( 1, time( '04:20:20' ) ),\n( 2, time( '04:20:20' ) ),\n( 2, time( '04:20:20' ) ),\n( 2, time( '05:20:20' ) ),\n( 3, time( '04:20:20' ) ),\n( 3, time( '04:20:20' ) ),\n( 3, time( '06:20:20' ) )\n", new String[][]{{"04:20:20"}}, new String[][]{{"1", "03:20:20"}, {"2", "04:20:20"}, {"3", "04:20:20"}}, new String[][]{{"06:20:20"}}, new String[][]{{"1", "04:20:20"}, {"2", "05:20:20"}, {"3", "06:20:20"}});
        this.expectCompilationError(XML_TYPE, "create derby aggregate xmlMode_11 for xml\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.LobMode'\n");
    }

    public static Blob makeBlob(String string) throws Exception {
        return new HarmonySerialBlob(UserDefinedAggregatesTest.makeBinary(string));
    }

    private int vetDatatypeCount(Connection connection, int n) throws Exception {
        ResultSet resultSet = connection.getMetaData().getTypeInfo();
        int n2 = 0;
        while (resultSet.next()) {
            ++n2;
        }
        resultSet.close();
        UserDefinedAggregatesTest.assertEquals((int)n, (int)n2);
        return n2;
    }

    public static byte[] makeBinary(String string) throws Exception {
        return string.getBytes("UTF-8");
    }

    public static Clob makeClob(String string) throws Exception {
        return new HarmonySerialClob(string);
    }

    public void test_12_coercion() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create derby aggregate charMode_12 for char( 4 )\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GenericMode$StringMode'\n");
        this.goodStatement(connection, "create table charMode_12_mode_inputs_small( a int, b char( 3 ) )");
        this.goodStatement(connection, "insert into charMode_12_mode_inputs_small( a, b ) values ( 1, 'aaa' ), ( 1, 'aba' ), ( 1, 'aaa' ), ( 2, 'aba' ), ( 2, 'aba' ), ( 2, 'aba' ), ( 3, 'aba' ), ( 3, 'aba' ), ( 3, 'abc' )");
        this.goodStatement(connection, "create table charMode_12_mode_inputs_big( a int, b char( 5 ) )");
        this.goodStatement(connection, "insert into charMode_12_mode_inputs_big( a, b ) values ( 1, 'aaaaa' ), ( 1, 'abaaa' ), ( 1, 'aaaaa' ), ( 2, 'abaaa' ), ( 2, 'abaaa' ), ( 2, 'abcaa' ), ( 3, 'abaaa' ), ( 3, 'abaaa' ), ( 3, 'abcde' )");
        this.assertResults(connection, "select charMode_12( b ) from charMode_12_mode_inputs_small", new String[][]{{"aba "}}, false);
        this.assertResults(connection, "select a, charMode_12( b ) from charMode_12_mode_inputs_small group by a", new String[][]{{"1", "aaa "}, {"2", "aba "}, {"3", "aba "}}, false);
        this.assertResults(connection, "select charMode_12( distinct b ) from charMode_12_mode_inputs_small", new String[][]{{"abc "}}, false);
        this.assertResults(connection, "select a, charMode_12( distinct b ) from charMode_12_mode_inputs_small group by a", new String[][]{{"1", "aba "}, {"2", "aba "}, {"3", "abc "}}, false);
        this.expectExecutionError(connection, "22001", "select charMode_12( b ) from charMode_12_mode_inputs_big");
        this.expectExecutionError(connection, "22001", "select a, charMode_12( b ) from charMode_12_mode_inputs_big group by a");
        this.expectExecutionError(connection, "22001", "select charMode_12( distinct b ) from charMode_12_mode_inputs_big");
        this.expectExecutionError(connection, "22001", "select a, charMode_12( distinct b ) from charMode_12_mode_inputs_big group by a");
        this.goodStatement(connection, "create derby aggregate bigintMode_12 for bigint\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GenericMode$BigintMode'\n");
        this.goodStatement(connection, "create table ints_12( a int, b int )");
        this.goodStatement(connection, "insert into ints_12( a, b ) values ( 1, 1 ), ( 1, 2 ), (1, 2 ), ( 2, 2 ), ( 2, 3 ), ( 3, 3 ), ( 3, 4 ), ( 3, 5 )");
        this.assertResults(connection, "select bigintMode_12( b ) from ints_12", new String[][]{{"2"}}, false);
        this.assertResults(connection, "select a, bigintMode_12( b ) from ints_12 group by a", new String[][]{{"1", "2"}, {"2", "3"}, {"3", "5"}}, false);
        this.assertResults(connection, "select bigintMode_12( distinct b ) from ints_12", new String[][]{{"5"}}, false);
        this.assertResults(connection, "select a, bigintMode_12( distinct b ) from ints_12 group by a", new String[][]{{"1", "2"}, {"2", "3"}, {"3", "5"}}, false);
        this.goodStatement(connection, "create derby aggregate intMode_12 for int\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GenericMode$IntMode'\n");
        this.goodStatement(connection, "create table bigints_12( a int, b bigint )");
        this.goodStatement(connection, "insert into bigints_12( a, b ) values ( 1, 1000000000001 ), ( 1, 1000000000002 ), (1, 1000000000002 ), ( 2, 1000000000002 ), ( 2, 1000000000003 ), ( 3, 1000000000003 ), ( 3, 1000000000004 ), ( 3, 1000000000005 )");
        this.expectExecutionError(connection, INT_TRUNCATION, "select intMode_12( b ) from bigints_12");
        this.expectExecutionError(connection, INT_TRUNCATION, "select a, intMode_12( b ) from bigints_12 group by a");
        this.expectExecutionError(connection, INT_TRUNCATION, "select intMode_12( distinct b ) from bigints_12");
        this.expectExecutionError(connection, INT_TRUNCATION, "select a, intMode_12( distinct b ) from bigints_12 group by a");
        this.expectCompilationError(INPUT_MISMATCH, "select intMode_12( b ) from charMode_12_mode_inputs_small");
        this.expectExecutionError(connection, CAST_FAILURE, "select intMode_12( cast (b as int) ) from charMode_12_mode_inputs_small");
    }

    public void test_13_differentReturnType() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create derby aggregate intMagnitude_13 for int returns bigint\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.LongMagnitude'\n");
        this.goodStatement(connection, "create derby aggregate stringMagnitude_13 for int returns varchar( 10 )\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.LongMagnitude'\n");
        this.goodStatement(connection, "create table intValues_13( a int, b int )");
        this.goodStatement(connection, "insert into intValues_13 values ( 1, 1 ), ( 2, -100 ), ( 1, 2 ), ( 2, -1234 )");
        this.assertResults(connection, "select intMagnitude_13( b ) from intValues_13", new String[][]{{"1234"}}, false);
        this.assertResults(connection, "select a, intMagnitude_13( b ) from intValues_13 group by a", new String[][]{{"1", "2"}, {"2", "1234"}}, false);
        this.expectCompilationError(RETURN_OUTSIDE_BOUNDS, "select stringMagnitude_13( b ) from intValues_13");
        this.expectCompilationError(RETURN_OUTSIDE_BOUNDS, "select a, stringMagnitude_13( b ) from intValues_13 group by a");
    }

    public void test_14_inGroupBy() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create derby aggregate intMode_14 for int\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GenericMode$IntMode'\n");
        this.goodStatement(connection, "create table intMode_14_mode_inputs( a int, b int )");
        this.expectCompilationError(AGG_IN_GROUP_BY, "select intMode_14( b ) from intMode_14_mode_inputs group by intMode_14( b )");
    }

    public void test_15_precisionMismatch() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create derby aggregate varcharMode_15 for varchar( 4 )\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GenericMode$StringMode'\n");
        this.goodStatement(connection, "create table varcharMode_15_mode_inputs_big( a int, b varchar( 5 ) )");
        this.goodStatement(connection, "insert into varcharMode_15_mode_inputs_big( a, b ) values ( 1, 'aaaaa' ), ( 1, 'abaaa' ), ( 1, 'aaaaa' ), ( 2, 'abaaa' ), ( 2, 'abaaa' ), ( 2, 'abcaa' ), ( 3, 'abaaa' ), ( 3, 'abaaa' ), ( 3, 'abcda' )");
        this.expectExecutionError(connection, "22001", "select varcharMode_15( b ) from varcharMode_15_mode_inputs_big");
        this.goodStatement(connection, "create derby aggregate numericMode_15_bigger for numeric( 5, 3 )\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GenericMode$BigDecimalMode'\n");
        this.goodStatement(connection, "create derby aggregate numericMode_15 for numeric( 5, 1 )\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GenericMode$BigDecimalMode'\n");
        this.goodStatement(connection, "create table numericMode_15_mode_inputs_big( a int, b numeric( 5, 2 ) )");
        this.goodStatement(connection, "insert into numericMode_15_mode_inputs_big( a, b ) values ( 1, 1.11 ), ( 1, 1.12 ), ( 1, 1.13 ), ( 1, 2.12 ), (1, 2.22 ), ( 2, 2.22 ), ( 2, 3.33 ), ( 3, 3.33 ), ( 3, 4.44 ), ( 3, 5.55 )");
        this.assertResults(connection, "select numericMode_15_bigger( b ) from numericMode_15_mode_inputs_big", new String[][]{{"3.330"}}, false);
        this.assertResults(connection, "select numericMode_15( b ) from numericMode_15_mode_inputs_big", new String[][]{{"1.1"}}, false);
        this.assertResults(connection, "select a, numericMode_15_bigger( b ) from numericMode_15_mode_inputs_big group by a", new String[][]{{"1", "2.220"}, {"2", "3.330"}, {"3", "5.550"}}, false);
        this.assertResults(connection, "select a, numericMode_15( b ) from numericMode_15_mode_inputs_big group by a", new String[][]{{"1", "1.1"}, {"2", "3.3"}, {"3", "5.5"}}, false);
    }

    public void test_16_exactBound() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create derby aggregate bigintMode_16 for bigint\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GenericMode$IntMode'\n");
        this.goodStatement(connection, "create table bigintMode_16_mode_inputs( a int, b bigint )");
        this.expectCompilationError(INPUT_OUTSIDE_BOUNDS, "select bigintMode_16( b ) from bigintMode_16_mode_inputs");
        this.goodStatement(connection, "create derby aggregate intMode_16 for int returns varchar( 10 )\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GenericMode$IntMode'\n");
        this.goodStatement(connection, "create table intMode_16_mode_inputs( a int, b int )");
        this.expectCompilationError(RETURN_OUTSIDE_BOUNDS, "select intMode_16( b ) from intMode_16_mode_inputs");
    }

    public void test_17_udtDependencies() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create type Price_17 external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java");
        this.goodStatement(connection, "create type Price_17_2 external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java");
        this.goodStatement(connection, "create derby aggregate priceMode_17 for Price_17 returns Price_17_2\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GenericMode'\n");
        this.expectExecutionError(connection, DEPENDENCY_VIOLATION, "drop type Price_17 restrict");
        this.expectExecutionError(connection, DEPENDENCY_VIOLATION, "drop type Price_17_2 restrict");
        this.goodStatement(connection, "drop derby aggregate priceMode_17 restrict");
        this.goodStatement(connection, "drop type Price_17 restrict");
        this.goodStatement(connection, "drop type Price_17_2 restrict");
    }
}

