/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LiveLockTest
extends BaseJDBCTestCase {
    private LinkedList<Exception> listExceptions = new LinkedList();
    private Object syncObject = new Object();
    private boolean updateDone = false;

    public LiveLockTest(String string) {
        super(string);
    }

    public void testLiveLock() throws Exception {
        Thread[] threadArray = this.createThreads();
        this.waitForThreads(threadArray);
        this.checkExceptions();
    }

    private void checkExceptions() throws Exception {
        Iterator iterator = this.listExceptions.iterator();
        if (iterator.hasNext()) {
            Exception exception = (Exception)iterator.next();
            throw exception;
        }
    }

    private void waitForThreads(Thread[] threadArray) {
        for (int i = 0; i < threadArray.length; ++i) {
            try {
                threadArray[i].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                LiveLockTest.fail((String)"FAIL - InterruptedException  thrown waiting for the threads");
            }
        }
    }

    private Thread[] createThreads() {
        Thread[] threadArray = new Thread[]{new Thread(new Runnable(){

            @Override
            public void run() {
                LiveLockTest.this.selectWorker(0);
            }
        }, "SelectThread1"), new Thread(new Runnable(){

            @Override
            public void run() {
                LiveLockTest.this.selectWorker(1000);
            }
        }, "SelectThread2"), new Thread(new Runnable(){

            @Override
            public void run() {
                LiveLockTest.this.updateWorker();
            }
        }, "UpdateThread")};
        threadArray[0].start();
        threadArray[1].start();
        threadArray[2].start();
        return threadArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectWorker(int n) {
        Connection connection = null;
        try {
            if (n > 0) {
                Thread.sleep(n);
            }
            connection = this.openDefaultConnection();
            Statement statement = connection.createStatement();
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(4);
            int n2 = 0;
            while (!this.isUpdateDone()) {
                ResultSet resultSet = statement.executeQuery("select * from t");
                while (resultSet.next()) {
                }
                Thread.sleep(4000L);
                connection.commit();
                if (++n2 != 10) continue;
                LiveLockTest.fail((String)"Update did not occur after 10 selects");
            }
        }
        catch (Exception exception) {
            Object object = this.syncObject;
            synchronized (object) {
                this.listExceptions.add(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWorker() {
        Connection connection = null;
        try {
            Thread.sleep(2000L);
            connection = this.openDefaultConnection();
            Statement statement = connection.createStatement();
            statement.executeUpdate("UPDATE T SET I = 456 where I = 456");
            Object object = this.syncObject;
            synchronized (object) {
                this.setUpdateDone(true);
                connection.commit();
            }
        }
        catch (Exception exception) {
            Object object = this.syncObject;
            synchronized (object) {
                this.listExceptions.add(exception);
            }
        }
    }

    public static Test suite() {
        Test test = TestConfiguration.embeddedSuite(LiveLockTest.class);
        return new CleanDatabaseTestSetup(DatabasePropertyTestSetup.setLockTimeouts(test, 1, 10)){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.executeUpdate("CREATE TABLE T (I INT)");
                statement.executeUpdate("INSERT INTO T VALUES(456)");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUpdateDone() {
        Object object = this.syncObject;
        synchronized (object) {
            return this.updateDone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpdateDone(boolean bl) {
        Object object = this.syncObject;
        synchronized (object) {
            this.updateDone = bl;
        }
    }
}

