/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.store.raw.GlobalTransactionId;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.shared.common.error.StandardException;

public class T_TWC {
    protected Transaction tran;
    protected ContextManager cm;
    protected ContextService contextService;
    protected LockFactory lf;
    protected RawStoreFactory rawStore;

    public T_TWC(ContextService contextService, LockFactory lockFactory, RawStoreFactory rawStoreFactory) {
        this.contextService = contextService;
        this.lf = lockFactory;
        this.rawStore = rawStoreFactory;
        this.tran = null;
        this.cm = null;
    }

    public T_TWC startUserTransaction() throws StandardException {
        this.cm = this.contextService.newContextManager();
        this.contextService.setCurrentContextManager(this.cm);
        try {
            this.tran = this.rawStore.startTransaction(this.cm, "UserTransaction");
            this.checkNullLockCount();
        }
        finally {
            this.contextService.resetCurrentContextManager(this.cm);
        }
        return this;
    }

    public void checkNullLockCount() {
        this.switchTransactionContext();
        this.resetContext();
    }

    public void setSavePoint(String string, Object object) throws StandardException {
        this.switchTransactionContext();
        try {
            this.tran.setSavePoint(string, null);
        }
        finally {
            this.resetContext();
        }
    }

    public void rollbackToSavePoint(String string, Object object) throws StandardException {
        this.switchTransactionContext();
        try {
            this.tran.rollbackToSavePoint(string, null);
        }
        finally {
            this.resetContext();
        }
    }

    public void switchTransactionContext() {
        this.contextService.setCurrentContextManager(this.cm);
    }

    public void resetContext() {
        this.contextService.resetCurrentContextManager(this.cm);
    }

    public void logAndDo(Loggable loggable) throws StandardException {
        this.switchTransactionContext();
        try {
            this.tran.logAndDo(loggable);
        }
        finally {
            this.resetContext();
        }
    }

    public void commit() throws StandardException {
        this.switchTransactionContext();
        try {
            this.tran.commit();
        }
        finally {
            this.resetContext();
        }
        this.checkNullLockCount();
    }

    public void abort() throws StandardException {
        this.switchTransactionContext();
        try {
            this.tran.abort();
        }
        finally {
            this.resetContext();
        }
        this.checkNullLockCount();
    }

    public GlobalTransactionId getId() throws StandardException {
        this.switchTransactionContext();
        try {
            GlobalTransactionId globalTransactionId = this.tran.getGlobalId();
            return globalTransactionId;
        }
        finally {
            this.resetContext();
        }
    }
}

