/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.TestConfiguration;

public class CastingTest
extends BaseJDBCTestCase {
    public static String VALID_DATE_STRING = "'2000-01-01'";
    public static String VALID_TIME_STRING = "'15:30:20'";
    public static String VALID_TIMESTAMP_STRING = "'2000-01-01 15:30:20'";
    public static String NULL_VALUE = "NULL";
    public static String ILLEGAL_CAST_EXCEPTION_SQLSTATE = "42846";
    public static String LANG_NOT_STORABLE_SQLSTATE = "42821";
    public static String LANG_NOT_COMPARABLE_SQLSTATE = "42818";
    public static String METHOD_NOT_FOUND_SQLSTATE = "42884";
    public static String LANG_FORMAT_EXCEPTION_SQLSTATE = "22018";
    public static int SQLTYPE_ARRAY_SIZE = 17;
    public static int SMALLINT_OFFSET = 0;
    public static int INTEGER_OFFSET = 1;
    public static int BIGINT_OFFSET = 2;
    public static int DECIMAL_OFFSET = 3;
    public static int REAL_OFFSET = 4;
    public static int DOUBLE_OFFSET = 5;
    public static int CHAR_OFFSET = 6;
    public static int VARCHAR_OFFSET = 7;
    public static int LONGVARCHAR_OFFSET = 8;
    public static int CHAR_FOR_BIT_OFFSET = 9;
    public static int VARCHAR_FOR_BIT_OFFSET = 10;
    public static int LONGVARCHAR_FOR_BIT_OFFSET = 11;
    public static int CLOB_OFFSET = 12;
    public static int DATE_OFFSET = 13;
    public static int TIME_OFFSET = 14;
    public static int TIMESTAMP_OFFSET = 15;
    public static int BLOB_OFFSET = 16;
    public static int[] jdbcTypes = new int[]{5, 4, -5, 3, 7, 8, 1, 12, -1, -2, -3, -4, 2005, 91, 92, 93, 2004};
    public static int NULL_DATA_OFFSET = 0;
    public static int VALID_DATA_OFFSET = 1;
    public static String[][] SQLData = new String[][]{{NULL_VALUE, "0"}, {NULL_VALUE, "11"}, {NULL_VALUE, "22"}, {NULL_VALUE, "3.3"}, {NULL_VALUE, "4.4"}, {NULL_VALUE, "5.5"}, {NULL_VALUE, "'7'"}, {NULL_VALUE, "'8'"}, {NULL_VALUE, "'9'"}, {NULL_VALUE, "X'10aa'"}, {NULL_VALUE, "X'10bb'"}, {NULL_VALUE, "X'10cc'"}, {NULL_VALUE, "'13'"}, {NULL_VALUE, VALID_DATE_STRING}, {NULL_VALUE, VALID_TIME_STRING}, {NULL_VALUE, VALID_TIMESTAMP_STRING}, {NULL_VALUE, "X'01dd'"}};
    public static final boolean n = false;
    public static final boolean X = true;
    public static final boolean[][] T_146 = new boolean[][]{{true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, false, false, true, true, true, false, false, false, true, true, true, true, false}, {true, true, true, true, false, false, true, true, true, false, false, false, true, true, true, true, false}, {false, false, false, false, false, false, true, true, true, false, false, false, true, false, false, false, false}, {false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, true}, {false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, true}, {false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, true}, {false, false, false, false, false, false, true, true, true, false, false, false, true, false, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, true, false, true, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, false, true, true, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, true, true, true, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true}};
    public static final boolean[][] T_147a = new boolean[][]{{true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, true, true, true, false, false, false, true, true, true, true, false}, {false, false, false, false, false, false, true, true, true, false, false, false, true, true, true, true, false}, {false, false, false, false, false, false, true, true, true, false, false, false, true, false, false, false, false}, {false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, true, true, true, false, false, false, true, false, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, true, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, false, true, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, true, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true}};
    public static final boolean[][] T_147b = new boolean[][]{{true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, true, true, true, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, true, true, true, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, true, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, false, true, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, true, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}};
    private static final String[][] explicitCastValues = new String[][]{{"0", "0", "0", "0.00000", "0.0", "0.0", "0                                                           ", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception"}, {"11", "11", "11", "11.00000", "11.0", "11.0", "11                                                          ", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception"}, {"22", "22", "22", "22.00000", "22.0", "22.0", "22                                                          ", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception"}, {"3", "3", "3", "3.30000", "3.3", "3.3", "3.30000                                                     ", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception"}, {"4", "4", "4", "4.40000", "4.4", "4.400000095367432", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception"}, {"5", "5", "5", "5.50000", "5.5", "5.5", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception"}, {"0", "11", "22", "3.30000", "Exception", "Exception", "7                                                           ", "8                                                           ", "9                                                           ", "Exception", "Exception", "Exception", "13                                                          ", "2000-01-01", "15:30:20", "2000-01-01 15:30:20.0", "Exception"}, {"0", "11", "22", "3.30000", "Exception", "Exception", "7                                                           ", "8", "9", "Exception", "Exception", "Exception", "13", "2000-01-01", "15:30:20", "2000-01-01 15:30:20.0", "Exception"}, {"Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "7                                                           ", "8", "9", "Exception", "Exception", "Exception", "13", "Exception", "Exception", "Exception", "Exception"}, {"Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "10aa20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020", "10bb20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020", "10cc20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020", "Exception", "Exception", "Exception", "Exception", "01dd20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020"}, {"Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "10aa20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020", "10bb", "10cc", "Exception", "Exception", "Exception", "Exception", "01dd"}, {"Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "10aa20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020", "10bb", "10cc", "Exception", "Exception", "Exception", "Exception", "01dd"}, {"Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "13                                                          ", "13", "13", "Exception", "Exception", "Exception", "13", "Exception", "Exception", "Exception", "Exception"}, {"Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "2000-01-01                                                  ", "2000-01-01", "Exception", "Exception", "Exception", "Exception", "Exception", "2000-01-01", "Exception", "2000-01-01 00:00:00.0", "Exception"}, {"Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "15:30:20                                                    ", "15:30:20", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "15:30:20", "TODAY 15:30:20.0", "Exception"}, {"Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "2000-01-01 15:30:20.0                                       ", "2000-01-01 15:30:20.0", "Exception", "Exception", "Exception", "Exception", "Exception", "2000-01-01", "15:30:20", "2000-01-01 15:30:20.0", "Exception"}, {"Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "01dd"}};
    private static final TypedColumn[] LEGAL_BOOLEAN_CASTS = new TypedColumn[]{new TypedColumn("charCol", "char( 5 )", true), new TypedColumn("varcharCol", "varchar( 5 )", true), new TypedColumn("longVarcharCol", "long varchar", false), new TypedColumn("clobCol", "clob", false), new TypedColumn("booleanCol", "boolean", true)};
    private static final TypedColumn[] ILLEGAL_BOOLEAN_CASTS = new TypedColumn[]{new TypedColumn("bigintCol", "bigint", true), new TypedColumn("blobCol", "blob", false), new TypedColumn("charForBitDataCol", "char( 5 ) for bit data", true), new TypedColumn("dateCol", "date", true), new TypedColumn("decimalCol", "decimal", true), new TypedColumn("doubleCol", "double", true), new TypedColumn("floatCol", "float", true), new TypedColumn("integerCol", "integer", true), new TypedColumn("longVarcharForBitDataCol", "long varchar for bit data", false), new TypedColumn("numericCol", "numeric", true), new TypedColumn("realCol", "real", true), new TypedColumn("smallintCol", "smallint", true), new TypedColumn("timeCol", "time", true), new TypedColumn("timestampCol", "timestamp", true), new TypedColumn("varcharForBitDataCol", "varchar( 5 ) for bit data", true), new TypedColumn("xmlCol", "xml", false)};

    public CastingTest(String string) {
        super(string);
    }

    protected void setUp() throws SQLException {
        String string;
        String string2;
        int n;
        Statement statement = this.createStatement();
        for (n = 0; n < SQLUtilities.SQLTypes.length; ++n) {
            String string3 = SQLUtilities.SQLTypes[n];
            string2 = CastingTest.getTableName(n);
            string = "create table " + string2 + " (c " + string3 + " )";
            statement.executeUpdate(string);
        }
        for (n = 0; n < SQLData[0].length; ++n) {
            for (int i = 0; i < SQLUtilities.SQLTypes.length; ++i) {
                try {
                    string2 = CastingTest.getTableName(i);
                    string = "insert into " + string2 + " values( " + SQLData[i][n] + ")";
                    statement.executeUpdate(string);
                    continue;
                }
                catch (SQLException sQLException) {
                    if (i == BLOB_OFFSET) continue;
                    throw sQLException;
                }
            }
        }
        statement.close();
        this.commit();
    }

    public void testAssignments() throws SQLException {
        Statement statement = this.createStatement();
        for (int i = 0; i < SQLData[0].length; ++i) {
            for (int j = 0; j < SQLUtilities.SQLTypes.length; ++j) {
                String string = SQLUtilities.SQLTypes[j];
                for (int k = 0; k < SQLUtilities.SQLTypes.length; ++k) {
                    String string2;
                    try {
                        String string3 = CastingTest.getTableName(k);
                        string2 = CastingTest.getCompatibleString(j, k, i);
                        String string4 = " VALUES CAST(" + string2 + " AS " + string + ")";
                        String string5 = "INSERT INTO " + string3 + string4;
                        statement.executeUpdate(string5);
                        CastingTest.checkSupportedAssignment(j, k);
                        continue;
                    }
                    catch (SQLException sQLException) {
                        string2 = sQLException.getSQLState();
                        CastingTest.assertTrue((!CastingTest.isSupportedAssignment(j, k) && CastingTest.isNotStorableException(sQLException) || CastingTest.isCastException(sQLException) ? 1 : 0) != 0);
                    }
                }
            }
        }
        statement.close();
        this.commit();
    }

    public void testExplicitCasts() throws SQLException {
        Statement statement = this.createStatement();
        for (int i = 0; i < SQLUtilities.SQLTypes.length; ++i) {
            String string = SQLUtilities.SQLTypes[i];
            for (int j = 0; j < SQLData[0].length; ++j) {
                for (int k = 0; k < SQLUtilities.SQLTypes.length; ++k) {
                    try {
                        long l = System.currentTimeMillis();
                        String string2 = SQLUtilities.SQLTypes[k];
                        String string3 = CastingTest.getCompatibleString(i, k, j);
                        String string4 = "VALUES CAST (CAST (" + string3 + " AS " + SQLUtilities.SQLTypes[i] + ") AS " + SQLUtilities.SQLTypes[k] + " )";
                        ResultSet resultSet = statement.executeQuery(string4);
                        resultSet.next();
                        String string5 = resultSet.getString(1);
                        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                        CastingTest.assertEquals((int)resultSetMetaData.getColumnType(1), (int)jdbcTypes[k]);
                        resultSet.close();
                        long l2 = System.currentTimeMillis();
                        if (j == 0) {
                            CastingTest.assertNull((Object)string5);
                        } else {
                            String string6 = explicitCastValues[i][k];
                            if (CastingTest.isTime(i) && CastingTest.isTimestamp(k)) {
                                String[] stringArray = new String[]{string6.replace("TODAY", new Date(l).toString()), string6.replace("TODAY", new Date(l2).toString())};
                                HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
                                if (!hashSet.contains(string5)) {
                                    CastingTest.fail((String)("Got " + string5 + ", expected one of " + String.valueOf(hashSet)));
                                }
                            } else {
                                CastingTest.assertEquals((String)string6, (String)string5);
                            }
                        }
                        CastingTest.checkSupportedCast(i, k);
                        continue;
                    }
                    catch (SQLException sQLException) {
                        if (j != 0) {
                            // empty if block
                        }
                        String string7 = sQLException.getSQLState();
                        if (!CastingTest.isSupportedCast(i, k)) {
                            CastingTest.assertTrue((boolean)CastingTest.isCastException(sQLException));
                            continue;
                        }
                        throw sQLException;
                    }
                }
            }
        }
        this.commit();
    }

    public void testComparisons() throws SQLException {
        Object object;
        String string;
        int n;
        int n2;
        Statement statement = this.createStatement();
        for (n2 = 0; n2 < SQLUtilities.SQLTypes.length; ++n2) {
            try {
                n = 1;
                string = CastingTest.getTableName(n2);
                String string2 = "SELECT distinct c FROM " + string + " WHERE c = " + SQLData[n2][n];
                object = statement.executeQuery(string2);
                CastingTest.assertTrue((boolean)object.next());
                object.close();
                continue;
            }
            catch (SQLException sQLException) {
                CastingTest.assertTrue((boolean)CastingTest.isLongType(n2));
            }
        }
        for (n2 = 0; n2 < SQLData[0].length; ++n2) {
            for (n = 0; n < SQLUtilities.SQLTypes.length; ++n) {
                string = SQLUtilities.SQLTypes[n];
                for (int i = 0; i < SQLUtilities.SQLTypes.length; ++i) {
                    String string3;
                    try {
                        object = CastingTest.getTableName(i);
                        string3 = CastingTest.getCompatibleString(n, i, n2);
                        statement.executeUpdate("DELETE FROM " + (String)object);
                        String string4 = " VALUES CAST(" + string3 + " AS " + string + ")";
                        String string5 = "INSERT INTO " + (String)object + string4;
                        String string6 = "select c from " + (String)object + " WHERE c = CAST(" + string3 + " AS " + string + ")";
                        ResultSet resultSet = statement.executeQuery(string6);
                        JDBC.assertDrainResults(resultSet);
                        CastingTest.checkSupportedComparison(n, i);
                        continue;
                    }
                    catch (SQLException sQLException) {
                        string3 = sQLException.getSQLState();
                        CastingTest.assertTrue((!CastingTest.isSupportedComparison(n, i) && CastingTest.isNotComparableException(sQLException) || CastingTest.isCastException(sQLException) ? 1 : 0) != 0);
                    }
                }
            }
        }
        statement.close();
        this.commit();
    }

    public void test_derby887() throws Exception {
        this.goodStatement("create table t_887 (a int)\n");
        this.expectError(LANG_NOT_COMPARABLE_SQLSTATE, "select * from t_887 where a=0<3\n");
    }

    public void test_legalBooleanCasts() throws Exception {
        this.assertAllTypesCovered();
        int n = LEGAL_BOOLEAN_CASTS.length;
        String string = "t_legal_boolean_casts";
        this.makeTableForCasts(string, LEGAL_BOOLEAN_CASTS);
        this.goodStatement("insert into " + string + "\n( " + this.makeColumnList(LEGAL_BOOLEAN_CASTS) + " )\nselect " + this.makeRepeatedColumnList("c.isIndex", LEGAL_BOOLEAN_CASTS.length) + "\nfrom\n  sys.sysconglomerates c,\n  sys.systables t\nwhere t.tablename='SYSTABLES'\nand t.tableid = c.tableid\nand not c.isIndex\n");
        this.assertBooleanResults("select * from " + string + "\n", false, 1);
        for (int i = 0; i < n; ++i) {
            TypedColumn typedColumn = LEGAL_BOOLEAN_CASTS[i];
            String string2 = "select count(*)\nfrom\n  sys.sysconglomerates c,\n  sys.systables t,\n  " + string + " tt\nwhere t.tablename='SYSTABLES'\nand t.tableid = c.tableid\nand not c.isIndex\nand tt." + typedColumn.columnName + " = c.isIndex\n";
            if (typedColumn.comparable) {
                this.assertScalarResult(string2, 1);
                continue;
            }
            this.expectError(LANG_NOT_COMPARABLE_SQLSTATE, string2);
        }
        this.assertBooleanResults("select\n" + this.makeCastedColumnList("c.isIndex", LEGAL_BOOLEAN_CASTS) + "\nfrom\n  sys.sysconglomerates c,\n  sys.systables t\nwhere t.tablename='SYSTABLES'\nand t.tableid = c.tableid\nand not c.isIndex\n", false, 1);
    }

    private void makeTableForCasts(String string, TypedColumn[] typedColumnArray) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        int n = typedColumnArray.length;
        stringBuffer.append("create table " + string + "\n(\n");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\t");
            if (i > 0) {
                stringBuffer.append(", ");
            }
            TypedColumn typedColumn = typedColumnArray[i];
            stringBuffer.append(typedColumn.columnName + "\t" + typedColumn.typeName + "\n");
        }
        stringBuffer.append(")\n");
        this.goodStatement(stringBuffer.toString());
    }

    private String makeColumnList(TypedColumn[] typedColumnArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = typedColumnArray.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(typedColumnArray[i].columnName);
        }
        return stringBuffer.toString();
    }

    private String makeCastedColumnList(String string, TypedColumn[] typedColumnArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = typedColumnArray.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("cast ( " + string + " as " + typedColumnArray[i].typeName + " )");
        }
        return stringBuffer.toString();
    }

    private String makeRepeatedColumnList(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private void assertBooleanResults(String string, boolean bl, int n) throws Exception {
        PreparedStatement preparedStatement = this.chattyPrepare(string);
        ResultSet resultSet = preparedStatement.executeQuery();
        int n2 = 0;
        int n3 = resultSet.getMetaData().getColumnCount();
        String string2 = Boolean.toString(bl);
        while (resultSet.next()) {
            ++n2;
            for (int i = 0; i < n3; ++i) {
                CastingTest.assertEquals((String)("Column " + i), (String)string2, (String)resultSet.getString(i + 1).trim());
            }
        }
        resultSet.close();
        preparedStatement.close();
        CastingTest.assertEquals((int)n, (int)n2);
    }

    private void assertScalarResult(String string, int n) throws Exception {
        PreparedStatement preparedStatement = this.chattyPrepare(string);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        CastingTest.assertEquals((int)n, (int)resultSet.getInt(1));
        resultSet.close();
        preparedStatement.close();
    }

    private void assertAllTypesCovered() throws Exception {
        CastingTest.println("Verify that we are testing the casting behavior of BOOLEAN to/from all Derby data types.");
        Connection connection = this.getConnection();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet resultSet = databaseMetaData.getTypeInfo();
        int n = 0;
        int n2 = LEGAL_BOOLEAN_CASTS.length + ILLEGAL_BOOLEAN_CASTS.length;
        ++n2;
        while (resultSet.next()) {
            ++n;
        }
        CastingTest.assertEquals((String)"You must add your new data type to LEGAL_BOOLEAN_CASTS or ILLEGAL_BOOLEAN_CASTS", (int)n2, (int)n);
        resultSet.close();
    }

    public void test_illegalBooleanCasts() throws Exception {
        TypedColumn[] typedColumnArray;
        int n;
        this.assertAllTypesCovered();
        int n2 = ILLEGAL_BOOLEAN_CASTS.length;
        String string = "t_illegal_boolean_casts";
        this.makeTableForCasts(string, ILLEGAL_BOOLEAN_CASTS);
        for (n = 0; n < n2; ++n) {
            typedColumnArray = ILLEGAL_BOOLEAN_CASTS[n];
            this.expectError(LANG_NOT_STORABLE_SQLSTATE, "insert into " + string + "( " + typedColumnArray.columnName + " ) select c.isIndex from sys.sysconglomerates c\n");
        }
        for (n = 0; n < n2; ++n) {
            typedColumnArray = ILLEGAL_BOOLEAN_CASTS[n];
            this.expectError(LANG_NOT_COMPARABLE_SQLSTATE, "select * from " + string + " t, sys.sysconglomerates c where t." + typedColumnArray.columnName + " = c.isIndex\n");
        }
        for (n = 0; n < n2; ++n) {
            typedColumnArray = new TypedColumn[]{ILLEGAL_BOOLEAN_CASTS[n]};
            this.expectError(ILLEGAL_CAST_EXCEPTION_SQLSTATE, "select " + this.makeCastedColumnList("c.isIndex", typedColumnArray) + " from sys.sysconglomerates c\n");
        }
    }

    public void testDataTruncationWarning() throws SQLException {
        Statement statement = this.createStatement();
        this.checkDataTruncationResult(statement, "values (cast('abc' as char(2)), cast('de'   as char(2))),       (cast('fg'  as char(2)), cast('hi'   as char(2))),       (cast('jkl' as char(2)), cast('mnop' as char(2)))");
        this.checkDataTruncationResult(statement, "values (cast('abc' as varchar(2)), cast('de'   as varchar(2))),       (cast('fg'  as varchar(2)), cast('hi'   as varchar(2))),       (cast('jkl' as varchar(2)), cast('mnop' as varchar(2)))");
        this.checkDataTruncationResult(statement, "values (cast('abc' as clob(2)), cast('de'   as clob(2))),       (cast('fg'  as clob(2)), cast('hi'   as clob(2))),       (cast('jkl' as clob(2)), cast('mnop' as clob(2)))");
        this.checkDataTruncationResult(statement, "values (cast(x'abcdef' as char(2) for bit data),        cast(x'abcd' as char(2) for bit data)),       (cast(x'abcd' as char(2) for bit data),        cast(x'cdef' as char(2) for bit data)),       (cast(x'012345' as char(2) for bit data),        cast(x'6789ABCD' as char(2) for bit data))");
        this.checkDataTruncationResult(statement, "values (cast(x'abcdef' as varchar(2) for bit data),        cast(x'abcd' as varchar(2) for bit data)),       (cast(x'abcd' as varchar(2) for bit data),        cast(x'cdef' as varchar(2) for bit data)),       (cast(x'012345' as varchar(2) for bit data),        cast(x'6789ABCD' as varchar(2) for bit data))");
        this.checkDataTruncationResult(statement, "values    (cast(x'abcdef' as blob(2)), cast(x'abcd' as blob(2))),     (cast(x'abcd' as blob(2)),   cast(x'cdef' as blob(2))),     (cast(x'012345' as blob(2)), cast(x'6789ABCD' as blob(2)))");
        ResultSet resultSet = statement.executeQuery("values cast('abc\u00e6\u00f8\u00e5' as varchar(4))");
        CastingTest.assertTrue((boolean)resultSet.next());
        CastingTest.assertEquals((String)"abc\u00e6", (String)resultSet.getString(1));
        this.assertDataTruncation(resultSet.getWarnings(), -1, true, false, 9, 5);
        CastingTest.assertFalse((boolean)resultSet.next());
        resultSet.close();
        this.setAutoCommit(false);
        statement.execute("create table t1_d129 (x8 char(8) for bit data)");
        statement.execute("create table t2_d129 (x4 char(4) for bit data)");
        statement.execute("insert into t1_d129(x8) values x'0123456789ABCDEF'");
        CastingTest.assertNull((Object)statement.getWarnings());
        statement.execute("insert into t2_d129(x4) select cast(x8 as char(4) for bit data) from t1_d129");
        this.assertDataTruncation(statement.getWarnings(), -1, true, false, 8, 4);
        this.rollback();
    }

    private void checkDataTruncationResult(Statement statement, String string) throws SQLException {
        ResultSet resultSet = statement.executeQuery(string);
        CastingTest.assertTrue((boolean)resultSet.next());
        SQLWarning sQLWarning = resultSet.getWarnings();
        this.assertDataTruncation(sQLWarning, -1, true, false, 3, 2);
        sQLWarning = sQLWarning.getNextWarning();
        CastingTest.assertNull((Object)sQLWarning);
        resultSet.clearWarnings();
        CastingTest.assertTrue((boolean)resultSet.next());
        CastingTest.assertNull((Object)resultSet.getWarnings());
        CastingTest.assertTrue((boolean)resultSet.next());
        sQLWarning = resultSet.getWarnings();
        this.assertDataTruncation(sQLWarning, -1, true, false, 3, 2);
        if (CastingTest.usingEmbedded()) {
            sQLWarning = sQLWarning.getNextWarning();
            this.assertDataTruncation(sQLWarning, -1, true, false, 4, 2);
        }
        sQLWarning = sQLWarning.getNextWarning();
        CastingTest.assertNull((Object)sQLWarning);
        resultSet.clearWarnings();
        CastingTest.assertFalse((boolean)resultSet.next());
        resultSet.close();
        CastingTest.assertNull((Object)statement.getWarnings());
        CastingTest.assertNull((Object)this.getConnection().getWarnings());
    }

    private void assertDataTruncation(SQLWarning sQLWarning, int n, boolean bl, boolean bl2, int n2, int n3) throws SQLException {
        CastingTest.assertNotNull((String)"No warning", (Object)sQLWarning);
        if (!(sQLWarning instanceof DataTruncation)) {
            CastingTest.fail("Not a DataTruncation warning", sQLWarning);
        }
        DataTruncation dataTruncation = (DataTruncation)sQLWarning;
        CastingTest.assertEquals((String)"Column index", (int)n, (int)dataTruncation.getIndex());
        CastingTest.assertEquals((String)"Read", (boolean)bl, (boolean)dataTruncation.getRead());
        CastingTest.assertEquals((String)"Parameter", (boolean)bl2, (boolean)dataTruncation.getParameter());
        CastingTest.assertEquals((String)"Data size", (int)n2, (int)dataTruncation.getDataSize());
        CastingTest.assertEquals((String)"Transfer size", (int)n3, (int)dataTruncation.getTransferSize());
    }

    public void testDateTimeToTimestamp() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("values (cast (current date as timestamp), current date, cast (current time as timestamp), current time)");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        CastingTest.assertEquals((int)93, (int)resultSetMetaData.getColumnType(1));
        CastingTest.assertEquals((int)93, (int)resultSetMetaData.getColumnType(3));
        resultSet.next();
        CastingTest.assertEquals((String)(resultSet.getString(2) + " 00:00:00.0"), (String)resultSet.getString(1));
        CastingTest.assertEquals((String)(resultSet.getString(2) + " " + resultSet.getString(4) + ".0"), (String)resultSet.getString(3));
        resultSet.close();
        this.assertCompileError(ILLEGAL_CAST_EXCEPTION_SQLSTATE, "values cast(current time as date)");
        this.assertCompileError(ILLEGAL_CAST_EXCEPTION_SQLSTATE, "values cast(current date as time)");
        statement.execute("create table derby896(id int generated always as identity, d date, t time, ts timestamp)");
        this.assertCompileError(LANG_NOT_STORABLE_SQLSTATE, "insert into derby896(ts) values current time");
        this.assertCompileError(LANG_NOT_STORABLE_SQLSTATE, "insert into derby896(ts) values current date");
        statement.execute("insert into derby896(d,t,ts) values (current date, current time, cast(current date as timestamp)), (current date, current time, cast(current time as timestamp))");
        resultSet = statement.executeQuery("select d, t, ts from derby896 order by id");
        resultSet.next();
        CastingTest.assertEquals((String)(resultSet.getString(1) + " 00:00:00.0"), (String)resultSet.getString(3));
        resultSet.next();
        CastingTest.assertEquals((String)(resultSet.getString(1) + " " + resultSet.getString(2) + ".0"), (String)resultSet.getString(3));
        resultSet.close();
        statement.execute("insert into derby896(d, t) values ({d'1999-12-31'}, {t'23:59:59'}), ({d'2000-01-01'}, {t'00:00:00'}), ({d'1970-01-01'}, {t'00:00:01'}), ({d'1969-12-31'}, {t'12:00:00'})");
        resultSet = statement.executeQuery("select d, cast(d as timestamp) from derby896");
        while (resultSet.next()) {
            CastingTest.assertEquals((String)(resultSet.getString(1) + " 00:00:00.0"), (String)resultSet.getString(2));
        }
        resultSet.close();
        resultSet = statement.executeQuery("select t, cast(t as timestamp), current date from derby896");
        while (resultSet.next()) {
            CastingTest.assertEquals((String)(resultSet.getString(3) + " " + resultSet.getString(1) + ".0"), (String)resultSet.getString(2));
        }
        resultSet.close();
    }

    @Override
    protected void tearDown() throws SQLException, Exception {
        Statement statement = this.createStatement();
        for (int i = 0; i < SQLUtilities.SQLTypes.length; ++i) {
            String string = SQLUtilities.SQLTypes[i];
            String string2 = CastingTest.getTableName(i);
            String string3 = "drop table " + string2;
            statement.executeUpdate(string3);
        }
        statement.close();
        this.commit();
        super.tearDown();
    }

    private static String getTableName(int n) {
        return CastingTest.getShortTypeName(n).replace(' ', '_') + "_TAB";
    }

    private static String getShortTypeName(int n) {
        String string = SQLUtilities.SQLTypes[n];
        Object object = string;
        int n2 = string.indexOf(40);
        if (n2 >= 0) {
            object = string.substring(0, n2);
            int n3 = string.indexOf(41);
            object = (String)object + string.substring(n3 + 1, string.length());
        }
        return object;
    }

    private static String getCompatibleString(int n, int n2, int n3) {
        String string = null;
        string = (CastingTest.isCharacterType(n) || CastingTest.isBinaryType(n)) && !CastingTest.isLob(n) ? CastingTest.formatString(SQLData[n2][n3]) : SQLData[n][n3];
        return string;
    }

    private static boolean isSupportedCast(int n, int n2) {
        return T_146[n][n2];
    }

    private static boolean isSupportedAssignment(int n, int n2) {
        return T_147a[n][n2];
    }

    private static boolean isSupportedComparison(int n, int n2) {
        return T_147b[n][n2];
    }

    private static boolean isCastException(SQLException sQLException) {
        return CastingTest.sqlStateMatches(sQLException, ILLEGAL_CAST_EXCEPTION_SQLSTATE);
    }

    private static boolean isMethodNotFoundException(SQLException sQLException) {
        return CastingTest.sqlStateMatches(sQLException, METHOD_NOT_FOUND_SQLSTATE);
    }

    private static boolean sqlStateMatches(SQLException sQLException, String string) {
        String string2 = sQLException.getSQLState();
        return string2 != null && string2.equals(string);
    }

    private static boolean isNotStorableException(SQLException sQLException) {
        String string = sQLException.getSQLState();
        return string != null && string.equals(LANG_NOT_STORABLE_SQLSTATE);
    }

    private static boolean isNotComparableException(SQLException sQLException) {
        String string = sQLException.getSQLState();
        return string != null && string.equals(LANG_NOT_COMPARABLE_SQLSTATE);
    }

    private static void checkSupportedCast(int n, int n2) {
        String string = " Cast from " + SQLUtilities.SQLTypes[n] + " to " + SQLUtilities.SQLTypes[n2];
        if (!CastingTest.isSupportedCast(n, n2)) {
            CastingTest.fail((String)(string + "should not succeed"));
        }
    }

    private static void checkSupportedAssignment(int n, int n2) {
        String string = " Assignment from " + SQLUtilities.SQLTypes[n] + " to " + SQLUtilities.SQLTypes[n2];
        if (!CastingTest.isSupportedAssignment(n, n2)) {
            CastingTest.fail((String)(string + "should not succeed"));
        }
    }

    private static void checkSupportedComparison(int n, int n2) {
        String string = " Comparison of " + SQLUtilities.SQLTypes[n] + " to " + SQLUtilities.SQLTypes[n2];
        if (!CastingTest.isSupportedComparison(n, n2)) {
            CastingTest.fail((String)("FAIL: unsupported comparison:" + string));
        }
    }

    private static boolean isLongType(int n) {
        return n == LONGVARCHAR_OFFSET || n == LONGVARCHAR_FOR_BIT_OFFSET || n == CLOB_OFFSET || n == BLOB_OFFSET;
    }

    private static boolean isCharacterType(int n) {
        return n == CHAR_OFFSET || n == VARCHAR_OFFSET || n == LONGVARCHAR_OFFSET || n == CLOB_OFFSET;
    }

    private static boolean isBinaryType(int n) {
        return n == CHAR_FOR_BIT_OFFSET || n == VARCHAR_FOR_BIT_OFFSET || n == LONGVARCHAR_FOR_BIT_OFFSET || n == BLOB_OFFSET;
    }

    private static boolean isTime(int n) {
        return n == TIME_OFFSET;
    }

    private static boolean isTimestamp(int n) {
        return n == TIMESTAMP_OFFSET;
    }

    private static boolean isLob(int n) {
        return n == CLOB_OFFSET || n == BLOB_OFFSET;
    }

    private static String formatString(String string) {
        if (string != null && (string.startsWith("X") || string.startsWith("'") || string == NULL_VALUE)) {
            return string;
        }
        return "'" + string + "'";
    }

    private void goodStatement(String string) throws SQLException {
        PreparedStatement preparedStatement = this.chattyPrepare(string);
        preparedStatement.execute();
        preparedStatement.close();
    }

    private void expectError(String string, String string2) {
        CastingTest.println("\nExpecting " + string + " when preparing:\n\t" + string2);
        this.assertCompileError(string, string2);
    }

    private PreparedStatement chattyPrepare(String string) throws SQLException {
        CastingTest.println("Preparing statement:\n\t" + string);
        return this.prepareStatement(string);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(CastingTest.class);
    }

    public static final class TypedColumn {
        public String columnName;
        public String typeName;
        public boolean comparable;

        public TypedColumn(String string, String string2, boolean bl) {
            this.columnName = string;
            this.typeName = string2;
            this.comparable = bl;
        }
    }
}

