/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.WarehouseVTI;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;

public class VTITest
extends BaseJDBCTestCase {
    private final String tableName;

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("VTITest");
        if (JDBC.vmSupportsJDBC3()) {
            baseTestSuite.addTest((Test)new VTITest("bulkInsertVtiTest", "WAREHOUSE"));
            baseTestSuite.addTest((Test)new VTITest("bulkInsertVtiTest", "test\"'table"));
        }
        return baseTestSuite;
    }

    private VTITest(String string, String string2) {
        super(string);
        this.tableName = string2;
    }

    protected void setUp() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("CREATE TABLE " + JDBC.escape(this.tableName) + "(id int)");
        statement.close();
    }

    @Override
    protected void tearDown() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("DROP TABLE " + JDBC.escape(this.tableName));
        statement.close();
        super.tearDown();
    }

    public void bulkInsertVtiTest() throws SQLException {
        int n = 10;
        CallableStatement callableStatement = this.prepareCall("CALL SYSCS_UTIL.SYSCS_BULK_INSERT(?, ?, ?, ?)");
        callableStatement.setString(1, "APP");
        callableStatement.setString(2, this.tableName);
        callableStatement.setString(3, WarehouseVTI.class.getName());
        callableStatement.setInt(4, n);
        callableStatement.execute();
        ResultSet resultSet = this.createStatement().executeQuery("SELECT 1 FROM " + JDBC.escape(this.tableName));
        JDBC.assertDrainResults(resultSet, n);
    }
}

