/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memorydb;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Derby6662Test
extends BaseJDBCTestCase {
    public Derby6662Test(String string) {
        super(string);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(Derby6662Test.class);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.dropInMemoryDb();
    }

    public void testDatabaseMetaDataCalls() throws SQLException {
        DatabaseMetaData databaseMetaData = this.getDMD();
        Derby6662Test.assertFalse((boolean)databaseMetaData.usesLocalFilePerTable());
        Derby6662Test.assertFalse((boolean)databaseMetaData.usesLocalFiles());
    }

    public void testOptionalToolMetaData() throws SQLException {
        Connection connection = this.obtainConnection();
        this.goodStatement(connection, "call syscs_util.syscs_register_tool('databaseMetaData', true)");
        this.assertResults(connection, "values usesLocalFiles()", new String[][]{{"false"}}, false);
        this.assertResults(connection, "values usesLocalFilePerTable()", new String[][]{{"false"}}, false);
        this.goodStatement(connection, "call syscs_util.syscs_register_tool('databaseMetaData', false)");
    }

    private DatabaseMetaData getDMD() throws SQLException {
        return this.obtainConnection().getMetaData();
    }

    private Connection obtainConnection() throws SQLException {
        try {
            if (Derby6662Test.usingDerbyNetClient()) {
                Class.forName("org.apache.derby.jdbc.ClientDriver");
            } else {
                Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
            }
        }
        catch (Exception exception) {
            SQLException sQLException = new SQLException(exception.getMessage());
            sQLException.initCause(exception);
            throw sQLException;
        }
        StringBuffer stringBuffer = this.constructUrl().append(";create=true");
        return DriverManager.getConnection(stringBuffer.toString());
    }

    private void dropInMemoryDb() throws SQLException {
        StringBuffer stringBuffer = this.constructUrl().append(";drop=true");
        try {
            DriverManager.getConnection(stringBuffer.toString());
            Derby6662Test.fail((String)"Dropping database should have raised exception.");
        }
        catch (SQLException sQLException) {
            Derby6662Test.assertSQLState("08006", sQLException);
        }
    }

    private StringBuffer constructUrl() {
        StringBuffer stringBuffer = new StringBuffer("jdbc:derby:");
        if (Derby6662Test.usingEmbedded()) {
            stringBuffer.append("memory:");
        } else {
            stringBuffer.append("//");
            stringBuffer.append(TestConfiguration.getCurrent().getHostName());
            stringBuffer.append(':');
            stringBuffer.append(TestConfiguration.getCurrent().getPort());
            stringBuffer.append('/');
            stringBuffer.append("memory:");
        }
        stringBuffer.append("DBMDTestDb");
        return stringBuffer;
    }
}

