/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.RowMultiSetImpl;
import org.apache.derby.catalog.types.SynonymAliasInfo;
import org.apache.derby.catalog.types.UserDefinedTypeIdImpl;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.sql.StatementUtil;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.OptTrace;
import org.apache.derby.iapi.sql.compile.OptimizerFactory;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.BitConstantNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.CharConstantNode;
import org.apache.derby.impl.sql.compile.CompilerContextImpl;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.NumericConstantNode;
import org.apache.derby.impl.sql.compile.OffsetOrderVisitor;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.UserTypeConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VarbitConstantNode;
import org.apache.derby.impl.sql.compile.XMLConstantNode;
import org.apache.derby.impl.sql.execute.GenericConstantActionFactory;
import org.apache.derby.impl.sql.execute.GenericExecutionFactory;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derby.shared.common.sanity.SanityManager;

public abstract class QueryTreeNode
implements Visitable {
    static final int AUTOINCREMENT_START_INDEX = 0;
    static final int AUTOINCREMENT_INC_INDEX = 1;
    static final int AUTOINCREMENT_IS_AUTOINCREMENT_INDEX = 2;
    static final int AUTOINCREMENT_CREATE_MODIFY = 3;
    static final int AUTOINCREMENT_CYCLE = 4;
    private int beginOffset = -1;
    private int endOffset = -1;
    private ContextManager cm;
    private LanguageConnectionContext lcc;
    private GenericConstantActionFactory constantActionFactory;
    private ArrayList<String> visitableTags;
    private boolean isPrivilegeCollectionRequired = true;

    QueryTreeNode(ContextManager cm) {
        this.cm = cm;
        SanityManager.ASSERT(cm != null, "cm not expected to be null");
    }

    final ContextManager getContextManager() {
        if (this.cm == null) {
            SanityManager.THROWASSERT("Null context manager in QueryTreeNode of type :" + String.valueOf(this.getClass()));
        }
        return this.cm;
    }

    public final OptimizerFactory getOptimizerFactory() {
        return this.getLanguageConnectionContext().getLanguageConnectionFactory().getOptimizerFactory();
    }

    public OptTrace getOptimizerTracer() {
        return this.getLanguageConnectionContext().getOptimizerTracer();
    }

    public boolean optimizerTracingIsOn() {
        return this.getLanguageConnectionContext().optimizerTracingIsOn();
    }

    public final GenericConstantActionFactory getGenericConstantActionFactory() {
        if (this.constantActionFactory == null) {
            GenericExecutionFactory execFactory = (GenericExecutionFactory)this.getExecutionFactory();
            this.constantActionFactory = execFactory.getConstantActionFactory();
        }
        return this.constantActionFactory;
    }

    public final ExecutionFactory getExecutionFactory() {
        ExecutionFactory ef = this.getLanguageConnectionContext().getLanguageConnectionFactory().getExecutionFactory();
        return ef;
    }

    protected final ClassFactory getClassFactory() {
        return this.getLanguageConnectionContext().getLanguageConnectionFactory().getClassFactory();
    }

    protected final LanguageConnectionContext getLanguageConnectionContext() {
        if (this.lcc == null) {
            this.lcc = (LanguageConnectionContext)this.getContextManager().getContext("LanguageConnectionContext");
        }
        return this.lcc;
    }

    public int getBeginOffset() {
        return this.beginOffset;
    }

    public void setBeginOffset(int beginOffset) {
        this.beginOffset = beginOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    protected String nodeHeader() {
        return "\n" + this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + "\n";
    }

    static String formatNodeString(String nodeString, int depth) {
        StringBuilder nodeStringBuilder = new StringBuilder(nodeString);
        char[] indent = new char[depth];
        while (depth > 0) {
            indent[depth - 1] = 9;
            --depth;
        }
        nodeStringBuilder.insert(0, indent);
        for (int pos = 0; pos < nodeStringBuilder.length() - 1; ++pos) {
            char c = nodeStringBuilder.charAt(pos);
            if (c != '\n') continue;
            nodeStringBuilder.insert(pos + 1, indent);
        }
        return nodeStringBuilder.toString();
    }

    public void treePrint() {
        QueryTreeNode.debugPrint(this.nodeHeader());
        String thisStr = QueryTreeNode.formatNodeString(this.toString(), 0);
        if (QueryTreeNode.containsInfo(thisStr) && !SanityManager.DEBUG_ON("DumpBrief")) {
            QueryTreeNode.debugPrint(thisStr);
        }
        this.printSubNodes(0);
        QueryTreeNode.debugFlush();
    }

    void stackPrint() {
        QueryTreeNode.debugPrint("Stacktrace:\n");
        Exception e = new Exception("dummy");
        StackTraceElement[] st = e.getStackTrace();
        for (int i = 0; i < st.length; ++i) {
            QueryTreeNode.debugPrint(String.valueOf(st[i]) + "\n");
        }
        QueryTreeNode.debugFlush();
    }

    void treePrint(int depth) {
        Map<Object, Object> printed = this.getLanguageConnectionContext().getPrintedObjectsMap();
        if (printed.containsKey(this)) {
            QueryTreeNode.debugPrint(QueryTreeNode.formatNodeString(this.nodeHeader(), depth));
            QueryTreeNode.debugPrint(QueryTreeNode.formatNodeString("***truncated***\n", depth));
        } else {
            printed.put(this, null);
            QueryTreeNode.debugPrint(QueryTreeNode.formatNodeString(this.nodeHeader(), depth));
            String thisStr = QueryTreeNode.formatNodeString(this.toString(), depth);
            if (QueryTreeNode.containsInfo(thisStr) && !SanityManager.DEBUG_ON("DumpBrief")) {
                QueryTreeNode.debugPrint(thisStr);
            }
            if (thisStr.charAt(thisStr.length() - 1) != '\n') {
                QueryTreeNode.debugPrint("\n");
            }
            this.printSubNodes(depth);
        }
    }

    private static boolean containsInfo(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '\t' || str.charAt(i) == '\n') continue;
            return true;
        }
        return false;
    }

    static void debugPrint(String outputString) {
        SanityManager.GET_DEBUG_STREAM().print(outputString);
    }

    protected static void debugFlush() {
        SanityManager.GET_DEBUG_STREAM().flush();
    }

    void printSubNodes(int depth) {
    }

    public String toString() {
        return "";
    }

    void printLabel(int depth, String label) {
        QueryTreeNode.debugPrint(QueryTreeNode.formatNodeString(label, depth));
    }

    public boolean referencesSessionSchema() throws StandardException {
        return false;
    }

    final boolean isSessionSchema(SchemaDescriptor sd) {
        return QueryTreeNode.isSessionSchema(sd.getSchemaName());
    }

    static boolean isSessionSchema(String schemaName) {
        return "SESSION".equals(schemaName);
    }

    final void disablePrivilegeCollection() {
        this.isPrivilegeCollectionRequired = false;
    }

    boolean isPrivilegeCollectionRequired() throws StandardException {
        return this.isPrivilegeCollectionRequired && this.getCompilerContext().passesPrivilegeFilters(this);
    }

    void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        throw StandardException.newException("42Z50", this.nodeHeader());
    }

    public DataTypeDescriptor[] getParameterTypes() throws StandardException {
        return ((CompilerContextImpl)this.getCompilerContext()).getParameterTypes();
    }

    public ConstantAction makeConstantAction() throws StandardException {
        return null;
    }

    public final DataDictionary getDataDictionary() {
        return this.getLanguageConnectionContext().getDataDictionary();
    }

    final DependencyManager getDependencyManager() {
        return this.getDataDictionary().getDependencyManager();
    }

    protected final CompilerContext getCompilerContext() {
        return (CompilerContext)this.getContextManager().getContext("CompilerContext");
    }

    protected final TypeCompiler getTypeCompiler(TypeId typeId) {
        return this.getCompilerContext().getTypeCompilerFactory().getTypeCompiler(typeId);
    }

    @Override
    public final Visitable accept(Visitor v) throws StandardException {
        QueryTreeNode ret;
        boolean childrenFirst = v.visitChildrenFirst(this);
        boolean skipChildren = v.skipChildren(this);
        if (childrenFirst && !skipChildren && !v.stopTraversal()) {
            this.acceptChildren(v);
        }
        Visitable visitable = ret = v.stopTraversal() ? this : v.visit(this);
        if (!(childrenFirst || skipChildren || v.stopTraversal())) {
            this.acceptChildren(v);
        }
        return ret;
    }

    void acceptChildren(Visitor v) throws StandardException {
    }

    @Override
    public void addTag(String tag) {
        if (this.visitableTags == null) {
            this.visitableTags = new ArrayList();
        }
        this.visitableTags.add(tag);
    }

    @Override
    public boolean taggedWith(String tag) {
        if (this.visitableTags == null) {
            return false;
        }
        return this.visitableTags.contains(tag);
    }

    protected void copyTagsFrom(QueryTreeNode that) {
        if (that.visitableTags == null) {
            return;
        }
        for (String tag : that.visitableTags) {
            this.addTag(tag);
        }
    }

    protected int getIntProperty(String value, String key) throws StandardException {
        int intVal = -1;
        try {
            intVal = Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw StandardException.newException("42Y58", value, key);
        }
        return intVal;
    }

    protected long getLongProperty(String value, String key) throws StandardException {
        long longVal = -1L;
        try {
            longVal = Long.parseLong(value);
        }
        catch (NumberFormatException nfe) {
            throw StandardException.newException("42Y58", value, key);
        }
        return longVal;
    }

    StatementNode parseStatement(String sql, boolean internalSQL) throws StandardException {
        return (StatementNode)this.parseStatementOrSearchCondition(sql, internalSQL, true);
    }

    ValueNode parseSearchCondition(String sql, boolean internalSQL) throws StandardException {
        return (ValueNode)this.parseStatementOrSearchCondition(sql, internalSQL, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Visitable parseStatementOrSearchCondition(String sql, boolean internalSQL, boolean isStatement) throws StandardException {
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        CompilerContext newCC = lcc.pushCompilerContext();
        if (internalSQL) {
            newCC.setReliability(0);
        }
        try {
            Parser p = newCC.getParser();
            Visitable visitable = isStatement ? p.parseStatement(sql) : p.parseSearchCondition(sql);
            return visitable;
        }
        finally {
            lcc.popCompilerContext(newCC);
        }
    }

    protected int getStatementType() {
        return 0;
    }

    ConstantNode getNullNode(DataTypeDescriptor type) throws StandardException {
        switch (type.getTypeId().getJDBCTypeId()) {
            case 12: {
                CharConstantNode ccn = new CharConstantNode(1, type.getTypeId(), this.cm);
                ccn.setType(type.getNullabilityType(true));
                return ccn;
            }
            case 1: {
                CharConstantNode ccn = new CharConstantNode(type.getTypeId(), this.cm);
                ccn.setType(type.getNullabilityType(true));
                return ccn;
            }
            case -6: 
            case -5: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                NumericConstantNode nvn = new NumericConstantNode(type.getTypeId(), this.cm);
                nvn.setType(type.getNullabilityType(true));
                return nvn;
            }
            case 2: {
                NumericConstantNode ncn = new NumericConstantNode(TypeId.getBuiltInTypeId(3), this.cm);
                ncn.setType(type.getNullabilityType(true));
                return ncn;
            }
            case 91: 
            case 92: 
            case 93: {
                UserTypeConstantNode utcn = new UserTypeConstantNode(type.getTypeId(), this.cm);
                utcn.setType(type.getNullabilityType(true));
                return utcn;
            }
            case -2: {
                BitConstantNode bcn = new BitConstantNode(type.getTypeId(), this.cm);
                bcn.setType(type.getNullabilityType(true));
                return bcn;
            }
            case -3: {
                VarbitConstantNode vcn = new VarbitConstantNode(type.getTypeId(), this.cm);
                vcn.setType(type.getNullabilityType(true));
                return vcn;
            }
            case -1: {
                CharConstantNode ccn = new CharConstantNode(2, type.getTypeId(), this.cm);
                ccn.setType(type.getNullabilityType(true));
                return ccn;
            }
            case 2005: {
                CharConstantNode ccn = new CharConstantNode(3, type.getTypeId(), this.cm);
                ccn.setType(type.getNullabilityType(true));
                return ccn;
            }
            case -4: {
                VarbitConstantNode vcn = new VarbitConstantNode(type.getTypeId(), this.cm);
                vcn.setType(type.getNullabilityType(true));
                return vcn;
            }
            case 2004: {
                VarbitConstantNode vcn = new VarbitConstantNode(type.getTypeId(), this.cm);
                vcn.setType(type.getNullabilityType(true));
                return vcn;
            }
            case 2009: {
                XMLConstantNode xcn = new XMLConstantNode(type.getTypeId(), this.cm);
                xcn.setType(type.getNullabilityType(true));
                return xcn;
            }
            case 16: {
                BooleanConstantNode bCn = new BooleanConstantNode(type.getTypeId(), this.cm);
                bCn.setType(type.getNullabilityType(true));
                return bCn;
            }
        }
        if (type.getTypeId().userType()) {
            UserTypeConstantNode utcn = new UserTypeConstantNode(type.getTypeId(), this.cm);
            utcn.setType(type.getNullabilityType(true));
            return utcn;
        }
        SanityManager.THROWASSERT("Unknown type " + type.getTypeId().getSQLTypeName() + " in getNullNode");
        return null;
    }

    DataValueDescriptor convertDefaultNode(DataTypeDescriptor typeDescriptor) throws StandardException {
        return null;
    }

    public TableName makeTableName(String schemaName, String flatName) throws StandardException {
        return QueryTreeNode.makeTableName(this.getContextManager(), schemaName, flatName);
    }

    public static TableName makeTableName(ContextManager contextManager, String schemaName, String flatName) throws StandardException {
        return new TableName(schemaName, flatName, contextManager);
    }

    public boolean isAtomic() throws StandardException {
        SanityManager.THROWASSERT("isAtomic should not be called for this  class: " + this.getClass().getName());
        return false;
    }

    protected final TableDescriptor getTableDescriptor(String tableName, SchemaDescriptor schema) throws StandardException {
        TableDescriptor retval;
        if (this.isSessionSchema(schema) && (retval = this.getLanguageConnectionContext().getTableDescriptorForDeclaredGlobalTempTable(tableName)) != null) {
            return retval;
        }
        if (schema.getUUID() == null) {
            return null;
        }
        TableDescriptor td = this.getDataDictionary().getTableDescriptor(tableName, schema, this.getLanguageConnectionContext().getTransactionCompile());
        if (td == null || td.isSynonymDescriptor()) {
            return null;
        }
        return td;
    }

    final SchemaDescriptor getSchemaDescriptor(String schemaName) throws StandardException {
        return this.getSchemaDescriptor(schemaName, true);
    }

    final SchemaDescriptor getSchemaDescriptor(String schemaName, boolean raiseError) throws StandardException {
        return StatementUtil.getSchemaDescriptor(schemaName, raiseError, this.getDataDictionary(), this.getLanguageConnectionContext(), this.getCompilerContext());
    }

    TableName resolveTableToSynonym(TableName tabName) throws StandardException {
        AliasDescriptor nextAD;
        SchemaDescriptor nextSD;
        DataDictionary dd = this.getDataDictionary();
        String nextSynonymTable = tabName.getTableName();
        String nextSynonymSchema = tabName.getSchemaName();
        boolean found = false;
        CompilerContext cc = this.getCompilerContext();
        while ((nextSD = this.getSchemaDescriptor(nextSynonymSchema, false)) != null && nextSD.getUUID() != null && (nextAD = dd.getAliasDescriptor(nextSD.getUUID().toString(), nextSynonymTable, 'S')) != null) {
            cc.createDependency(nextAD);
            found = true;
            SynonymAliasInfo info = (SynonymAliasInfo)nextAD.getAliasInfo();
            nextSynonymTable = info.getSynonymTable();
            nextSynonymSchema = info.getSynonymSchema();
        }
        if (!found) {
            return null;
        }
        TableName tableName = new TableName(nextSynonymSchema, nextSynonymTable, this.getContextManager());
        return tableName;
    }

    void verifyClassExist(String javaClassName) throws StandardException {
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        ClassNotFoundException reason = null;
        boolean foundMatch = false;
        try {
            foundMatch = classInspector.accessible(javaClassName);
        }
        catch (ClassNotFoundException cnfe) {
            reason = cnfe;
        }
        if (!foundMatch) {
            throw StandardException.newException("42X51", reason, javaClassName);
        }
        if (ClassInspector.primitiveType(javaClassName)) {
            throw StandardException.newException("42Y37", javaClassName);
        }
    }

    void setRefActionInfo(long fkIndexConglomId, int[] fkColArray, String parentResultSetId, boolean dependentScan) {
        SanityManager.THROWASSERT("setRefActionInfo() not expected to be called for " + this.getClass().getName());
    }

    void generateAuthorizeCheck(ActivationClassBuilder acb, MethodBuilder mb, int sqlOperation) {
        acb.pushThisAsActivation(mb);
        mb.callMethod((short)185, null, "getLanguageConnectionContext", "org.apache.derby.iapi.sql.conn.LanguageConnectionContext", 0);
        mb.callMethod((short)185, null, "getAuthorizer", "org.apache.derby.iapi.sql.conn.Authorizer", 0);
        acb.pushThisAsActivation(mb);
        mb.push(sqlOperation);
        mb.callMethod((short)185, null, "authorize", "void", 2);
    }

    public void checkReliability(String fragmentType, int fragmentBitMask) throws StandardException {
        if ((this.getCompilerContext().getReliability() & fragmentBitMask) != 0) {
            this.throwReliabilityException(fragmentType, fragmentBitMask);
        }
    }

    public void checkReliability(int fragmentBitMask, String fragmentType) throws StandardException {
        if ((this.getCompilerContext().getReliability() & fragmentBitMask) != 0) {
            String fragmentTypeTxt = MessageService.getTextMessage(fragmentType, new Object[0]);
            this.throwReliabilityException(fragmentTypeTxt, fragmentBitMask);
        }
    }

    public DataTypeDescriptor bindUserType(DataTypeDescriptor originalDTD) throws StandardException {
        if (originalDTD.getCatalogType().isRowMultiSet()) {
            return this.bindRowMultiSet(originalDTD);
        }
        if (!originalDTD.getTypeId().userType()) {
            return originalDTD;
        }
        UserDefinedTypeIdImpl userTypeID = (UserDefinedTypeIdImpl)originalDTD.getTypeId().getBaseTypeId();
        if (userTypeID.isBound()) {
            return originalDTD;
        }
        DataDictionary dd = this.getDataDictionary();
        SchemaDescriptor typeSchema = this.getSchemaDescriptor(userTypeID.getSchemaName());
        char udtNameSpace = 'A';
        String unqualifiedTypeName = userTypeID.getUnqualifiedName();
        AliasDescriptor ad = dd.getAliasDescriptor(typeSchema.getUUID().toString(), unqualifiedTypeName, udtNameSpace);
        if (ad == null) {
            throw StandardException.newException("42X94", AliasDescriptor.getAliasType(udtNameSpace), unqualifiedTypeName);
        }
        this.createTypeDependency(ad);
        DataTypeDescriptor result = new DataTypeDescriptor(TypeId.getUserDefinedTypeId(typeSchema.getSchemaName(), unqualifiedTypeName, ad.getJavaClassName()), originalDTD.isNullable());
        return result;
    }

    public TypeDescriptor bindUserCatalogType(TypeDescriptor td) throws StandardException {
        if (!td.isUserDefinedType()) {
            return td;
        }
        DataTypeDescriptor dtd = DataTypeDescriptor.getType(td);
        dtd = this.bindUserType(dtd);
        return dtd.getCatalogType();
    }

    public AliasDescriptor getUDTDesc(DataTypeDescriptor dtd) throws StandardException {
        UserDefinedTypeIdImpl userTypeID = (UserDefinedTypeIdImpl)dtd.getTypeId().getBaseTypeId();
        DataDictionary dd = this.getDataDictionary();
        SchemaDescriptor typeSchema = this.getSchemaDescriptor(userTypeID.getSchemaName());
        char udtNameSpace = 'A';
        String unqualifiedTypeName = userTypeID.getUnqualifiedName();
        AliasDescriptor ad = dd.getAliasDescriptor(typeSchema.getUUID().toString(), unqualifiedTypeName, udtNameSpace);
        return ad;
    }

    void addUDTUsagePriv(List<ValueNode> valueNodes) throws StandardException {
        if (!this.isPrivilegeCollectionRequired()) {
            return;
        }
        for (ValueNode val : valueNodes) {
            this.addUDTUsagePriv(val);
        }
    }

    void addUDTUsagePriv(ValueNode val) throws StandardException {
        if (!this.isPrivilegeCollectionRequired()) {
            return;
        }
        DataTypeDescriptor dtd = val.getTypeServices();
        if (dtd != null && dtd.getTypeId().userType()) {
            AliasDescriptor ad = this.getUDTDesc(dtd);
            this.getCompilerContext().addRequiredUsagePriv(ad);
        }
    }

    public DataTypeDescriptor bindRowMultiSet(DataTypeDescriptor originalDTD) throws StandardException {
        if (!originalDTD.getCatalogType().isRowMultiSet()) {
            return originalDTD;
        }
        RowMultiSetImpl originalMultiSet = (RowMultiSetImpl)originalDTD.getTypeId().getBaseTypeId();
        TypeDescriptor[] columnTypes = originalMultiSet.getTypes();
        int columnCount = columnTypes.length;
        for (int i = 0; i < columnCount; ++i) {
            columnTypes[i] = this.bindUserCatalogType(columnTypes[i]);
        }
        originalMultiSet.setTypes(columnTypes);
        return originalDTD;
    }

    public void createTypeDependency(DataTypeDescriptor dtd) throws StandardException {
        AliasDescriptor ad = this.getDataDictionary().getAliasDescriptorForUDT(null, dtd);
        if (ad != null) {
            this.createTypeDependency(ad);
        }
    }

    private void createTypeDependency(AliasDescriptor ad) throws StandardException {
        this.getCompilerContext().createDependency(ad);
        if (this.isPrivilegeCollectionRequired() && !this.getCompilerContext().skippingTypePrivileges()) {
            this.getCompilerContext().addRequiredUsagePriv(ad);
        }
    }

    private void throwReliabilityException(String fragmentType, int fragmentBitMask) throws StandardException {
        String sqlState;
        int reliability = this.getCompilerContext().getReliability();
        if (reliability == 1192) {
            sqlState = "42Y84";
        } else if (reliability == 30329) {
            switch (fragmentBitMask) {
                case 8192: {
                    sqlState = "42XA5";
                    break;
                }
                default: {
                    sqlState = "42XA2";
                    break;
                }
            }
        } else {
            sqlState = (reliability & fragmentBitMask & 0x2000) != 0 ? "42XA5" : (reliability == 18041 ? "42Y39" : "42Y98");
        }
        throw StandardException.newException(sqlState, fragmentType);
    }

    public int orReliability(int newBits) {
        CompilerContext cc = this.getCompilerContext();
        int previousReliability = cc.getReliability();
        cc.setReliability(previousReliability | newBits);
        return previousReliability;
    }

    public static void bindOffsetFetch(ValueNode offset, ValueNode fetchFirst) throws StandardException {
        long val;
        DataValueDescriptor dvd;
        if (offset instanceof ConstantNode) {
            dvd = ((ConstantNode)offset).getValue();
            val = dvd.getLong();
            if (val < 0L) {
                throw StandardException.newException("2201X", Long.toString(val));
            }
        } else if (offset instanceof ParameterNode) {
            offset.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(-5), false));
        }
        if (fetchFirst instanceof ConstantNode) {
            dvd = ((ConstantNode)fetchFirst).getValue();
            val = dvd.getLong();
            if (val < 1L) {
                throw StandardException.newException("2201W", Long.toString(val));
            }
        } else if (fetchFirst instanceof ParameterNode) {
            fetchFirst.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(-5), false));
        }
    }

    public <N extends QueryTreeNode> SortedSet<N> getOffsetOrderedNodes(Class<N> type) throws StandardException {
        OffsetOrderVisitor<N> visitor = new OffsetOrderVisitor<N>(type, this.getBeginOffset(), this.getEndOffset() + 1);
        this.accept(visitor);
        return visitor.getNodes();
    }

    static Context getContext(String contextID) {
        return ContextService.getContext(contextID);
    }
}

