/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.sql.SQLException;
import java.util.Properties;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.shared.common.error.PublicAPI;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derbyTesting.functionTests.util.PropertyUtil;

public class TestPropertyInfo {
    public static String getAllTableProperties(String schemaName, String tableName) throws SQLException {
        Properties p = TestPropertyInfo.getConglomerateProperties(schemaName, tableName, false);
        if (p == null) {
            return null;
        }
        return PropertyUtil.sortProperties((Properties)p);
    }

    public static String getTableProperty(String schemaName, String tableName, String key) throws SQLException {
        return TestPropertyInfo.getConglomerateProperties(schemaName, tableName, false).getProperty(key);
    }

    public static String getAllIndexProperties(String schemaName, String indexName) throws SQLException {
        Properties p = TestPropertyInfo.getConglomerateProperties(schemaName, indexName, true);
        if (p == null) {
            return null;
        }
        return PropertyUtil.sortProperties((Properties)p);
    }

    public static Properties filter(Properties p, String filterMe) {
        p.remove(filterMe);
        return p;
    }

    private static Properties getConglomerateProperties(String schemaName, String conglomerateName, boolean isIndex) throws SQLException {
        Properties properties;
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        TransactionController tc = lcc.getTransactionExecute();
        try {
            long conglomerateNumber;
            DataDictionary dd = lcc.getDataDictionary();
            SchemaDescriptor sd = dd.getSchemaDescriptor(schemaName, tc, true);
            if (!isIndex) {
                TableDescriptor td = dd.getTableDescriptor(conglomerateName, sd, tc);
                if (td == null || td.getTableType() == 2) {
                    return new Properties();
                }
                conglomerateNumber = td.getHeapConglomerateId();
            } else {
                ConglomerateDescriptor cd = dd.getConglomerateDescriptor(conglomerateName, sd, false);
                if (cd == null) {
                    return new Properties();
                }
                conglomerateNumber = cd.getConglomerateNumber();
            }
            ConglomerateController cc = tc.openConglomerate(conglomerateNumber, false, 0, 6, 5);
            properties = cc.getInternalTablePropertySet(new Properties());
            cc.close();
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException((StandardException)se);
        }
        return properties;
    }
}

