/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.i18n;

import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Locale;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.LocaleTestSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class UrlLocaleTest
extends BaseJDBCTestCase {
    public UrlLocaleTest(String string) {
        super(string);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        TestConfiguration.getCurrent().shutdownEngine();
        String string = TestConfiguration.getCurrent().getJDBCClient().getJDBCDriverName();
        Class<?> clazz = Class.forName(string);
        clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public void testURLLocale() throws SQLException, MalformedURLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("call checkRDefaultLoc()");
        Object object = UrlLocaleTest.getReadWriteJDBCURL("swissdb");
        object = (String)object + ";create=true;territory=fr_CH";
        Connection connection = DriverManager.getConnection((String)object);
        UrlLocaleTest.createLocaleProcedures(connection);
        Statement statement2 = connection.createStatement();
        statement2.executeUpdate("call checkDatabaseLoc('fr_CH')");
        statement2.close();
        connection.close();
        object = UrlLocaleTest.getReadWriteJDBCURL("hindi");
        object = (String)object + ";create=true;territory=hi_IN";
        connection = DriverManager.getConnection((String)object);
        UrlLocaleTest.createLocaleProcedures(connection);
        statement2 = connection.createStatement();
        statement2.executeUpdate("call checkDatabaseLoc('hi_IN')");
        statement2.close();
        connection.close();
        object = UrlLocaleTest.getReadWriteJDBCURL("Israel");
        object = (String)object + ";create=true;territory=en_IL_JavaOS";
        connection = DriverManager.getConnection((String)object);
        UrlLocaleTest.createLocaleProcedures(connection);
        statement2 = connection.createStatement();
        statement2.executeUpdate("call checkDatabaseLoc('en_IL_JavaOS')");
        statement2.close();
        connection.close();
        object = UrlLocaleTest.getReadWriteJDBCURL("bacon");
        object = (String)object + ";create=true;territory=da";
        connection = DriverManager.getConnection((String)object);
        UrlLocaleTest.createLocaleProcedures(connection);
        statement2 = connection.createStatement();
        statement2.executeUpdate("call checkDatabaseLoc('da')");
        statement2.close();
        connection.close();
    }

    public void testUrlLocaleNegative() throws SQLException {
        Object object = UrlLocaleTest.getReadWriteJDBCURL("fail1");
        object = (String)object + ";create=true;territory=";
        this.checkInvalidTerritoryFormat((String)object);
        object = UrlLocaleTest.getReadWriteJDBCURL("fail1");
        try {
            DriverManager.getConnection((String)object);
            UrlLocaleTest.fail((String)("Database connect " + (String)object + " should fail because db does not exist"));
        }
        catch (SQLException sQLException) {
            UrlLocaleTest.assertSQLState("XJ004", sQLException);
        }
        this.checkInvalidTerritoryFormat("en_");
        this.checkInvalidTerritoryFormat("en_d");
        this.checkInvalidTerritoryFormat("en-US");
    }

    public void messageLocale_unknown() throws SQLException {
        Object object = UrlLocaleTest.getReadWriteJDBCURL("rrTTdb");
        object = (String)object + ";create=true";
        Connection connection = DriverManager.getConnection((String)object);
        Statement statement = connection.createStatement();
        UrlLocaleTest.createLocaleProcedures(connection);
        statement.executeUpdate("call checkDefaultLoc()");
        statement.executeUpdate("call checkDatabaseLoc('rr_TT')");
        try {
            statement.executeUpdate("create table t1 oops (i int)");
        }
        catch (SQLException sQLException) {
            UrlLocaleTest.assertSQLState("42X01", sQLException);
            UrlLocaleTest.assertTrue((String)"Expected English Message with \"Encountered\" ", (sQLException.getMessage().indexOf("Encountered") != -1 ? 1 : 0) != 0);
        }
        statement.executeUpdate("create table t2 (i int)");
        statement.executeUpdate("create index i2_a on t2(i)");
        statement.executeUpdate("create index i2_b on t2(i)");
        SQLWarning sQLWarning = statement.getWarnings();
        UrlLocaleTest.assertSQLState("01504", sQLWarning);
        UrlLocaleTest.assertTrue((String)"Expected English warning", (sQLWarning.getMessage().indexOf("duplicate") != -1 ? 1 : 0) != 0);
        statement.close();
        connection.close();
    }

    public void messageLocale_Germany() throws SQLException {
        Object object = UrlLocaleTest.getReadWriteJDBCURL("qqPPdb");
        object = (String)object + ";create=true;territory=qq_PP_testOnly";
        Connection connection = DriverManager.getConnection((String)object);
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table t2 (i int)");
        statement.executeUpdate("create index i2_a on t2(i)");
        try {
            statement.executeUpdate("create table t1 oops (i int)");
        }
        catch (SQLException sQLException) {
            UrlLocaleTest.assertSQLState("42X01", sQLException);
            UrlLocaleTest.assertTrue((String)"Expected qq_PP Message with \"Encountered\" ", (sQLException.getMessage().indexOf("Encountered") != -1 ? 1 : 0) != 0);
        }
        statement.executeUpdate("create index i2_b on t2(i)");
        SQLWarning sQLWarning = statement.getWarnings();
        UrlLocaleTest.assertSQLState("01504", sQLWarning);
        UrlLocaleTest.assertTrue((String)"Expected German warning with Duplikat", (sQLWarning.getMessage().indexOf(" Duplikat") != -1 ? 1 : 0) != 0);
        try {
            statement.executeUpdate("drop table t3");
        }
        catch (SQLException sQLException) {
            UrlLocaleTest.assertSQLState("42Y55", sQLException);
            UrlLocaleTest.assertTrue((String)"Expected German Message with vorhanden", (sQLException.getMessage().indexOf("vorhanden") != -1 ? 1 : 0) != 0);
        }
        object = UrlLocaleTest.getReadWriteJDBCURL("enUSdb");
        object = (String)object + ";create=true;territory=en_US";
        connection = DriverManager.getConnection((String)object);
        statement = connection.createStatement();
        statement.executeUpdate("create table t2 (i int)");
        statement.executeUpdate("create index i2_a on t2(i)");
        try {
            statement.executeUpdate("create table t1 oops (i int)");
        }
        catch (SQLException sQLException) {
            UrlLocaleTest.assertSQLState("42X01", sQLException);
            UrlLocaleTest.assertTrue((String)"Expected English message with \"Encountered\" ", (sQLException.getMessage().indexOf("Encountered") != -1 ? 1 : 0) != 0);
        }
        statement.executeUpdate("create index i2_b on t2(i)");
        sQLWarning = statement.getWarnings();
        UrlLocaleTest.assertSQLState("01504", sQLWarning);
        UrlLocaleTest.assertTrue((String)"Expected English warning with duplicate", (sQLWarning.getMessage().indexOf("duplicate") != -1 ? 1 : 0) != 0);
        try {
            statement.executeUpdate("drop table t3");
        }
        catch (SQLException sQLException) {
            UrlLocaleTest.assertSQLState("42Y55", sQLException);
            UrlLocaleTest.assertTrue((String)"Expected English Message with performed", (sQLException.getMessage().indexOf("performed") != -1 ? 1 : 0) != 0);
        }
    }

    private void checkInvalidTerritoryFormat(String string) {
        try {
            Object object = UrlLocaleTest.getReadWriteJDBCURL("fail3");
            object = (String)object + ";create=true;territory=" + string;
            DriverManager.getConnection((String)object);
            UrlLocaleTest.fail((String)("connection without territory: " + (String)object + "should have failed"));
        }
        catch (SQLException sQLException) {
            UrlLocaleTest.assertSQLState("XJ041", sQLException);
            UrlLocaleTest.assertSQLState("XBM0X", sQLException.getNextException());
        }
    }

    private static String getReadWriteJDBCURL(String string) {
        return TestConfiguration.getCurrent().getJDBCUrl(SupportFilesSetup.getReadWriteFileName(string));
    }

    private static void createLocaleProcedures(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        statement.executeUpdate("create procedure checkDatabaseLoc(in locale char(12)) parameter style java language java external name 'org.apache.derbyTesting.functionTests.tests.i18n.DefaultLocale.checkDatabaseLocale'");
        statement.executeUpdate("create procedure checkRDefaultLoc() parameter style java language java external name 'org.apache.derbyTesting.functionTests.tests.i18n.DefaultLocale.checkRDefaultLocale'");
        statement.executeUpdate("create procedure checkDefaultLoc() parameter style java language java external name 'org.apache.derbyTesting.functionTests.tests.i18n.DefaultLocale.checkDefaultLocale'");
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite();
        baseTestSuite.addTestSuite(UrlLocaleTest.class);
        baseTestSuite.addTest((Test)new LocaleTestSetup((Test)new UrlLocaleTest("messageLocale_unknown"), Locale.of("rr", "TT")));
        baseTestSuite.addTest((Test)new LocaleTestSetup((Test)new UrlLocaleTest("messageLocale_Germany"), Locale.GERMANY));
        TestSetup testSetup = new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                UrlLocaleTest.createLocaleProcedures(statement.getConnection());
            }
        };
        testSetup = new SupportFilesSetup((Test)testSetup);
        return testSetup;
    }
}

