/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;

public class T_Authorize {
    public static void verifyAccessRW(int n) throws Exception {
        T_Authorize.verifyAccess(n, false);
    }

    public static void verifyAccessRO(int n) throws Exception {
        T_Authorize.verifyAccess(n, true);
    }

    private static void verifyAccess(int n, boolean bl) throws Exception {
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        if (connection.isReadOnly() != bl) {
            throw new Exception("Connection read-only mode does not match " + bl);
        }
        String string = "create table t2 (a int)";
        T_Authorize.verifyExecute(connection, string, 0, nArray, bl, 0);
        if (!bl) {
            string = "drop table t2";
            T_Authorize.verifyExecute(connection, string, 0, nArray, bl, 0);
        }
        nArray[0] = n;
        string = "insert into AUTH_TEST.t1 values ?";
        T_Authorize.verifyExecute(connection, string, 1, nArray, bl, 1);
        String string2 = "select a from AUTH_TEST.t1 where a = ?";
        nArray2[0] = n;
        T_Authorize.verifyResult(connection, string2, 1, nArray2, !bl, Integer.toString(n));
        nArray[0] = -n;
        nArray[1] = n;
        string = "update AUTH_TEST.t1 set a=? where a=?";
        T_Authorize.verifyExecute(connection, string, 2, nArray, bl, 1);
        nArray2[0] = -n;
        T_Authorize.verifyResult(connection, string2, 1, nArray2, !bl, Integer.toString(-n));
        string = "delete from AUTH_TEST.t1 where a=?";
        T_Authorize.verifyExecute(connection, string, 1, nArray, bl, 1);
        T_Authorize.verifyResult(connection, string2, 1, nArray2, false, null);
        string = "call sqlj.install_jar(AUTH_TEST.resourcefile('org.apache.derbyTesting.functionTests.testData.v1','j1v1.jar', 'extinout/j1v1.jar'), 'APP.J1', 0)";
        T_Authorize.verifyExecute(connection, string, 0, nArray, bl, 0);
        string2 = "select filename from sys.sysfiles where filename = 'J1'";
        T_Authorize.verifyResult(connection, string2, 0, nArray2, !bl, "J1");
        string = bl ? "call sqlj.replace_jar(AUTH_TEST.resourcefile('org.apache.derbyTesting.functionTests.testData.v2','j1v2.jar', 'extinout/j1v2.jar'), 'APP.IMMUTABLE')" : "call sqlj.replace_jar(AUTH_TEST.resourcefile('org.apache.derbyTesting.functionTests.testData.v2','j1v2.jar', 'extinout/j1v2.jar'), 'APP.J1')";
        T_Authorize.verifyExecute(connection, string, 0, nArray, bl, 0);
        T_Authorize.verifyResult(connection, string2, 0, nArray2, !bl, "J1");
        string = bl ? "call sqlj.remove_jar('APP.IMMUTABLE', 0)" : "call sqlj.remove_jar('APP.J1', 0)";
        T_Authorize.verifyExecute(connection, string, 0, nArray, bl, 0);
        T_Authorize.verifyResult(connection, string2, 0, nArray2, false, null);
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyExecute(Connection connection, String string, int n, int[] nArray, boolean bl, int n2) throws Exception {
        try (PreparedStatement preparedStatement = null;){
            int n3;
            preparedStatement = connection.prepareStatement(string);
            for (n3 = 0; n3 < n; ++n3) {
                preparedStatement.setInt(n3 + 1, nArray[n3]);
            }
            n3 = preparedStatement.executeUpdate();
            if (bl) {
                throw new Exception("operation incorrectly allowed for read only connection " + string);
            }
            if (n3 != n2) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < n; ++i) {
                    if (i != 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(nArray[i]);
                }
                throw new Exception("Incorrect row count " + n3 + " for " + string + " with args " + String.valueOf(stringBuffer));
            }
        }
    }

    private static void verifyResult(Connection connection, String string, int n, int[] nArray, boolean bl, String string2) throws Exception {
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        for (int i = 0; i < n; ++i) {
            preparedStatement.setInt(i + 1, nArray[i]);
        }
        ResultSet resultSet = preparedStatement.executeQuery();
        boolean bl2 = resultSet.next();
        if (bl) {
            String string3;
            if (!bl2) {
                throw new Exception("incorrect row count");
            }
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            if (resultSetMetaData.getColumnCount() != 1) {
                new Exception("bad column count");
            }
            if (!string2.equals(string3 = resultSet.getString(1))) {
                throw new Exception("bad return column " + string3);
            }
            bl2 = resultSet.next();
            if (bl2) {
                throw new Exception("incorrect row count");
            }
        } else if (bl2) {
            throw new Exception("incorrect row count");
        }
    }
}

