/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.StaticPropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.Table;
import org.apache.fop.fo.flow.TableCell;
import org.apache.fop.fo.flow.TableColumn;
import org.apache.fop.fo.flow.TableFObj;
import org.apache.fop.fo.flow.TableRow;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class TableBody
extends TableFObj {
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private PropertyList savedPropertyList;
    protected boolean tableRowsFound = false;
    protected boolean tableCellsFound = false;
    protected List pendingSpans;
    protected BitSet usedColumnIndices;
    private int columnIndex = 1;
    protected boolean firstRow = true;

    public TableBody(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        this.commonBorderPaddingBackground = pList.getBorderPaddingBackgroundProps();
        super.bind(pList);
        this.savedPropertyList = pList;
    }

    public void processNode(String elementName, Locator locator, Attributes attlist, PropertyList pList) throws FOPException {
        if (!this.inMarker()) {
            if (this.getTable().columns != null) {
                int cap = this.getTable().columns.size();
                this.pendingSpans = new ArrayList(cap);
                this.usedColumnIndices = new BitSet(cap);
            } else {
                this.pendingSpans = new ArrayList();
                this.usedColumnIndices = new BitSet();
            }
            this.setNextColumnIndex();
        }
        super.processNode(elementName, locator, attlist, pList);
    }

    protected void startOfNode() throws FOPException {
        this.getFOEventHandler().startBody(this);
    }

    protected void endOfNode() throws FOPException {
        if (!this.inMarker()) {
            this.savedPropertyList = null;
            this.pendingSpans = null;
            this.usedColumnIndices = null;
        }
        this.getFOEventHandler().endBody(this);
        if (!this.tableRowsFound && !this.tableCellsFound) {
            if (this.getUserAgent().validateStrictly()) {
                this.missingChildElementError("marker* (table-row+|table-cell+)");
            } else {
                this.getLogger().error((Object)"fo:table-body must not be empty. Expected: marker* (table-row+|table-cell+)");
                this.getParent().removeChild(this);
            }
        }
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(nsURI)) {
            if (localName.equals("marker")) {
                if (this.tableRowsFound || this.tableCellsFound) {
                    this.nodesOutOfOrderError(loc, "fo:marker", "(table-row+|table-cell+)");
                }
            } else if (localName.equals("table-row")) {
                this.tableRowsFound = true;
                if (this.tableCellsFound) {
                    this.invalidChildError(loc, nsURI, localName, "Either fo:table-rows or fo:table-cells may be children of an " + this.getName() + " but not both");
                }
            } else if (localName.equals("table-cell")) {
                this.tableCellsFound = true;
                if (this.tableRowsFound) {
                    this.invalidChildError(loc, nsURI, localName, "Either fo:table-rows or fo:table-cells may be children of an " + this.getName() + " but not both");
                }
            } else {
                this.invalidChildError(loc, nsURI, localName);
            }
        } else {
            this.invalidChildError(loc, nsURI, localName);
        }
    }

    protected void addChildNode(FONode child) throws FOPException {
        if (!this.inMarker() && this.firstRow) {
            Table t = this.getTable();
            if (t.columns == null) {
                t.columns = new ArrayList();
            }
            switch (child.getNameId()) {
                case 54: {
                    this.firstRow = false;
                    break;
                }
                case 50: {
                    TableCell cell = (TableCell)child;
                    int colNr = cell.getColumnNumber();
                    int colSpan = cell.getNumberColumnsSpanned();
                    Length colWidth = null;
                    if (cell.getWidth().getEnum() != 9 && colSpan == 1) {
                        colWidth = cell.getWidth();
                    }
                    for (int i = colNr; i < colNr + colSpan; ++i) {
                        if (t.columns.size() < i || t.columns.get(i - 1) == null) {
                            t.addDefaultColumn(colWidth, i == colNr ? cell.getColumnNumber() : 0);
                            continue;
                        }
                        TableColumn col = (TableColumn)t.columns.get(i - 1);
                        if (col.isDefaultColumn() || colWidth == null) continue;
                        col.setColumnWidth(colWidth);
                    }
                    break;
                }
            }
        }
        super.addChildNode(child);
    }

    private void convertCellsToRows() throws FOPException {
        ArrayList cells = new ArrayList(this.childNodes);
        this.childNodes.clear();
        Iterator i = cells.iterator();
        TableRow row = null;
        while (i.hasNext()) {
            TableCell cell = (TableCell)i.next();
            if (cell.startsRow() && row != null) {
                this.childNodes.add(row);
                row = null;
            }
            if (row == null) {
                row = new TableRow(this);
                StaticPropertyList pList = new StaticPropertyList(row, this.savedPropertyList);
                pList.setWritingMode();
                row.bind(pList);
            }
            row.addReplacedCell(cell);
            if (!cell.endsRow()) continue;
            this.childNodes.add(row);
            row = null;
        }
        if (row != null) {
            this.childNodes.add(row);
        }
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public String getLocalName() {
        return "table-body";
    }

    public int getNameId() {
        return 48;
    }

    public boolean isFirst(TableRow obj) {
        return this.childNodes == null || !this.childNodes.isEmpty() && this.childNodes.get(0) == obj;
    }

    public boolean isLast(TableRow obj) {
        return this.childNodes == null || this.childNodes.size() > 0 && this.childNodes.get(this.childNodes.size() - 1) == obj;
    }

    protected void initPendingSpans(FONode child) {
        if (child.getNameId() == 54) {
            this.pendingSpans = ((TableRow)child).pendingSpans;
        } else if (this.pendingSpans == null) {
            if (this.getTable().columns != null) {
                List tableCols = this.getTable().columns;
                this.pendingSpans = new ArrayList(tableCols.size());
                int i = tableCols.size();
                while (--i >= 0) {
                    this.pendingSpans.add(null);
                }
            } else {
                this.pendingSpans = new ArrayList();
            }
        }
    }

    protected int getCurrentColumnIndex() {
        return this.columnIndex;
    }

    protected void setCurrentColumnIndex(int newIndex) {
        this.columnIndex = newIndex;
    }

    protected void resetColumnIndex() {
        this.columnIndex = 1;
        int i = this.usedColumnIndices.length();
        while (--i >= 0) {
            this.usedColumnIndices.clear(i);
        }
        int i2 = this.pendingSpans.size();
        while (--i2 >= 0) {
            TableFObj.PendingSpan pSpan = (TableFObj.PendingSpan)this.pendingSpans.get(i2);
            if (pSpan == null) continue;
            --pSpan.rowsLeft;
            if (pSpan.rowsLeft == 0) {
                this.pendingSpans.set(i2, null);
                continue;
            }
            this.usedColumnIndices.set(i2);
        }
        if (!this.firstRow) {
            this.setNextColumnIndex();
        }
    }

    protected void setNextColumnIndex() {
        while (this.usedColumnIndices.get(this.columnIndex - 1)) {
            ++this.columnIndex;
        }
        if (this.getTable().columns != null) {
            while (this.columnIndex <= this.getTable().columns.size() && !this.getTable().isColumnNumberUsed(this.columnIndex)) {
                ++this.columnIndex;
            }
        }
    }

    protected boolean previousCellEndedRow() {
        FONode prevNode;
        if (this.childNodes != null && (prevNode = (FONode)this.childNodes.get(this.childNodes.size() - 1)).getNameId() == 50) {
            return ((TableCell)prevNode).endsRow();
        }
        return true;
    }

    public boolean isColumnNumberUsed(int colNr) {
        return this.usedColumnIndices.get(colNr - 1);
    }

    protected void flagColumnIndices(int start, int end) {
        for (int i = start; i < end; ++i) {
            this.usedColumnIndices.set(i);
        }
        this.setNextColumnIndex();
    }
}

