/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.Position;

public class KnuthGlue
extends KnuthElement {
    private int stretchability;
    private int shrinkability;
    private int adjustmentClass = -1;

    public KnuthGlue(int w, int y, int z, Position pos, boolean bAux) {
        super(w, pos, bAux);
        this.stretchability = y;
        this.shrinkability = z;
    }

    public KnuthGlue(int w, int y, int z, int iAdjClass, Position pos, boolean bAux) {
        super(w, pos, bAux);
        this.stretchability = y;
        this.shrinkability = z;
        this.adjustmentClass = iAdjClass;
    }

    public boolean isGlue() {
        return true;
    }

    public int getY() {
        return this.stretchability;
    }

    public int getZ() {
        return this.shrinkability;
    }

    public int getAdjustmentClass() {
        return this.adjustmentClass;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        if (this.isAuxiliary()) {
            sb.append("aux. ");
        }
        sb.append("glue");
        sb.append(" w=").append(this.getW());
        sb.append(" stretch=").append(this.getY());
        sb.append(" shrink=").append(this.getZ());
        if (this.getAdjustmentClass() >= 0) {
            sb.append(" adj-class=").append(this.getAdjustmentClass());
        }
        return sb.toString();
    }
}

