/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.util;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.Typed;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.deltaspike.jsf.api.config.base.JsfBaseConfig;
import org.apache.deltaspike.jsf.impl.util.JsfUtils;
import org.apache.deltaspike.jsf.spi.scope.window.ClientWindow;

@Typed
public abstract class ClientWindowHelper {
    private static final Logger LOG = Logger.getLogger(ClientWindowHelper.class.getName());
    private static final String INITIAL_REDIRECT_WINDOW_ID = ClientWindowHelper.class.getName() + ".INITIAL_REDIRECT_WINDOW_ID";

    public static String constructRequestUrl(ExternalContext externalContext) {
        String url = externalContext.getRequestContextPath() + externalContext.getRequestServletPath();
        if (externalContext.getRequestPathInfo() != null) {
            url = url + externalContext.getRequestPathInfo();
        }
        url = JsfUtils.addRequestParameters(externalContext, url, true);
        url = externalContext.encodeResourceURL(url);
        return url;
    }

    public static void handleInitialRedirect(FacesContext facesContext, String newWindowId) {
        facesContext.getAttributes().put(INITIAL_REDIRECT_WINDOW_ID, newWindowId);
        ExternalContext externalContext = facesContext.getExternalContext();
        String url = ClientWindowHelper.constructRequestUrl(externalContext);
        ClientWindowHelper.addRequestWindowIdCookie(facesContext, newWindowId, newWindowId);
        try {
            externalContext.redirect(url);
        }
        catch (IOException e) {
            throw new FacesException("Could not send initial redirect!", (Throwable)e);
        }
    }

    public static boolean isInitialRedirect(FacesContext facesContext) {
        return facesContext.getAttributes().containsKey(INITIAL_REDIRECT_WINDOW_ID);
    }

    public static String getInitialRedirectWindowId(FacesContext facesContext) {
        return (String)facesContext.getAttributes().get(INITIAL_REDIRECT_WINDOW_ID);
    }

    public static String appendWindowId(FacesContext facesContext, String url, ClientWindow clientWindow) {
        Map parameters;
        if (clientWindow != null && clientWindow.isClientWindowRenderModeEnabled(facesContext) && (parameters = clientWindow.getQueryURLParameters(facesContext)) != null && !parameters.isEmpty()) {
            String targetUrl = url;
            for (Map.Entry entry : parameters.entrySet()) {
                String emptyParameter;
                targetUrl = JsfUtils.addParameter(facesContext.getExternalContext(), targetUrl, true, (String)entry.getKey(), (String)entry.getValue());
                if (!targetUrl.contains(emptyParameter = (String)entry.getKey() + "=&")) continue;
                targetUrl = targetUrl.replace(emptyParameter, "");
            }
            return targetUrl;
        }
        return url;
    }

    public static void addRequestWindowIdCookie(FacesContext context, String requestToken, String windowId) {
        context.getExternalContext().addResponseHeader("Set-Cookie", "dsrwid-" + requestToken + "=" + windowId + "; path=/; maxAge=30; SameSite=Strict");
    }

    public static Object getRequestWindowIdCookie(FacesContext context, String requestToken) {
        Map cookieMap = context.getExternalContext().getRequestCookieMap();
        if (cookieMap.containsKey("dsrwid-" + requestToken)) {
            return cookieMap.get("dsrwid-" + requestToken);
        }
        return null;
    }

    public static int getMaxWindowIdLength() {
        int result = JsfBaseConfig.ScopeCustomization.WindowRestriction.ID_MAX_LENGTH;
        if (result > 10 && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("ATTENTION: if you change this value to be significant longer than 10, you can introduce a security issue in WindowIdHtmlRenderer. If you increase it because window.name contains a value already, please revisit that usage or create shorter unique ids since they just need to be unique within the user-session.");
        }
        return result;
    }

    public abstract class Cookies {
        public static final String REQUEST_WINDOW_ID_PREFIX = "dsrwid-";
    }

    public abstract class RequestParameters {
        public static final String POST_WINDOW_ID = "dspwid";
        public static final String JSF_POST_WINDOW_ID = "javax.faces.ClientWindow";
        public static final String GET_WINDOW_ID = "dswid";
        public static final String REQUEST_TOKEN = "dsrid";
    }
}

