/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core;

import org.apache.commons.lang.StringUtils;
import org.apache.directory.fortress.core.Manageable;
import org.apache.directory.fortress.core.PwPolicyMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.PwPolicyMgrImpl;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.rest.PwPolicyMgrRestImpl;
import org.apache.directory.fortress.core.util.ClassUtil;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.core.util.VUtil;

public final class PwPolicyMgrFactory {
    private static final String CLS_NM = PwPolicyMgrFactory.class.getName();

    public static PwPolicyMgr createInstance() throws SecurityException {
        return PwPolicyMgrFactory.createInstance("HOME");
    }

    public static PwPolicyMgr createInstance(String contextId) throws SecurityException {
        VUtil.assertNotNull(contextId, 101, CLS_NM + ".createInstance");
        String policyClassName = Config.getInstance().getProperty("policymgr.implementation");
        Manageable policyMgr = StringUtils.isEmpty((String)policyClassName) ? (Config.getInstance().isRestEnabled() ? new PwPolicyMgrRestImpl() : new PwPolicyMgrImpl()) : (PwPolicyMgr)ClassUtil.createInstance(policyClassName);
        policyMgr.setContextId(contextId);
        return policyMgr;
    }

    public static PwPolicyMgr createInstance(Session adminSess) throws SecurityException {
        return PwPolicyMgrFactory.createInstance("HOME", adminSess);
    }

    public static PwPolicyMgr createInstance(String contextId, Session adminSess) throws SecurityException {
        PwPolicyMgr policyMgr = PwPolicyMgrFactory.createInstance(contextId);
        policyMgr.setAdmin(adminSess);
        return policyMgr;
    }
}

