/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.fortress.core.CreateException;
import org.apache.directory.fortress.core.RemoveException;
import org.apache.directory.fortress.core.ldap.LdapDataProvider;
import org.apache.directory.fortress.core.model.Suffix;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SuffixDAO
extends LdapDataProvider {
    private static final String CLS_NM = SuffixDAO.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);
    private static final String[] SUFFIX_OBJ_CLASS = new String[]{"dcObject", "organization"};

    SuffixDAO() {
    }

    void create(Suffix se) throws CreateException {
        LdapConnection ld = null;
        String nodeDn = this.getDn(se);
        try {
            LOG.info("create suffix dn [{}]", (Object)nodeDn);
            DefaultEntry myEntry = new DefaultEntry(nodeDn);
            myEntry.add("objectClass", SUFFIX_OBJ_CLASS);
            myEntry.add("dc", new String[]{se.getName()});
            myEntry.add("o", new String[]{se.getDescription()});
            ld = this.getAdminConnection();
            this.add(ld, (Entry)myEntry);
        }
        catch (LdapException e) {
            try {
                String error = "create container node dn [" + nodeDn + "] caught LDAPException=" + e;
                throw new CreateException(6010, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
    }

    void remove(Suffix se) throws RemoveException {
        LdapConnection ld = null;
        String nodeDn = this.getDn(se);
        LOG.info("remove suffix dn [{}]", (Object)nodeDn);
        try {
            ld = this.getAdminConnection();
            this.deleteRecursive(ld, nodeDn);
        }
        catch (CursorException e) {
            String error = "remove suffix node dn [" + nodeDn + "] caught CursorException=" + e.getMessage();
            throw new RemoveException(6011, error, (Exception)((Object)e));
        }
        catch (LdapException e) {
            String error = "remove suffix node dn [" + nodeDn + "] caught LDAPException=" + e;
            throw new RemoveException(6011, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
    }

    private String getDn(Suffix se) {
        String dn = "dc=" + se.getName() + ",dc=" + se.getDc();
        if (StringUtils.isNotEmpty((String)se.getDc2()) && !se.getDc2().equals("${suffix.dc2}")) {
            dn = dn + ",dc=" + se.getDc2();
        }
        LOG.debug("suffix={}", (Object)dn);
        return dn;
    }
}

