/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.chart;

import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.pkg.NamespaceName;
import org.odftoolkit.odfdom.pkg.OdfNamespace;
import org.odftoolkit.odfdom.type.CellRangeAddress;
import org.odftoolkit.odfdom.type.CellRangeAddressList;
import org.odftoolkit.simple.SpreadsheetDocument;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSet {
    private Vector<Vector<Double>> dataset = new Vector();
    private Vector<String> labelset = new Vector();
    private Vector<String> legendset = new Vector();
    private CellRangeAddressList cellRangeAddress;
    private boolean bFirstRowAsLabel;
    private boolean bFirstColumnAsLabel;
    private boolean bRowAsDataSeries;
    private boolean isLocalTable;

    public DataSet() {
        this.bFirstRowAsLabel = true;
        this.bFirstColumnAsLabel = true;
        this.bRowAsDataSeries = false;
        this.isLocalTable = false;
    }

    public DataSet(String[] labels, String[] legends, double[][] data) {
        this.bFirstRowAsLabel = true;
        this.bFirstColumnAsLabel = true;
        this.bRowAsDataSeries = false;
        this.isLocalTable = true;
        this.setValues(labels, legends, data);
    }

    public DataSet(CellRangeAddressList cellRangeAddress, SpreadsheetDocument spreadsheet, boolean bFirstRowAsLabel, boolean bFirstColumnAsLabel, boolean rowAsDataSeries) {
        this.bFirstRowAsLabel = bFirstRowAsLabel;
        this.bFirstColumnAsLabel = bFirstColumnAsLabel;
        this.bRowAsDataSeries = rowAsDataSeries;
        this.isLocalTable = false;
        this.setValues(cellRangeAddress, spreadsheet, bFirstRowAsLabel, bFirstColumnAsLabel, rowAsDataSeries);
    }

    public String getLocalTableCellRanges(int seriesCount, int labelLength, Vector<String> seriesCellRange, Vector<String> legendCellAddr) {
        String localtable = "local-table";
        String tablecellrange = localtable + "." + "A1:" + (char)(65 + seriesCount) + (1 + labelLength);
        return this.getCellRanges(tablecellrange, true, true, false, seriesCellRange, legendCellAddr);
    }

    public CellRangeAddressList getCellRangeAddress() {
        return this.cellRangeAddress;
    }

    public void appendDataSeries(String legend, double[] values) {
        this.legendset.add(legend);
        Vector<Double> valuesList = new Vector<Double>();
        for (int i = 0; i < values.length; ++i) {
            valuesList.add(new Double(values[i]));
        }
        this.dataset.add(valuesList);
    }

    public void insertDataSeries(int index, String legend, double[] values) {
        this.legendset.add(index, legend);
        Vector<Double> valuesList = new Vector<Double>();
        for (int i = 0; i < values.length; ++i) {
            valuesList.add(new Double(values[i]));
        }
        this.dataset.add(index, valuesList);
    }

    public void updateDataSeries(int index, double[] values) {
        Vector<Double> valuesList = new Vector<Double>();
        for (int i = 0; i < values.length; ++i) {
            valuesList.add(new Double(values[i]));
        }
        this.dataset.set(index, valuesList);
    }

    public void updateDataSeries(String legend, int beginindex, double[] values) {
        Vector<Double> valuesList = new Vector<Double>();
        for (int i = 0; i < values.length; ++i) {
            valuesList.add(new Double(values[i]));
        }
        this.dataset.set(this.getIndexOfDataSeries(legend, beginindex), valuesList);
    }

    public void removeDataSeries(int index) {
        this.legendset.remove(index);
        this.dataset.remove(index);
    }

    public void removeDataSeries(String legend, int beginindex) {
        int index = this.getIndexOfDataSeries(legend, beginindex);
        this.removeDataSeries(index);
    }

    public int getIndexOfDataSeries(String legend, int beginindex) {
        return this.legendset.indexOf(legend, beginindex);
    }

    public String getLegendByIndex(int index) {
        return this.legendset.get(index);
    }

    public void setLegendByIndex(int index, String legend) {
        this.legendset.set(index, legend);
    }

    public String getLabelByIndex(int index) {
        return this.labelset.get(index);
    }

    public void setLabelByIndex(int index, String label) {
        this.labelset.set(index, label);
    }

    public String[] getLabels() {
        return this.labelset.toArray(new String[1]);
    }

    public String[] getLegends() {
        return this.legendset.toArray(new String[1]);
    }

    public boolean isFirstRowAsLabel() {
        return this.bFirstRowAsLabel;
    }

    public boolean isFirstColumnAsLabel() {
        return this.bFirstColumnAsLabel;
    }

    public boolean isRowAsDataSeries() {
        return this.bRowAsDataSeries;
    }

    public boolean isLocalTable() {
        return this.isLocalTable;
    }

    public void setLocalTable(boolean isLocalTable) {
        this.isLocalTable = isLocalTable;
    }

    public double[] getDataSeriesByIndex(int index) {
        Vector<Double> values = this.dataset.elementAt(index);
        double[] doubleArray = new double[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            doubleArray[i] = values.get(i);
        }
        return doubleArray;
    }

    public double[] getDataSeriesByLegend(String legend, int beginindex) {
        Vector<Double> values = this.dataset.elementAt(this.getIndexOfDataSeries(legend, beginindex));
        double[] doubleArray = new double[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            doubleArray[i] = values.get(i);
        }
        return doubleArray;
    }

    public Double[][] getLocalTableData() {
        int seriescount = this.legendset.size();
        int itemcount = this.labelset.size();
        Double[][] doubleArray = this.bRowAsDataSeries ? new Double[seriescount][itemcount] : new Double[itemcount][seriescount];
        for (int i = 0; i < seriescount; ++i) {
            Vector<Double> values = this.dataset.elementAt(i);
            for (int j = 0; j < itemcount; ++j) {
                if (this.bRowAsDataSeries) {
                    doubleArray[i][j] = values.get(j);
                    continue;
                }
                doubleArray[j][i] = values.get(j);
            }
        }
        return doubleArray;
    }

    public String[] getLocalTableFirstRow() {
        if (this.bRowAsDataSeries) {
            return this.labelset.toArray(new String[1]);
        }
        return this.legendset.toArray(new String[1]);
    }

    public String[] getLocalTableFirstColumn() {
        if (this.bRowAsDataSeries) {
            return this.legendset.toArray(new String[1]);
        }
        return this.labelset.toArray(new String[1]);
    }

    public int getLengthOfDataSeries(int index) {
        Vector<Double> values = this.dataset.elementAt(index);
        int length = values.size();
        for (int i = values.size() - 1; i >= 0; --i) {
            if (values.elementAt(i) != null) continue;
            --length;
        }
        return length;
    }

    public int getLengthOfDataSeries(String legend, int beginindex) {
        int index = this.getIndexOfDataSeries(legend, beginindex);
        return this.getLengthOfDataSeries(index);
    }

    public int getMaxLengthOfDataSeries() {
        int max = 0;
        for (int i = 0; i < this.legendset.size(); ++i) {
            int length = this.getLengthOfDataSeries(i);
            if (max >= length) continue;
            max = length;
        }
        return max;
    }

    public int getDataSeriesCount() {
        return this.legendset.size();
    }

    public void setValues(String[] labels, String[] legends, double[][] data) {
        int i;
        this.isLocalTable = true;
        this.bFirstColumnAsLabel = true;
        this.bFirstRowAsLabel = true;
        this.bRowAsDataSeries = false;
        int seriescount = legends.length <= data.length ? legends.length : data.length;
        int itemcount = labels.length <= data[0].length ? labels.length : data[0].length;
        for (i = 0; i < seriescount; ++i) {
            if (i < legends.length) {
                this.legendset.add(legends[i]);
            } else {
                this.legendset.add("" + (i + 1));
            }
            Vector<Double> series = new Vector<Double>();
            for (int j = 0; j < itemcount; ++j) {
                if (i < data.length && j < data[0].length) {
                    series.add(new Double(data[i][j]));
                    continue;
                }
                series.add(null);
            }
            this.dataset.add(series);
        }
        for (i = 0; i < itemcount; ++i) {
            if (i < labels.length) {
                this.labelset.add(labels[i]);
                continue;
            }
            this.labelset.add("");
        }
    }

    public void setValues(CellRangeAddressList cellRangeAddress, SpreadsheetDocument spreadsheet, boolean bFirstRowAsLabel, boolean bFirstColumnAsLabel, boolean rowAsDataSeries) {
        this.isLocalTable = false;
        this.bFirstColumnAsLabel = bFirstColumnAsLabel;
        this.bFirstRowAsLabel = bFirstRowAsLabel;
        this.bRowAsDataSeries = rowAsDataSeries;
        this.cellRangeAddress = cellRangeAddress;
        String cellrange = ((CellRangeAddress)cellRangeAddress.getCellRangesAddressList().get(0)).toString();
        StringTokenizer st = new StringTokenizer(cellrange, ".:$ ");
        if (st.countTokens() < 3) {
            return;
        }
        String sheettable = st.nextToken();
        String begincell = st.nextToken();
        String endcell = st.nextToken();
        if (st.hasMoreTokens()) {
            endcell = st.nextToken();
        }
        char beginColumn = begincell.charAt(0);
        char endColumn = endcell.charAt(0);
        int beginRow = Integer.parseInt(begincell.substring(1));
        int endRow = Integer.parseInt(endcell.substring(1));
        this.dataset = new Vector();
        Vector<String> rowLabels = new Vector<String>();
        Vector<String> columnLabels = new Vector<String>();
        try {
            int i = 0;
            OdfContentDom sheetContent = spreadsheet.getContentDom();
            NodeList tableList = sheetContent.getElementsByTagNameNS(OdfNamespace.newNamespace((NamespaceName)OdfDocumentNamespace.TABLE).toString(), "table");
            while (!sheettable.equals(((TableTableElement)tableList.item(i)).getTableNameAttribute())) {
                ++i;
            }
            TableTableElement table = (TableTableElement)tableList.item(i);
            NodeList rowList = table.getElementsByTagNameNS(OdfNamespace.newNamespace((NamespaceName)OdfDocumentNamespace.TABLE).toString(), "table-row");
            for (i = beginRow; i <= endRow; ++i) {
                int rowindex = bFirstRowAsLabel ? i - beginRow - 1 : i - beginRow;
                TableTableRowElement td = (TableTableRowElement)rowList.item(i - 1);
                NodeList cellList = td.getElementsByTagNameNS(OdfNamespace.newNamespace((NamespaceName)OdfDocumentNamespace.TABLE).toString(), "table-cell");
                HashMap<Integer, TableTableCellElement> cellIndexMap = new HashMap<Integer, TableTableCellElement>();
                int index = 0;
                for (int cellNum = 0; cellNum < cellList.getLength() && index <= endColumn - 65; ++cellNum) {
                    TableTableCellElement item = (TableTableCellElement)cellList.item(cellNum);
                    int repeatedCount = item.getTableNumberColumnsRepeatedAttribute() * item.getTableNumberColumnsSpannedAttribute();
                    int tmpIndex = index + repeatedCount;
                    if (tmpIndex >= beginColumn - 65) {
                        if (beginColumn - 65 > index) {
                            index = beginColumn - 65;
                        }
                        for (int ii = index; ii < tmpIndex; ++ii) {
                            cellIndexMap.put(ii, item);
                        }
                    }
                    index = tmpIndex;
                }
                for (char ch = beginColumn; ch <= endColumn; ch = (char)(ch + '\u0001')) {
                    double value;
                    Vector<Object> series;
                    int columnindex = bFirstColumnAsLabel ? ch - beginColumn - 1 : ch - beginColumn;
                    TableTableCellElement cell = (TableTableCellElement)cellIndexMap.get(ch - 65);
                    if (bFirstRowAsLabel && i == beginRow) {
                        if (bFirstColumnAsLabel && ch == beginColumn) continue;
                        if (cell.getFirstChild() != null) {
                            rowLabels.add(cell.getFirstChild().getTextContent());
                            continue;
                        }
                        rowLabels.add("Column " + ch);
                        continue;
                    }
                    if (bFirstColumnAsLabel && ch == beginColumn) {
                        if (bFirstRowAsLabel && i == beginRow) continue;
                        if (cell.getFirstChild() != null) {
                            columnLabels.add(cell.getFirstChild().getTextContent());
                            continue;
                        }
                        columnLabels.add("Row " + i);
                        continue;
                    }
                    if (!(i != beginRow || bFirstColumnAsLabel && ch == beginColumn)) {
                        rowLabels.add("Column " + ch);
                    }
                    if (!(ch != beginColumn || bFirstRowAsLabel && i == beginRow)) {
                        columnLabels.add("Row " + i);
                    }
                    if (rowAsDataSeries) {
                        if (rowindex < this.dataset.size()) {
                            series = this.dataset.get(rowindex);
                        } else {
                            series = new Vector();
                            this.dataset.add(series);
                        }
                        try {
                            value = cell.getOfficeValueAttribute();
                            series.add(new Double(value));
                        }
                        catch (Exception e) {
                            series.add(null);
                        }
                        continue;
                    }
                    if (columnindex < this.dataset.size()) {
                        series = this.dataset.get(columnindex);
                    } else {
                        series = new Vector();
                        this.dataset.add(series);
                    }
                    try {
                        value = cell.getOfficeValueAttribute();
                        series.add(new Double(value));
                        continue;
                    }
                    catch (Exception e) {
                        series.add(null);
                    }
                }
            }
            if (rowAsDataSeries) {
                this.labelset = rowLabels;
                this.legendset = columnLabels;
            } else {
                this.labelset = columnLabels;
                this.legendset = rowLabels;
            }
        }
        catch (Exception e) {
            Logger.getLogger(DataSet.class.getName()).log(Level.SEVERE, e.getMessage(), e);
        }
    }

    String getCellRanges(String tablecellrange, boolean bFirstRowAsLabel, boolean bFirstColumnAsLabel, boolean rowAsDataSeries, Vector<String> seriesCellRange, Vector<String> legendCellAddr) {
        String labelCellRange = null;
        if (seriesCellRange == null) {
            seriesCellRange = new Vector();
        } else {
            seriesCellRange.removeAllElements();
        }
        if (legendCellAddr == null) {
            legendCellAddr = new Vector();
        } else {
            legendCellAddr.removeAllElements();
        }
        StringTokenizer st = new StringTokenizer(tablecellrange, ".:$ ");
        if (st.countTokens() < 3) {
            return null;
        }
        String sheettable = st.nextToken();
        String begincell = st.nextToken();
        String endcell = st.nextToken();
        if (st.hasMoreTokens()) {
            endcell = st.nextToken();
        }
        char beginColumn = begincell.charAt(0);
        char endColumn = endcell.charAt(0);
        int beginRow = Integer.parseInt(begincell.substring(1));
        int endRow = Integer.parseInt(endcell.substring(1));
        if (rowAsDataSeries) {
            int starti = beginRow + 1;
            if (!bFirstRowAsLabel) {
                labelCellRange = null;
                starti = beginRow;
            } else {
                labelCellRange = bFirstColumnAsLabel ? this.createCellRange(sheettable, beginRow, (char)(beginColumn + '\u0001'), beginRow, endColumn) : this.createCellRange(sheettable, beginRow, beginColumn, beginRow, endColumn);
            }
            for (int i = starti; i < endRow + 1; ++i) {
                if (bFirstColumnAsLabel) {
                    seriesCellRange.add(this.createCellRange(sheettable, i, (char)(beginColumn + '\u0001'), i, endColumn));
                } else {
                    seriesCellRange.add(this.createCellRange(sheettable, i, beginColumn, i, endColumn));
                }
                if (bFirstColumnAsLabel) {
                    legendCellAddr.add(sheettable + "." + beginColumn + i);
                    continue;
                }
                legendCellAddr.add(null);
            }
        } else {
            char startch = (char)(beginColumn + '\u0001');
            if (!bFirstColumnAsLabel) {
                labelCellRange = null;
                startch = beginColumn;
            } else {
                labelCellRange = bFirstRowAsLabel ? this.createCellRange(sheettable, beginRow + 1, beginColumn, endRow, beginColumn) : this.createCellRange(sheettable, beginRow, beginColumn, endRow, beginColumn);
            }
            for (char ch = startch; ch <= endColumn; ch = (char)(ch + '\u0001')) {
                if (bFirstRowAsLabel) {
                    seriesCellRange.add(this.createCellRange(sheettable, beginRow + 1, ch, endRow, ch));
                } else {
                    seriesCellRange.add(this.createCellRange(sheettable, beginRow, ch, endRow, ch));
                }
                if (bFirstRowAsLabel) {
                    legendCellAddr.add(sheettable + "." + ch + beginRow);
                    continue;
                }
                legendCellAddr.add(null);
            }
        }
        return labelCellRange;
    }

    private String createCellRange(String table, int beginRow, char beginColumn, int endRow, char endColumn) {
        return table + "." + beginColumn + beginRow + ":" + table + "." + endColumn + endRow;
    }
}

