/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.preferences;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.security.KeyStoreException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.directory.api.util.FileUtils;
import org.apache.directory.studio.common.ui.CommonUIUtils;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionManager;
import org.apache.directory.studio.connection.core.PasswordsKeyStoreManager;
import org.apache.directory.studio.connection.ui.ConnectionUIConstants;
import org.apache.directory.studio.connection.ui.ConnectionUIPlugin;
import org.apache.directory.studio.connection.ui.dialogs.PasswordDialog;
import org.apache.directory.studio.connection.ui.dialogs.ResetPasswordDialog;
import org.apache.directory.studio.connection.ui.dialogs.SetupPasswordDialog;
import org.apache.directory.studio.connection.ui.preferences.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PasswordsKeystorePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String TEMPORARY_KEYSTORE_FILENAME = "passwords-prefs-temp.jks";
    private PasswordsKeyStoreManager passwordsKeyStoreManager;
    private Map<String, String> connectionsPasswordsBackup = new ConcurrentHashMap<String, String>();
    private ConnectionManager connectionManager;
    private Button enableKeystoreCheckbox;
    private Button changeMasterPasswordButton;
    private SelectionListener enableKeystoreCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            Boolean selected = PasswordsKeystorePreferencePage.this.enableKeystoreCheckbox.getSelection();
            try {
                if (selected.booleanValue()) {
                    if (!PasswordsKeystorePreferencePage.this.enablePasswordsKeystore()) {
                        PasswordsKeystorePreferencePage.this.enableKeystoreCheckbox.setSelection(selected == false);
                    }
                } else if (!PasswordsKeystorePreferencePage.this.disablePasswordsKeystore()) {
                    PasswordsKeystorePreferencePage.this.enableKeystoreCheckbox.setSelection(selected == false);
                }
            }
            catch (KeyStoreException kse) {
                CommonUIUtils.openErrorDialog((String)(String.valueOf(Messages.getString("PasswordsKeystorePreferencePage.AnErrorOccurredWhenEnablingDisablingTheKeystore")) + kse.getMessage()));
                PasswordsKeystorePreferencePage.this.enableKeystoreCheckbox.setSelection(selected == false);
            }
            PasswordsKeystorePreferencePage.this.updateButtonsEnabledState();
        }
    };
    private SelectionListener changeMasterPasswordButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            PasswordsKeystorePreferencePage.this.changeMasterPassword();
        }
    };

    public PasswordsKeystorePreferencePage() {
        super(Messages.getString("PasswordsKeystorePreferencePage.PasswordsKeystore"));
        super.setDescription(Messages.getString("PasswordsKeystorePreferencePage.GeneralSettingsForPasswordsKeystore"));
        super.noDefaultAndApplyButton();
        this.passwordsKeyStoreManager = new PasswordsKeyStoreManager(TEMPORARY_KEYSTORE_FILENAME);
        this.connectionManager = ConnectionCorePlugin.getDefault().getConnectionManager();
    }

    public void init(IWorkbench workbench) {
        File keystoreFile = ConnectionCorePlugin.getDefault().getPasswordsKeyStoreManager().getKeyStoreFile();
        if (keystoreFile.exists()) {
            try {
                Files.copy(keystoreFile.toPath(), this.getTemporaryKeystoreFile().toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                ConnectionUIPlugin.getDefault().getLog().log((IStatus)new Status(4, ConnectionUIConstants.PLUGIN_ID, 4, "Couldn't duplicate the global keystore file.", (Throwable)e));
            }
        }
    }

    private File getTemporaryKeystoreFile() {
        return ConnectionCorePlugin.getDefault().getStateLocation().append(TEMPORARY_KEYSTORE_FILENAME).toFile();
    }

    protected void contributeButtons(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        this.changeMasterPasswordButton = BaseWidgetUtils.createButton((Composite)parent, (String)Messages.getString("PasswordsKeystorePreferencePage.ChangeMasterPasswordEllipsis"), (int)1);
        this.changeMasterPasswordButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.changeMasterPasswordButton.addSelectionListener(this.changeMasterPasswordButtonListener);
        this.updateButtonsEnabledState();
    }

    protected Control createContents(Composite parent) {
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)2, (int)1);
        this.enableKeystoreCheckbox = new Button(composite, 96);
        this.enableKeystoreCheckbox.setText(Messages.getString("PasswordsKeystorePreferencePage.StoreConnectionsPasswordsInPasswordProtectedKeystore"));
        this.enableKeystoreCheckbox.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        BaseWidgetUtils.createRadioIndent((Composite)composite, (int)1);
        BaseWidgetUtils.createWrappedLabel((Composite)composite, (String)Messages.getString("PasswordsKeystorePreferencePage.WarningPasswordsKeystoreRequiresMasterPassword"), (int)1);
        this.initUI();
        this.addListeners();
        return composite;
    }

    private void initUI() {
        int connectionsPasswordsKeystore = ConnectionCorePlugin.getDefault().getPluginPreferences().getInt("connectionsPasswordsKeystore");
        if (connectionsPasswordsKeystore == 0) {
            this.enableKeystoreCheckbox.setSelection(false);
        } else if (connectionsPasswordsKeystore == 1) {
            this.enableKeystoreCheckbox.setSelection(true);
        }
    }

    private void addListeners() {
        this.enableKeystoreCheckbox.addSelectionListener(this.enableKeystoreCheckboxListener);
    }

    private void removeListeners() {
        this.enableKeystoreCheckbox.removeSelectionListener(this.enableKeystoreCheckboxListener);
    }

    private void updateButtonsEnabledState() {
        this.changeMasterPasswordButton.setEnabled(this.enableKeystoreCheckbox.getSelection());
    }

    protected void performDefaults() {
        this.removeListeners();
        int enablePasswordsKeystore = ConnectionCorePlugin.getDefault().getPluginPreferences().getDefaultInt("connectionsPasswordsKeystore");
        if (enablePasswordsKeystore == 0) {
            this.enableKeystoreCheckbox.setSelection(false);
        } else if (enablePasswordsKeystore == 1) {
            this.enableKeystoreCheckbox.setSelection(true);
        }
        this.updateButtonsEnabledState();
        this.addListeners();
        ConnectionCorePlugin.getDefault().savePluginPreferences();
        super.performDefaults();
    }

    public boolean performOk() {
        PasswordsKeyStoreManager globalPasswordsKeyStoreManager = ConnectionCorePlugin.getDefault().getPasswordsKeyStoreManager();
        if (this.enableKeystoreCheckbox.getSelection()) {
            if (this.passwordsKeyStoreManager.isLoaded()) {
                try {
                    this.passwordsKeyStoreManager.save();
                }
                catch (KeyStoreException e) {
                    ConnectionUIPlugin.getDefault().getLog().log((IStatus)new Status(4, ConnectionUIConstants.PLUGIN_ID, 4, "Couldn't save the temporary password keystore.", (Throwable)e));
                }
                try {
                    Files.copy(this.getTemporaryKeystoreFile().toPath(), ConnectionCorePlugin.getDefault().getPasswordsKeyStoreManager().getKeyStoreFile().toPath(), new CopyOption[0]);
                }
                catch (IOException e) {
                    ConnectionUIPlugin.getDefault().getLog().log((IStatus)new Status(4, ConnectionUIConstants.PLUGIN_ID, 4, "Couldn't copy the temporary keystore as the global keystore.", (Throwable)e));
                }
                try {
                    globalPasswordsKeyStoreManager.reload(this.passwordsKeyStoreManager.getMasterPassword());
                }
                catch (KeyStoreException e) {
                    ConnectionUIPlugin.getDefault().getLog().log((IStatus)new Status(4, ConnectionUIConstants.PLUGIN_ID, 4, "Couldn't reload the global keystore file.", (Throwable)e));
                }
                Connection[] connectionArray = this.connectionManager.getConnections();
                int n = connectionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Connection connection = connectionArray[n2];
                    connection.getConnectionParameter().setBindPassword(null);
                    ++n2;
                }
                ConnectionCorePlugin.getDefault().getConnectionManager().saveConnections();
                ConnectionCorePlugin.getDefault().getPluginPreferences().setValue("connectionsPasswordsKeystore", 1);
            }
        } else {
            globalPasswordsKeyStoreManager.reset();
            if (!this.connectionsPasswordsBackup.isEmpty()) {
                for (Map.Entry<String, String> entry : this.connectionsPasswordsBackup.entrySet()) {
                    Connection connection = this.connectionManager.getConnectionById(entry.getKey());
                    if (connection == null) continue;
                    connection.getConnectionParameter().setBindPassword(entry.getValue());
                }
                ConnectionCorePlugin.getDefault().getConnectionManager().saveConnections();
            }
            ConnectionCorePlugin.getDefault().getPluginPreferences().setValue("connectionsPasswordsKeystore", 0);
        }
        ConnectionCorePlugin.getDefault().savePluginPreferences();
        this.deleteTemporaryKeystore();
        return true;
    }

    public boolean performCancel() {
        this.deleteTemporaryKeystore();
        return true;
    }

    private void deleteTemporaryKeystore() {
        File temporaryKeystoreFile = this.getTemporaryKeystoreFile();
        if (temporaryKeystoreFile.exists()) {
            FileUtils.deleteQuietly((File)temporaryKeystoreFile);
        }
    }

    private boolean enablePasswordsKeystore() throws KeyStoreException {
        SetupPasswordDialog setupPasswordDialog = new SetupPasswordDialog(this.enableKeystoreCheckbox.getShell(), Messages.getString("PasswordsKeystorePreferencePage.SetupMasterPassword"), Messages.getString("PasswordsKeystorePreferencePage.PleaseEnterMasterPasswordToSecurePasswordsKeystore"), null);
        if (setupPasswordDialog.open() == 0) {
            String masterPassword = setupPasswordDialog.getPassword();
            this.passwordsKeyStoreManager.load(masterPassword);
            Connection[] connectionArray = this.connectionManager.getConnections();
            int n = connectionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Connection connection = connectionArray[n2];
                String connectionPassword = connection.getBindPassword();
                if (connectionPassword != null) {
                    this.passwordsKeyStoreManager.storeConnectionPassword(connection, connectionPassword, false);
                }
                ++n2;
            }
            this.passwordsKeyStoreManager.save();
            return true;
        }
        return false;
    }

    private boolean disablePasswordsKeystore() {
        MessageDialog keepConnectionsPasswordsDialog = new MessageDialog(this.enableKeystoreCheckbox.getShell(), Messages.getString("PasswordsKeystorePreferencePage.KeepConnectionsPasswords"), null, Messages.getString("PasswordsKeystorePreferencePage.DoYouWantToKeepYourConnectionsPasswords"), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        int keepConnectionsPasswordsValue = keepConnectionsPasswordsDialog.open();
        if (keepConnectionsPasswordsValue == 1) {
            this.connectionsPasswordsBackup.clear();
            this.passwordsKeyStoreManager.deleteKeystoreFile();
            return true;
        }
        if (keepConnectionsPasswordsValue == 0) {
            block10: {
                String message;
                MessageDialog errorDialog;
                this.connectionsPasswordsBackup.clear();
                do {
                    KeyStoreException checkPasswordException;
                    block9: {
                        PasswordDialog passwordDialog;
                        if ((passwordDialog = new PasswordDialog(this.enableKeystoreCheckbox.getShell(), Messages.getString("PasswordsKeystorePreferencePage.VerifyMasterPassword"), Messages.getString("PasswordsKeystorePreferencePage.PleaseEnterYourMasterPassword"), null)).open() == 1) {
                            return false;
                        }
                        String password = passwordDialog.getPassword();
                        checkPasswordException = null;
                        try {
                            if (!this.passwordsKeyStoreManager.checkMasterPassword(password)) break block9;
                            break block10;
                        }
                        catch (KeyStoreException e) {
                            checkPasswordException = e;
                        }
                    }
                    message = null;
                    message = checkPasswordException == null ? Messages.getString("PasswordsKeystorePreferencePage.MasterPasswordVerificationFailed") : String.valueOf(Messages.getString("PasswordsKeystorePreferencePage.MasterPasswordVerificationFailedWithException")) + checkPasswordException.getMessage();
                } while ((errorDialog = new MessageDialog(this.enableKeystoreCheckbox.getShell(), Messages.getString("PasswordsKeystorePreferencePage.VerifyMasterPasswordFailed"), null, message, 1, new String[]{IDialogConstants.RETRY_LABEL, IDialogConstants.CANCEL_LABEL}, 0)).open() != 1);
                return false;
            }
            String[] connectionIds = this.passwordsKeyStoreManager.getConnectionIds();
            if (connectionIds != null) {
                String[] stringArray = connectionIds;
                int n = connectionIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String connectionId = stringArray[n2];
                    String password = this.passwordsKeyStoreManager.getConnectionPassword(connectionId);
                    if (password != null) {
                        this.connectionsPasswordsBackup.put(connectionId, password);
                    }
                    ++n2;
                }
            }
            this.passwordsKeyStoreManager.deleteKeystoreFile();
            return true;
        }
        return false;
    }

    private void changeMasterPassword() {
        String newMasterPassword;
        block8: {
            String message;
            MessageDialog errorDialog;
            newMasterPassword = null;
            do {
                KeyStoreException checkPasswordException;
                block7: {
                    ResetPasswordDialog resetPasswordDialog;
                    if ((resetPasswordDialog = new ResetPasswordDialog(this.changeMasterPasswordButton.getShell(), "", null, null)).open() != 0) {
                        return;
                    }
                    checkPasswordException = null;
                    try {
                        if (!this.passwordsKeyStoreManager.checkMasterPassword(resetPasswordDialog.getCurrentPassword())) break block7;
                        newMasterPassword = resetPasswordDialog.getNewPassword();
                        break block8;
                    }
                    catch (KeyStoreException e) {
                        checkPasswordException = e;
                    }
                }
                message = null;
                message = checkPasswordException == null ? Messages.getString("PasswordsKeystorePreferencePage.MasterPasswordVerificationFailed") : String.valueOf(Messages.getString("PasswordsKeystorePreferencePage.MasterPasswordVerificationFailedWithException")) + checkPasswordException.getMessage();
            } while ((errorDialog = new MessageDialog(this.enableKeystoreCheckbox.getShell(), Messages.getString("PasswordsKeystorePreferencePage.VerifyMasterPasswordFailed"), null, message, 1, new String[]{IDialogConstants.RETRY_LABEL, IDialogConstants.CANCEL_LABEL}, 0)).open() != 1);
            return;
        }
        if (newMasterPassword != null) {
            try {
                this.passwordsKeyStoreManager.setMasterPassword(newMasterPassword);
                this.passwordsKeyStoreManager.save();
            }
            catch (KeyStoreException e) {
                ConnectionUIPlugin.getDefault().getLog().log((IStatus)new Status(4, ConnectionUIConstants.PLUGIN_ID, 4, "Couldn't save the keystore file.", (Throwable)e));
            }
        }
    }
}

