/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;

public class DirectionFilterActionGroup
extends ActionGroup
implements IPropertyChangeListener {
    private List actions = new ArrayList(3);
    private DirectionFilterAction incomingMode;
    private DirectionFilterAction outgoingMode;
    private DirectionFilterAction bothMode;
    private DirectionFilterAction conflictsMode;
    private ISynchronizePageConfiguration configuration;

    public DirectionFilterActionGroup(ISynchronizePageConfiguration configuration) {
        this.configuration = configuration;
        this.createActions();
        configuration.addPropertyChangeListener(this);
        this.checkMode(configuration.getMode());
    }

    private void createActions() {
        int supportedModes = this.configuration.getSupportedModes();
        if (supportedModes == 0) {
            return;
        }
        int currentMode = this.configuration.getMode();
        if ((supportedModes & currentMode) == 0) {
            currentMode = this.getSupportedMode(supportedModes);
            if (currentMode == 0) {
                return;
            }
            this.configuration.setMode(currentMode);
        }
        if ((supportedModes & 1) != 0) {
            this.incomingMode = new DirectionFilterAction("action.directionFilterIncoming.", "org.eclipse.team.ui.syncview.incomingFilter", 1);
            this.actions.add(this.incomingMode);
            this.incomingMode.setChecked(currentMode == 1);
        }
        if ((supportedModes & 2) != 0) {
            this.outgoingMode = new DirectionFilterAction("action.directionFilterOutgoing.", "org.eclipse.team.ui.syncview.outgoingFilter", 2);
            this.actions.add(this.outgoingMode);
            this.outgoingMode.setChecked(currentMode == 2);
        }
        if ((supportedModes & 4) != 0) {
            this.bothMode = new DirectionFilterAction("action.directionFilterBoth.", "org.eclipse.team.ui.syncview.bothFilter", 4);
            this.actions.add(this.bothMode);
            this.bothMode.setChecked(currentMode == 4);
        }
        if ((supportedModes & 8) != 0) {
            this.conflictsMode = new DirectionFilterAction("action.directionFilterConflicts.", "org.eclipse.team.ui.syncview.conflictsFilter", 8);
            this.actions.add(this.conflictsMode);
            this.conflictsMode.setChecked(currentMode == 8);
        }
    }

    private int getSupportedMode(int supportedModes) {
        if ((supportedModes & 1) != 0) {
            return 1;
        }
        if ((supportedModes & 2) != 0) {
            return 2;
        }
        if ((supportedModes & 4) != 0) {
            return 4;
        }
        if ((supportedModes & 8) != 0) {
            return 8;
        }
        return 0;
    }

    public void fillActionBars(IActionBars actionBars, String group) {
        super.fillActionBars(actionBars);
        IToolBarManager toolBar = actionBars.getToolBarManager();
        for (Object action2 : this.actions) {
            DirectionFilterAction action = (DirectionFilterAction)((Object)action2);
            if (group != null) {
                toolBar.appendToGroup(group, (IAction)action);
                continue;
            }
            toolBar.add((IAction)action);
        }
    }

    public void fillToolBar(String groupId, IToolBarManager toolBar) {
        for (Object action2 : this.actions) {
            DirectionFilterAction action = (DirectionFilterAction)((Object)action2);
            toolBar.appendToGroup(groupId, (IAction)action);
        }
    }

    public void fillMenu(IContributionManager manager) {
        for (Object action2 : this.actions) {
            DirectionFilterAction action = (DirectionFilterAction)((Object)action2);
            manager.add((IAction)action);
        }
    }

    private void checkMode(int mode) {
        for (Object action2 : this.actions) {
            DirectionFilterAction action = (DirectionFilterAction)((Object)action2);
            if (action.getModeId() == mode) {
                action.setChecked(true);
                continue;
            }
            action.setChecked(false);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.team.ui.P_SYNCVIEWPAGE_MODE")) {
            Integer mode = (Integer)event.getNewValue();
            this.checkMode(mode);
        }
    }

    public void dispose() {
        super.dispose();
    }

    class DirectionFilterAction
    extends Action {
        private int modeId;

        public DirectionFilterAction(String prefix, String commandId, int modeId) {
            super("", 8);
            this.modeId = modeId;
            Utils.initAction((IAction)this, prefix);
        }

        public void run() {
            if (this.isChecked()) {
                DirectionFilterActionGroup.this.configuration.setMode(this.modeId);
            }
        }

        public int getModeId() {
            return this.modeId;
        }
    }
}

