/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.model.io;

import java.util.List;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.schemaeditor.model.Project;
import org.apache.directory.studio.schemaeditor.model.ProjectType;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.io.SchemaConnector;
import org.apache.directory.studio.schemaeditor.model.io.XMLSchemaFileExporter;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ProjectsExporter {
    private static final String PROJECT_TAG = "project";
    private static final String PROJECTS_TAG = "projects";
    private static final String NAME_TAG = "name";
    private static final String TYPE_TAG = "type";
    private static final String CONNECTION_TAG = "connection";
    private static final String SCHEMA_CONNECTOR_TAG = "schemaConnector";
    private static final String SCHEMA_BACKUP_TAG = "schemaBackup";

    public static Document toDocument(Project project) {
        Document document = DocumentHelper.createDocument();
        ProjectsExporter.addProject(project, (Branch)document);
        return document;
    }

    public static Document toDocument(Project[] projects) {
        Document document = DocumentHelper.createDocument();
        Element projectsElement = document.addElement(PROJECTS_TAG);
        if (projects != null) {
            Project[] projectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                Project project = projectArray[n2];
                ProjectsExporter.addProject(project, (Branch)projectsElement);
                ++n2;
            }
        }
        return document;
    }

    private static void addProject(Project project, Branch branch) {
        Element element = branch.addElement(PROJECT_TAG);
        if (project != null) {
            ProjectType type;
            String name = project.getName();
            if (name != null && !name.equals("")) {
                element.addAttribute(NAME_TAG, name);
            }
            if ((type = project.getType()) != null) {
                element.addAttribute(TYPE_TAG, type.toString());
            }
            if (type.equals((Object)ProjectType.ONLINE)) {
                SchemaConnector schemaConnector;
                Connection connection = project.getConnection();
                if (connection != null) {
                    element.addAttribute(CONNECTION_TAG, connection.getId());
                }
                if ((schemaConnector = project.getSchemaConnector()) != null) {
                    element.addAttribute(SCHEMA_CONNECTOR_TAG, project.getSchemaConnector().getId());
                }
                Element schemaBackupElement = element.addElement(SCHEMA_BACKUP_TAG);
                List<Schema> backupSchemas = project.getInitialSchema();
                if (backupSchemas != null) {
                    XMLSchemaFileExporter.addSchemas(backupSchemas.toArray(new Schema[0]), (Branch)schemaBackupElement);
                }
            }
            XMLSchemaFileExporter.addSchemas(project.getSchemaHandler().getSchemas().toArray(new Schema[0]), (Branch)element);
        }
    }
}

