/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.model.Project;
import org.apache.directory.studio.schemaeditor.view.wrappers.ProjectSorter;
import org.apache.directory.studio.schemaeditor.view.wrappers.ProjectWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.ProjectsViewRoot;
import org.apache.directory.studio.schemaeditor.view.wrappers.TreeNode;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

public class ProjectsViewContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    private TableViewer tableViewer;
    private ProjectSorter projectSorter;

    public ProjectsViewContentProvider(TableViewer tableViewer) {
        this.tableViewer = tableViewer;
        this.projectSorter = new ProjectSorter();
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getChildren(Object parentElement) {
        List<Object> children = new ArrayList();
        if (parentElement instanceof ProjectsViewRoot) {
            ProjectsViewRoot projectsViewRoot = (ProjectsViewRoot)parentElement;
            if (!projectsViewRoot.hasChildren()) {
                for (Project project : Activator.getDefault().getProjectsHandler().getProjects()) {
                    projectsViewRoot.addChild(new ProjectWrapper(project, this.tableViewer));
                }
            }
            children = projectsViewRoot.getChildren();
            Collections.sort(children, this.projectSorter);
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof TreeNode) {
            return ((TreeNode)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TreeNode) {
            return ((TreeNode)element).hasChildren();
        }
        return false;
    }
}

