/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.wizards;

import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.model.DependenciesComputer;
import org.apache.directory.studio.schemaeditor.model.Project;
import org.apache.directory.studio.schemaeditor.view.wizards.CommitChangesDifferencesWizardPage;
import org.apache.directory.studio.schemaeditor.view.wizards.CommitChangesInformationWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class CommitChangesWizard
extends Wizard
implements IExportWizard {
    private boolean schemaContainsErrors = false;
    private Project project;
    private DependenciesComputer dependenciesComputer;
    private CommitChangesInformationWizardPage commitChangesInformation;
    private CommitChangesDifferencesWizardPage commitChangesDifferences;

    public void addPages() {
        this.commitChangesInformation = new CommitChangesInformationWizardPage();
        this.commitChangesDifferences = new CommitChangesDifferencesWizardPage();
        this.addPage((IWizardPage)this.commitChangesInformation);
        this.addPage((IWizardPage)this.commitChangesDifferences);
    }

    public boolean performFinish() {
        return true;
    }

    public boolean canFinish() {
        if (this.schemaContainsErrors) {
            return false;
        }
        return this.getContainer().getCurrentPage() instanceof CommitChangesDifferencesWizardPage;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setNeedsProgressMonitor(true);
        this.project = Activator.getDefault().getProjectsHandler().getOpenProject();
        try {
            this.dependenciesComputer = new DependenciesComputer(this.project.getSchemaHandler().getSchemas());
        }
        catch (DependenciesComputer.DependencyComputerException dependencyComputerException) {
            this.schemaContainsErrors = true;
        }
    }

    public boolean isSchemaContainsErrors() {
        return this.schemaContainsErrors;
    }

    public DependenciesComputer getDependenciesComputer() {
        return this.dependenciesComputer;
    }
}

