/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.model.Project;
import org.apache.directory.studio.schemaeditor.model.ProjectType;
import org.apache.directory.studio.schemaeditor.view.wizards.AbstractWizardPage;
import org.apache.directory.studio.schemaeditor.view.wizards.Messages;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ExportProjectsWizardPage
extends AbstractWizardPage {
    private Project[] selectedProjects = new Project[0];
    private CheckboxTableViewer projectsTableViewer;
    private Button projectsTableSelectAllButton;
    private Button projectsTableDeselectAllButton;
    private Label exportDirectoryLabel;
    private Text exportDirectoryText;
    private Button exportDirectoryButton;

    protected ExportProjectsWizardPage() {
        super("ExportProjectsWizardPage");
        this.setTitle(Messages.getString("ExportProjectsWizardPage.ExportSchemaProjects"));
        this.setDescription(Messages.getString("ExportProjectsWizardPage.PleaseSelectSchemaProjects"));
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("resources/icons/project_export_wizard.png"));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        Group schemaProjectsGroup = new Group(composite, 0);
        schemaProjectsGroup.setText(Messages.getString("ExportProjectsWizardPage.SchemaProjects"));
        schemaProjectsGroup.setLayout((Layout)new GridLayout(2, false));
        schemaProjectsGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        Label projectsLabel = new Label((Composite)schemaProjectsGroup, 0);
        projectsLabel.setText(Messages.getString("ExportProjectsWizardPage.SelectSchemaProjects"));
        projectsLabel.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.projectsTableViewer = new CheckboxTableViewer(new Table((Composite)schemaProjectsGroup, 67616));
        GridData projectsTableViewerGridData = new GridData(4, 0, true, false, 1, 2);
        projectsTableViewerGridData.heightHint = 125;
        this.projectsTableViewer.getTable().setLayoutData((Object)projectsTableViewerGridData);
        this.projectsTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.projectsTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Project) {
                    return ((Project)element).getName();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof Project) {
                    ProjectType type = ((Project)element).getType();
                    switch (type) {
                        case OFFLINE: {
                            return Activator.getDefault().getImage("resources/icons/project_offline_closed.gif");
                        }
                        case ONLINE: {
                            return Activator.getDefault().getImage("resources/icons/project_online_closed.gif");
                        }
                    }
                }
                return super.getImage(element);
            }
        });
        this.projectsTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ExportProjectsWizardPage.this.dialogChanged();
            }
        });
        this.projectsTableSelectAllButton = new Button((Composite)schemaProjectsGroup, 8);
        this.projectsTableSelectAllButton.setText(Messages.getString("ExportProjectsWizardPage.SelectAll"));
        this.projectsTableSelectAllButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.projectsTableSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportProjectsWizardPage.this.projectsTableViewer.setAllChecked(true);
                ExportProjectsWizardPage.this.dialogChanged();
            }
        });
        this.projectsTableDeselectAllButton = new Button((Composite)schemaProjectsGroup, 8);
        this.projectsTableDeselectAllButton.setText(Messages.getString("ExportProjectsWizardPage.DeselectAll"));
        this.projectsTableDeselectAllButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.projectsTableDeselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportProjectsWizardPage.this.projectsTableViewer.setAllChecked(false);
                ExportProjectsWizardPage.this.dialogChanged();
            }
        });
        Group exportDestinationGroup = new Group(composite, 0);
        exportDestinationGroup.setText(Messages.getString("ExportProjectsWizardPage.ExportDestination"));
        exportDestinationGroup.setLayout((Layout)new GridLayout(3, false));
        exportDestinationGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        this.exportDirectoryLabel = new Label((Composite)exportDestinationGroup, 0);
        this.exportDirectoryLabel.setText(Messages.getString("ExportProjectsWizardPage.Directory"));
        this.exportDirectoryText = new Text((Composite)exportDestinationGroup, 2048);
        this.exportDirectoryText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.exportDirectoryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportProjectsWizardPage.this.dialogChanged();
            }
        });
        this.exportDirectoryButton = new Button((Composite)exportDestinationGroup, 8);
        this.exportDirectoryButton.setText(Messages.getString("ExportProjectsWizardPage.Browse"));
        this.exportDirectoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportProjectsWizardPage.this.chooseExportDirectory();
                ExportProjectsWizardPage.this.dialogChanged();
            }
        });
        this.initFields();
        this.setControl((Control)composite);
    }

    private void initFields() {
        ArrayList<Project> projects = new ArrayList<Project>();
        projects.addAll(Activator.getDefault().getProjectsHandler().getProjects());
        Collections.sort(projects, new Comparator<Project>(){

            @Override
            public int compare(Project o1, Project o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        this.projectsTableViewer.setInput(projects);
        this.projectsTableViewer.setCheckedElements((Object[])this.selectedProjects);
        this.displayErrorMessage(null);
        this.setPageComplete(false);
    }

    private void chooseExportDirectory() {
        DirectoryDialog dialog = new DirectoryDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        dialog.setText(Messages.getString("ExportProjectsWizardPage.ChooseFolder"));
        dialog.setMessage(Messages.getString("ExportProjectsWizardPage.SelectFolderToExportTo"));
        if ("".equals(this.exportDirectoryText.getText())) {
            dialog.setFilterPath(Activator.getDefault().getPreferenceStore().getString(PluginConstants.FILE_DIALOG_EXPORT_PROJECTS));
        } else {
            dialog.setFilterPath(this.exportDirectoryText.getText());
        }
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            this.exportDirectoryText.setText(selectedDirectory);
        }
    }

    private void dialogChanged() {
        if (this.projectsTableViewer.getCheckedElements().length == 0) {
            this.displayErrorMessage(Messages.getString("ExportProjectsWizardPage.ErrorNoSchemaSelected"));
            return;
        }
        String directory = this.exportDirectoryText.getText();
        if (directory == null || directory.equals("")) {
            this.displayErrorMessage(Messages.getString("ExportProjectsWizardPage.ErrorNoDirectorySelected"));
            return;
        }
        File directoryFile = new File(directory);
        if (!directoryFile.exists()) {
            this.displayErrorMessage(Messages.getString("ExportProjectsWizardPage.SelectedDirectoryNotExists"));
            return;
        }
        if (!directoryFile.isDirectory()) {
            this.displayErrorMessage(Messages.getString("ExportProjectsWizardPage.SelectedDirectoryNotDirectory"));
            return;
        }
        if (!directoryFile.canWrite()) {
            this.displayErrorMessage(Messages.getString("ExportProjectsWizardPage.SelectedDirectoryNotWritable"));
            return;
        }
        this.displayErrorMessage(null);
    }

    public Project[] getSelectedProjects() {
        Object[] selectedProjects = this.projectsTableViewer.getCheckedElements();
        ArrayList<Project> schemas = new ArrayList<Project>();
        Object[] objectArray = selectedProjects;
        int n = selectedProjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object project = objectArray[n2];
            schemas.add((Project)project);
            ++n2;
        }
        return schemas.toArray(new Project[0]);
    }

    public void setSelectedProjects(Project[] projects) {
        this.selectedProjects = projects;
    }

    public String getExportDirectory() {
        return this.exportDirectoryText.getText();
    }

    public void saveDialogSettings() {
        Activator.getDefault().getPreferenceStore().putValue(PluginConstants.FILE_DIALOG_EXPORT_PROJECTS, this.exportDirectoryText.getText());
    }
}

