/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.dbms.postgresql;

import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBDDLGenerator;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.DBSQLScript;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.dbms.postgresql.DBMSHandlerPostgreSQL;

public class PostgresDDLGenerator
extends DBDDLGenerator<DBMSHandlerPostgreSQL> {
    private static final String CREATE_REVERSE_FUNCTION = "CREATE OR REPLACE FUNCTION reverse(TEXT) RETURNS TEXT AS $$\nDECLARE\n   original ALIAS FOR $1;\n   reversed TEXT := '';\n   onechar  VARCHAR;\n   mypos    INTEGER;\nBEGIN\n   SELECT LENGTH(original) INTO mypos;\n   LOOP\n      EXIT WHEN mypos < 1;\n      SELECT substring(original FROM mypos FOR 1) INTO onechar;\n      reversed := reversed || onechar;\n      mypos := mypos -1;\n   END LOOP;\n   RETURN reversed;\nEND\n$$ LANGUAGE plpgsql IMMUTABLE RETURNS NULL ON NULL INPUT";
    private boolean createReverseFunction = false;

    public PostgresDDLGenerator(DBMSHandlerPostgreSQL dbms) {
        super(dbms);
        this.initDataTypes();
    }

    public boolean isCreateReverseFunction() {
        return this.createReverseFunction;
    }

    public void setCreateReverseFunction(boolean createReverseFunction) {
        this.createReverseFunction = createReverseFunction;
    }

    private void initDataTypes() {
        this.DATATYPE_BOOLEAN = "BOOLEAN";
        this.DATATYPE_CLOB = "TEXT";
        this.DATATYPE_BLOB = "BYTEA";
    }

    @Override
    protected boolean appendColumnDataType(DataType type, double size, DBTableColumn c, DBSQLBuilder sql) {
        switch (type) {
            case AUTOINC: {
                int bytes = Math.abs((int)size);
                if (bytes >= 8) {
                    sql.append(((DBMSHandlerPostgreSQL)this.dbms).isUsePostgresSerialType() ? "BIGSERIAL" : this.DATATYPE_INT_BIG);
                    break;
                }
                sql.append(((DBMSHandlerPostgreSQL)this.dbms).isUsePostgresSerialType() ? "SERIAL" : this.DATATYPE_INTEGER);
                break;
            }
            case FLOAT: {
                sql.append("DOUBLE PRECISION");
                break;
            }
            case BLOB: {
                sql.append(this.DATATYPE_BLOB);
                break;
            }
            default: {
                return super.appendColumnDataType(type, size, c, sql);
            }
        }
        return true;
    }

    @Override
    protected void createDatabase(DBDatabase db, DBSQLScript script) {
        if (!((DBMSHandlerPostgreSQL)this.dbms).isUsePostgresSerialType()) {
            for (DBTable table : db.getTables()) {
                for (DBColumn dbColumn : table.getColumns()) {
                    DBTableColumn c = (DBTableColumn)dbColumn;
                    if (c.getDataType() != DataType.AUTOINC) continue;
                    this.createSequence(db, c, script);
                }
            }
        }
        if (this.createReverseFunction) {
            script.addStmt(CREATE_REVERSE_FUNCTION);
        }
        super.createDatabase(db, script);
    }

    protected void createSequence(DBDatabase db, DBTableColumn column, DBSQLScript script) {
        String seqName = ((DBMSHandlerPostgreSQL)this.dbms).getColumnSequenceName(column);
        DBSQLBuilder sql = ((DBMSHandlerPostgreSQL)this.dbms).createSQLBuilder();
        sql.append("-- creating sequence for column ");
        sql.append(column.getFullName());
        sql.append(" --\r\n");
        sql.append("CREATE SEQUENCE ");
        db.appendQualifiedName(sql, seqName, null);
        sql.append(" INCREMENT BY 1 START WITH 1 MINVALUE 0");
        script.addStmt(sql);
    }

    @Override
    protected void appendColumnDesc(DBTableColumn c, boolean alter, DBSQLBuilder sql) {
        c.addSQL(sql, 1L);
        if (alter) {
            sql.append(" TYPE ");
        } else {
            sql.append(" ");
        }
        if (!this.appendColumnDataType(c.getDataType(), c.getSize(), c, sql)) {
            return;
        }
        if (this.isDDLColumnDefaults() && !c.isAutoGenerated() && c.getDefaultValue() != null) {
            sql.append(" DEFAULT ");
            sql.appendValue(c.getDataType(), c.getDefaultValue());
        }
        if (c.isRequired() || c.isAutoGenerated()) {
            sql.append(" NOT NULL");
        }
    }
}

